//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cMainMenu.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cMainMenu_hpp
#define cMainMenu_hpp
//==============================================================================
// Includes
#include <vector>
#include <string>
#include <SDL.h>
#include "cTextureFont.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cDisplayManager;
class cTextureManager;
class cOptions;
class cGameCore;
struct tPlayerKeys;
//==============================================================================

class cMenuItem
{
	public:
		enum ItemType
		{
			Type_Toggle,
			Type_Button
		};
	
		cMenuItem (ItemType type, int ID, string text, bool value = false):
		mType (type),
		mID (ID),
		mText (text),
		mToggleValue (value),
		mEnabled ("enabled"),
		mDisabled ("disabled")
		{
		};

		void SetToggleNames (string enabled="enabled", string disabled="disabled")
		{
			mEnabled = enabled;
			mDisabled = disabled;
		}

		string GetToggleText (void) const
		{
			if ( mToggleValue )
				return mEnabled;
			return mDisabled;
		}
		
		ItemType mType;
		int mID;
		string mText;
		bool mToggleValue;
		string mEnabled;
		string mDisabled;
};

//==============================================================================
//! MainMenu
//------------------------------------------------------------------------------
class cMainMenu
{
	public:
		enum MenuSelection
		{
			SinglePlayer,
			SplitScreen,
			QuitGame
		};
	
	// Constructor & Destructor
	public:
		//! Constructor
		cMainMenu (cGameCore &gameCore);
		//! Destructor
		~cMainMenu (void);
	
	// Public methods
	public:
		MenuSelection Run (void);
	
	// Private methods
	private:
		void Options (void);

		void MoveSelectionUp (void);
		void MoveSelectionDown (void);
		
		void Render (void);
		void RenderDemo (void);
		void RenderOptions (void);
		void Fade (void);
		void ButtonHandler (void);
		void ClearKeys (SDLKey key);
		void ClearButtons (Uint8 button);
		void CheckOptions (bool flush = false);
	
	// Member variables
	private:
		cGameCore &mGameCore;
		cDisplayManager &mDisplayManager;
		cTextureManager &mTextureManager;
		cOptions &mOptions;
		cTextureFont mFont;
	
		Uint32 mLogoLeft;
		Uint32 mLogoRight;
		Uint32 mMainMenu;
		Uint32 mMenuSelector;
	
		vector<string> mMenuItems;
		unsigned int mSelectedItem;
        int mNumberOfMenuItems;
		
		// Options stuff
		bool mShowOptions;
		bool mShowKeys;
		bool mShowMouse;
		vector<cMenuItem> mItems;
		unsigned int mOptionsSelection;
		tPlayerKeys *mpKeys;
		vector<string> mKeyNames;
		int mSelectedKey;
		bool mWaitKey;
		vector<cMenuItem> mMouseItems;
		unsigned int mMouseSelection;
		bool mNeedsRestart;

		// Demo stuff
		vector<string> mDemoStrings;
		unsigned int mCurrentString;
		Uint32 mLastUpdate;
		Uint32 mLastLetter;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cMainMenu_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
