#!/bin/sh

SDL_V=1.2.13
TTF_V=2.0.9
IMG_V=1.2.7
NET_V=1.2.7
INT_V=0.14.4

set -e

echo 'Windows required includes, dlls and libraries cannot be found.'

mkdir -p windlls winincs winlibs

if which -s curl
then
	USE_CURL=1
elif which -s wget
then
	USE_WGET=1
else
	echo 'Error: curl/wget are not installed.'
	echo 'Please install one of them or do a manual installation :'
	echo "- Download SDL-devel-${SDL_V}-mingw32.tar.gz, SDL_ttf-devel-${TTF_V}-VC8.zip, \
SDL_image-devel-${IMG_V}-VC9.zip and SDL_net-devel-${NET_V}-VC8.zip."
	echo '- Copy each .dll file from these archives to the "windlls"  directory, \
each .lib or .dll.a file into "winlibs", and each .h into "winincs".'
	exit 1
fi

down_file_to()
{
	if [ $USE_CURL ]
	then
		curl -s $1 -o $2
	else
		wget $1 -o $2
	fi
}

mkdir -p downld
cd downld

# SDL
echo 'Downloading SDL...'
down_file_to http://www.libsdl.org/release/SDL-devel-${SDL_V}-mingw32.tar.gz sdl.tar.gz

echo 'Extracting SDL...'

tar xzf sdl.tar.gz

cp SDL-${SDL_V}/include/SDL/*.h ../winincs
cp SDL-${SDL_V}/lib/libSDL.dll.a SDL-${SDL_V}/lib/libSDLmain.a SDL-${SDL_V}/lib/libSDL.la ../winlibs
cp SDL-${SDL_V}/bin/SDL.dll ../windlls

# SDL_ttf
echo 'Downloading SDL_ttf...'
down_file_to http://www.libsdl.org/projects/SDL_ttf/release/SDL_ttf-devel-${TTF_V}-VC8.zip sdl_ttf.zip

echo 'Extracting SDL_ttf...'
unzip -q sdl_ttf.zip

cp SDL_ttf-${TTF_V}/include/SDL_ttf.h ../winincs
cp SDL_ttf-${TTF_V}/lib/SDL_ttf.lib ../winlibs
cp SDL_ttf-${TTF_V}/lib/SDL_ttf.dll SDL_ttf-${TTF_V}/lib/libfreetype-6.dll \
	SDL_ttf-${TTF_V}/lib/zlib1.dll ../windlls

# SDL_image
echo 'Downloading SDL_image...'
down_file_to http://www.libsdl.org/projects/SDL_image/release/SDL_image-devel-${IMG_V}-VC9.zip sdl_image.zip

echo 'Extracting SDL_image...'
unzip -q sdl_image.zip

cp SDL_image-${IMG_V}/include/SDL_image.h ../winincs
cp SDL_image-${IMG_V}/lib/SDL_image.lib ../winlibs
cp SDL_image-${IMG_V}/lib/SDL_image.dll SDL_image-${IMG_V}/lib/jpeg.dll \
	SDL_image-${IMG_V}/lib/libpng12-0.dll SDL_image-${IMG_V}/lib/libtiff-3.dll ../windlls

# SDL_net
echo 'Downloading SDL_net...'
down_file_to http://www.libsdl.org/projects/SDL_net/release/SDL_net-devel-${NET_V}-VC8.zip sdl_net.zip

echo 'Extracting SDL_net...'
unzip -q sdl_net.zip

cp SDL_net-${NET_V}/include/SDL_net.h ../winincs
cp SDL_net-${NET_V}/lib/SDL_net.lib ../winlibs
cp SDL_net-${NET_V}/lib/SDL_net.dll ../windlls

# Intl
echo 'Downloading libintl (dev)...'
down_file_to http://heanet.dl.sourceforge.net/sourceforge/gnuwin32/libintl-${INT_V}-lib.zip libintl.zip

echo 'Extracting libintl (dev)...'
unzip -q libintl.zip

cp include/libintl.h ../winincs
cp lib/libintl.lib lib/libintl.dll.a ../winlibs 

rm -r include lib manifest share
echo 'Downloading libintl (DLL)...'
down_file_to http://heanet.dl.sourceforge.net/sourceforge/gnuwin32/libintl-${INT_V}-bin.zip libintl-bin.zip

echo 'Extracting libintl (dev)...'
unzip -q libintl-bin.zip

cp bin/libintl3.dll ../windlls

echo 'Cleaning up...'

cd ..
rm -r downld

echo 'Finished!'
