/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.eql.action.RequestDefaults;

public class EqlSearchRequest
extends ActionRequest
implements IndicesRequest.Replaceable,
ToXContent {
    public static long MIN_KEEP_ALIVE = TimeValue.timeValueMinutes((long)1L).millis();
    public static TimeValue DEFAULT_KEEP_ALIVE = TimeValue.timeValueDays((long)5L);
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    private String[] indices;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private QueryBuilder filter = null;
    private String timestampField = "@timestamp";
    private String tiebreakerField = null;
    private String eventCategoryField = "event.category";
    private int size = RequestDefaults.SIZE;
    private int fetchSize = RequestDefaults.FETCH_SIZE;
    private String query;
    private boolean ccsMinimizeRoundtrips = RequestDefaults.CCS_MINIMIZE_ROUNDTRIPS;
    private String resultPosition = "tail";
    private List<FieldAndFormat> fetchFields;
    private Map<String, Object> runtimeMappings = Collections.emptyMap();
    private TimeValue waitForCompletionTimeout = null;
    private TimeValue keepAlive = DEFAULT_KEEP_ALIVE;
    private boolean keepOnCompletion;
    static final String KEY_FILTER = "filter";
    static final String KEY_TIMESTAMP_FIELD = "timestamp_field";
    static final String KEY_TIEBREAKER_FIELD = "tiebreaker_field";
    static final String KEY_EVENT_CATEGORY_FIELD = "event_category_field";
    static final String KEY_SIZE = "size";
    static final String KEY_FETCH_SIZE = "fetch_size";
    static final String KEY_QUERY = "query";
    static final String KEY_WAIT_FOR_COMPLETION_TIMEOUT = "wait_for_completion_timeout";
    static final String KEY_KEEP_ALIVE = "keep_alive";
    static final String KEY_KEEP_ON_COMPLETION = "keep_on_completion";
    static final String KEY_RESULT_POSITION = "result_position";
    static final String KEY_FETCH_FIELDS = "fields";
    static final String KEY_RUNTIME_MAPPINGS = "runtime_mappings";
    static final ParseField FILTER = new ParseField("filter", new String[0]);
    static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
    static final ParseField TIEBREAKER_FIELD = new ParseField("tiebreaker_field", new String[0]);
    static final ParseField EVENT_CATEGORY_FIELD = new ParseField("event_category_field", new String[0]);
    static final ParseField SIZE = new ParseField("size", new String[0]);
    static final ParseField FETCH_SIZE = new ParseField("fetch_size", new String[0]);
    static final ParseField QUERY = new ParseField("query", new String[0]);
    static final ParseField WAIT_FOR_COMPLETION_TIMEOUT = new ParseField("wait_for_completion_timeout", new String[0]);
    static final ParseField KEEP_ALIVE = new ParseField("keep_alive", new String[0]);
    static final ParseField KEEP_ON_COMPLETION = new ParseField("keep_on_completion", new String[0]);
    static final ParseField RESULT_POSITION = new ParseField("result_position", new String[0]);
    static final ParseField FETCH_FIELDS_FIELD = SearchSourceBuilder.FETCH_FIELDS_FIELD;
    private static final ObjectParser<EqlSearchRequest, Void> PARSER = EqlSearchRequest.objectParser(EqlSearchRequest::new);

    public EqlSearchRequest() {
    }

    public EqlSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.filter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.timestampField = in.readString();
        this.tiebreakerField = in.readOptionalString();
        this.eventCategoryField = in.readString();
        this.size = in.readVInt();
        this.fetchSize = in.readVInt();
        this.query = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_15_0)) {
            this.ccsMinimizeRoundtrips = in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
            this.waitForCompletionTimeout = in.readOptionalTimeValue();
            this.keepAlive = in.readOptionalTimeValue();
            this.keepOnCompletion = in.readBoolean();
        }
        if (in.getVersion().before(Version.V_7_10_0)) {
            in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_7_17_8)) {
            this.resultPosition = in.readString();
        }
        if (in.getVersion().onOrAfter(Version.V_7_13_0)) {
            if (in.readBoolean()) {
                this.fetchFields = in.readList(FieldAndFormat::new);
            }
            this.runtimeMappings = in.readMap();
        } else {
            this.runtimeMappings = Collections.emptyMap();
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError((String)"indices is null", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError((String)"index is null", (ActionRequestValidationException)validationException);
                break;
            }
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError((String)"indicesOptions is null", (ActionRequestValidationException)validationException);
        }
        if (this.query == null || this.query.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"query is null or empty", (ActionRequestValidationException)validationException);
        }
        if (this.timestampField == null || this.timestampField.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"@timestamp field is null or empty", (ActionRequestValidationException)validationException);
        }
        if (this.eventCategoryField == null || this.eventCategoryField.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"event category field is null or empty", (ActionRequestValidationException)validationException);
        }
        if (this.size < 0) {
            validationException = ValidateActions.addValidationError((String)"size must be greater than or equal to 0", (ActionRequestValidationException)validationException);
        }
        if (this.fetchSize < 2) {
            validationException = ValidateActions.addValidationError((String)"fetch size must be greater than 1", (ActionRequestValidationException)validationException);
        }
        if (this.keepAlive != null && this.keepAlive.getMillis() < MIN_KEEP_ALIVE) {
            validationException = ValidateActions.addValidationError((String)("[keep_alive] must be greater than 1 minute, got:" + this.keepAlive.toString()), (ActionRequestValidationException)validationException);
        }
        if (this.runtimeMappings != null) {
            validationException = EqlSearchRequest.validateRuntimeMappings(this.runtimeMappings, validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateRuntimeMappings(Map<String, Object> runtimeMappings, ActionRequestValidationException validationException) {
        for (Map.Entry<String, Object> entry : runtimeMappings.entrySet()) {
            String fieldName = entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map propNode = (Map)entry.getValue();
                if (propNode.get("type") != null) continue;
                return ValidateActions.addValidationError((String)("No type specified for runtime field [" + fieldName + "]"), (ActionRequestValidationException)validationException);
            }
            return ValidateActions.addValidationError((String)("Expected map for runtime field [" + fieldName + "] definition but got [" + fieldName.getClass().getSimpleName() + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            builder.field(KEY_FILTER, (ToXContent)this.filter);
        }
        builder.field(KEY_TIMESTAMP_FIELD, this.timestampField());
        if (this.tiebreakerField != null) {
            builder.field(KEY_TIEBREAKER_FIELD, this.tiebreakerField());
        }
        builder.field(KEY_EVENT_CATEGORY_FIELD, this.eventCategoryField());
        builder.field(KEY_SIZE, this.size());
        builder.field(KEY_FETCH_SIZE, this.fetchSize());
        builder.field(KEY_QUERY, this.query);
        if (this.waitForCompletionTimeout != null) {
            builder.field(KEY_WAIT_FOR_COMPLETION_TIMEOUT, (Object)this.waitForCompletionTimeout);
        }
        if (this.keepAlive != null) {
            builder.field(KEY_KEEP_ALIVE, (Object)this.keepAlive);
        }
        builder.field(KEY_KEEP_ON_COMPLETION, this.keepOnCompletion);
        builder.field(KEY_RESULT_POSITION, this.resultPosition);
        if (this.fetchFields != null && !this.fetchFields.isEmpty()) {
            builder.field(KEY_FETCH_FIELDS, this.fetchFields);
        }
        if (this.runtimeMappings != null) {
            builder.field(KEY_RUNTIME_MAPPINGS, this.runtimeMappings);
        }
        return builder;
    }

    public static EqlSearchRequest fromXContent(XContentParser parser) {
        return (EqlSearchRequest)((Object)PARSER.apply(parser, null));
    }

    protected static <R extends EqlSearchRequest> ObjectParser<R, Void> objectParser(Supplier<R> supplier) {
        ObjectParser parser = new ObjectParser("eql/search", false, supplier);
        parser.declareObject(EqlSearchRequest::filter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), FILTER);
        parser.declareString(EqlSearchRequest::timestampField, TIMESTAMP_FIELD);
        parser.declareString(EqlSearchRequest::tiebreakerField, TIEBREAKER_FIELD);
        parser.declareString(EqlSearchRequest::eventCategoryField, EVENT_CATEGORY_FIELD);
        parser.declareInt(EqlSearchRequest::size, SIZE);
        parser.declareInt(EqlSearchRequest::fetchSize, FETCH_SIZE);
        parser.declareString(EqlSearchRequest::query, QUERY);
        parser.declareField(EqlSearchRequest::waitForCompletionTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)KEY_WAIT_FOR_COMPLETION_TIMEOUT), WAIT_FOR_COMPLETION_TIMEOUT, ObjectParser.ValueType.VALUE);
        parser.declareField(EqlSearchRequest::keepAlive, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)KEY_KEEP_ALIVE), KEEP_ALIVE, ObjectParser.ValueType.VALUE);
        parser.declareBoolean(EqlSearchRequest::keepOnCompletion, KEEP_ON_COMPLETION);
        parser.declareString(EqlSearchRequest::resultPosition, RESULT_POSITION);
        parser.declareField(EqlSearchRequest::fetchFields, EqlSearchRequest::parseFetchFields, FETCH_FIELDS_FIELD, ObjectParser.ValueType.VALUE_ARRAY);
        parser.declareObject(EqlSearchRequest::runtimeMappings, (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
        return parser;
    }

    public EqlSearchRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public EqlSearchRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public EqlSearchRequest runtimeMappings(Map<String, Object> runtimeMappings) {
        this.runtimeMappings = runtimeMappings;
        return this;
    }

    public String timestampField() {
        return this.timestampField;
    }

    public EqlSearchRequest timestampField(String timestampField) {
        this.timestampField = timestampField;
        return this;
    }

    public String tiebreakerField() {
        return this.tiebreakerField;
    }

    public EqlSearchRequest tiebreakerField(String tiebreakerField) {
        this.tiebreakerField = tiebreakerField;
        return this;
    }

    public String eventCategoryField() {
        return this.eventCategoryField;
    }

    public EqlSearchRequest eventCategoryField(String eventCategoryField) {
        this.eventCategoryField = eventCategoryField;
        return this;
    }

    public int size() {
        return this.size;
    }

    public EqlSearchRequest size(int size) {
        this.size = size;
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public EqlSearchRequest fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public String query() {
        return this.query;
    }

    public EqlSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public EqlSearchRequest waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        return this;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public EqlSearchRequest keepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public EqlSearchRequest keepOnCompletion(boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
        return this;
    }

    public EqlSearchRequest ccsMinimizeRoundtrips(boolean ccsMinimizeRoundtrips) {
        this.ccsMinimizeRoundtrips = ccsMinimizeRoundtrips;
        return this;
    }

    public boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public String resultPosition() {
        return this.resultPosition;
    }

    public EqlSearchRequest resultPosition(String position) {
        if (!"head".equals(position) && !"tail".equals(position)) {
            throw new IllegalArgumentException("result position needs to be 'head' or 'tail', received '" + position + "'");
        }
        this.resultPosition = position;
        return this;
    }

    public List<FieldAndFormat> fetchFields() {
        return this.fetchFields;
    }

    public EqlSearchRequest fetchFields(List<FieldAndFormat> fetchFields) {
        this.fetchFields = fetchFields;
        return this;
    }

    private static List<FieldAndFormat> parseFetchFields(XContentParser parser) throws IOException {
        ArrayList<FieldAndFormat> result = new ArrayList<FieldAndFormat>();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                result.add(FieldAndFormat.fromXContent((XContentParser)parser));
            }
        }
        return result.isEmpty() ? null : result;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalNamedWriteable((NamedWriteable)this.filter);
        out.writeString(this.timestampField);
        out.writeOptionalString(this.tiebreakerField);
        out.writeString(this.eventCategoryField);
        out.writeVInt(this.size);
        out.writeVInt(this.fetchSize);
        out.writeString(this.query);
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            out.writeBoolean(this.ccsMinimizeRoundtrips);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalTimeValue(this.waitForCompletionTimeout);
            out.writeOptionalTimeValue(this.keepAlive);
            out.writeBoolean(this.keepOnCompletion);
        }
        if (out.getVersion().before(Version.V_7_10_0)) {
            out.writeBoolean(true);
        }
        if (out.getVersion().onOrAfter(Version.V_7_17_8)) {
            out.writeString(this.resultPosition);
        }
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeBoolean(this.fetchFields != null);
            if (this.fetchFields != null) {
                out.writeList(this.fetchFields);
            }
            out.writeMap(this.runtimeMappings);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EqlSearchRequest that = (EqlSearchRequest)((Object)o);
        return this.size == that.size && this.fetchSize == that.fetchSize && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.filter, that.filter) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.tiebreakerField, that.tiebreakerField) && Objects.equals(this.eventCategoryField, that.eventCategoryField) && Objects.equals(this.query, that.query) && Objects.equals(this.ccsMinimizeRoundtrips, that.ccsMinimizeRoundtrips) && Objects.equals(this.waitForCompletionTimeout, that.waitForCompletionTimeout) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.resultPosition, that.resultPosition) && Objects.equals(this.fetchFields, that.fetchFields) && Objects.equals(this.runtimeMappings, that.runtimeMappings);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions, this.filter, this.size, this.fetchSize, this.timestampField, this.tiebreakerField, this.eventCategoryField, this.query, this.ccsMinimizeRoundtrips, this.waitForCompletionTimeout, this.keepAlive, this.resultPosition, this.fetchFields, this.runtimeMappings);
    }

    public String[] indices() {
        return this.indices;
    }

    public EqlSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new EqlSearchTask(id, type, action, this.getDescription(), parentTaskId, headers, null, null, this.keepAlive);
    }

    public boolean allowsRemoteIndices() {
        return true;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("indices[");
        Strings.arrayToDelimitedString((Object[])this.indices, (String)",", (StringBuilder)sb);
        sb.append("], ");
        sb.append(this.query);
        return sb.toString();
    }
}

