/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.GeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MultiValueAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetric;
import org.elasticsearch.xpack.core.spatial.search.aggregations.GeoShapeMetricAggregation;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GeoTileGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.transforms.IDGenerator;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.utils.OutputFieldNameConverter;

public final class AggregationResultUtils {
    private static final Map<String, AggValueExtractor> TYPE_VALUE_EXTRACTOR_MAP;
    private static final Map<String, BucketKeyExtractor> BUCKET_KEY_EXTRACTOR_MAP;
    private static final BucketKeyExtractor DEFAULT_BUCKET_KEY_EXTRACTOR;
    private static final BucketKeyExtractor DATES_AS_EPOCH_BUCKET_KEY_EXTRACTOR;
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_COORDINATES = "coordinates";
    private static final String POINT = "point";
    private static final String LINESTRING = "linestring";
    private static final String POLYGON = "polygon";

    public static Stream<Map<String, Object>> extractCompositeAggregationResults(CompositeAggregation agg, GroupConfig groups, Collection<AggregationBuilder> aggregationBuilders, Collection<PipelineAggregationBuilder> pipelineAggs, Map<String, String> fieldTypeMap, TransformIndexerStats stats, TransformProgress progress, boolean datesAsEpoch) {
        return agg.getBuckets().stream().map(bucket -> {
            stats.incrementNumDocuments(bucket.getDocCount());
            progress.incrementDocsProcessed(bucket.getDocCount());
            progress.incrementDocsIndexed(1L);
            HashMap<String, Object> document = new HashMap<String, Object>();
            IDGenerator idGen = new IDGenerator();
            groups.getGroups().forEach((destinationFieldName, singleGroupSource) -> {
                Object value = bucket.getKey().get(destinationFieldName);
                idGen.add((String)destinationFieldName, value);
                AggregationResultUtils.updateDocument(document, destinationFieldName, AggregationResultUtils.getBucketKeyExtractor(singleGroupSource, datesAsEpoch).value(value, (String)fieldTypeMap.get(destinationFieldName)));
            });
            List aggNames = aggregationBuilders.stream().map(AggregationBuilder::getName).collect(Collectors.toList());
            aggNames.addAll(pipelineAggs.stream().map(PipelineAggregationBuilder::getName).collect(Collectors.toList()));
            for (String aggName : aggNames) {
                Aggregation aggResult = bucket.getAggregations().get(aggName);
                if (aggResult == null) continue;
                AggValueExtractor extractor = AggregationResultUtils.getExtractor(aggResult);
                AggregationResultUtils.updateDocument(document, aggName, extractor.value(aggResult, fieldTypeMap, ""));
            }
            document.put(TransformField.DOCUMENT_ID_FIELD, idGen.getID());
            return document;
        });
    }

    static BucketKeyExtractor getBucketKeyExtractor(SingleGroupSource groupSource, boolean datesAsEpoch) {
        return BUCKET_KEY_EXTRACTOR_MAP.getOrDefault(groupSource.getClass().getName(), datesAsEpoch ? DATES_AS_EPOCH_BUCKET_KEY_EXTRACTOR : DEFAULT_BUCKET_KEY_EXTRACTOR);
    }

    static AggValueExtractor getExtractor(Aggregation aggregation) {
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(NumericMetricsAggregation.SingleValue.class.getName());
        }
        if (aggregation instanceof ScriptedMetric) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(ScriptedMetric.class.getName());
        }
        if (aggregation instanceof GeoCentroid) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(GeoCentroid.class.getName());
        }
        if (aggregation instanceof GeoBounds) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(GeoBounds.class.getName());
        }
        if (aggregation instanceof Percentiles) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(Percentiles.class.getName());
        }
        if (aggregation instanceof NumericMetricsAggregation.MultiValue) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(NumericMetricsAggregation.MultiValue.class.getName());
        }
        if (aggregation instanceof MultiValueAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(MultiValueAggregation.class.getName());
        }
        if (aggregation instanceof SingleBucketAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(SingleBucketAggregation.class.getName());
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(MultiBucketsAggregation.class.getName());
        }
        if (aggregation instanceof GeoShapeMetricAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(GeoShapeMetricAggregation.class.getName());
        }
        throw new AggregationExtractionException("unsupported aggregation [{}] with name [{}]", aggregation.getType(), aggregation.getName());
    }

    static void updateDocument(Map<String, Object> document, String fieldName, Object value) {
        String[] fieldTokens = fieldName.split("\\.");
        if (fieldTokens.length == 1) {
            document.put(fieldName, value);
            return;
        }
        HashMap<String, Object> internalMap = document;
        for (int i = 0; i < fieldTokens.length; ++i) {
            String token = fieldTokens[i];
            if (i == fieldTokens.length - 1) {
                if (internalMap.containsKey(token)) {
                    if (internalMap.get(token) instanceof Map) {
                        throw new AggregationExtractionException("mixed object types of nested and non-nested fields [{}]", fieldName);
                    }
                    throw new AggregationExtractionException("duplicate key value pairs key [{}] old value [{}] duplicate value [{}]", fieldName, internalMap.get(token), value);
                }
                internalMap.put(token, value);
                continue;
            }
            if (internalMap.containsKey(token)) {
                if (internalMap.get(token) instanceof Map) {
                    internalMap = (HashMap<String, Object>)internalMap.get(token);
                    continue;
                }
                throw new AggregationExtractionException("mixed object types of nested and non-nested fields [{}]", fieldName);
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            internalMap.put(token, newMap);
            internalMap = newMap;
        }
    }

    static {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(NumericMetricsAggregation.SingleValue.class.getName(), new SingleValueAggExtractor());
        tempMap.put(ScriptedMetric.class.getName(), new ScriptedMetricAggExtractor());
        tempMap.put(GeoCentroid.class.getName(), new GeoCentroidAggExtractor());
        tempMap.put(GeoBounds.class.getName(), new GeoBoundsAggExtractor());
        tempMap.put(Percentiles.class.getName(), new PercentilesAggExtractor());
        tempMap.put(SingleBucketAggregation.class.getName(), new SingleBucketAggExtractor());
        tempMap.put(MultiBucketsAggregation.class.getName(), new MultiBucketsAggExtractor());
        tempMap.put(GeoShapeMetricAggregation.class.getName(), new GeoShapeMetricAggExtractor());
        tempMap.put(NumericMetricsAggregation.MultiValue.class.getName(), new NumericMultiValueAggExtractor());
        tempMap.put(MultiValueAggregation.class.getName(), new MultiValueAggExtractor());
        TYPE_VALUE_EXTRACTOR_MAP = Collections.unmodifiableMap(tempMap);
        DEFAULT_BUCKET_KEY_EXTRACTOR = new DefaultBucketKeyExtractor();
        DATES_AS_EPOCH_BUCKET_KEY_EXTRACTOR = new DatesAsEpochBucketKeyExtractor();
        tempMap = new HashMap();
        tempMap.put(GeoTileGroupSource.class.getName(), new GeoTileBucketKeyExtractor());
        BUCKET_KEY_EXTRACTOR_MAP = Collections.unmodifiableMap(tempMap);
    }

    static interface BucketKeyExtractor {
        public Object value(Object var1, String var2);
    }

    static interface AggValueExtractor {
        public Object value(Aggregation var1, Map<String, String> var2, String var3);
    }

    public static class AggregationExtractionException
    extends ElasticsearchException {
        AggregationExtractionException(String msg, Object ... args) {
            super(msg, args);
        }

        AggregationExtractionException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }

    static class SingleValueAggExtractor
    implements AggValueExtractor {
        SingleValueAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            NumericMetricsAggregation.SingleValue aggregation = (NumericMetricsAggregation.SingleValue)agg;
            if (!Numbers.isValidDouble((double)aggregation.value())) {
                return null;
            }
            String fieldType = fieldTypeMap.get(lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName());
            if (SchemaUtil.isNumericType(fieldType) || aggregation.getValueAsString().equals(String.valueOf(aggregation.value()))) {
                return SchemaUtil.dropFloatingPointComponentIfTypeRequiresIt(fieldType, aggregation.value());
            }
            return aggregation.getValueAsString();
        }
    }

    static class ScriptedMetricAggExtractor
    implements AggValueExtractor {
        ScriptedMetricAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            ScriptedMetric aggregation = (ScriptedMetric)agg;
            return aggregation.aggregation();
        }
    }

    static class GeoCentroidAggExtractor
    implements AggValueExtractor {
        GeoCentroidAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            GeoCentroid aggregation = (GeoCentroid)agg;
            return aggregation.count() > 0L ? aggregation.centroid().toString() : null;
        }
    }

    static class GeoBoundsAggExtractor
    implements AggValueExtractor {
        GeoBoundsAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            GeoBounds aggregation = (GeoBounds)agg;
            if (aggregation.bottomRight() == null || aggregation.topLeft() == null) {
                return null;
            }
            HashMap<String, Object> geoShape = new HashMap<String, Object>();
            if (aggregation.topLeft().equals((Object)aggregation.bottomRight())) {
                geoShape.put(AggregationResultUtils.FIELD_TYPE, AggregationResultUtils.POINT);
                geoShape.put(AggregationResultUtils.FIELD_COORDINATES, Arrays.asList(aggregation.topLeft().getLon(), aggregation.bottomRight().getLat()));
            } else if (Double.compare(aggregation.topLeft().getLat(), aggregation.bottomRight().getLat()) == 0 || Double.compare(aggregation.topLeft().getLon(), aggregation.bottomRight().getLon()) == 0) {
                geoShape.put(AggregationResultUtils.FIELD_TYPE, AggregationResultUtils.LINESTRING);
                geoShape.put(AggregationResultUtils.FIELD_COORDINATES, Arrays.asList({aggregation.topLeft().getLon(), aggregation.topLeft().getLat()}, {aggregation.bottomRight().getLon(), aggregation.bottomRight().getLat()}));
            } else {
                geoShape.put(AggregationResultUtils.FIELD_TYPE, AggregationResultUtils.POLYGON);
                GeoPoint tl = aggregation.topLeft();
                GeoPoint br = aggregation.bottomRight();
                geoShape.put(AggregationResultUtils.FIELD_COORDINATES, Collections.singletonList(Arrays.asList({tl.getLon(), tl.getLat()}, {br.getLon(), tl.getLat()}, {br.getLon(), br.getLat()}, {tl.getLon(), br.getLat()}, {tl.getLon(), tl.getLat()})));
            }
            return geoShape;
        }
    }

    static class PercentilesAggExtractor
    implements AggValueExtractor {
        PercentilesAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            Percentiles aggregation = (Percentiles)agg;
            HashMap<String, Double> percentiles = new HashMap<String, Double>();
            for (Percentile p : aggregation) {
                if (!Numbers.isValidDouble((double)p.getValue())) {
                    percentiles.put(OutputFieldNameConverter.fromDouble(p.getPercent()), null);
                    continue;
                }
                percentiles.put(OutputFieldNameConverter.fromDouble(p.getPercent()), p.getValue());
            }
            return percentiles;
        }
    }

    static class SingleBucketAggExtractor
    implements AggValueExtractor {
        SingleBucketAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            SingleBucketAggregation aggregation = (SingleBucketAggregation)agg;
            if (!aggregation.getAggregations().iterator().hasNext()) {
                return aggregation.getDocCount();
            }
            HashMap<String, Object> nested = new HashMap<String, Object>();
            for (Aggregation subAgg : aggregation.getAggregations()) {
                nested.put(subAgg.getName(), AggregationResultUtils.getExtractor(subAgg).value(subAgg, fieldTypeMap, lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName()));
            }
            return nested;
        }
    }

    static class MultiBucketsAggExtractor
    implements AggValueExtractor {
        MultiBucketsAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            MultiBucketsAggregation aggregation = (MultiBucketsAggregation)agg;
            HashMap<String, Serializable> nested = new HashMap<String, Serializable>();
            for (MultiBucketsAggregation.Bucket bucket : aggregation.getBuckets()) {
                if (!bucket.getAggregations().iterator().hasNext()) {
                    nested.put(bucket.getKeyAsString(), Long.valueOf(bucket.getDocCount()));
                    continue;
                }
                HashMap<String, Object> nestedBucketObject = new HashMap<String, Object>();
                for (Aggregation subAgg : bucket.getAggregations()) {
                    nestedBucketObject.put(subAgg.getName(), AggregationResultUtils.getExtractor(subAgg).value(subAgg, fieldTypeMap, lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName()));
                }
                nested.put(bucket.getKeyAsString(), nestedBucketObject);
            }
            return nested;
        }
    }

    static class GeoShapeMetricAggExtractor
    implements AggValueExtractor {
        GeoShapeMetricAggExtractor() {
        }

        @Override
        public Object value(Aggregation aggregation, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            assert (aggregation instanceof GeoShapeMetricAggregation) : "Unexpected type [" + aggregation.getClass().getName() + "] for aggregation [" + aggregation.getName() + "]";
            return ((GeoShapeMetricAggregation)aggregation).geoJSONGeometry();
        }
    }

    static class NumericMultiValueAggExtractor
    implements AggValueExtractor {
        NumericMultiValueAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            NumericMetricsAggregation.MultiValue aggregation = (NumericMetricsAggregation.MultiValue)agg;
            HashMap<String, Object> extracted = new HashMap<String, Object>();
            String fieldLookupPrefix = (lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName()) + ".";
            for (String valueName : aggregation.valueNames()) {
                double value = aggregation.value(valueName);
                String fieldType = fieldTypeMap.get(fieldLookupPrefix + valueName);
                if (!Numbers.isValidDouble((double)value)) continue;
                extracted.put(valueName, SchemaUtil.dropFloatingPointComponentIfTypeRequiresIt(fieldType, value));
            }
            return extracted;
        }
    }

    static class MultiValueAggExtractor
    implements AggValueExtractor {
        MultiValueAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            MultiValueAggregation aggregation = (MultiValueAggregation)agg;
            HashMap extracted = new HashMap();
            for (String valueName : aggregation.valueNames()) {
                List valueAsStrings = aggregation.getValuesAsStrings(valueName);
                if (valueAsStrings.size() <= 0) continue;
                extracted.put(valueName, valueAsStrings.get(0));
            }
            return extracted;
        }
    }

    static class DefaultBucketKeyExtractor
    implements BucketKeyExtractor {
        DefaultBucketKeyExtractor() {
        }

        @Override
        public Object value(Object key, String type) {
            if (SchemaUtil.isNumericType(type) && key instanceof Double) {
                return SchemaUtil.dropFloatingPointComponentIfTypeRequiresIt(type, (Double)key);
            }
            if (("date".equals(type) || "date_nanos".equals(type)) && key instanceof Long) {
                return DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(((Long)key).longValue());
            }
            return key;
        }
    }

    static class DatesAsEpochBucketKeyExtractor
    implements BucketKeyExtractor {
        DatesAsEpochBucketKeyExtractor() {
        }

        @Override
        public Object value(Object key, String type) {
            if (SchemaUtil.isNumericType(type) && key instanceof Double) {
                return SchemaUtil.dropFloatingPointComponentIfTypeRequiresIt(type, (Double)key);
            }
            return key;
        }
    }

    static class GeoTileBucketKeyExtractor
    implements BucketKeyExtractor {
        GeoTileBucketKeyExtractor() {
        }

        @Override
        public Object value(Object key, String type) {
            assert (key instanceof String);
            Rectangle rectangle = GeoTileUtils.toBoundingBox((String)key.toString());
            HashMap<String, Object> geoShape = new HashMap<String, Object>();
            geoShape.put(AggregationResultUtils.FIELD_TYPE, AggregationResultUtils.POLYGON);
            geoShape.put(AggregationResultUtils.FIELD_COORDINATES, Collections.singletonList(Arrays.asList({rectangle.getMaxLon(), rectangle.getMinLat()}, {rectangle.getMinLon(), rectangle.getMinLat()}, {rectangle.getMinLon(), rectangle.getMaxLat()}, {rectangle.getMaxLon(), rectangle.getMaxLat()}, {rectangle.getMaxLon(), rectangle.getMinLat()})));
            return geoShape;
        }
    }
}

