/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexGeoShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafGeoShapeFieldData;

public abstract class GeoShapeValuesSource
extends ValuesSource {
    public static final GeoShapeValuesSource EMPTY = new GeoShapeValuesSource(){

        @Override
        public GeoShapeValues geoShapeValues(LeafReaderContext context) {
            return GeoShapeValues.EMPTY;
        }

        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return FieldData.emptySortedBinary();
        }
    };

    public abstract GeoShapeValues geoShapeValues(LeafReaderContext var1);

    protected Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        throw new AggregationExecutionException("can't round a [geo_shape]");
    }

    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        final GeoShapeValues values = this.geoShapeValues(context);
        return new DocValueBits(){

            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public static class Fielddata
    extends GeoShapeValuesSource {
        protected final IndexGeoShapeFieldData indexFieldData;

        public Fielddata(IndexGeoShapeFieldData indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public GeoShapeValues geoShapeValues(LeafReaderContext context) {
            return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getGeoShapeValues();
        }
    }
}

