/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.shard.ShardId;

public class RecoverFilesRecoveryException
extends ElasticsearchException
implements ElasticsearchWrapperException {
    private final int numberOfFiles;
    private final ByteSizeValue totalFilesSize;

    public RecoverFilesRecoveryException(ShardId shardId, int numberOfFiles, ByteSizeValue totalFilesSize, Throwable cause) {
        super("Failed to transfer [{}] files with total size of [{}]", cause, numberOfFiles, totalFilesSize);
        Objects.requireNonNull(totalFilesSize, "totalFilesSize must not be null");
        this.setShard(shardId);
        this.numberOfFiles = numberOfFiles;
        this.totalFilesSize = totalFilesSize;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public ByteSizeValue totalFilesSize() {
        return this.totalFilesSize;
    }

    public RecoverFilesRecoveryException(StreamInput in) throws IOException {
        super(in);
        this.numberOfFiles = in.readInt();
        this.totalFilesSize = new ByteSizeValue(in);
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeInt(this.numberOfFiles);
        this.totalFilesSize.writeTo(out);
    }
}

