/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.ccr;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.CcrConstants;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.client.CcrClient;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.ccr.AutoFollowStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.ccr.FollowStatsMonitoringDoc;

public final class StatsCollector
extends Collector {
    public static final Setting<TimeValue> CCR_STATS_TIMEOUT = StatsCollector.collectionTimeoutSetting("ccr.stats.timeout");
    private final Settings settings;
    private final ThreadContext threadContext;
    private final CcrClient ccrClient;

    public StatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        this(settings, clusterService, licenseState, new XPackClient(client).ccr(), client.threadPool().getThreadContext());
    }

    StatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, CcrClient ccrClient, ThreadContext threadContext) {
        super("ccr_stats", clusterService, CCR_STATS_TIMEOUT, licenseState);
        this.settings = settings;
        this.ccrClient = ccrClient;
        this.threadContext = threadContext;
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster) && (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(this.settings) != false && CcrConstants.CCR_FEATURE.checkWithoutTracking(this.licenseState);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        try (ThreadContext.StoredContext ignore = this.threadContext.stashWithOrigin("monitoring");){
            long timestamp = StatsCollector.timestamp();
            String clusterUuid = StatsCollector.clusterUuid(clusterState);
            CcrStatsAction.Request request = new CcrStatsAction.Request();
            CcrStatsAction.Response response = (CcrStatsAction.Response)this.ccrClient.stats(request).actionGet(this.getCollectionTimeout());
            AutoFollowStatsMonitoringDoc autoFollowStatsDoc = new AutoFollowStatsMonitoringDoc(clusterUuid, timestamp, interval, node, response.getAutoFollowStats());
            HashSet<String> collectionIndices = new HashSet<String>(Arrays.asList(this.getCollectionIndices()));
            List<MonitoringDoc> docs = response.getFollowStats().getStatsResponses().stream().filter(statsResponse -> collectionIndices.isEmpty() || collectionIndices.contains(statsResponse.status().followerIndex())).map(stats -> new FollowStatsMonitoringDoc(clusterUuid, timestamp, interval, node, stats.status())).collect(Collectors.toList());
            docs.add(autoFollowStatsDoc);
            List<MonitoringDoc> list = docs;
            return list;
        }
    }
}

