/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentFunction;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class CurrentDateTime
extends CurrentFunction<ZonedDateTime> {
    private final Expression precision;

    public CurrentDateTime(Source source, Expression precision, Configuration configuration) {
        super(source, configuration, CurrentDateTime.nanoPrecision(configuration.now(), precision), DataTypes.DATETIME);
        this.precision = precision;
    }

    Expression precision() {
        return this.precision;
    }

    protected NodeInfo<CurrentDateTime> info() {
        return NodeInfo.create((Node)this, CurrentDateTime::new, (Object)this.precision, (Object)this.configuration());
    }

    static ZonedDateTime nanoPrecision(ZonedDateTime zdt, Expression precisionExpression) {
        return zdt.withNano(DateUtils.getNanoPrecision(precisionExpression, zdt.getNano()));
    }
}

