/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalArithmetics;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalYearMonth;

public enum SqlBinaryArithmeticOperation implements BinaryArithmeticOperation
{
    ADD((l, r) -> {
        if (l instanceof Number) {
            return Arithmetics.add((Number)((Number)l), (Number)((Number)r));
        }
        if (l instanceof IntervalYearMonth && r instanceof IntervalYearMonth) {
            return ((IntervalYearMonth)l).add((Interval)((IntervalYearMonth)r));
        }
        if (l instanceof IntervalDayTime && r instanceof IntervalDayTime) {
            return ((IntervalDayTime)l).add((Interval)((IntervalDayTime)r));
        }
        l = SqlBinaryArithmeticOperation.unwrapJodaTime(l);
        r = SqlBinaryArithmeticOperation.unwrapJodaTime(r);
        if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalYearMonth) {
            return IntervalArithmetics.add((Temporal)l, (Period)((IntervalYearMonth)r).interval());
        }
        if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalDayTime) {
            return IntervalArithmetics.add((Temporal)l, (Duration)((IntervalDayTime)r).interval());
        }
        if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof IntervalYearMonth) {
            return IntervalArithmetics.add((Temporal)r, (Period)((IntervalYearMonth)l).interval());
        }
        if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof IntervalDayTime) {
            return IntervalArithmetics.add((Temporal)r, (Duration)((IntervalDayTime)l).interval());
        }
        throw new QlIllegalArgumentException("Cannot compute [+] between [{}] and [{}]", new Object[]{l.getClass().getSimpleName(), r.getClass().getSimpleName()});
    }, "+"),
    SUB((l, r) -> {
        if (l instanceof Number) {
            return Arithmetics.sub((Number)((Number)l), (Number)((Number)r));
        }
        if (l instanceof IntervalYearMonth && r instanceof IntervalYearMonth) {
            return ((IntervalYearMonth)l).sub((Interval)((IntervalYearMonth)r));
        }
        if (l instanceof IntervalDayTime && r instanceof IntervalDayTime) {
            return ((IntervalDayTime)l).sub((Interval)((IntervalDayTime)r));
        }
        l = SqlBinaryArithmeticOperation.unwrapJodaTime(l);
        r = SqlBinaryArithmeticOperation.unwrapJodaTime(r);
        if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalYearMonth) {
            return IntervalArithmetics.sub((Temporal)l, (Period)((IntervalYearMonth)r).interval());
        }
        if ((l instanceof ZonedDateTime || l instanceof OffsetTime) && r instanceof IntervalDayTime) {
            return IntervalArithmetics.sub((Temporal)l, (Duration)((IntervalDayTime)r).interval());
        }
        if ((r instanceof ZonedDateTime || r instanceof OffsetTime) && l instanceof Interval) {
            throw new QlIllegalArgumentException("Cannot subtract a date from an interval; do you mean the reverse?");
        }
        throw new QlIllegalArgumentException("Cannot compute [-] between [{}] and [{}]", new Object[]{l.getClass().getSimpleName(), r.getClass().getSimpleName()});
    }, "-"),
    MUL((l, r) -> {
        if (l instanceof Number && r instanceof Number) {
            return Arithmetics.mul((Number)((Number)l), (Number)((Number)r));
        }
        l = SqlBinaryArithmeticOperation.unwrapJodaTime(l);
        r = SqlBinaryArithmeticOperation.unwrapJodaTime(r);
        if (l instanceof Number && r instanceof IntervalYearMonth) {
            return ((IntervalYearMonth)r).mul(((Number)l).intValue());
        }
        if (r instanceof Number && l instanceof IntervalYearMonth) {
            return ((IntervalYearMonth)l).mul(((Number)r).intValue());
        }
        if (l instanceof Number && r instanceof IntervalDayTime) {
            return ((IntervalDayTime)r).mul(((Number)l).longValue());
        }
        if (r instanceof Number && l instanceof IntervalDayTime) {
            return ((IntervalDayTime)l).mul(((Number)r).longValue());
        }
        throw new QlIllegalArgumentException("Cannot compute [*] between [{}] and [{}]", new Object[]{l.getClass().getSimpleName(), r.getClass().getSimpleName()});
    }, "*"),
    DIV(Arithmetics::div, "/"),
    MOD(Arithmetics::mod, "%");

    public static final String NAME = "abn-sql";
    private final BiFunction<Object, Object, Object> process;
    private final String symbol;

    private SqlBinaryArithmeticOperation(BiFunction<Object, Object, Object> process, String symbol) {
        this.process = process;
        this.symbol = symbol;
    }

    private SqlBinaryArithmeticOperation(Arithmetics.NumericArithmetic process, String symbol) {
        this((arg_0, arg_1) -> ((Arithmetics.NumericArithmetic)process).wrap(arg_0, arg_1), symbol);
    }

    public String symbol() {
        return this.symbol;
    }

    public final Object doApply(Object left, Object right) {
        return this.process.apply(left, right);
    }

    public String toString() {
        return this.symbol;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static SqlBinaryArithmeticOperation read(StreamInput in) throws IOException {
        return (SqlBinaryArithmeticOperation)in.readEnum(SqlBinaryArithmeticOperation.class);
    }

    private static Object unwrapJodaTime(Object o) {
        return o instanceof JodaCompatibleZonedDateTime ? ((JodaCompatibleZonedDateTime)o).getZonedDateTime() : o;
    }
}

