/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new IndexTemplateConfig(".watch-history-13", "/watch-history.json", 13, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_10 = new IndexTemplateConfig(".watch-history-10", "/watch-history-10.json", 10, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_11 = new IndexTemplateConfig(".watch-history-11", "/watch-history-11.json", 11, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM = new IndexTemplateConfig(".watch-history-no-ilm-13", "/watch-history-no-ilm.json", 13, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_10 = new IndexTemplateConfig(".watch-history-no-ilm-10", "/watch-history-no-ilm-10.json", 10, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_11 = new IndexTemplateConfig(".watch-history-no-ilm-11", "/watch-history-no-ilm-11.json", 11, "xpack.watcher.template.version");
    public static final LifecyclePolicyConfig POLICY_WATCH_HISTORY = new LifecyclePolicyConfig("watch-history-ilm-policy", "/watch-history-ilm-policy.json");
    private final boolean ilmManagementEnabled;

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmManagementEnabled = (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(nodeSettings);
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        if (this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(Version.V_7_10_0)) {
            return Collections.emptyList();
        }
        if (this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(Version.V_7_7_0)) {
            return Collections.singletonList(this.ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY_11 : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_11);
        }
        return Collections.singletonList(this.ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY_10 : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_10);
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        return Collections.singletonList(this.ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM);
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (!((Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(this.settings)).booleanValue()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(POLICY_WATCH_HISTORY);
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        Stream<String> watcherHistoryTemplateIds = Stream.concat(state.getMetadata().templatesV2().keySet().stream(), Arrays.stream((String[])state.getMetadata().getTemplates().keys().toArray(String.class)));
        return watcherHistoryTemplateIds.filter(s -> s.startsWith(".watch-history-")).map(s -> Integer.valueOf(s.substring(s.lastIndexOf(45) + 1))).anyMatch(version -> version >= 9);
    }

    protected boolean requiresMasterNode() {
        return true;
    }
}

