/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class GenerateSnapshotNameStep
extends ClusterStateActionStep {
    public static final String NAME = "generate-snapshot-name";
    private static final Logger logger = LogManager.getLogger(GenerateSnapshotNameStep.class);
    private static final IndexNameExpressionResolver.DateMathExpressionResolver DATE_MATH_RESOLVER = new IndexNameExpressionResolver.DateMathExpressionResolver();
    private final String snapshotRepository;

    public GenerateSnapshotNameStep(Step.StepKey key, Step.StepKey nextStepKey, String snapshotRepository) {
        super(key, nextStepKey);
        this.snapshotRepository = snapshotRepository;
    }

    public String getSnapshotRepository() {
        return this.snapshotRepository;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetaData = clusterState.metadata().index(index);
        if (indexMetaData == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        String policy = indexMetaData.getSettings().get("index.lifecycle.name");
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetaData);
        if (((RepositoriesMetadata)clusterState.metadata().custom("repositories", (Metadata.Custom)RepositoriesMetadata.EMPTY)).repository(this.snapshotRepository) == null) {
            throw new IllegalStateException("repository [" + this.snapshotRepository + "] is missing. [" + policy + "] policy for index [" + index.getName() + "] cannot continue until the repository is created or the policy is changed");
        }
        LifecycleExecutionState.Builder newCustomData = LifecycleExecutionState.builder(lifecycleState);
        newCustomData.setSnapshotIndexName(index.getName());
        newCustomData.setSnapshotRepository(this.snapshotRepository);
        if (lifecycleState.getSnapshotName() == null) {
            String snapshotName;
            String snapshotNamePrefix = ("<{now/d}-" + index.getName() + "-" + policy + ">").toLowerCase(Locale.ROOT);
            ActionRequestValidationException validationException = GenerateSnapshotNameStep.validateGeneratedSnapshotName(snapshotNamePrefix, snapshotName = GenerateSnapshotNameStep.generateSnapshotName(snapshotNamePrefix));
            if (validationException != null) {
                logger.warn("unable to generate a snapshot name as part of policy [{}] for index [{}] due to [{}]", (Object)policy, (Object)index.getName(), (Object)validationException.getMessage());
                throw validationException;
            }
            newCustomData.setSnapshotName(snapshotName);
        }
        return ClusterState.builder((ClusterState)clusterState).metadata(Metadata.builder((Metadata)clusterState.getMetadata()).put(IndexMetadata.builder((IndexMetadata)indexMetaData).putCustom("ilm", newCustomData.build().asMap())).build(false)).build();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.snapshotRepository);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenerateSnapshotNameStep other = (GenerateSnapshotNameStep)obj;
        return super.equals(obj) && Objects.equals(this.snapshotRepository, other.snapshotRepository);
    }

    public static String generateSnapshotName(String name) {
        return GenerateSnapshotNameStep.generateSnapshotName(name, (IndexNameExpressionResolver.Context)new IndexNameExpressionResolver.ResolverContext());
    }

    public static String generateSnapshotName(String name, IndexNameExpressionResolver.Context context) {
        List candidates = DATE_MATH_RESOLVER.resolve(context, Collections.singletonList(name));
        if (candidates.size() != 1) {
            throw new IllegalStateException("resolving snapshot name " + name + " generated more than one candidate: " + candidates);
        }
        return (String)candidates.get(0) + "-" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static ActionRequestValidationException validateGeneratedSnapshotName(String snapshotPrefix, String snapshotName) {
        ActionRequestValidationException err = new ActionRequestValidationException();
        if (!Strings.hasText((String)snapshotPrefix)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: cannot be empty");
        }
        if (snapshotName.contains("#")) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must be lowercase");
        }
        if (!Strings.validFileName((String)snapshotName)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not contain contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (err.validationErrors().size() > 0) {
            return err;
        }
        return null;
    }
}

