/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.DiagnosticTrustManager;
import org.elasticsearch.common.ssl.SslDiagnostics;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.StoreTrustConfig;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class SSLService {
    private static final Logger logger = LogManager.getLogger(SSLService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    private static final Map<String, String> ORDERED_PROTOCOL_ALGORITHM_MAP;
    private final Settings settings;
    private final boolean diagnoseTrustExceptions;
    private final Map<String, SSLConfiguration> sslConfigurations;
    private final Map<SSLConfiguration, SSLContextHolder> sslContexts;
    private final Environment env;

    public SSLService(Environment environment) {
        this(environment, SSLService.getSSLConfigurations(environment.settings()));
    }

    public SSLService(Environment environment, Map<String, SSLConfiguration> sslConfigurations) {
        this.env = environment;
        this.settings = environment.settings();
        this.diagnoseTrustExceptions = this.shouldEnableDiagnoseTrust();
        this.sslConfigurations = sslConfigurations;
        this.sslContexts = this.loadSSLConfigurations(this.sslConfigurations);
    }

    public SSLService(Settings settings, Environment environment) {
        this.env = environment;
        this.settings = settings;
        this.diagnoseTrustExceptions = this.shouldEnableDiagnoseTrust();
        this.sslConfigurations = SSLService.getSSLConfigurations(this.settings);
        this.sslContexts = this.loadSSLConfigurations(this.sslConfigurations);
    }

    private SSLService(Settings settings, Environment environment, Map<String, SSLConfiguration> sslConfigurations, Map<SSLConfiguration, SSLContextHolder> sslContexts) {
        this.settings = settings;
        this.env = environment;
        this.diagnoseTrustExceptions = this.shouldEnableDiagnoseTrust();
        this.sslConfigurations = sslConfigurations;
        this.sslContexts = sslContexts;
    }

    public SSLService createDynamicSSLService() {
        return new SSLService(this.settings, this.env, this.sslConfigurations, this.sslContexts){

            @Override
            SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
                SSLContextHolder holder = (SSLContextHolder)SSLService.this.sslContexts.get(sslConfiguration);
                if (holder == null) {
                    holder = SSLService.this.createSslContext(sslConfiguration);
                }
                return holder;
            }
        };
    }

    @Deprecated
    public SSLIOSessionStrategy sslIOSessionStrategy(Settings settingsToUse) {
        SSLConfiguration config = this.sslConfiguration(settingsToUse);
        return this.sslIOSessionStrategy(config);
    }

    public SSLIOSessionStrategy sslIOSessionStrategy(SSLConfiguration config) {
        SSLContext sslContext = this.sslContext(config);
        String[] ciphers = this.supportedCiphers(this.sslParameters(sslContext).getCipherSuites(), config.cipherSuites(), false);
        String[] supportedProtocols = config.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        HostnameVerifier verifier = config.verificationMode().isHostnameVerificationEnabled() ? SSLIOSessionStrategy.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        return this.sslIOSessionStrategy(sslContext, supportedProtocols, ciphers, verifier);
    }

    public static HostnameVerifier getHostnameVerifier(SSLConfiguration sslConfiguration) {
        if (sslConfiguration.verificationMode().isHostnameVerificationEnabled()) {
            return new DefaultHostnameVerifier();
        }
        return NoopHostnameVerifier.INSTANCE;
    }

    SSLParameters sslParameters(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters();
    }

    SSLIOSessionStrategy sslIOSessionStrategy(SSLContext sslContext, String[] protocols, String[] ciphers, final HostnameVerifier verifier) {
        return new SSLIOSessionStrategy(sslContext, protocols, ciphers, verifier){

            protected void verifySession(HttpHost host, IOSession iosession, SSLSession session) throws SSLException {
                if (!verifier.verify(host.getHostName(), session)) {
                    Certificate[] certs = session.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    X500Principal x500Principal = x509.getSubjectX500Principal();
                    String altNames = Strings.collectionToCommaDelimitedString((Iterable)SslDiagnostics.describeValidHostnames((X509Certificate)x509));
                    throw new SSLPeerUnverifiedException(LoggerMessageFormat.format((String)"Expected SSL certificate to be valid for host [{}], but it is only valid for subject alternative names [{}] and subject [{}]", (Object[])new Object[]{host.getHostName(), altNames, x500Principal.toString()}));
                }
            }
        };
    }

    public SSLSocketFactory sslSocketFactory(SSLConfiguration configuration) {
        SSLContextHolder contextHolder = this.sslContextHolder(configuration);
        SSLSocketFactory socketFactory = contextHolder.sslContext().getSocketFactory();
        SecuritySSLSocketFactory securitySSLSocketFactory = new SecuritySSLSocketFactory(() -> contextHolder.sslContext().getSocketFactory(), configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY), this.supportedCiphers(socketFactory.getSupportedCipherSuites(), configuration.cipherSuites(), false));
        contextHolder.addReloadListener(securitySSLSocketFactory::reload);
        return securitySSLSocketFactory;
    }

    public SSLEngine createSSLEngine(SSLConfiguration configuration, String host, int port) {
        SSLContext sslContext = this.sslContext(configuration);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        String[] ciphers = this.supportedCiphers(sslEngine.getSupportedCipherSuites(), configuration.cipherSuites(), false);
        String[] supportedProtocols = configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        SSLParameters parameters = new SSLParameters(ciphers, supportedProtocols);
        if (configuration.verificationMode().isHostnameVerificationEnabled() && host != null) {
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        parameters.setUseCipherSuitesOrder(true);
        configuration.sslClientAuth().configure(parameters);
        sslEngine.setSSLParameters(parameters);
        return sslEngine;
    }

    public boolean isConfigurationValidForServerUsage(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSLConfiguration cannot be null");
        return sslConfiguration.keyConfig() != KeyConfig.NONE;
    }

    public boolean isSSLClientAuthEnabled(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSLConfiguration cannot be null");
        return sslConfiguration.sslClientAuth().enabled();
    }

    public SSLContext sslContext(SSLConfiguration configuration) {
        return this.sslContextHolder(configuration).sslContext();
    }

    public void reloadSSLContext(SSLConfiguration configuration) {
        this.sslContextHolder(configuration).reload();
    }

    SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSL Configuration cannot be null");
        SSLContextHolder holder = this.sslContexts.get(sslConfiguration);
        if (holder == null) {
            throw new IllegalArgumentException("did not find an SSLContext for [" + sslConfiguration.toString() + "]");
        }
        return holder;
    }

    public SSLConfiguration sslConfiguration(Settings settingsToUse) {
        return new SSLConfiguration(settingsToUse);
    }

    public Set<String> getTransportProfileContextNames() {
        return Collections.unmodifiableSet(this.sslConfigurations.keySet().stream().filter(k -> k.startsWith("transport.profiles.")).collect(Collectors.toSet()));
    }

    Collection<SSLConfiguration> getLoadedSSLConfigurations() {
        return Collections.unmodifiableSet(new HashSet<SSLConfiguration>(this.sslContexts.keySet()));
    }

    String[] supportedCiphers(String[] supportedCiphers, List<String> requestedCiphers, boolean log) {
        ArrayList<String> supportedCiphersList = new ArrayList<String>(requestedCiphers.size());
        LinkedList<String> unsupportedCiphers = new LinkedList<String>();
        for (String requestedCipher : requestedCiphers) {
            boolean found = false;
            for (String supportedCipher : supportedCiphers) {
                if (!supportedCipher.equals(requestedCipher)) continue;
                found = true;
                supportedCiphersList.add(requestedCipher);
                break;
            }
            if (found) continue;
            unsupportedCiphers.add(requestedCipher);
        }
        if (supportedCiphersList.isEmpty()) {
            throw new IllegalArgumentException("none of the ciphers " + Arrays.toString(requestedCiphers.toArray()) + " are supported by this JVM");
        }
        if (log && !unsupportedCiphers.isEmpty()) {
            logger.error("unsupported ciphers [{}] were requested but cannot be used in this JVM, however there are supported ciphers that will be used [{}]. If you are trying to use ciphers with a key length greater than 128 bits on an Oracle JVM, you will need to install the unlimited strength JCE policy files.", unsupportedCiphers, supportedCiphersList);
        }
        return supportedCiphersList.toArray(new String[supportedCiphersList.size()]);
    }

    private SSLContextHolder createSslContext(SSLConfiguration sslConfiguration) {
        if (logger.isDebugEnabled()) {
            logger.debug("using ssl settings [{}]", (Object)sslConfiguration);
        }
        X509ExtendedTrustManager trustManager = sslConfiguration.trustConfig().createTrustManager(this.env);
        X509ExtendedKeyManager keyManager = sslConfiguration.keyConfig().createKeyManager(this.env);
        return this.createSslContext(keyManager, trustManager, sslConfiguration);
    }

    private SSLContextHolder createSslContext(X509ExtendedKeyManager keyManager, X509ExtendedTrustManager trustManager, SSLConfiguration sslConfiguration) {
        trustManager = this.wrapWithDiagnostics(trustManager, sslConfiguration);
        try {
            SSLContext sslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(sslConfiguration.supportedProtocols()));
            sslContext.init(new X509ExtendedKeyManager[]{keyManager}, new X509ExtendedTrustManager[]{trustManager}, null);
            this.supportedCiphers(sslContext.getSupportedSSLParameters().getCipherSuites(), sslConfiguration.cipherSuites(), true);
            return new SSLContextHolder(sslContext, sslConfiguration);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
        }
    }

    X509ExtendedTrustManager wrapWithDiagnostics(X509ExtendedTrustManager trustManager, SSLConfiguration configuration) {
        if (this.diagnoseTrustExceptions && !(trustManager instanceof DiagnosticTrustManager)) {
            Logger diagnosticLogger = LogManager.getLogger(DiagnosticTrustManager.class);
            Supplier<String> contextName = () -> {
                List names = this.sslConfigurations.entrySet().stream().filter(e -> ((SSLConfiguration)e.getValue()).equals(configuration)).limit(2L).map(Map.Entry::getKey).collect(Collectors.toList());
                switch (names.size()) {
                    case 0: {
                        return "(unknown)";
                    }
                    case 1: {
                        return (String)names.get(0);
                    }
                }
                return "(shared)";
            };
            trustManager = new DiagnosticTrustManager(trustManager, contextName, (arg_0, arg_1) -> ((Logger)diagnosticLogger).warn(arg_0, arg_1));
        }
        return trustManager;
    }

    public static Map<String, SSLConfiguration> getSSLConfigurations(Settings settings) {
        Map<String, Settings> sslSettingsMap = SSLService.getSSLSettingsMap(settings);
        HashMap sslConfigurationMap = new HashMap(sslSettingsMap.size());
        sslSettingsMap.forEach((key, sslSettings) -> {
            if (key.endsWith(".")) {
                key = key.substring(0, key.length() - 1);
            }
            sslConfigurationMap.put(key, new SSLConfiguration((Settings)sslSettings));
        });
        return Collections.unmodifiableMap(sslConfigurationMap);
    }

    static Map<String, Settings> getSSLSettingsMap(Settings settings) {
        HashMap<String, Settings> sslSettingsMap = new HashMap<String, Settings>();
        sslSettingsMap.put(XPackSettings.HTTP_SSL_PREFIX, SSLService.getHttpTransportSSLSettings(settings));
        sslSettingsMap.put("xpack.http.ssl", settings.getByPrefix("xpack.http.ssl."));
        sslSettingsMap.putAll(SSLService.getRealmsSSLSettings(settings));
        sslSettingsMap.putAll(SSLService.getMonitoringExporterSettings(settings));
        sslSettingsMap.put("xpack.notification.email.ssl.", settings.getByPrefix("xpack.notification.email.ssl."));
        sslSettingsMap.put(XPackSettings.TRANSPORT_SSL_PREFIX, settings.getByPrefix(XPackSettings.TRANSPORT_SSL_PREFIX));
        sslSettingsMap.putAll(SSLService.getTransportProfileSSLSettings(settings));
        return Collections.unmodifiableMap(sslSettingsMap);
    }

    Map<SSLConfiguration, SSLContextHolder> loadSSLConfigurations(Map<String, SSLConfiguration> sslConfigurationMap) {
        HashMap sslContextHolders = new HashMap(sslConfigurationMap.size());
        sslConfigurationMap.forEach((key, sslConfiguration) -> {
            try {
                sslContextHolders.computeIfAbsent(sslConfiguration, this::createSslContext);
            }
            catch (Exception e) {
                throw new ElasticsearchSecurityException("failed to load SSL configuration [{}]", e, new Object[]{key});
            }
        });
        for (String context : Arrays.asList("xpack.security.transport.ssl", "xpack.security.http.ssl")) {
            this.validateServerConfiguration(context);
        }
        this.sslConfigurations.forEach(this::validateTruststoresContainTrustEntries);
        return Collections.unmodifiableMap(sslContextHolders);
    }

    private void validateServerConfiguration(String prefix) {
        List sslSettingNames;
        assert (prefix.endsWith(".ssl"));
        SSLConfiguration configuration = this.getSSLConfiguration(prefix);
        String enabledSetting = prefix + ".enabled";
        if (this.settings.getAsBoolean(enabledSetting, Boolean.valueOf(false)).booleanValue()) {
            SSLConfigurationSettings configurationSettings = SSLConfigurationSettings.withPrefix(prefix + ".");
            if (!this.isConfigurationValidForServerUsage(configuration)) {
                deprecationLogger.critical(DeprecationCategory.SECURITY, "invalid_ssl_configuration", "invalid SSL configuration for " + prefix + " - server ssl configuration requires a key and certificate, but these have not been configured; you must set either [" + configurationSettings.x509KeyPair.keystorePath.getKey() + "], or both [" + configurationSettings.x509KeyPair.keyPath.getKey() + "] and [" + configurationSettings.x509KeyPair.certificatePath.getKey() + "]", new Object[0]);
            }
        } else if (!this.settings.hasValue(enabledSetting) && !(sslSettingNames = this.settings.keySet().stream().filter(s -> s.startsWith(prefix)).sorted().collect(Collectors.toList())).isEmpty()) {
            deprecationLogger.critical(DeprecationCategory.SECURITY, "invalid_ssl_configuration", "invalid configuration for " + prefix + " - [" + enabledSetting + "] is not set, but the following settings have been configured in elasticsearch.yml : [" + Strings.collectionToCommaDelimitedString(sslSettingNames) + "]", new Object[0]);
        }
    }

    void validateTruststoresContainTrustEntries(String prefix, SSLConfiguration configuration) {
        assert (prefix.endsWith(".ssl"));
        if (configuration.trustConfig() instanceof StoreTrustConfig) {
            StoreTrustConfig storeConfig = (StoreTrustConfig)configuration.trustConfig();
            Path path = storeConfig.resolveTrustStorePath(this.env);
            try {
                KeyStore store = storeConfig.getStore(path);
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!store.isCertificateEntry(alias)) continue;
                    return;
                }
            }
            catch (IOException | GeneralSecurityException e) {
                logger.warn("Failed to read truststore [" + path + "] for SSL configuration [" + prefix + "]", (Throwable)e);
                return;
            }
            deprecationLogger.critical(DeprecationCategory.SECURITY, "invalid_ssl_configuration", "invalid configuration for [" + prefix + "] - the truststore [" + path + "] does not contain any trusted certificate entries", new Object[0]);
        }
    }

    public Set<CertificateInfo> getLoadedCertificates() throws GeneralSecurityException, IOException {
        HashSet<CertificateInfo> certificates = new HashSet<CertificateInfo>();
        for (SSLConfiguration config : this.getLoadedSSLConfigurations()) {
            certificates.addAll(config.getDefinedCertificates(this.env));
        }
        return certificates;
    }

    static void invalidateSessions(SSLSessionContext sslSessionContext) {
        Enumeration<byte[]> sessionIds = sslSessionContext.getIds();
        while (sessionIds.hasMoreElements()) {
            byte[] sessionId = sessionIds.nextElement();
            SSLSession session = sslSessionContext.getSession(sessionId);
            if (session == null) continue;
            session.invalidate();
        }
    }

    private static Map<String, Settings> getRealmsSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        String prefix = "xpack.security.authc.realms.";
        Map settingsByRealmType = settings.getGroups("xpack.security.authc.realms.");
        settingsByRealmType.forEach((realmType, typeSettings) -> {
            Optional<String> nonDottedSetting = typeSettings.keySet().stream().filter(k -> k.indexOf(46) == -1).findAny();
            if (nonDottedSetting.isPresent()) {
                logger.warn("Skipping any SSL configuration from realm [{}{}] because the key [{}] is not in the correct format", (Object)"xpack.security.authc.realms.", realmType, (Object)nonDottedSetting.get());
            } else {
                typeSettings.getAsGroups().forEach((realmName, realmSettings) -> {
                    Settings realmSSLSettings = realmSettings.getByPrefix("ssl.");
                    sslSettings.put("xpack.security.authc.realms." + realmType + "." + realmName + ".ssl", realmSSLSettings);
                });
            }
        });
        return sslSettings;
    }

    private static Map<String, Settings> getTransportProfileSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map profiles = settings.getGroups("transport.profiles.", true);
        for (Map.Entry entry : profiles.entrySet()) {
            Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("xpack.security.ssl.");
            sslSettings.put("transport.profiles." + (String)entry.getKey() + ".xpack.security.ssl", profileSettings);
        }
        return sslSettings;
    }

    private static Settings getHttpTransportSSLSettings(Settings settings) {
        Settings httpSSLSettings = settings.getByPrefix(XPackSettings.HTTP_SSL_PREFIX);
        if (httpSSLSettings.isEmpty()) {
            return httpSSLSettings;
        }
        Settings.Builder builder = Settings.builder().put(httpSSLSettings);
        if (builder.get("client_authentication") == null) {
            builder.put("client_authentication", (Enum)XPackSettings.HTTP_CLIENT_AUTH_DEFAULT);
        }
        return builder.build();
    }

    public SSLConfiguration getHttpTransportSSLConfiguration() {
        return this.getSSLConfiguration(XPackSettings.HTTP_SSL_PREFIX);
    }

    private static Map<String, Settings> getMonitoringExporterSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map exportersSettings = settings.getGroups("xpack.monitoring.exporters.");
        for (Map.Entry entry : exportersSettings.entrySet()) {
            Settings exporterSSLSettings = ((Settings)entry.getValue()).getByPrefix("ssl.");
            sslSettings.put("xpack.monitoring.exporters." + (String)entry.getKey() + ".ssl", exporterSSLSettings);
        }
        return sslSettings;
    }

    public SSLConfiguration getSSLConfiguration(String contextName) {
        SSLConfiguration configuration;
        if (contextName.endsWith(".")) {
            contextName = contextName.substring(0, contextName.length() - 1);
        }
        if ((configuration = this.sslConfigurations.get(contextName)) == null) {
            logger.warn("Cannot find SSL configuration for context {}. Known contexts are: {}", (Object)contextName, (Object)Strings.collectionToCommaDelimitedString(this.sslConfigurations.keySet()));
        }
        return configuration;
    }

    private static String sslContextAlgorithm(List<String> supportedProtocols) {
        if (supportedProtocols.isEmpty()) {
            throw new IllegalArgumentException("no SSL/TLS protocols have been configured");
        }
        for (Map.Entry<String, String> entry : ORDERED_PROTOCOL_ALGORITHM_MAP.entrySet()) {
            if (!supportedProtocols.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("no supported SSL/TLS protocol was found in the configured supported protocols: " + supportedProtocols);
    }

    private boolean shouldEnableDiagnoseTrust() {
        if (SSLService.inSunJsseInFipsMode()) {
            logger.info("diagnostic messages for SSL/TLS trust cannot be enabled for SunJSSE in FIPS mode.");
            return false;
        }
        if (((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(this.settings)).booleanValue() && !XPackSettings.DIAGNOSE_TRUST_EXCEPTIONS_SETTING.exists(this.settings)) {
            logger.info("diagnostic messages for SSL/TLS trust failures are not enabled in FIPS 140 mode by default.");
            return false;
        }
        return (Boolean)XPackSettings.DIAGNOSE_TRUST_EXCEPTIONS_SETTING.get(this.settings);
    }

    static boolean inSunJsseInFipsMode() {
        return (Integer)JavaVersion.current().getVersion().get(0) == 8 && Arrays.stream(Security.getProviders()).anyMatch(provider -> provider.getName().equals("SunJSSE") && provider.getInfo().contains("FIPS mode"));
    }

    static {
        LinkedHashMap<String, String> protocolAlgorithmMap = new LinkedHashMap<String, String>();
        if (XPackSettings.DEFAULT_SUPPORTED_PROTOCOLS.contains("TLSv1.3")) {
            protocolAlgorithmMap.put("TLSv1.3", "TLSv1.3");
        }
        protocolAlgorithmMap.put("TLSv1.2", "TLSv1.2");
        protocolAlgorithmMap.put("TLSv1.1", "TLSv1.1");
        protocolAlgorithmMap.put("TLSv1", "TLSv1");
        protocolAlgorithmMap.put("SSLv3", "SSLv3");
        protocolAlgorithmMap.put("SSLv2", "SSL");
        protocolAlgorithmMap.put("SSLv2Hello", "SSL");
        ORDERED_PROTOCOL_ALGORITHM_MAP = Collections.unmodifiableMap(protocolAlgorithmMap);
    }

    final class SSLContextHolder {
        private volatile SSLContext context;
        private final KeyConfig keyConfig;
        private final TrustConfig trustConfig;
        private final SSLConfiguration sslConfiguration;
        private final List<Runnable> reloadListeners;

        SSLContextHolder(SSLContext context, SSLConfiguration sslConfiguration) {
            this.context = context;
            this.sslConfiguration = sslConfiguration;
            this.keyConfig = sslConfiguration.keyConfig();
            this.trustConfig = sslConfiguration.trustConfig();
            this.reloadListeners = new ArrayList<Runnable>();
        }

        SSLContext sslContext() {
            return this.context;
        }

        synchronized void reload() {
            SSLService.invalidateSessions(this.context.getClientSessionContext());
            SSLService.invalidateSessions(this.context.getServerSessionContext());
            this.reloadSslContext();
            this.reloadListeners.forEach(Runnable::run);
        }

        private void reloadSslContext() {
            try {
                X509ExtendedKeyManager loadedKeyManager = this.keyConfig.createKeyManager(SSLService.this.env);
                X509ExtendedTrustManager loadedTrustManager = this.trustConfig.createTrustManager(SSLService.this.env);
                loadedTrustManager = SSLService.this.wrapWithDiagnostics(loadedTrustManager, this.sslConfiguration);
                SSLContext loadedSslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(this.sslConfiguration.supportedProtocols()));
                loadedSslContext.init(new X509ExtendedKeyManager[]{loadedKeyManager}, new X509ExtendedTrustManager[]{loadedTrustManager}, null);
                SSLService.this.supportedCiphers(loadedSslContext.getSupportedSSLParameters().getCipherSuites(), this.sslConfiguration.cipherSuites(), false);
                this.context = loadedSslContext;
            }
            catch (GeneralSecurityException e) {
                throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
            }
        }

        public void addReloadListener(Runnable listener) {
            this.reloadListeners.add(listener);
        }
    }

    private static class SecuritySSLSocketFactory
    extends SSLSocketFactory {
        private final Supplier<SSLSocketFactory> delegateSupplier;
        private final String[] supportedProtocols;
        private final String[] ciphers;
        private volatile SSLSocketFactory delegate;

        SecuritySSLSocketFactory(Supplier<SSLSocketFactory> delegateSupplier, String[] supportedProtocols, String[] ciphers) {
            this.delegateSupplier = delegateSupplier;
            this.delegate = this.delegateSupplier.get();
            this.supportedProtocols = supportedProtocols;
            this.ciphers = ciphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)this.delegate::createSocket));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(socket, host, port, autoClose)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port, localHost, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(address, port, localAddress, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        public void reload() {
            SSLSocketFactory newDelegate;
            this.delegate = newDelegate = this.delegateSupplier.get();
        }

        private void configureSSLSocket(SSLSocket socket) {
            SSLParameters parameters = new SSLParameters(this.ciphers, this.supportedProtocols);
            parameters.setUseCipherSuitesOrder(true);
            socket.setSSLParameters(parameters);
        }

        private static SSLSocket createWithPermissions(CheckedSupplier<Socket, IOException> supplier) throws IOException {
            return (SSLSocket)SocketAccess.doPrivileged(supplier);
        }
    }
}

