package v2

// VulnerabilityMetadata represents all vulnerability data that is not necessary to perform package-to-vulnerability matching.
type VulnerabilityMetadata struct {
	ID           string   // The identifier of the vulnerability or advisory
	RecordSource string   // The source of the vulnerability information
	Severity     string   // How severe the vulnerability is (valid values are defined by upstream sources currently)
	Links        []string // URLs to get more information about the vulnerability or advisory
	Description  string   // Description of the vulnerability
	CvssV2       *Cvss    // Common Vulnerability Scoring System V2 values
	CvssV3       *Cvss    // Common Vulnerability Scoring System V3 values
}

// Cvss contains select Common Vulnerability Scoring System fields for a vulnerability.
type Cvss struct {
	BaseScore           float64 // Ranges from 0 - 10 and defines for qualities intrinsic to a vulnerability
	ExploitabilityScore float64 // Indicator of how easy it may be for an attacker to exploit a vulnerability
	ImpactScore         float64 // Representation of the effects of an exploited vulnerability relative to compromise in confidentiality, integrity, and availability
	Vector              string  // A textual representation of the metric values used to determine the score
}
