/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/* Copyright (C) 2025 Hans Petter Jansson
 *
 * This file is part of Chafa, a program that shows pictures on text terminals.
 *
 * Chafa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Chafa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Chafa.  If not, see <http://www.gnu.org/licenses/>. */

#include "config.h"

#include "chafa.h"
#include "internal/chafa-noise.h"

/* Blue noise texture from https://momentsingraphics.de/BlueNoise.html by
 * Christoph Peters. Generated by void and cluster method. Released under
 * Creative Commons CC0 Public Domain Dedication (thanks!).
 *
 * LDR_RGB1_0.png */
static const unsigned char blue_noise_src [CHAFA_NOISE_TEXTURE_ARRAY_LEN] =
{
    0xda, 0x15, 0x5b, 0x6e, 0xdd, 0x6d, 0xa6, 0x9c, 0xd4, 0x1c, 0x0b, 0x4a, 0xe6, 0x75, 0x7e, 0x3a, 0xf6, 0x66, 0x9f, 0x8d, 0x10, 0x48, 0x08, 0xaa, 0x05, 0xd9, 0x78, 0xa7, 0x60, 0x00, 0x79, 0xb6, 0x3f, 0xd2, 0xe0, 0x6a, 0x8f, 0x56, 0x26, 0x51, 0x25, 0x07, 0x19, 0x65, 0x39, 0x42, 0xa7, 0xc1, 0xe2, 0x49, 0x1f, 0xf2, 0xe6, 0x32, 0x9f, 0x68, 0xfe, 0x4f, 0xac, 0x87, 0x7a, 0x8d, 0xbc, 0xb4, 
    0xcc, 0x28, 0xf0, 0x5b, 0xea, 0x6d, 0xa2, 0x6a, 0xbd, 0xc2, 0xfc, 0xdb, 0x93, 0xa2, 0x1f, 0xb4, 0xb5, 0x4f, 0x72, 0xe8, 0x6c, 0x2e, 0x42, 0x9a, 0x59, 0x97, 0x58, 0x4b, 0x2b, 0x2e, 0xd1, 0xf1, 0xe9, 0xa3, 0x39, 0xde, 0x80, 0x7f, 0x52, 0xc9, 0x68, 0x9e, 0x17, 0xd6, 0xcb, 0xe9, 0x44, 0x5e, 0x69, 0x31, 0x95, 0x24, 0xab, 0x41, 0x32, 0x79, 0xfb, 0x7c, 0xcd, 0x9f, 0xb0, 0x43, 0x5d, 0x20, 
    0x64, 0xbd, 0x88, 0xb3, 0xed, 0xee, 0x77, 0x95, 0xbc, 0x20, 0x01, 0x93, 0xa1, 0xa3, 0x5a, 0x0e, 0xf3, 0x9e, 0xae, 0x73, 0x35, 0xcd, 0x39, 0x67, 0xf2, 0x7e, 0x55, 0x58, 0xe1, 0x90, 0xd7, 0x9f, 0xb9, 0x12, 0x77, 0x78, 0xe9, 0x49, 0xcd, 0xc2, 0xea, 0x0f, 0x3c, 0xb8, 0xe1, 0xa2, 0x1f, 0x92, 0x4c, 0x74, 0xc1, 0x8a, 0xaf, 0x6a, 0xf6, 0x4f, 0x53, 0x68, 0x9c, 0xef, 0xbf, 0x5e, 0xc5, 0x33, 
    0x0b, 0x35, 0xdc, 0x8e, 0xb7, 0x89, 0xf2, 0x4e, 0x04, 0x7c, 0xce, 0x9b, 0x63, 0x42, 0xe3, 0xc3, 0xb1, 0x1d, 0x2a, 0x30, 0xb8, 0xb8, 0x51, 0x4d, 0xe1, 0x7e, 0x34, 0xf6, 0x94, 0xf3, 0x22, 0x14, 0x59, 0x10, 0x73, 0xb2, 0x6c, 0x0d, 0xdc, 0xfd, 0x87, 0x4f, 0xa6, 0xd9, 0x99, 0x76, 0x3c, 0xeb, 0x58, 0x93, 0xad, 0x2b, 0x76, 0x72, 0xba, 0x20, 0x96, 0x8b, 0x2f, 0x3f, 0x35, 0x0a, 0x62, 0x5e, 
    0x6f, 0x7e, 0xa6, 0xf5, 0xac, 0x26, 0x0f, 0x3a, 0x57, 0xe8, 0x01, 0x78, 0x1c, 0x76, 0x33, 0x3b, 0x5c, 0xc7, 0xf4, 0x34, 0x83, 0xa1, 0x0f, 0x00, 0x01, 0x68, 0xb8, 0x92, 0xca, 0x88, 0x77, 0x4b, 0x1d, 0x0e, 0xa6, 0xa6, 0x2a, 0xc0, 0x3a, 0x52, 0x27, 0xfe, 0x95, 0xf4, 0x73, 0x87, 0x99, 0x01, 0x48, 0x4f, 0xb8, 0xde, 0xec, 0x55, 0xbb, 0x90, 0xcd, 0x91, 0x57, 0x35, 0xe6, 0x2b, 0xde, 0x66, 
    0x8c, 0x2b, 0x09, 0x01, 0x16, 0x39, 0xc7, 0xd8, 0x51, 0x51, 0x6b, 0x2b, 0x6c, 0x84, 0xe5, 0xe2, 0xcf, 0xcd, 0x37, 0x4a, 0x0d, 0x63, 0x93, 0xfb, 0x77, 0xef, 0xa4, 0x19, 0x2e, 0x43, 0x30, 0x55, 0x04, 0x6c, 0x00, 0x64, 0x9a, 0xaa, 0x24, 0x5d, 0x33, 0xb4, 0x1e, 0x59, 0x5e, 0xef, 0xfd, 0x31, 0x72, 0x42, 0xd7, 0xda, 0xca, 0xa8, 0x25, 0x13, 0x29, 0x99, 0x81, 0x0e, 0x83, 0xc4, 0x93, 0x1b, 
    0x45, 0xf9, 0xf8, 0x57, 0x70, 0x3f, 0x27, 0x2a, 0xb1, 0xaf, 0xa8, 0x61, 0x08, 0x5e, 0x2b, 0xfb, 0xd5, 0x8f, 0x8f, 0x16, 0xfb, 0x14, 0xbe, 0x6d, 0x80, 0xff, 0xca, 0x5f, 0x48, 0x93, 0x98, 0xcf, 0x1a, 0x44, 0x36, 0xc6, 0xdd, 0x9a, 0x73, 0x34, 0xc8, 0xfa, 0xc2, 0xef, 0x15, 0x07, 0x00, 0x7e, 0x94, 0xc1, 0xd9, 0xc9, 0xd4, 0x03, 0x65, 0x54, 0xc7, 0xfc, 0xf0, 0xe3, 0x1f, 0x47, 0x12, 0x99, 
    0x96, 0x1e, 0xcb, 0xb1, 0xc4, 0x46, 0x29, 0x95, 0xf9, 0x84, 0xe1, 0x94, 0x52, 0xbe, 0xa9, 0xcf, 0x8b, 0xf4, 0x61, 0xf6, 0x42, 0x80, 0x9e, 0xee, 0xc7, 0xe2, 0xd6, 0xae, 0xb1, 0x70, 0xeb, 0x0a, 0xc5, 0x69, 0xeb, 0x64, 0xdb, 0x93, 0x92, 0xfb, 0x57, 0x12, 0xaa, 0x01, 0x47, 0x08, 0xc8, 0x85, 0xef, 0x82, 0xe4, 0x9e, 0x0e, 0x1f, 0x13, 0xb8, 0x7e, 0x3f, 0x20, 0xb3, 0x53, 0xe5, 0x05, 0x9b, 
    0xa4, 0x8d, 0xcd, 0xd7, 0xa9, 0x75, 0xf1, 0x3b, 0xb5, 0x2e, 0x54, 0x83, 0xb8, 0x2f, 0x6b, 0xfc, 0x1e, 0x21, 0x8f, 0xb7, 0xaf, 0x08, 0x07, 0x79, 0xa6, 0x69, 0x2a, 0xbc, 0xaf, 0xd0, 0xed, 0xcd, 0x83, 0x8d, 0x89, 0xf4, 0x45, 0xdb, 0x9d, 0xd3, 0xc2, 0x3f, 0x84, 0x7f, 0x7d, 0x2e, 0x98, 0xfb, 0xac, 0x28, 0x17, 0x11, 0x63, 0x75, 0x3a, 0xe1, 0xe9, 0xc8, 0x34, 0xb0, 0x49, 0xed, 0x60, 0xa2, 
    0xa3, 0x1f, 0xbb, 0xcf, 0xe2, 0x74, 0xe1, 0x87, 0x15, 0x36, 0x04, 0xef, 0x87, 0xea, 0xc3, 0x50, 0x7a, 0x58, 0xd6, 0x9a, 0x41, 0x6f, 0x6c, 0xd8, 0x3c, 0xa6, 0x24, 0xae, 0x27, 0xa0, 0xcd, 0xe6, 0xe6, 0x87, 0x64, 0x89, 0xb4, 0xba, 0x2c, 0x62, 0x4e, 0xab, 0x25, 0x2d, 0x62, 0x84, 0x5e, 0x42, 0xdb, 0x19, 0x59, 0x3c, 0xb0, 0x29, 0x0e, 0x85, 0x4c, 0x49, 0xdf, 0xa5, 0xdf, 0xbc, 0xf8, 0x06, 
    0x7a, 0x54, 0xe6, 0x38, 0xd3, 0x87, 0xd7, 0x46, 0x0f, 0x67, 0x29, 0xd2, 0x9d, 0x16, 0x17, 0x08, 0x4c, 0x63, 0xe4, 0xc5, 0x26, 0x26, 0x24, 0xa1, 0x46, 0x58, 0x35, 0x1d, 0x78, 0x0d, 0x34, 0x88, 0x4b, 0xb7, 0x19, 0xee, 0x42, 0x71, 0x24, 0x1f, 0x3c, 0xd0, 0x62, 0xb9, 0xac, 0x3b, 0x60, 0xf2, 0xb4, 0xe1, 0x2a, 0x5c, 0x6a, 0xa4, 0x74, 0x3b, 0x6d, 0xfd, 0xf9, 0x4a, 0x29, 0x72, 0xf5, 0xc0, 
    0x49, 0x61, 0xde, 0x7f, 0x74, 0x17, 0x14, 0xba, 0xfa, 0x9b, 0xfe, 0x00, 0x5a, 0xdf, 0x45, 0x1d, 0x9e, 0xc3, 0x7d, 0xe8, 0x8b, 0xdb, 0x5d, 0x4d, 0x50, 0xc5, 0xe7, 0x3f, 0x12, 0xc0, 0xcb, 0xf5, 0x14, 0x24, 0x23, 0xd9, 0xb0, 0x64, 0x55, 0xf9, 0x16, 0xc6, 0x15, 0xe5, 0xa5, 0xbb, 0x0c, 0x00, 0x91, 0xd4, 0x4a, 0x5a, 0x8e, 0x8d, 0xd4, 0xa9, 0xcc, 0x79, 0x6f, 0x82, 0xeb, 0x19, 0x45, 0x0e, 
    0x7a, 0xa1, 0x51, 0x94, 0x55, 0x94, 0x10, 0xc4, 0xd1, 0x6a, 0x94, 0x39, 0xc8, 0x38, 0xa3, 0x9d, 0x22, 0x07, 0x21, 0xf1, 0xb4, 0xbe, 0x3f, 0x82, 0xf0, 0x02, 0x0f, 0x2f, 0x89, 0x60, 0x51, 0xad, 0x3c, 0x09, 0x1d, 0x4b, 0xf5, 0xf7, 0x0b, 0x9e, 0x7f, 0x92, 0x48, 0xa4, 0xbc, 0xef, 0xea, 0xcc, 0xa8, 0x6d, 0xef, 0x6d, 0x37, 0x8e, 0xb1, 0x9c, 0xb8, 0x80, 0x07, 0x80, 0xbe, 0x61, 0x31, 0x72, 
    0xcb, 0x70, 0x2e, 0x1e, 0x88, 0x68, 0xec, 0xf3, 0x3e, 0x45, 0x64, 0xb8, 0xac, 0x81, 0x53, 0x78, 0xdb, 0xe1, 0xb8, 0x6f, 0x74, 0x8d, 0x06, 0xc2, 0xff, 0xd4, 0x5a, 0xd3, 0x44, 0x96, 0x5b, 0x32, 0xb2, 0x86, 0xcd, 0xda, 0x9f, 0xdc, 0x7f, 0xc3, 0xfd, 0x57, 0xd6, 0xa8, 0xbf, 0x7d, 0x14, 0x65, 0x2c, 0x2e, 0x3d, 0xd1, 0xa3, 0xd6, 0xc5, 0xd1, 0x0c, 0x04, 0x95, 0xe2, 0xa8, 0x0a, 0x98, 0x7f, 
    0xb2, 0xc7, 0x48, 0x61, 0x46, 0x5e, 0x3d, 0x08, 0x94, 0x8a, 0x8a, 0xa7, 0xd2, 0x13, 0xd5, 0x46, 0x7b, 0xf1, 0xc5, 0x3f, 0x13, 0x29, 0x28, 0x9a, 0xf6, 0x99, 0x5e, 0x5f, 0x4e, 0x36, 0x9f, 0x74, 0x6f, 0x03, 0x38, 0x93, 0x79, 0xa4, 0x2d, 0x51, 0x46, 0x1c, 0x65, 0x71, 0x69, 0xe0, 0xb0, 0xed, 0x41, 0x54, 0xba, 0xfc, 0x3e, 0x59, 0x06, 0xf4, 0x36, 0xb0, 0x23, 0x06, 0x60, 0xba, 0xd5, 0x2f, 
    0x3a, 0x77, 0xe6, 0xff, 0x17, 0x68, 0x4a, 0xf5, 0x25, 0xb4, 0x65, 0x84, 0xed, 0xb9, 0xda, 0x5b, 0x53, 0x76, 0x42, 0xca, 0xe9, 0x00, 0xdb, 0x31, 0xa2, 0x5d, 0xac, 0xe6, 0xc5, 0xf6, 0x17, 0x78, 0xc0, 0xc3, 0x3d, 0x7c, 0x71, 0x07, 0xd5, 0x1c, 0x90, 0xe9, 0xd3, 0x43, 0x36, 0x54, 0xb9, 0x21, 0x13, 0x7b, 0xa1, 0xf6, 0xfe, 0x11, 0x23, 0x26, 0x68, 0xd5, 0x40, 0xdb, 0x91, 0xa7, 0x07, 0x51, 
    0x12, 0xb1, 0xab, 0x56, 0x9b, 0xc5, 0x88, 0x0f, 0x9f, 0xc0, 0xba, 0x7b, 0xf8, 0xa3, 0x04, 0x17, 0x30, 0x8b, 0x36, 0xad, 0xb0, 0x4f, 0x92, 0x1b, 0x6b, 0xee, 0x81, 0x98, 0xba, 0xf3, 0x16, 0xa1, 0x3e, 0xf2, 0x64, 0x75, 0x03, 0x4e, 0x05, 0x70, 0x23, 0x31, 0x90, 0x78, 0x8e, 0xf7, 0x88, 0x16, 0x1b, 0xf0, 0x9b, 0x4c, 0x4c, 0xc2, 0x89, 0x1c, 0x5a, 0x64, 0x59, 0x84, 0xec, 0xc8, 0x1a, 0x1d, 
    0x33, 0x28, 0x34, 0xf5, 0xec, 0xb2, 0xc1, 0xd3, 0xe8, 0xe3, 0x5b, 0x2c, 0x04, 0xac, 0x55, 0x72, 0xc4, 0x39, 0xae, 0x6d, 0x73, 0x96, 0xf9, 0xdc, 0x13, 0xd5, 0x04, 0x85, 0x84, 0xaa, 0x6e, 0xbd, 0x47, 0xe5, 0xe8, 0xfe, 0x34, 0x95, 0xb1, 0xc5, 0xd0, 0xde, 0x0c, 0x2f, 0x85, 0x9b, 0xf8, 0xca, 0x7d, 0xbf, 0x98, 0xc2, 0x02, 0x23, 0x6e, 0x85, 0xe5, 0x21, 0xcc, 0x66, 0x8f, 0x5d, 0xbc, 0xcd, 
    0x05, 0x31, 0x01, 0xd9, 0x40, 0xa8, 0x73, 0xda, 0xfe, 0x1b, 0x11, 0x47, 0x2d, 0xad, 0x18, 0x82, 0x7f, 0x66, 0xdd, 0x0c, 0x50, 0x78, 0x90, 0x97, 0x68, 0x2f, 0xd3, 0x93, 0x4e, 0x70, 0x5b, 0xec, 0x15, 0x7e, 0xd1, 0xa8, 0xe3, 0x70, 0x53, 0x38, 0xda, 0x6a, 0x8d, 0x24, 0x07, 0xbb, 0x0c, 0x86, 0x78, 0x52, 0x74, 0x31, 0xd2, 0xf5, 0x9b, 0xc3, 0x3b, 0x5c, 0x8f, 0xce, 0x3a, 0xe6, 0x5e, 0xfa, 
    0xf7, 0xec, 0x12, 0x99, 0x22, 0xeb, 0x6d, 0x39, 0x24, 0x0b, 0xcf, 0xda, 0x2d, 0x56, 0xff, 0x5e, 0xff, 0x37, 0xc9, 0x40, 0x47, 0xdd, 0x1d, 0xe6, 0x07, 0x7d, 0xce, 0xc0, 0x29, 0x2c, 0x76, 0xf8, 0x13, 0xe0, 0x90, 0xbb, 0x49, 0x05, 0x9d, 0x2d, 0xb3, 0xe0, 0x56, 0x98, 0xef, 0x0c, 0x43, 0x4f, 0x9a, 0xd9, 0x76, 0xad, 0xbe, 0xfd, 0xe3, 0x75, 0x32, 0x31, 0x85, 0xb7, 0x97, 0xde, 0x40, 0xd5, 
    0x17, 0xad, 0x6c, 0xa7, 0x7d, 0x89, 0x6c, 0x9c, 0x0e, 0x27, 0x36, 0x78, 0xa1, 0x21, 0x9f, 0xef, 0x4b, 0x64, 0x64, 0x8f, 0xb5, 0x3a, 0x0c, 0x27, 0xe0, 0xa9, 0xee, 0xba, 0x1d, 0x89, 0x1e, 0x43, 0xbb, 0xd2, 0x09, 0x0a, 0x8b, 0xb4, 0x78, 0xa7, 0x58, 0x4f, 0xee, 0x8a, 0x34, 0x25, 0x1e, 0x0e, 0x4e, 0x9f, 0x41, 0x32, 0x69, 0x70, 0xa5, 0xde, 0xa6, 0xf3, 0x4e, 0xfd, 0x43, 0x9c, 0x93, 0x81, 
    0x2b, 0xc9, 0x1d, 0xc0, 0xa9, 0xc6, 0x8a, 0x85, 0x5a, 0xce, 0x4a, 0xb9, 0xa9, 0x2b, 0x9e, 0x13, 0xe5, 0xf3, 0xfa, 0x6f, 0x23, 0xaf, 0xa3, 0xbd, 0x4b, 0xf8, 0x02, 0xd0, 0xb4, 0x44, 0x23, 0x11, 0xe3, 0x40, 0x9e, 0x29, 0xad, 0x55, 0x9b, 0x9b, 0xbf, 0xff, 0x04, 0xa8, 0xb5, 0x64, 0xe3, 0xde, 0xcf, 0x96, 0x4a, 0x44, 0x15, 0xac, 0xe6, 0x67, 0x1a, 0x00, 0x4b, 0x95, 0xcb, 0x73, 0x44, 0x1d, 
    0x30, 0xc3, 0x84, 0xb4, 0x50, 0x5f, 0x3f, 0xe2, 0x4c, 0xd3, 0x79, 0x92, 0x90, 0x04, 0x66, 0xe9, 0x68, 0xc9, 0xa0, 0xe6, 0x9e, 0x81, 0xc9, 0x08, 0xaa, 0x60, 0x6b, 0x2a, 0x52, 0xaa, 0x3d, 0x10, 0x60, 0xb3, 0xc1, 0xfc, 0xa2, 0x39, 0x44, 0xcc, 0xe8, 0x6a, 0xe9, 0xcc, 0xb0, 0xb9, 0x5b, 0x09, 0xdb, 0x08, 0xd1, 0x6d, 0xae, 0x20, 0x40, 0x28, 0x8c, 0x14, 0x9c, 0xe7, 0x57, 0xed, 0x6f, 0xba, 
    0x46, 0xd9, 0xf6, 0x90, 0x0f, 0x3f, 0x54, 0x67, 0xcf, 0x10, 0xf6, 0xbf, 0x83, 0xcd, 0x1c, 0x32, 0xe3, 0xf8, 0xcf, 0xb3, 0xc8, 0x0c, 0x30, 0x7f, 0x57, 0x58, 0x52, 0xa4, 0xe0, 0xce, 0x49, 0x6b, 0x63, 0xff, 0xff, 0x25, 0x5a, 0x7c, 0xea, 0x3d, 0x14, 0x90, 0x6b, 0xea, 0x5f, 0xb5, 0x4a, 0xf8, 0xdb, 0x7a, 0xd6, 0x14, 0x33, 0xb7, 0x95, 0x12, 0x1a, 0x55, 0xb2, 0x4e, 0xe0, 0xe9, 0x0b, 0xb5, 
    0x63, 0x5e, 0x98, 0xa5, 0xe9, 0x71, 0x54, 0x6b, 0x30, 0x3e, 0x9e, 0x8d, 0x65, 0xfc, 0x09, 0x92, 0xc0, 0xcd, 0xc1, 0x1a, 0x7d, 0x36, 0x44, 0x38, 0x0d, 0x64, 0x8f, 0xf1, 0x20, 0x57, 0xba, 0x83, 0x85, 0xdc, 0x2d, 0xc9, 0x6a, 0x68, 0x1a, 0xf9, 0xfa, 0x3b, 0x29, 0x34, 0x5f, 0xea, 0x62, 0x26, 0xa5, 0x84, 0xc6, 0x88, 0xee, 0x58, 0xb7, 0xad, 0xe6, 0x69, 0x04, 0x2a, 0xa1, 0x82, 0x7c, 0x75, 
    0xcf, 0xa5, 0xe1, 0x23, 0x6c, 0xb1, 0xe2, 0x8e, 0x31, 0xa9, 0xaf, 0x0e, 0x4d, 0x26, 0xbb, 0x71, 0x99, 0x1d, 0x20, 0x85, 0x58, 0x41, 0x14, 0xf7, 0x58, 0xa6, 0x90, 0xf6, 0xe0, 0x4c, 0x8a, 0x71, 0xd3, 0x60, 0xd5, 0x87, 0x21, 0x83, 0x1c, 0x7b, 0x68, 0xc7, 0x66, 0x2e, 0x29, 0x3a, 0x19, 0x81, 0x24, 0x6e, 0x3f, 0x81, 0xfc, 0xaa, 0xf1, 0x3d, 0x63, 0xcb, 0x66, 0x03, 0x7a, 0x03, 0x4b, 0x0a, 
    0xba, 0xc3, 0xa3, 0x78, 0x30, 0x25, 0xd6, 0x50, 0x50, 0xfe, 0x85, 0xdf, 0xbf, 0x02, 0x8f, 0x4c, 0x75, 0x48, 0xb4, 0x61, 0x0d, 0x90, 0xef, 0x33, 0xf1, 0x80, 0xa4, 0x7a, 0x9f, 0x1a, 0x2f, 0x35, 0x3c, 0x09, 0xca, 0x9b, 0x96, 0x28, 0xd3, 0x19, 0x62, 0x17, 0xcf, 0xd7, 0xaf, 0x82, 0xa8, 0x9f, 0x5f, 0xc5, 0x7b, 0xec, 0xf2, 0x2d, 0xca, 0x91, 0x8a, 0x0d, 0x41, 0xdb, 0x66, 0x7f, 0x7d, 0x3a, 
    0x0d, 0x28, 0xd2, 0x20, 0x1c, 0x4d, 0xe5, 0xd3, 0xee, 0xf3, 0x01, 0xe0, 0x07, 0x37, 0x40, 0xd4, 0x58, 0x5c, 0x56, 0x89, 0xa8, 0x1f, 0xd5, 0xde, 0x8b, 0xe2, 0xfb, 0x9f, 0x95, 0x64, 0x2f, 0xc3, 0xb7, 0x85, 0xe7, 0xf1, 0x15, 0x0b, 0x75, 0x4c, 0x8b, 0x91, 0x5a, 0x1b, 0xd3, 0xc5, 0x44, 0x7f, 0x1f, 0xca, 0x99, 0x0c, 0x2b, 0x00, 0x50, 0x3b, 0xbc, 0xf4, 0xdd, 0x89, 0x2a, 0xbe, 0xfd, 0xbc, 
    0x54, 0x09, 0x3d, 0x0f, 0x18, 0x98, 0x63, 0xf2, 0xf3, 0x7c, 0x42, 0xd2, 0x00, 0xd8, 0x77, 0xfb, 0xbd, 0x87, 0xba, 0x4c, 0x2e, 0x13, 0x35, 0xb5, 0xe5, 0xb4, 0x73, 0xc5, 0x8e, 0x22, 0x0c, 0x45, 0xe4, 0xd7, 0x1e, 0x36, 0xf0, 0xab, 0xa5, 0x13, 0x50, 0x5c, 0xab, 0xf5, 0xd8, 0x8c, 0xa0, 0xea, 0x52, 0x8d, 0x99, 0x01, 0xc5, 0x53, 0xbe, 0xe4, 0xcd, 0xa6, 0x53, 0xf6, 0x49, 0xd0, 0x9f, 0x91, 
    0x20, 0x8f, 0xe5, 0x2e, 0xef, 0x65, 0xac, 0xa8, 0x82, 0x3c, 0xbb, 0x03, 0x5e, 0x97, 0x6f, 0x1c, 0x3e, 0xae, 0xe9, 0x17, 0xe8, 0x68, 0xc0, 0x94, 0x24, 0xd1, 0x6a, 0xc7, 0x04, 0xf6, 0xdb, 0x51, 0xe0, 0xb0, 0xac, 0xbe, 0x76, 0x8d, 0x6c, 0xbe, 0xbc, 0x46, 0xf5, 0x07, 0xc4, 0x02, 0x3c, 0x03, 0x39, 0x5e, 0x52, 0xae, 0x24, 0x63, 0x88, 0xd2, 0xf0, 0x78, 0x70, 0x3d, 0x2a, 0xf8, 0xb0, 0xf7, 
    0x94, 0xf6, 0x09, 0xb1, 0x52, 0x7e, 0x33, 0xba, 0x12, 0x78, 0x94, 0xb0, 0x9c, 0x79, 0x27, 0x47, 0xcc, 0x6d, 0x6f, 0xa9, 0xc3, 0xe7, 0x07, 0x10, 0xcc, 0x34, 0x1e, 0x60, 0x75, 0xa4, 0x75, 0x40, 0x2f, 0x08, 0xce, 0x05, 0xbe, 0x4c, 0x4f, 0xd7, 0xb2, 0xae, 0x95, 0xd7, 0x0f, 0x73, 0x75, 0x44, 0x3f, 0xb9, 0xf6, 0xdd, 0x9f, 0x70, 0x7c, 0x5d, 0x38, 0x92, 0x1e, 0x60, 0x47, 0xfb, 0xb3, 0xd9, 
    0xa2, 0xd3, 0x09, 0x8b, 0x33, 0x54, 0xf2, 0xc7, 0x6e, 0xc5, 0x5f, 0xa7, 0x38, 0x0b, 0x44, 0x9b, 0xf9, 0xec, 0xd5, 0x72, 0xde, 0x67, 0xce, 0x3e, 0x92, 0x02, 0x10, 0x72, 0xf6, 0xc2, 0x35, 0x2b, 0x96, 0x51, 0x9b, 0x02, 0x97, 0xed, 0x78, 0x46, 0x0b, 0x49, 0xc2, 0xba, 0x91, 0xfe, 0xdd, 0x15, 0xd0, 0x7c, 0x6e, 0x9b, 0x31, 0xb6, 0x61, 0x13, 0x2c, 0x29, 0xa4, 0x12, 0xf9, 0x82, 0x78, 0x1d, 
    0xf7, 0x23, 0x36, 0x69, 0x5e, 0xc8, 0x98, 0x19, 0xb6, 0xdf, 0xdf, 0xff, 0x8a, 0x2a, 0x3d, 0x74, 0xfc, 0x20, 0x9e, 0xa5, 0x5d, 0x00, 0x47, 0xd9, 0x41, 0x25, 0xb6, 0x87, 0x95, 0x01, 0x50, 0x73, 0x7b, 0x63, 0xe7, 0x56, 0xe3, 0x45, 0x30, 0x2c, 0xf5, 0x87, 0x49, 0x6e, 0xf3, 0xa1, 0x97, 0x25, 0x6f, 0xe4, 0xe2, 0x21, 0xb7, 0xcc, 0x47, 0x17, 0x16, 0xd9, 0x57, 0xc1, 0xb9, 0xc4, 0x99, 0xa6, 
    0xdf, 0x74, 0x42, 0x4d, 0x89, 0x62, 0x84, 0x3f, 0xa2, 0xbd, 0xf1, 0xd4, 0xdb, 0x62, 0x87, 0x27, 0x23, 0xe8, 0xb3, 0x4d, 0x49, 0x7f, 0xf3, 0x98, 0x3a, 0xbc, 0x77, 0xfd, 0x13, 0xd1, 0x50, 0x5b, 0x40, 0xa5, 0xa2, 0xdb, 0xef, 0x7c, 0x6b, 0x35, 0xf0, 0xbf, 0xb1, 0x98, 0xec, 0x81, 0x57, 0x2f, 0xfe, 0x08, 0xa6, 0x2f, 0xf5, 0xd7, 0xad, 0x7e, 0x20, 0x12, 0x93, 0xe0, 0xc9, 0x6a, 0x4a, 0x65, 
    0x33, 0x74, 0x8a, 0x46, 0x56, 0x1a, 0xb8, 0x97, 0xc6, 0x19, 0x7e, 0x27, 0x5c, 0xa4, 0x02, 0x2a, 0x2d, 0x60, 0x82, 0x8b, 0xa0, 0x4b, 0x59, 0xcb, 0x25, 0xe8, 0x7f, 0xb5, 0x66, 0xef, 0xa6, 0x7f, 0x56, 0x84, 0xc8, 0xb2, 0xcb, 0x5a, 0xf3, 0x07, 0x76, 0xc0, 0x31, 0x3e, 0x0c, 0x74, 0x22, 0xfb, 0x18, 0x4b, 0x38, 0xe0, 0x60, 0xdc, 0x38, 0xb6, 0x85, 0x6e, 0x92, 0xbf, 0xd9, 0x38, 0x3c, 0xaf, 
    0xc2, 0xe3, 0x76, 0x4b, 0xd0, 0x5a, 0x06, 0x45, 0x9a, 0x18, 0x6d, 0x2b, 0xc5, 0x7b, 0xa2, 0x2c, 0x55, 0xd0, 0xd2, 0xd6, 0x86, 0xaa, 0x89, 0x4e, 0xf9, 0x66, 0x2a, 0xb9, 0xb6, 0x43, 0x0f, 0xd9, 0x8d, 0x9d, 0x0e, 0xab, 0x1f, 0x1f, 0x11, 0x8a, 0xa1, 0xd8, 0x58, 0x30, 0x75, 0xe8, 0x7d, 0x3a, 0x93, 0x10, 0xa8, 0xc3, 0x4c, 0x93, 0xfd, 0x87, 0x6e, 0x54, 0xa2, 0x4b, 0x1b, 0x38, 0x06, 0x8b, 
    0x67, 0xe2, 0xf1, 0xcc, 0xc7, 0xc9, 0x17, 0x2d, 0x31, 0x5d, 0x0d, 0x75, 0x10, 0xb3, 0x18, 0xf7, 0xe4, 0xfc, 0xa6, 0x99, 0x34, 0x02, 0x7f, 0xb6, 0xbb, 0x69, 0x52, 0x18, 0xae, 0xed, 0x92, 0xfe, 0x80, 0xc8, 0x23, 0x9d, 0x45, 0x01, 0x20, 0x6d, 0x3a, 0xe2, 0x1a, 0x29, 0x89, 0x06, 0xe1, 0x17, 0xbd, 0x18, 0x66, 0xd2, 0xd2, 0xc9, 0x59, 0x4d, 0x92, 0xec, 0xb2, 0x0d, 0x22, 0xc9, 0x9f, 0xa3, 
    0x15, 0xec, 0xf9, 0x76, 0x25, 0xe4, 0xea, 0xb9, 0x7e, 0x94, 0xe5, 0xb3, 0xde, 0x1c, 0xd6, 0xae, 0x47, 0x93, 0xc9, 0xdd, 0x18, 0xf1, 0x9e, 0x51, 0x08, 0x21, 0xab, 0xdc, 0x3d, 0x66, 0xfc, 0xbc, 0x28, 0x1d, 0xda, 0xda, 0x6b, 0x15, 0x6b, 0xed, 0x94, 0x30, 0xa0, 0xcd, 0x7e, 0x5e, 0xa9, 0xae, 0x4c, 0x01, 0x5e, 0xb0, 0xd2, 0x1e, 0x8f, 0xf2, 0xf0, 0x0e, 0x72, 0x67, 0x53, 0x0c, 0x51, 0x87, 
    0xda, 0xaf, 0x08, 0xb0, 0x84, 0xee, 0x7e, 0x07, 0x13, 0xf3, 0xc9, 0x4c, 0x55, 0xb2, 0xea, 0xe4, 0x0f, 0x75, 0x47, 0x34, 0xbc, 0x7d, 0xe4, 0x14, 0x31, 0x14, 0x9d, 0xd7, 0xfa, 0xca, 0x70, 0x3c, 0xfd, 0x3b, 0x5c, 0x21, 0xfb, 0x86, 0xe9, 0xcb, 0xce, 0x9c, 0xb3, 0x53, 0x5c, 0x15, 0xda, 0xbb, 0xd6, 0xfc, 0x82, 0x2f, 0xab, 0x0d, 0x06, 0x2d, 0xec, 0x9d, 0xed, 0x35, 0x68, 0x01, 0xa4, 0xdf, 
    0x24, 0x19, 0x23, 0xfe, 0x5a, 0x51, 0xaa, 0xab, 0x94, 0x71, 0xdc, 0xbc, 0x31, 0x6d, 0x57, 0x8e, 0x15, 0x07, 0x41, 0x42, 0x67, 0x66, 0x2a, 0x8c, 0xd6, 0xd2, 0x28, 0x2b, 0x51, 0x0c, 0xe0, 0xdb, 0x5f, 0x5d, 0x86, 0xc7, 0x21, 0xbd, 0x35, 0xe3, 0x64, 0x56, 0xa1, 0xac, 0x79, 0x62, 0x6f, 0x48, 0x4b, 0x8e, 0xba, 0x9b, 0x3f, 0x53, 0x6c, 0x27, 0x7b, 0x3a, 0xeb, 0x40, 0x77, 0x03, 0xaf, 0xb6, 
    0xda, 0x85, 0x2d, 0xaa, 0x11, 0x5d, 0x26, 0x3b, 0x39, 0x4f, 0xd0, 0x4c, 0x6d, 0x6f, 0xfd, 0x3d, 0xb1, 0x6c, 0x10, 0x0e, 0x2c, 0xa2, 0xc4, 0xf4, 0x58, 0x78, 0x38, 0x40, 0xad, 0x09, 0x61, 0x09, 0x8c, 0x2b, 0x4d, 0x41, 0xb2, 0x35, 0x19, 0x7f, 0x64, 0xcf, 0xe2, 0xf7, 0x51, 0xbb, 0x83, 0x9d, 0x26, 0xe9, 0xc9, 0xf4, 0x9b, 0x45, 0x79, 0x41, 0x95, 0xe9, 0x27, 0xa6, 0xbf, 0x58, 0x0d, 0xcf, 
    0xea, 0xfe, 0x41, 0x61, 0x99, 0xd7, 0x31, 0x37, 0x8d, 0xa0, 0xf2, 0xc2, 0xb7, 0x8f, 0x62, 0x0d, 0x9f, 0x06, 0x63, 0xc5, 0x37, 0x96, 0x5a, 0xf2, 0x16, 0x7d, 0xe2, 0x5c, 0xa7, 0x6f, 0xed, 0x29, 0x61, 0xa5, 0xc3, 0x38, 0x7a, 0xef, 0xb5, 0x07, 0xae, 0x06, 0x67, 0x03, 0x48, 0x41, 0x66, 0xfb, 0x7d, 0x8e, 0x1d, 0x5d, 0xc1, 0x58, 0xb5, 0x72, 0xb3, 0x76, 0xd7, 0xcf, 0x37, 0x7c, 0x64, 0xac, 
    0x8c, 0xff, 0x84, 0x3d, 0x7e, 0x05, 0x9a, 0x46, 0xf6, 0xe8, 0x9c, 0x3f, 0xc1, 0x84, 0xdb, 0x57, 0xec, 0xaa, 0xec, 0xc8, 0xcc, 0x99, 0x8d, 0xe3, 0x4d, 0x05, 0xc0, 0x76, 0x9e, 0xa6, 0xad, 0x32, 0xf9, 0x0a, 0x70, 0x8e, 0x7f, 0xe5, 0x08, 0x8d, 0xcc, 0xaa, 0xcb, 0x4f, 0xf4, 0xf1, 0xf3, 0x9b, 0x27, 0xc2, 0x05, 0x89, 0xa5, 0xfc, 0x0b, 0x66, 0xe3, 0xe2, 0x7a, 0x2d, 0x96, 0x38, 0xc5, 0x4a, 
    0x5b, 0xf9, 0x06, 0x85, 0x66, 0xc0, 0xce, 0x8e, 0x9d, 0x06, 0x4e, 0x8d, 0xfe, 0xf5, 0x0f, 0x8b, 0x61, 0xc4, 0x75, 0x35, 0x79, 0xe4, 0xee, 0xb7, 0x7e, 0x53, 0xd1, 0xbf, 0x92, 0x9c, 0x9b, 0xfe, 0xe7, 0xd1, 0xa2, 0xbc, 0x49, 0xe5, 0xa3, 0x15, 0xb6, 0x87, 0x3b, 0x2a, 0xe5, 0x89, 0x6e, 0x25, 0x05, 0x54, 0x74, 0xc8, 0x16, 0x00, 0x43, 0xbf, 0xd4, 0x99, 0x88, 0x32, 0x2f, 0xa9, 0x70, 0x21, 
    0x1d, 0xc2, 0xa3, 0x90, 0x27, 0x6b, 0xd1, 0x62, 0x33, 0x3f, 0x4d, 0x7d, 0x6e, 0x1c, 0xde, 0x21, 0x69, 0xaa, 0xf0, 0xed, 0x91, 0xbf, 0x00, 0x57, 0xcf, 0xbe, 0x80, 0x8e, 0x4d, 0x0d, 0x25, 0x90, 0xc1, 0x49, 0x69, 0x50, 0xc1, 0x79, 0xd2, 0x33, 0x36, 0x91, 0xdc, 0xbb, 0x68, 0xa9, 0x26, 0xc7, 0xf3, 0x3f, 0x31, 0x8c, 0x1b, 0xdc, 0xcf, 0x5c, 0x79, 0xed, 0x44, 0x24, 0x13, 0xba, 0x8e, 0xc2, 
    0x54, 0xb8, 0xe7, 0x0f, 0x09, 0xb3, 0xd4, 0xd3, 0x6c, 0x49, 0x20, 0x1c, 0x7c, 0x54, 0x9c, 0x20, 0x35, 0x7c, 0xca, 0xb9, 0x21, 0x0e, 0x5f, 0x3b, 0x86, 0xf7, 0x71, 0xf2, 0x1b, 0x17, 0xc2, 0x47, 0x46, 0x3f, 0x91, 0xb5, 0xfa, 0x15, 0x67, 0xb7, 0x9c, 0xce, 0x52, 0x0e, 0x25, 0x37, 0x31, 0xd8, 0xdc, 0x84, 0x38, 0xa9, 0x0a, 0x8b, 0xc1, 0xfd, 0x1b, 0x19, 0xbb, 0x6e, 0xf7, 0x9c, 0x5a, 0x85, 
    0xe6, 0x03, 0xd8, 0x41, 0xda, 0x6f, 0x67, 0xaa, 0xee, 0xa3, 0x19, 0x21, 0xc1, 0xbd, 0x58, 0x21, 0x9a, 0xe3, 0xb6, 0x85, 0x44, 0x34, 0xd1, 0x87, 0x17, 0x17, 0x1e, 0x8f, 0x2c, 0x70, 0x02, 0x6d, 0x4d, 0x74, 0x81, 0xff, 0xea, 0x1f, 0x60, 0x56, 0x8c, 0x06, 0x95, 0x0c, 0x3c, 0xd9, 0xc5, 0xf5, 0x69, 0x37, 0xbd, 0xa7, 0xde, 0x8a, 0x1b, 0x63, 0xeb, 0x62, 0xfd, 0x5a, 0x82, 0xcc, 0x1e, 0xfc, 
    0x48, 0xde, 0x5d, 0x77, 0x7a, 0xba, 0x08, 0xb7, 0xf3, 0xfa, 0xe2, 0x18, 0x8b, 0xd3, 0x26, 0xab, 0x29, 0x45, 0x76, 0x76, 0xc7, 0x3a, 0x43, 0x1e, 0x4f, 0x9a, 0xb0, 0xae, 0x1d, 0x2e, 0x0c, 0xe8, 0xa3, 0xe0, 0xd3, 0x86, 0x86, 0x15, 0x74, 0x55, 0x48, 0x28, 0x96, 0x9c, 0xe0, 0x29, 0xe6, 0xa5, 0x10, 0xca, 0x8a, 0x4d, 0xf3, 0x45, 0x1f, 0x0a, 0x9d, 0x40, 0xa0, 0xef, 0x96, 0xe5, 0x3d, 0x5a, 
    0xc5, 0xe0, 0x46, 0x65, 0x32, 0x2a, 0x2c, 0x72, 0xd3, 0xb5, 0xc2, 0x8c, 0x07, 0xf9, 0xec, 0xde, 0x0b, 0x4a, 0x6d, 0xa4, 0x60, 0xaa, 0x78, 0xef, 0x34, 0xde, 0x98, 0x1b, 0xb0, 0x55, 0x9f, 0xc1, 0xde, 0x69, 0xed, 0x2d, 0x2f, 0x5e, 0xe8, 0x13, 0x3e, 0x41, 0x71, 0x7a, 0x71, 0x02, 0xdb, 0xc1, 0x79, 0x5a, 0x5f, 0x45, 0xd0, 0xa6, 0xce, 0x1b, 0xb4, 0x64, 0x53, 0xd1, 0x55, 0x8a, 0x9a, 0xa6, 
    0x0c, 0x48, 0x3f, 0xb3, 0x33, 0x16, 0xf4, 0xeb, 0xd1, 0x31, 0x7b, 0xae, 0x56, 0x28, 0x35, 0xd9, 0x04, 0xa1, 0x47, 0x44, 0x05, 0xef, 0x73, 0xd9, 0x6a, 0xb8, 0x5e, 0xd5, 0xdc, 0xb0, 0xf5, 0x41, 0x0e, 0x33, 0xca, 0x33, 0xc6, 0x58, 0x78, 0xaa, 0xd5, 0xd7, 0x0c, 0x48, 0xb3, 0xfc, 0xa8, 0x68, 0x30, 0x92, 0x17, 0x52, 0x79, 0x4f, 0xb8, 0xb3, 0xad, 0xdf, 0x30, 0x81, 0x0f, 0x0f, 0xca, 0xad, 
    0x9f, 0x44, 0x49, 0xbb, 0x8c, 0x00, 0xdf, 0x04, 0x93, 0x51, 0xa4, 0x54, 0xc3, 0x3e, 0xb3, 0x2e, 0x84, 0xfc, 0xda, 0xb5, 0x67, 0x04, 0xf5, 0xd7, 0x80, 0xd8, 0x3e, 0xeb, 0x35, 0xf7, 0x6b, 0xad, 0xde, 0xb5, 0x08, 0x1b, 0x1b, 0x56, 0xef, 0xf7, 0xfb, 0x41, 0xc9, 0x87, 0x0a, 0x71, 0x70, 0xf6, 0xe5, 0x50, 0x15, 0xbe, 0x96, 0x70, 0xa6, 0x81, 0xc3, 0x6e, 0xaf, 0x02, 0xda, 0x1f, 0x51, 0x7a, 
    0x77, 0xa4, 0x0d, 0x95, 0x93, 0x9f, 0xf2, 0x63, 0x5f, 0x86, 0xae, 0x34, 0xa1, 0x88, 0xc5, 0x39, 0x49, 0x02, 0xfb, 0x6a, 0xba, 0xbc, 0x23, 0x88, 0x61, 0x3b, 0x0e, 0xd9, 0x56, 0xd4, 0x55, 0x80, 0x77, 0x90, 0x28, 0x85, 0xd1, 0xa9, 0x1a, 0xe8, 0xfa, 0x96, 0x9a, 0xba, 0x0f, 0xb2, 0x23, 0x80, 0xf8, 0xb0, 0x4e, 0x21, 0x95, 0x0b, 0x80, 0x45, 0xe9, 0x32, 0xde, 0x24, 0xb9, 0x2c, 0x82, 0x25, 
    0xc8, 0xc0, 0xf2, 0x1f, 0x71, 0x5f, 0x79, 0xa1, 0x89, 0x93, 0x59, 0x7a, 0x16, 0xc8, 0xbe, 0x63, 0xde, 0x67, 0x98, 0xfb, 0xf6, 0xac, 0xa8, 0x95, 0x27, 0x5b, 0x2a, 0x4f, 0x00, 0xe1, 0xa5, 0xf2, 0x84, 0x1c, 0xaf, 0xc4, 0x83, 0x13, 0x22, 0x63, 0x75, 0x8f, 0xbd, 0xfa, 0x55, 0x76, 0xe6, 0x9b, 0xcd, 0x22, 0x2e, 0x86, 0x05, 0xdc, 0xf2, 0x4c, 0x3b, 0x6e, 0x82, 0x0a, 0x38, 0x6d, 0xf4, 0xc7, 
    0xed, 0x9d, 0x77, 0x39, 0x55, 0xe1, 0x27, 0x18, 0xa0, 0x67, 0xfa, 0xce, 0x15, 0x5c, 0x71, 0x99, 0xcc, 0x88, 0x5d, 0x0c, 0x0a, 0xfe, 0x52, 0x9a, 0xa0, 0x89, 0x79, 0x29, 0x5f, 0x4b, 0xd2, 0xc8, 0x03, 0x3d, 0x80, 0x96, 0x61, 0xa3, 0xae, 0xa2, 0xdd, 0x5f, 0x05, 0x20, 0x7e, 0x80, 0xb3, 0xb6, 0x38, 0x11, 0x54, 0x5e, 0xd3, 0x2c, 0xfc, 0x68, 0xd6, 0x01, 0x34, 0x60, 0x30, 0xfa, 0x83, 0xca, 
    0x06, 0x20, 0xa9, 0x3c, 0xf6, 0x82, 0xdb, 0x0f, 0xfe, 0x1a, 0xe7, 0x13, 0x5e, 0x2c, 0x75, 0x50, 0xd9, 0xa5, 0x93, 0x96, 0x2c, 0x28, 0xf2, 0xfa, 0x46, 0xca, 0xaf, 0xe7, 0x13, 0x37, 0x04, 0x6e, 0xc4, 0xaf, 0xd6, 0xa3, 0x23, 0x04, 0xfe, 0x49, 0x88, 0x5a, 0x61, 0x4b, 0xb1, 0xc3, 0xe9, 0xf2, 0x57, 0x6c, 0xdd, 0x92, 0x36, 0x32, 0xe9, 0x77, 0x67, 0x0c, 0xab, 0x40, 0xde, 0xef, 0xf0, 0x74, 
    0x6f, 0x15, 0xc7, 0x4d, 0xd5, 0x00, 0xe2, 0x0c, 0x46, 0xd0, 0x3c, 0x2a, 0x83, 0x92, 0xea, 0xeb, 0x67, 0x4e, 0x08, 0x31, 0x19, 0xcd, 0x8a, 0xca, 0x87, 0x23, 0x3f, 0x5d, 0x9d, 0x55, 0xb7, 0x67, 0xf2, 0x3e, 0x33, 0x98, 0xe5, 0x96, 0x47, 0x28, 0xb9, 0xec, 0x46, 0x3c, 0x11, 0x9e, 0x5d, 0xc8, 0x20, 0xce, 0xf1, 0x3e, 0xa1, 0x78, 0x03, 0xf4, 0x94, 0xa1, 0xdc, 0xb9, 0xd3, 0x1e, 0x68, 0x8c, 
    0x95, 0x2c, 0x1c, 0x5b, 0xe8, 0x3e, 0xb2, 0xc0, 0x2c, 0x7f, 0x6d, 0xeb, 0xe7, 0x93, 0x12, 0xcb, 0x32, 0x35, 0x48, 0xab, 0xe6, 0xb8, 0x15, 0x5a, 0x1a, 0x6f, 0xb9, 0x56, 0x26, 0xcf, 0x94, 0xee, 0x6b, 0x79, 0x41, 0x57, 0xe7, 0x6c, 0xc2, 0x2f, 0x30, 0xd9, 0x4a, 0xc6, 0x37, 0xb4, 0x5f, 0xce, 0xd2, 0x3a, 0x95, 0x9e, 0xe1, 0xe9, 0x87, 0x27, 0xaa, 0x52, 0x4c, 0x12, 0xb8, 0xce, 0xbd, 0xf1, 
    0x59, 0x4d, 0x21, 0xbd, 0xcc, 0x4e, 0x6d, 0x40, 0xb6, 0xad, 0x58, 0xe3, 0xea, 0x19, 0x56, 0x78, 0xc6, 0x41, 0xd2, 0xaa, 0xdb, 0x13, 0x00, 0x69, 0x84, 0x84, 0x4e, 0x73, 0xe3, 0x23, 0xc6, 0x9d, 0x63, 0xf5, 0x34, 0x00, 0x7b, 0xc7, 0x4b, 0x89, 0x64, 0xc8, 0xde, 0x19, 0x2c, 0x19, 0xa1, 0x8c, 0x3b, 0x07, 0xa0, 0xa2, 0xf7, 0xcb, 0x6b, 0xc0, 0x79, 0xb0, 0x0f, 0x94, 0x8c, 0x5e, 0xb7, 0x3a, 
    0x99, 0x52, 0xa0, 0x35, 0x8b, 0x94, 0xa9, 0xf8, 0xb6, 0x01, 0xb1, 0xdc, 0x41, 0xe8, 0x0c, 0xbb, 0x1b, 0x8d, 0x71, 0x4f, 0x71, 0x3a, 0xd7, 0xb4, 0xfa, 0xc6, 0x7d, 0x12, 0xe9, 0xa6, 0xdd, 0x83, 0x18, 0x6f, 0x51, 0x64, 0x91, 0xe1, 0xd0, 0xf7, 0x09, 0xac, 0x11, 0x69, 0x70, 0xdb, 0x87, 0x42, 0x5c, 0x2e, 0xa5, 0x92, 0xbc, 0x21, 0xe3, 0x55, 0x5c, 0x4e, 0x3e, 0xd3, 0x29, 0xc1, 0x15, 0x59, 
    0xd2, 0xa8, 0xf5, 0x02, 0x37, 0xbf, 0xf6, 0xd9, 0x83, 0x91, 0x7c, 0x62, 0x40, 0x21, 0x4e, 0x0c, 0xeb, 0xc3, 0x70, 0x9c, 0xa5, 0x87, 0xde, 0x27, 0x36, 0xff, 0x16, 0xc8, 0xbe, 0x8c, 0xf4, 0x97, 0xea, 0x0b, 0x1a, 0x31, 0xbe, 0xb9, 0x20, 0x88, 0x8d, 0x9f, 0xda, 0x0b, 0x0e, 0x1d, 0xa7, 0x73, 0x69, 0x7c, 0x1d, 0x0e, 0xef, 0x66, 0x26, 0xb6, 0x3a, 0xe1, 0x8e, 0xf2, 0x90, 0xa5, 0x77, 0x63, 
    0x83, 0x2f, 0xd2, 0x11, 0x6d, 0x3b, 0x48, 0xb5, 0x6d, 0xcc, 0x9e, 0x97, 0x25, 0x7c, 0xca, 0x03, 0x65, 0x8d, 0xa3, 0x31, 0x0a, 0xf1, 0x44, 0x7d, 0xba, 0x5e, 0xcb, 0x9d, 0xb5, 0x91, 0x35, 0x4f, 0xec, 0x42, 0xf5, 0xba, 0x10, 0x42, 0x72, 0xa6, 0x95, 0xe0, 0x30, 0xe1, 0x1d, 0xf0, 0xcb, 0x6b, 0x0a, 0x56, 0x12, 0xd6, 0x8c, 0x47, 0x47, 0x27, 0xfb, 0xff, 0xcf, 0x01, 0x18, 0x82, 0xa5, 0x50, 
    0x18, 0x2f, 0xd3, 0xbe, 0x64, 0x66, 0x5b, 0x22, 0xfa, 0xfc, 0x4a, 0x56, 0x2a, 0x7e, 0xa4, 0xa3, 0x9e, 0xc3, 0x53, 0xbb, 0x37, 0x1f, 0x0d, 0xfc, 0xc2, 0x79, 0x03, 0x7a, 0x45, 0xd6, 0x9b, 0x18, 0x30, 0x05, 0xc1, 0xbc, 0xcb, 0x2a, 0x0b, 0x4e, 0xa5, 0x36, 0x7d, 0xf0, 0xdf, 0xae, 0x19, 0x83, 0xee, 0x97, 0x07, 0xc2, 0x74, 0xc1, 0x74, 0x10, 0x4a, 0x14, 0xad, 0xfd, 0xb4, 0x8a, 0x75, 0x99, 
    0x69, 0x88, 0xda, 0x4a, 0x4e, 0x6b, 0xa8, 0xb2, 0x08, 0xd7, 0x0b, 0xb1, 0x1f, 0x46, 0x90, 0xa2, 0xc3, 0xdc, 0xf0, 0x67, 0x76, 0xdc, 0x3a, 0xf8, 0xa9, 0x48, 0x3a, 0x68, 0x79, 0xaa, 0x46, 0x03, 0x7c, 0x16, 0xd6, 0x45, 0xac, 0x50, 0xff, 0x52, 0xe5, 0x88, 0xfa, 0xf7, 0x4d, 0x94, 0x46, 0xf4, 0x41, 0x97, 0xbf, 0xf0, 0x01, 0x8a, 0xc9, 0x72, 0x47, 0x36, 0x16, 0x98, 0x74, 0xe9, 0xd4, 0x15, 
    0x2d, 0x86, 0xbe, 0xf8, 0xed, 0xde, 0x9a, 0x8f, 0x05, 0x35, 0x06, 0x24, 0x89, 0xe1, 0xf4, 0xc4, 0xfe, 0xad, 0x40, 0x8c, 0x1c, 0x67, 0xbc, 0xe7, 0x54, 0xea, 0x9d, 0x20, 0x10, 0x13, 0xe2, 0x8f, 0x43, 0x6c, 0x1e, 0x89, 0x5b, 0xb2, 0x32, 0xd0, 0x72, 0x9a, 0xba, 0x2e, 0x3f, 0x72, 0x7f, 0xd5, 0x84, 0x3d, 0x58, 0xc9, 0xd9, 0xbd, 0x29, 0x66, 0x21, 0x5d, 0xa0, 0x5e, 0x7b, 0x40, 0xd7, 0xe5, 
    0xf6, 0xe4, 0x23, 0xdb, 0x75, 0x11, 0x8e, 0xc2, 0x34, 0x6a, 0xcf, 0x81, 0xca, 0x07, 0x1d, 0x7e, 0x6f, 0xd7, 0xe1, 0xf6, 0x60, 0x95, 0x59, 0x24, 0xe9, 0x38, 0x9d, 0x47, 0xae, 0x6b, 0x2e, 0xfd, 0xe5, 0x5b, 0x90, 0x77, 0xa4, 0xd6, 0x8b, 0xba, 0x7b, 0x5a, 0x36, 0xc7, 0x28, 0x69, 0x46, 0xf5, 0x0c, 0xe4, 0x64, 0x2e, 0xd4, 0x8e, 0xa8, 0x61, 0xe1, 0xff, 0x24, 0x2b, 0x65, 0xec, 0x02, 0x7e, 
    0x33, 0xcd, 0x10, 0x14, 0x64, 0x46, 0x73, 0x97, 0xa5, 0x57, 0xf8, 0xfa, 0x31, 0x59, 0x22, 0xc0, 0x83, 0x40, 0x5f, 0x07, 0x03, 0x26, 0xb6, 0x68, 0x01, 0x90, 0xbe, 0x7f, 0x59, 0xe1, 0xd6, 0xa9, 0x09, 0x9d, 0x35, 0xc9, 0x6f, 0x63, 0xb2, 0x27, 0x75, 0x62, 0xc2, 0x25, 0xdd, 0x77, 0xd0, 0xa6, 0x5b, 0x57, 0x29, 0xa8, 0xc0, 0xe4, 0x7e, 0x40, 0x18, 0xb2, 0x62, 0xb1, 0x46, 0xd4, 0x0c, 0x9c, 
    0x51, 0x60, 0x59, 0xb8, 0x1c, 0x8a, 0x7a, 0xbf, 0x79, 0xe1, 0x3b, 0x32, 0x56, 0xd2, 0x49, 0xff, 0x4f, 0x61, 0xb0, 0x1f, 0xbc, 0x2f, 0x71, 0x39, 0xd8, 0xd0, 0x59, 0x09, 0x2b, 0xf5, 0x8e, 0x79, 0xac, 0xc0, 0xd4, 0xd2, 0xfd, 0x54, 0x0b, 0x27, 0x0a, 0xf7, 0x94, 0xfd, 0xb8, 0x4f, 0xb8, 0x7e, 0x63, 0xa7, 0xe7, 0xb4, 0x1e, 0xab, 0x9d, 0xed, 0x89, 0x04, 0x50, 0xc7, 0xc5, 0xb6, 0x3d, 0xa6, 
    0x0b, 0x16, 0xbd, 0x78, 0x92, 0x71, 0x21, 0xaa, 0xee, 0x47, 0x37, 0x96, 0x10, 0xdd, 0x42, 0xb3, 0x2a, 0x78, 0x34, 0xa7, 0xe7, 0x07, 0x8e, 0x4d, 0x66, 0xce, 0x90, 0xad, 0x6b, 0x40, 0xd7, 0x04, 0xaa, 0xf2, 0x5d, 0x4e, 0x18, 0x3d, 0xfd, 0x8a, 0x20, 0x9e, 0x22, 0x54, 0xb4, 0xd1, 0xb1, 0xcb, 0x54, 0x02, 0x1b, 0x84, 0x38, 0xad, 0x45, 0xff, 0x38, 0xd4, 0x9a, 0x9b, 0x38, 0x79, 0xb5, 0x23, 
    0xde, 0xee, 0xba, 0xb8, 0x1b, 0xe4, 0xc8, 0x28, 0x33, 0x89, 0xc7, 0xca, 0xfb, 0xa6, 0x5c, 0x7b, 0xdc, 0x9b, 0x4d, 0x2d, 0xd5, 0x96, 0xd3, 0x85, 0xe9, 0x20, 0x49, 0xb9, 0xe7, 0x5c, 0x2d, 0xc6, 0x9c, 0x5c, 0xf3, 0x18, 0xe6, 0x9e, 0x2d, 0x3a, 0x13, 0x78, 0x03, 0xad, 0x00, 0xeb, 0x86, 0x3d, 0x15, 0x31, 0x5a, 0xd8, 0xfe, 0x6f, 0x50, 0xdc, 0xc6, 0x06, 0x22, 0x56, 0xe5, 0x93, 0xfc, 0xf5, 
    0x6a, 0xdc, 0x0e, 0x05, 0xa9, 0xab, 0xa8, 0x4a, 0xea, 0x1e, 0x28, 0x9e, 0x62, 0x75, 0xd7, 0x0f, 0xb0, 0x84, 0x76, 0x0a, 0x74, 0x97, 0x98, 0x2b, 0xea, 0x3e, 0xd9, 0x7d, 0xa7, 0x6d, 0xac, 0x66, 0x25, 0x4b, 0xec, 0x53, 0x9f, 0x9f, 0x78, 0x00, 0xc3, 0x60, 0x3d, 0x5e, 0xa7, 0xe9, 0x12, 0x26, 0x1e, 0x4a, 0x0c, 0xf5, 0x74, 0x36, 0x36, 0x02, 0x6e, 0x8e, 0x92, 0xee, 0xeb, 0xe6, 0x80, 0x40, 
    0x2b, 0x4f, 0x86, 0x57, 0xff, 0x4c, 0xad, 0x10, 0xb0, 0x99, 0x5b, 0xce, 0xd8, 0x85, 0x06, 0xf1, 0x42, 0xa9, 0x5d, 0xee, 0xb9, 0x8d, 0x12, 0x0d, 0xbc, 0x26, 0xcd, 0x23, 0xe2, 0xee, 0x85, 0x9c, 0x11, 0x3d, 0xb9, 0x22, 0x63, 0x73, 0xd4, 0xdf, 0xf4, 0x00, 0xfb, 0xa0, 0x45, 0x95, 0x66, 0x7c, 0xbf, 0x8e, 0x52, 0xeb, 0x80, 0xeb, 0x1c, 0xc4, 0x6c, 0x90, 0x4d, 0x80, 0xc8, 0x08, 0x56, 0xf3, 
    0xa2, 0x44, 0x55, 0x43, 0xe2, 0x8b, 0x27, 0x79, 0x6f, 0xe5, 0x3b, 0x19, 0x06, 0x16, 0x7b, 0xb1, 0xee, 0xee, 0x38, 0x73, 0xb2, 0xce, 0xa1, 0x2e, 0x19, 0x88, 0x1f, 0x52, 0x10, 0xf5, 0xfd, 0x2c, 0x8e, 0x91, 0x7f, 0x6e, 0xc7, 0x42, 0xed, 0x83, 0xe2, 0xd4, 0xb0, 0xc4, 0x95, 0x9f, 0x6a, 0xb7, 0x32, 0x1b, 0x81, 0xbe, 0xa2, 0xd1, 0x22, 0x7f, 0x07, 0x91, 0xaf, 0xa2, 0x67, 0xc8, 0x38, 0x2c, 
    0x18, 0x6a, 0x43, 0x44, 0xcb, 0xc6, 0xee, 0x81, 0x19, 0xcd, 0xeb, 0x54, 0x91, 0xa0, 0xb5, 0xbd, 0x62, 0x14, 0x4a, 0xef, 0xfc, 0x15, 0x56, 0xc6, 0xc5, 0xc5, 0xa5, 0x39, 0xf9, 0x06, 0x5e, 0x02, 0x83, 0x18, 0x33, 0xc1, 0xdc, 0x85, 0xe2, 0x7b, 0x24, 0x19, 0xaf, 0xdb, 0x47, 0xd2, 0x8e, 0x8f, 0x0f, 0xf1, 0xf3, 0x76, 0xc7, 0x52, 0xda, 0xb1, 0x99, 0x55, 0x7d, 0x07, 0x6a, 0x37, 0x2b, 0x2f, 
    0xc4, 0xa1, 0x0a, 0xd3, 0xb9, 0xe0, 0xed, 0x6d, 0x5f, 0x3b, 0xea, 0x2a, 0x74, 0x9a, 0xf8, 0x15, 0xc1, 0x69, 0x4c, 0x62, 0x30, 0xcd, 0xb5, 0x87, 0xff, 0x7b, 0x5a, 0x71, 0x47, 0xc2, 0x0e, 0xed, 0x7f, 0xc6, 0x32, 0x62, 0xa8, 0x86, 0xbe, 0x77, 0x09, 0x92, 0x00, 0xdd, 0x6f, 0x3f, 0x2f, 0xda, 0x70, 0xea, 0x30, 0xa2, 0xb7, 0x0c, 0x08, 0x1a, 0xbf, 0x5f, 0x5b, 0xd4, 0x76, 0xcf, 0x11, 0xab, 
    0xf5, 0xa2, 0x03, 0x83, 0x89, 0xa0, 0x63, 0xbc, 0xd6, 0x99, 0x6a, 0x4b, 0x18, 0x90, 0xc0, 0x6b, 0x51, 0x11, 0xdf, 0x40, 0x54, 0x8c, 0x60, 0xcc, 0x75, 0xfb, 0xa3, 0xaf, 0x4b, 0xda, 0x40, 0x6e, 0x37, 0x0e, 0xbb, 0x52, 0x1f, 0x91, 0xba, 0xd2, 0x05, 0x46, 0x62, 0x4f, 0x12, 0x44, 0xec, 0xe7, 0x88, 0xb7, 0x22, 0x6f, 0x08, 0xf8, 0xff, 0x4b, 0x91, 0xa3, 0x36, 0x7b, 0xce, 0xf2, 0x2b, 0x82, 
    0x8b, 0x98, 0x72, 0xda, 0x01, 0xf9, 0x6f, 0x58, 0x65, 0x27, 0x17, 0xcf, 0x3c, 0xc2, 0x3e, 0xa2, 0x32, 0x03, 0xf5, 0x87, 0x97, 0x86, 0xda, 0x4d, 0x26, 0x19, 0x8e, 0xd2, 0x7e, 0x3f, 0xf1, 0x4a, 0xf0, 0x70, 0xaf, 0xb2, 0x31, 0xe4, 0x36, 0xc6, 0x3f, 0x97, 0x59, 0x99, 0xca, 0x88, 0x69, 0xdc, 0x99, 0x35, 0x64, 0x44, 0x28, 0xba, 0xab, 0xe0, 0xd3, 0x13, 0x5b, 0xaf, 0xb8, 0x6c, 0xdf, 0xfc, 
    0xa3, 0x66, 0x99, 0x84, 0x43, 0xca, 0x04, 0x24, 0x15, 0x63, 0xd2, 0x8f, 0xbf, 0x02, 0x52, 0xa1, 0x4e, 0xda, 0x80, 0x1d, 0x9f, 0x2c, 0xda, 0xf5, 0x41, 0x95, 0x17, 0x9d, 0x55, 0x3a, 0x53, 0xc5, 0xb0, 0xeb, 0x1b, 0x2d, 0x31, 0xab, 0xe2, 0x4c, 0x4b, 0x3c, 0xb2, 0xcd, 0x14, 0x5b, 0x12, 0xf6, 0x28, 0x70, 0x98, 0xe2, 0x43, 0xa8, 0xb7, 0x29, 0x40, 0x4d, 0xaa, 0x24, 0xdd, 0x6c, 0xfb, 0x2f, 
    0x35, 0x5d, 0x40, 0x0f, 0x32, 0x80, 0x53, 0xd1, 0xe7, 0xd5, 0xf6, 0x2a, 0xbd, 0x0d, 0x97, 0xa1, 0xb1, 0x3b, 0x46, 0xc1, 0x8c, 0x0d, 0x01, 0x71, 0xf2, 0xcb, 0x0b, 0x64, 0xaa, 0x7b, 0xa4, 0xdd, 0xc4, 0xe1, 0x5c, 0x23, 0x7a, 0x21, 0xa5, 0x4f, 0xd6, 0x86, 0xf7, 0x39, 0x60, 0x0b, 0x5f, 0x33, 0xe4, 0x8f, 0xac, 0xc4, 0x72, 0x4e, 0x5d, 0xe8, 0x40, 0x3b, 0x5b, 0xbc, 0x12, 0x9e, 0xe7, 0xb9, 
    0x2e, 0xb1, 0x98, 0xbf, 0x43, 0x35, 0x52, 0xfa, 0x23, 0x81, 0x92, 0x8d, 0xd7, 0xdf, 0xef, 0x01, 0x0e, 0x69, 0xdf, 0x44, 0xe4, 0x67, 0xb4, 0x20, 0x54, 0x28, 0x60, 0xb4, 0x94, 0xd4, 0x9c, 0x5d, 0x14, 0x8c, 0xc0, 0x68, 0x46, 0x71, 0x4e, 0xf9, 0x17, 0xfd, 0x22, 0x50, 0x03, 0x67, 0xce, 0x71, 0xe4, 0x80, 0x30, 0xc4, 0x9d, 0x13, 0x26, 0x45, 0x45, 0x82, 0x0d, 0x76, 0xd5, 0xfe, 0x1c, 0x1f, 
    0x19, 0xc5, 0x75, 0x4d, 0xf4, 0xa5, 0x91, 0x8e, 0x3a, 0x2f, 0xb0, 0x80, 0xf9, 0x33, 0xc0, 0x20, 0x74, 0x20, 0xdc, 0xf8, 0x45, 0xab, 0x87, 0x76, 0x02, 0x2d, 0xdf, 0xd4, 0x08, 0x98, 0xb6, 0xd4, 0x6d, 0x90, 0x65, 0xf2, 0x12, 0xfb, 0x87, 0xd6, 0x92, 0xa6, 0x9a, 0xbc, 0x5a, 0xcb, 0x5e, 0xc6, 0xf4, 0x99, 0x81, 0x37, 0xf9, 0x61, 0x7f, 0xd9, 0xe0, 0x97, 0x86, 0x75, 0x13, 0xe7, 0x92, 0xbe, 
    0x94, 0xb7, 0xee, 0xb4, 0x04, 0x61, 0xed, 0x4c, 0x0f, 0x3e, 0x22, 0xa9, 0x2b, 0x9e, 0xfe, 0xf8, 0xe6, 0x69, 0x5b, 0x7c, 0xe0, 0xc7, 0x29, 0xf2, 0x30, 0x96, 0x44, 0x23, 0x3a, 0xaf, 0x86, 0x15, 0x63, 0xbf, 0xf6, 0xfc, 0x35, 0x9c, 0x07, 0x6c, 0x76, 0xca, 0xb8, 0xaa, 0xf2, 0x93, 0xfa, 0x9e, 0x27, 0x2a, 0x6a, 0x4b, 0xd0, 0xdf, 0x1a, 0xc1, 0x1a, 0xd9, 0x0f, 0x5d, 0xee, 0x7a, 0x11, 0x51, 
    0xf7, 0xd5, 0xa7, 0x0b, 0x73, 0xe1, 0x99, 0x26, 0xbe, 0xb2, 0xb9, 0x7e, 0x5d, 0x68, 0xa2, 0x32, 0x7a, 0x2e, 0x79, 0xf4, 0xaf, 0xaa, 0xa4, 0x7b, 0x42, 0x6e, 0xb8, 0x1e, 0xe7, 0xeb, 0x05, 0xd2, 0x2b, 0xe8, 0x10, 0xa0, 0x12, 0xfb, 0x8a, 0xb7, 0xa8, 0x20, 0xa1, 0xbb, 0x7e, 0x04, 0x06, 0xbf, 0x34, 0xf6, 0xa5, 0x4f, 0x1b, 0x87, 0xf7, 0xd5, 0xfa, 0x61, 0xac, 0x59, 0x94, 0xc0, 0x34, 0x49, 
    0x25, 0x82, 0x59, 0xe5, 0x0d, 0xe3, 0xb7, 0x54, 0xb5, 0xcf, 0x7b, 0x6e, 0x54, 0xe3, 0xeb, 0x8a, 0xa5, 0x01, 0x6a, 0xcb, 0x60, 0xea, 0x3c, 0xc9, 0x5b, 0xaf, 0x26, 0x7a, 0x70, 0x50, 0x22, 0x9f, 0x05, 0x66, 0x3e, 0xcf, 0x81, 0x78, 0x4a, 0xf0, 0x25, 0x1e, 0x1f, 0x36, 0xb6, 0x88, 0x81, 0x29, 0x14, 0xa7, 0x08, 0x67, 0x05, 0x4c, 0xd6, 0x51, 0xef, 0x23, 0xbe, 0x1a, 0xfb, 0x14, 0xcb, 0x6c, 
    0x23, 0x69, 0x8e, 0xca, 0xa7, 0x1f, 0x7b, 0xdf, 0xc8, 0x6e, 0x75, 0xb6, 0x8f, 0x5a, 0x56, 0x1e, 0x35, 0x01, 0x81, 0xd7, 0x21, 0xb5, 0x65, 0xbc, 0x98, 0xf1, 0x2c, 0xda, 0x85, 0x96, 0x57, 0x53, 0x15, 0x02, 0xb3, 0xdc, 0xed, 0x30, 0x3c, 0xa9, 0xc8, 0x79, 0x16, 0x82, 0x54, 0xdb, 0x0c, 0x16, 0x7f, 0x99, 0xc3, 0x9d, 0x40, 0x76, 0xb1, 0x1f, 0xce, 0x7a, 0xe2, 0x8b, 0x8d, 0xa7, 0xf3, 0x00, 
    0x3b, 0x51, 0x60, 0x64, 0x84, 0x16, 0xe8, 0xa7, 0x4b, 0x1b, 0x36, 0x09, 0xf1, 0xd1, 0x58, 0xca, 0x4d, 0xdb, 0x14, 0x21, 0x43, 0x94, 0xcb, 0xcd, 0xfd, 0x3a, 0x0c, 0xc2, 0x08, 0x55, 0x80, 0x89, 0x77, 0x64, 0x44, 0xc9, 0xce, 0x2f, 0xad, 0x53, 0x7a, 0xd6, 0x7c, 0xde, 0x5a, 0xef, 0x61, 0x40, 0xbe, 0xb2, 0xe5, 0x71, 0x71, 0x25, 0xa3, 0x53, 0xc8, 0x0f, 0x92, 0x91, 0xcd, 0x81, 0xeb, 0x33, 
    0x60, 0x9f, 0xee, 0x41, 0xd9, 0x08, 0x71, 0x3d, 0x24, 0xa9, 0xbf, 0x44, 0x11, 0x17, 0xd2, 0x3c, 0x65, 0x94, 0xc4, 0x0e, 0xad, 0x1a, 0x59, 0x82, 0x96, 0xef, 0xb7, 0xf7, 0xe0, 0xe9, 0x3a, 0x13, 0xa2, 0xe0, 0xbf, 0x13, 0xbc, 0xe7, 0x7a, 0x43, 0x57, 0xfc, 0x6e, 0xd1, 0x69, 0x52, 0xf0, 0xe9, 0xac, 0x1f, 0xd0, 0xc2, 0xc6, 0x8b, 0x46, 0x78, 0xb1, 0xa5, 0x3d, 0x38, 0x57, 0x65, 0x52, 0xb0, 
    0xa3, 0x2b, 0xd1, 0x4b, 0xf4, 0x4f, 0x00, 0x86, 0x38, 0xad, 0x41, 0x75, 0xcf, 0xcc, 0x84, 0xe8, 0x8c, 0xd7, 0x4d, 0x12, 0xa5, 0x06, 0xbb, 0x5f, 0xee, 0x20, 0x82, 0x6d, 0x74, 0xea, 0xca, 0xd3, 0x4c, 0x44, 0x06, 0x6d, 0x9b, 0x6a, 0x9a, 0x2b, 0x48, 0x27, 0x59, 0x19, 0xd7, 0x3e, 0xdb, 0x8f, 0xcc, 0x55, 0x08, 0xf4, 0xb2, 0x30, 0x34, 0x8a, 0xa3, 0x6b, 0x69, 0x3b, 0x2a, 0x4e, 0x22, 0xd4, 
    0x24, 0x97, 0xfb, 0xcf, 0x0b, 0x75, 0x76, 0xed, 0xb1, 0x41, 0x5e, 0xf2, 0x8c, 0x04, 0xc4, 0x4d, 0x8b, 0x6f, 0xb8, 0x9a, 0x18, 0xe3, 0x57, 0x86, 0x71, 0xbd, 0x36, 0x2f, 0x66, 0x93, 0xda, 0xf0, 0xf7, 0xa9, 0xa2, 0x45, 0x26, 0x5a, 0x11, 0x37, 0x93, 0x34, 0x93, 0x22, 0xee, 0xd5, 0x3c, 0x98, 0x15, 0x8a, 0x0a, 0x8b, 0xe7, 0x62, 0xdf, 0x2c, 0xb2, 0x3f, 0x39, 0x4a, 0x7d, 0xf0, 0x01, 0xbf, 
    0xd7, 0xab, 0xad, 0x9c, 0x61, 0x8c, 0x09, 0x20, 0x64, 0xf5, 0x95, 0xf9, 0x7d, 0xfd, 0xa1, 0xe7, 0x47, 0x36, 0x49, 0x9b, 0x1b, 0xb8, 0xba, 0xff, 0x30, 0x22, 0x3e, 0xca, 0x8e, 0x8d, 0x4e, 0x4d, 0x5d, 0xa1, 0x83, 0x35, 0x08, 0x01, 0xc1, 0x2e, 0xaf, 0x91, 0xc7, 0x17, 0x40, 0xfe, 0x48, 0x9b, 0x04, 0x69, 0x34, 0x90, 0xe0, 0x6f, 0xec, 0x31, 0x11, 0x0d, 0x90, 0xa0, 0x32, 0xf3, 0xd9, 0x7b, 
    0xda, 0x7e, 0x05, 0x5d, 0x0e, 0xe0, 0xfd, 0xbf, 0x92, 0x37, 0x17, 0xf5, 0x13, 0xae, 0x2e, 0x64, 0xfe, 0x47, 0xa8, 0x49, 0xca, 0x77, 0xa4, 0x38, 0x3b, 0xe9, 0x0a, 0x19, 0x43, 0xd1, 0x8f, 0xc1, 0xb3, 0xf8, 0x8f, 0x88, 0x7d, 0xe1, 0xc0, 0xc5, 0xf0, 0xee, 0xe9, 0xbc, 0x44, 0x72, 0x65, 0xb6, 0x04, 0xf4, 0xfe, 0x61, 0x32, 0x82, 0x17, 0x7c, 0xe9, 0xe8, 0xd7, 0x64, 0xc3, 0xba, 0xc6, 0x44, 
    0x91, 0x6e, 0x1f, 0xad, 0xe2, 0xcc, 0x07, 0x41, 0x93, 0xc2, 0xbf, 0x3a, 0xa4, 0xd9, 0x26, 0x25, 0xae, 0x9a, 0x62, 0xff, 0xff, 0x08, 0x13, 0xa9, 0x3c, 0xdf, 0xe7, 0x58, 0x2b, 0xc1, 0x91, 0xb1, 0x01, 0x49, 0x1b, 0x61, 0x77, 0xcf, 0xe0, 0xe2, 0xed, 0x6f, 0xae, 0xc3, 0xb3, 0x43, 0x4a, 0x4d, 0x5a, 0x10, 0xcf, 0x2d, 0xc7, 0x7a, 0xb2, 0xa6, 0x18, 0x01, 0x00, 0xd6, 0xf3, 0x77, 0x6f, 0x6c, 
    0x16, 0x2d, 0x1a, 0xc5, 0xf1, 0xd9, 0x35, 0xcc, 0x53, 0x5b, 0x6f, 0xbd, 0x27, 0x87, 0x12, 0x92, 0x2a, 0x72, 0xa2, 0xdd, 0x58, 0x07, 0x7c, 0xd8, 0x73, 0x6a, 0x0a, 0x87, 0x35, 0x6a, 0x11, 0xa9, 0xd3, 0xaf, 0xf9, 0xaf, 0x5e, 0x62, 0xe0, 0xe7, 0x98, 0x52, 0x7b, 0xdc, 0x03, 0x9e, 0x8a, 0xac, 0x3b, 0xb2, 0xdd, 0x76, 0x5a, 0x58, 0x5e, 0x9e, 0xfd, 0xcd, 0x0a, 0xc3, 0x8a, 0xb8, 0x95, 0xe7, 
    0x82, 0x46, 0x42, 0x29, 0xe9, 0xa1, 0xc0, 0x5c, 0x65, 0x88, 0x9a, 0x15, 0xe0, 0x2d, 0xe8, 0x9d, 0x6c, 0x9d, 0x2f, 0x08, 0x6a, 0xbd, 0x58, 0x8f, 0xd5, 0x98, 0xf7, 0x52, 0x2e, 0x56, 0xb2, 0x10, 0x20, 0x22, 0xa8, 0x33, 0x65, 0x59, 0x04, 0x0f, 0x3b, 0xa7, 0xb3, 0x89, 0x67, 0x8b, 0x22, 0x1d, 0xa2, 0xa4, 0x58, 0xbd, 0xca, 0xad, 0x53, 0x00, 0x49, 0x92, 0x16, 0x0f, 0xab, 0xfc, 0xb6, 0x83, 
    0x83, 0x32, 0x9e, 0x59, 0x1d, 0x2f, 0xde, 0x9f, 0x66, 0x33, 0x7d, 0x81, 0x6d, 0x16, 0xe2, 0xf9, 0x2f, 0x0e, 0x87, 0x70, 0x5c, 0xcc, 0x82, 0x48, 0x9f, 0x43, 0x69, 0xf0, 0x97, 0x21, 0x18, 0x73, 0x9c, 0xba, 0x50, 0xb5, 0xfa, 0x81, 0x84, 0x0f, 0x03, 0x1e, 0x6b, 0x6c, 0x8f, 0x1d, 0xa0, 0x2a, 0x9d, 0xfc, 0xf2, 0xff, 0x5a, 0xa3, 0x66, 0xd1, 0x3b, 0xc8, 0x68, 0xe7, 0x95, 0xb7, 0xc0, 0x2b, 
    0x4f, 0x7e, 0x48, 0xe2, 0x43, 0x7a, 0x87, 0xb4, 0x9a, 0xb0, 0x07, 0x2d, 0xdd, 0xe8, 0x84, 0xd0, 0x54, 0xe6, 0x64, 0xc4, 0xc5, 0xfd, 0x04, 0x4b, 0x57, 0xf3, 0x7d, 0xd7, 0xcf, 0x2b, 0xef, 0x1b, 0xf6, 0x6a, 0xc6, 0x19, 0x92, 0x2c, 0x72, 0xd3, 0x42, 0x26, 0x25, 0x74, 0xcb, 0xb3, 0x0b, 0x7b, 0x1a, 0xfe, 0x1c, 0xe3, 0x28, 0xbb, 0x27, 0xe9, 0x26, 0xb7, 0xce, 0x62, 0x69, 0x46, 0x02, 0x1a, 
    0x12, 0x71, 0xc4, 0x73, 0xb3, 0x25, 0x97, 0x20, 0xbc, 0x43, 0xf0, 0xae, 0x58, 0x79, 0x07, 0xc6, 0xe2, 0xc2, 0x23, 0xc5, 0x1b, 0xfa, 0x83, 0xdf, 0x86, 0xdc, 0xaa, 0x0a, 0x64, 0x76, 0xa2, 0xfb, 0xc5, 0xe2, 0x7b, 0xe3, 0x4c, 0x26, 0x5c, 0x39, 0x9d, 0x7b, 0xd6, 0x0b, 0xd4, 0x1f, 0x74, 0x36, 0x47, 0x4d, 0xe3, 0xfa, 0xe9, 0x72, 0xd1, 0x5e, 0x28, 0x39, 0x9c, 0xd8, 0x07, 0x45, 0xfa, 0x58, 
    0x2d, 0x4e, 0xd9, 0x13, 0xaf, 0x13, 0xf2, 0x59, 0xea, 0x9d, 0xf1, 0x52, 0x54, 0x69, 0xb4, 0xd6, 0x49, 0xd1, 0x10, 0xeb, 0x8d, 0xb0, 0xb7, 0x2f, 0x29, 0x06, 0xdc, 0x83, 0xd6, 0x7e, 0xd3, 0xf9, 0x50, 0x05, 0xbe, 0x3c, 0x60, 0x3a, 0xd1, 0xc7, 0xe3, 0xfb, 0x87, 0x31, 0x0d, 0xeb, 0xb7, 0xbd, 0xbc, 0x79, 0x68, 0x7d, 0x25, 0x86, 0x4c, 0x86, 0x56, 0x20, 0x42, 0x26, 0x58, 0xf8, 0x94, 0xa2, 
    0x95, 0x10, 0xea, 0x20, 0x50, 0xcf, 0x6d, 0x9c, 0x06, 0x43, 0x35, 0xf4, 0x0f, 0xd2, 0x41, 0x76, 0xa4, 0xb2, 0x1e, 0x3e, 0x91, 0x3a, 0xb0, 0x20, 0xa9, 0x94, 0xa8, 0x26, 0x45, 0xbf, 0xbf, 0x5b, 0x98, 0x1c, 0x79, 0x47, 0x37, 0xe5, 0x89, 0x4a, 0xbb, 0xf0, 0x86, 0xa3, 0x61, 0x59, 0x36, 0xe7, 0xd8, 0xc3, 0x4a, 0x45, 0x80, 0x8f, 0xa2, 0x1b, 0x82, 0xf3, 0x6f, 0x3d, 0x4e, 0x56, 0xe1, 0x98, 
    0xaf, 0xc8, 0xfd, 0xe4, 0x32, 0x74, 0x1f, 0x8b, 0x4a, 0xf1, 0xd1, 0x5a, 0x09, 0x3c, 0x89, 0x7e, 0x4f, 0x79, 0x49, 0xb5, 0x51, 0x6a, 0x1e, 0x2a, 0xe6, 0x38, 0x41, 0x5e, 0xcb, 0x0e, 0x2d, 0xb1, 0x9d, 0xcf, 0x4a, 0x49, 0x84, 0xe7, 0xf9, 0x96, 0xce, 0x14, 0xee, 0xb5, 0x98, 0x6a, 0xd8, 0x86, 0x2d, 0x90, 0xbe, 0x81, 0x3d, 0x01, 0x0f, 0xb0, 0x9d, 0x74, 0x70, 0x8e, 0xb5, 0xe5, 0x7a, 0xf1, 
    0xcd, 0xc4, 0x48, 0x67, 0x87, 0xbd, 0x7c, 0xcf, 0xa9, 0xbb, 0x27, 0x02, 0x1c, 0x92, 0x3f, 0x3e, 0xc9, 0x77, 0x77, 0xa5, 0xbf, 0xe8, 0x36, 0x15, 0x4b, 0x5c, 0xad, 0x6a, 0x8c, 0xcb, 0xa5, 0x25, 0xf0, 0x40, 0x12, 0x2b, 0x97, 0xa7, 0xa3, 0x32, 0x61, 0x75, 0x50, 0x8f, 0x54, 0xd0, 0xda, 0x35, 0x09, 0x18, 0xde, 0x36, 0x9a, 0x05, 0xd5, 0xeb, 0xfe, 0xe4, 0x0d, 0xb7, 0x85, 0xaa, 0x5f, 0xba, 
    0x2e, 0xdc, 0x16, 0xbd, 0xf7, 0x37, 0xef, 0x84, 0xab, 0x9e, 0x16, 0x6b, 0x51, 0x5e, 0xdd, 0xb4, 0x77, 0x0d, 0xc6, 0x24, 0x5f, 0xe4, 0x12, 0xf1, 0x90, 0x64, 0xe1, 0x43, 0xde, 0x3a, 0x7b, 0x9f, 0x5a, 0x9c, 0x0a, 0x0b, 0xec, 0x8d, 0xb9, 0xc5, 0x21, 0xa5, 0x02, 0xd8, 0x32, 0xf6, 0x4d, 0x99, 0x6c, 0x64, 0x0e, 0xc3, 0xab, 0xd2, 0x7f, 0x3c, 0xa9, 0x13, 0x92, 0xf2, 0x39, 0xf6, 0x18, 0xd4, 
    0x32, 0xa3, 0x82, 0xa0, 0x54, 0x30, 0xd0, 0x67, 0xda, 0x68, 0x05, 0xf2, 0xb5, 0xa8, 0x37, 0xd9, 0x14, 0xd1, 0x16, 0x90, 0xfb, 0x96, 0xf7, 0xb9, 0xac, 0x72, 0x84, 0x41, 0x02, 0xeb, 0xbb, 0x89, 0x69, 0x6e, 0x17, 0x8e, 0xfe, 0x60, 0xb2, 0x05, 0x34, 0x2d, 0x56, 0x69, 0xca, 0xaa, 0xff, 0x50, 0xb9, 0x13, 0xf7, 0xdd, 0x2b, 0x3d, 0x9b, 0xc6, 0xcf, 0xe6, 0x1e, 0x5d, 0x25, 0xb8, 0x13, 0x6b, 
    0x39, 0xf4, 0x36, 0x98, 0x03, 0x7a, 0x04, 0x3a, 0x8a, 0x49, 0xdb, 0xf8, 0xed, 0x0d, 0x22, 0xc5, 0x54, 0x65, 0x93, 0x1e, 0x9e, 0x5c, 0xe2, 0xf5, 0xbc, 0xc3, 0x09, 0x20, 0x6a, 0x70, 0xe0, 0x4c, 0x91, 0x7b, 0x99, 0x17, 0xf5, 0xf4, 0x5e, 0xb5, 0xc9, 0xe7, 0x25, 0x0b, 0x96, 0xa6, 0x55, 0xae, 0x74, 0x47, 0xca, 0x92, 0xbe, 0x47, 0x11, 0x35, 0x9c, 0xa8, 0xd8, 0x73, 0x40, 0x56, 0x1d, 0xfb, 
    0x7f, 0xc8, 0x62, 0x60, 0xa6, 0x90, 0x05, 0x69, 0xc2, 0xcd, 0xea, 0x57, 0xf8, 0xb7, 0x24, 0x32, 0x8d, 0xa1, 0x83, 0xfa, 0x33, 0x01, 0xd6, 0x6e, 0x67, 0x85, 0x03, 0xf3, 0x2a, 0x86, 0x0b, 0xb5, 0xcf, 0x54, 0xf5, 0xe5, 0xb6, 0x54, 0x67, 0x72, 0x6c, 0x16, 0x14, 0xf0, 0xc4, 0xa9, 0x11, 0x3e, 0x94, 0x97, 0xf7, 0x32, 0xe4, 0x68, 0x08, 0x06, 0x2e, 0x8f, 0xbc, 0x50, 0xaf, 0xd8, 0x77, 0x59, 
    0x87, 0x91, 0x00, 0x03, 0xd7, 0xa6, 0x4f, 0xfc, 0x10, 0x3a, 0xba, 0x94, 0x8d, 0x80, 0x1f, 0xa5, 0x5f, 0x68, 0xec, 0xda, 0x98, 0x36, 0x28, 0x12, 0xcc, 0xa6, 0x5f, 0x1d, 0x52, 0xcc, 0x7b, 0xeb, 0x24, 0x11, 0x97, 0x3a, 0x9f, 0xc2, 0xd9, 0x34, 0x7f, 0x73, 0xc9, 0x05, 0x0a, 0x7a, 0xaa, 0xac, 0x14, 0x57, 0x23, 0x50, 0x7b, 0x6c, 0x3f, 0xf1, 0xa6, 0x5e, 0x87, 0xe1, 0x8e, 0x4f, 0x44, 0xca, 
    0xf6, 0x69, 0x08, 0xd8, 0x9c, 0x98, 0xb2, 0x74, 0x58, 0x28, 0xaa, 0xc9, 0x82, 0xf6, 0xd7, 0xa7, 0x82, 0x4c, 0x31, 0x9c, 0xe8, 0x00, 0x77, 0x38, 0xfd, 0x14, 0x59, 0x37, 0xab, 0x43, 0xc6, 0xe8, 0xbb, 0x56, 0x7b, 0xdb, 0x1a, 0x42, 0x07, 0x6f, 0x70, 0xc4, 0xe8, 0x2c, 0x3f, 0x43, 0xb1, 0x22, 0x5e, 0xe5, 0x7d, 0xf8, 0x74, 0x14, 0xb4, 0x65, 0xd3, 0x6c, 0x90, 0x33, 0x27, 0x1b, 0x8c, 0x04, 
    0xc7, 0x3f, 0x76, 0xe6, 0x09, 0xe0, 0x3d, 0x2b, 0x4a, 0x8d, 0xd8, 0x81, 0x16, 0x1d, 0xcb, 0x60, 0x43, 0x8b, 0x99, 0xc9, 0xd4, 0x4d, 0x70, 0xb8, 0xd9, 0x50, 0x51, 0xb1, 0xea, 0x9e, 0xcc, 0x17, 0x76, 0x30, 0x3f, 0x2d, 0xdc, 0xcb, 0xfb, 0x8d, 0x32, 0x7f, 0x3f, 0x86, 0x56, 0xe5, 0xd1, 0xda, 0x51, 0x58, 0x75, 0xd1, 0xc7, 0xb5, 0x61, 0x7a, 0x09, 0xe0, 0x4a, 0xbe, 0xc5, 0x23, 0xe7, 0x6e, 
    0x5f, 0x41, 0xea, 0xc9, 0x0d, 0xba, 0x7b, 0x2a, 0x62, 0xfc, 0x48, 0xc9, 0x2a, 0xec, 0xe6, 0x5c, 0xc4, 0x46, 0x75, 0x9d, 0xb2, 0x02, 0x45, 0x33, 0x8a, 0x69, 0xda, 0xf5, 0xd5, 0xa2, 0xdc, 0xb9, 0x02, 0x4a, 0x3f, 0xbd, 0xc1, 0x21, 0x59, 0x5f, 0xde, 0xf0, 0xd9, 0xed, 0x43, 0x27, 0x43, 0x61, 0x92, 0x96, 0xe9, 0xf7, 0xd3, 0x7f, 0xc6, 0x64, 0x1a, 0x1b, 0x09, 0x2f, 0xa4, 0xa5, 0xb7, 0xfd, 
    0x5e, 0x23, 0xdf, 0x72, 0xdf, 0x18, 0x8a, 0xbe, 0x70, 0xe4, 0x5f, 0x2d, 0x65, 0x45, 0xa4, 0x13, 0xbb, 0x1a, 0xdb, 0x2e, 0x7b, 0x71, 0xfa, 0x95, 0x9c, 0x3e, 0xe0, 0x88, 0xcc, 0x23, 0x0b, 0x02, 0x78, 0xaf, 0xb5, 0xa8, 0x8f, 0xdd, 0x4c, 0xd5, 0x1d, 0x6a, 0x03, 0x85, 0xf7, 0x9c, 0xf1, 0x8b, 0xdc, 0x9f, 0x61, 0x2c, 0x03, 0xed, 0x53, 0xcc, 0xa9, 0xcb, 0xff, 0x4f, 0x82, 0x48, 0xf2, 0xd6, 
    0xa0, 0xb3, 0x9e, 0x6f, 0x7a, 0x2e, 0x26, 0x49, 0x0b, 0x78, 0xbf, 0xf7, 0xab, 0x56, 0x19, 0xea, 0x96, 0x75, 0xbf, 0x0d, 0x46, 0x2b, 0xad, 0xfd, 0x73, 0x36, 0x14, 0x12, 0xc0, 0xc6, 0x82, 0x7e, 0x1f, 0x5f, 0x95, 0x41, 0x1e, 0xa8, 0xaf, 0xfb, 0x02, 0x93, 0x65, 0xb4, 0x01, 0x27, 0x73, 0x25, 0xb5, 0x1f, 0x8a, 0x1c, 0x2e, 0x9d, 0x78, 0xf9, 0x5c, 0xf8, 0xa4, 0xcc, 0x2b, 0x6a, 0x21, 0x20, 
    0xe8, 0x84, 0x45, 0x19, 0xb1, 0x8a, 0xac, 0x9b, 0x3a, 0xc0, 0x72, 0x7c, 0x0d, 0x1d, 0xa3, 0xd4, 0x36, 0x06, 0x4b, 0x0a, 0x75, 0xb9, 0x7c, 0xee, 0x67, 0xf1, 0x4d, 0x55, 0x14, 0x71, 0x25, 0x2d, 0xff, 0xb1, 0x75, 0x7e, 0x8c, 0xa4, 0x1b, 0x1a, 0x4f, 0x89, 0x44, 0x8a, 0xa0, 0xeb, 0xbc, 0xba, 0x66, 0x1a, 0x8f, 0x02, 0x35, 0xc5, 0xaf, 0x9e, 0x55, 0x80, 0xe0, 0xee, 0x2f, 0x21, 0x92, 0x51, 
    0x43, 0x0e, 0xac, 0x16, 0x51, 0xbf, 0x34, 0x33, 0xf0, 0xca, 0x16, 0x3d, 0x55, 0x8f, 0xb6, 0xf4, 0x07, 0x85, 0xb6, 0x67, 0x0e, 0x4e, 0xd7, 0xae, 0xd2, 0x59, 0xc5, 0x62, 0x89, 0x62, 0xef, 0x27, 0xfa, 0x2b, 0x35, 0x86, 0x4a, 0x57, 0x31, 0xc3, 0x94, 0xb4, 0x81, 0xd0, 0x11, 0x15, 0x63, 0xd7, 0xbe, 0x3c, 0x2f, 0x8b, 0x21, 0xbd, 0x1a, 0x82, 0x6d, 0xef, 0x2d, 0x03, 0x49, 0xac, 0xe2, 0xc0, 
    0x09, 0x5b, 0x5b, 0xd5, 0x9a, 0xed, 0xb8, 0xfc, 0xa8, 0x54, 0x6c, 0xb9, 0xdf, 0xa8, 0x3c, 0x44, 0x30, 0xe6, 0x20, 0xef, 0xad, 0xa5, 0x5e, 0x29, 0xfc, 0x9e, 0x69, 0x39, 0x08, 0xec, 0x94, 0x6a, 0xa7, 0xab, 0xdc, 0xdd, 0x4b, 0x5c, 0x4e, 0xa1, 0xfc, 0xd1, 0x7d, 0x46, 0xb9, 0xc9, 0x9e, 0xef, 0x9c, 0xec, 0x45, 0xec, 0x40, 0x19, 0x3c, 0x8c, 0xdd, 0xa3, 0x11, 0x39, 0x53, 0xb7, 0x6c, 0x97, 
    0x35, 0xf6, 0xd6, 0x9a, 0x61, 0xf0, 0x43, 0xc9, 0x1a, 0x6c, 0xdf, 0x51, 0xe6, 0x8c, 0x2c, 0x21, 0x58, 0xc1, 0x9d, 0xe5, 0x87, 0xef, 0xab, 0x21, 0xc8, 0xc8, 0xc6, 0x30, 0x92, 0x92, 0x99, 0x5b, 0x42, 0xe5, 0xfb, 0xab, 0x72, 0xce, 0xe1, 0xf4, 0x10, 0xd0, 0xa6, 0x29, 0x29, 0x84, 0x6f, 0x13, 0xbc, 0xf9, 0xdc, 0x36, 0xae, 0x07, 0x71, 0x4a, 0x3a, 0xe4, 0x75, 0xaf, 0xce, 0xc7, 0x83, 0x64, 
    0xbd, 0xc8, 0x44, 0xfe, 0xfb, 0x82, 0x96, 0x7d, 0x0c, 0x0b, 0xe4, 0xdb, 0xa0, 0xd0, 0x67, 0x3d, 0xec, 0xfd, 0x25, 0xb1, 0x53, 0x7e, 0x48, 0x33, 0x17, 0x96, 0xd3, 0x42, 0xf1, 0x00, 0xa4, 0x66, 0x9d, 0xe2, 0xa4, 0x1c, 0x6a, 0xfd, 0xce, 0x38, 0xbc, 0xe4, 0x59, 0x11, 0x74, 0xf4, 0xab, 0xa0, 0x66, 0x50, 0x55, 0x3d, 0xdf, 0x1e, 0x7a, 0xb6, 0x96, 0xa2, 0x59, 0x84, 0x0d, 0xec, 0x27, 0x93, 
    0x8a, 0xcf, 0x3a, 0x38, 0x11, 0x20, 0xfa, 0x89, 0x6e, 0x97, 0xe5, 0x54, 0x07, 0x00, 0x92, 0x6a, 0x7f, 0x62, 0xd2, 0xdc, 0x09, 0x8b, 0x20, 0x98, 0x58, 0xf9, 0x80, 0xc7, 0xd1, 0x37, 0xe2, 0x4b, 0x8d, 0xef, 0x1c, 0x61, 0x05, 0x28, 0x12, 0xd3, 0x7a, 0x72, 0x36, 0xbe, 0x38, 0x0a, 0x13, 0x66, 0x89, 0x64, 0xa7, 0x48, 0xaf, 0xff, 0x0f, 0xdd, 0x7b, 0xba, 0x50, 0xad, 0x80, 0x76, 0x96, 0x0a, 
    0xef, 0x10, 0xa9, 0xd0, 0x31, 0x73, 0x57, 0x4d, 0xcd, 0x80, 0x00, 0xb4, 0x93, 0xf3, 0xfa, 0xb1, 0xb6, 0xdf, 0x3c, 0x65, 0x58, 0x78, 0x24, 0xad, 0x0e, 0x3b, 0x0b, 0xa9, 0x84, 0x63, 0x80, 0x04, 0x30, 0x05, 0xb1, 0x0f, 0x3a, 0x66, 0x51, 0xcb, 0x9b, 0x68, 0x0c, 0xd8, 0x37, 0x53, 0x58, 0x79, 0x9c, 0xc4, 0x4c, 0xd4, 0x02, 0xfd, 0x49, 0xe8, 0x70, 0x0e, 0x2e, 0xd3, 0x94, 0x8e, 0x62, 0x23, 
    0xa4, 0x2a, 0xea, 0x63, 0xa7, 0x9f, 0x4d, 0x97, 0x5c, 0xd5, 0x3e, 0x91, 0x77, 0x6e, 0x27, 0xc1, 0x26, 0xc3, 0x8f, 0x80, 0xe4, 0xab, 0x19, 0x6f, 0xf8, 0x0c, 0x8d, 0xc8, 0xbe, 0x4b, 0x79, 0x78, 0xeb, 0x0e, 0xd6, 0x3d, 0x96, 0x0a, 0x57, 0xec, 0x43, 0x93, 0xb2, 0x7d, 0x05, 0x25, 0x2f, 0x45, 0xa9, 0xf5, 0xf4, 0xcf, 0x97, 0xc7, 0xe4, 0x77, 0xdd, 0x33, 0xc1, 0x42, 0x64, 0x14, 0x66, 0xdb, 
    0x68, 0xbb, 0xb3, 0x4e, 0x37, 0x8a, 0x1a, 0x22, 0xc9, 0xc6, 0xcc, 0x12, 0x85, 0x3d, 0xd4, 0x36, 0xc3, 0x30, 0xee, 0x73, 0xc2, 0x0c, 0x91, 0xe0, 0x7b, 0x41, 0x58, 0x18, 0x88, 0xb6, 0x43, 0xb1, 0x07, 0x26, 0xe7, 0xf7, 0x75, 0xc7, 0x2b, 0xbb, 0x8f, 0x9f, 0x55, 0xe1, 0xe7, 0xf6, 0x33, 0xc9, 0x5f, 0xd2, 0x59, 0x73, 0x81, 0x2e, 0xdd, 0x09, 0x06, 0xcf, 0xc5, 0x52, 0x67, 0x95, 0xee, 0xfe, 
    0x28, 0xba, 0x34, 0x07, 0xd7, 0x5d, 0xdf, 0xa7, 0x04, 0x14, 0x81, 0x8e, 0x2f, 0x3d, 0x68, 0xf9, 0x95, 0x11, 0x5f, 0x11, 0x3d, 0x1a, 0xd8, 0x9b, 0xe0, 0x51, 0xf4, 0x41, 0xbb, 0xcc, 0xfb, 0xe9, 0xe6, 0x5b, 0x45, 0xb8, 0x69, 0x33, 0x99, 0xb7, 0xe5, 0xf7, 0x2e, 0x7b, 0xc0, 0x78, 0x3c, 0xa6, 0xe8, 0x91, 0x5f, 0x20, 0x61, 0x96, 0x5d, 0x82, 0x17, 0xf4, 0xd4, 0x9f, 0xb7, 0x0c, 0x47, 0x76, 
    0x7d, 0xd8, 0x19, 0x27, 0x59, 0x34, 0xb3, 0x1b, 0xcc, 0xec, 0xc4, 0x4b, 0x1d, 0xac, 0x04, 0x6a, 0x50, 0x9a, 0xe6, 0xa1, 0x43, 0x08, 0xc8, 0x11, 0x32, 0xdf, 0xba, 0x58, 0x3b, 0x28, 0xbb, 0x1f, 0x76, 0x1e, 0x4e, 0xb1, 0x85, 0x8d, 0x66, 0xca, 0x6e, 0xc2, 0x0b, 0xe8, 0x28, 0x74, 0xc4, 0xaa, 0x4c, 0x19, 0x7c, 0x90, 0x69, 0x36, 0x00, 0x07, 0x0c, 0xbb, 0x41, 0xaf, 0xfe, 0x9c, 0xa0, 0x16, 
    0xe1, 0xeb, 0x78, 0x7e, 0x77, 0xe8, 0xa6, 0x53, 0x43, 0x2d, 0xa2, 0xfa, 0x5e, 0x61, 0xa0, 0xb9, 0xb2, 0x77, 0x9e, 0x4f, 0xf0, 0x4c, 0x11, 0x1a, 0xb1, 0xba, 0x49, 0x64, 0x2d, 0xcc, 0xc0, 0x5f, 0xda, 0x9d, 0xa0, 0x79, 0x6a, 0x3b, 0xc1, 0x8b, 0x0c, 0x87, 0xe0, 0x6b, 0x1d, 0x1a, 0x4b, 0x0c, 0xc2, 0x99, 0x95, 0xab, 0x24, 0xbf, 0x2f, 0x5b, 0xd2, 0x8d, 0xff, 0x88, 0x18, 0x3c, 0x45, 0x4b, 
    0x63, 0x24, 0xc1, 0x89, 0x78, 0xdd, 0xbd, 0x5b, 0x25, 0xa7, 0xc1, 0x9e, 0x51, 0x29, 0x48, 0xc2, 0xcf, 0xd1, 0x88, 0x76, 0x7f, 0xd0, 0xf6, 0x6d, 0x91, 0x9a, 0x29, 0x4e, 0x6e, 0x4b, 0xbe, 0x1e, 0x8a, 0xd5, 0xca, 0x72, 0x22, 0x8b, 0x20, 0x97, 0x0a, 0x82, 0xdf, 0xab, 0x02, 0x41, 0x22, 0xe6, 0x12, 0xed, 0xcd, 0xc2, 0x14, 0x30, 0xa7, 0xb5, 0xea, 0x87, 0x54, 0xb9, 0x3b, 0xf0, 0x09, 0xd8, 
    0x3e, 0x8c, 0xc4, 0xdf, 0x74, 0xfb, 0x02, 0xee, 0x6d, 0x87, 0x00, 0xb2, 0x36, 0x63, 0xf1, 0x48, 0x31, 0x77, 0x5d, 0xfc, 0xaa, 0xd8, 0x72, 0x5d, 0x99, 0x5b, 0xf7, 0x70, 0x9b, 0xa1, 0x3d, 0xb2, 0xd8, 0xdc, 0xef, 0x0a, 0x53, 0xcb, 0xff, 0xa0, 0x28, 0x81, 0x31, 0xa0, 0xd3, 0xd8, 0x59, 0xe7, 0xf8, 0x88, 0x60, 0x1e, 0xd2, 0x8f, 0x56, 0x33, 0x71, 0x6f, 0xf9, 0xfb, 0xa8, 0xca, 0x4c, 0x4d, 
    0x22, 0x1a, 0x2b, 0xb4, 0xd6, 0x60, 0xd6, 0x8e, 0x05, 0xf3, 0xf8, 0x82, 0x74, 0x14, 0x24, 0xe3, 0x29, 0x4e, 0x1e, 0xea, 0xa9, 0xcc, 0xce, 0x8c, 0xf8, 0x6b, 0x6f, 0x91, 0xee, 0x22, 0x32, 0x04, 0x9a, 0xd9, 0x75, 0x43, 0x10, 0xf8, 0x56, 0xb2, 0x54, 0xac, 0x2d, 0xab, 0xd8, 0x42, 0xf1, 0x4c, 0x96, 0xc2, 0x7f, 0xf0, 0x72, 0x6e, 0x21, 0xa6, 0xea, 0x58, 0xd6, 0x1a, 0xe4, 0x19, 0x67, 0xb3, 
    0xb3, 0xe3, 0x85, 0xf3, 0x9e, 0x41, 0x70, 0x17, 0x78, 0x3f, 0xfd, 0xe8, 0xd5, 0x6c, 0xac, 0x01, 0x47, 0x30, 0x6a, 0xa5, 0xec, 0x25, 0x31, 0xb9, 0xb4, 0x09, 0xd8, 0x70, 0xde, 0x18, 0x9e, 0x7d, 0xa7, 0x17, 0xa2, 0x3c, 0x87, 0x53, 0xda, 0xf6, 0xf3, 0x5a, 0x58, 0xbb, 0x44, 0xaf, 0x48, 0xb1, 0x90, 0xcd, 0x1c, 0xfe, 0x9c, 0x86, 0x2c, 0x39, 0x41, 0x6c, 0x1e, 0x7a, 0x03, 0x6d, 0xf5, 0x55, 
    0x8f, 0x37, 0x8c, 0xcc, 0xb3, 0x29, 0x59, 0x48, 0x7f, 0xaa, 0xdc, 0x16, 0xfb, 0x87, 0xd6, 0xd0, 0xbb, 0x3a, 0xb9, 0x1e, 0x21, 0x18, 0x90, 0xd0, 0x88, 0xe7, 0x80, 0xee, 0x2c, 0x34, 0xaf, 0x81, 0x52, 0x28, 0x15, 0x90, 0xff, 0x61, 0x17, 0x65, 0xdd, 0x38, 0x43, 0x00, 0x4e, 0xb9, 0xb1, 0x1b, 0x7d, 0x46, 0xb7, 0x9b, 0xe3, 0x12, 0xc7, 0xa7, 0xcb, 0x3f, 0x52, 0x2b, 0x85, 0x8c, 0x82, 0xd1, 
    0x60, 0x5f, 0x9a, 0x3c, 0x04, 0xc3, 0x01, 0xb6, 0xad, 0x49, 0x44, 0xde, 0x13, 0xdd, 0x6a, 0x8f, 0x84, 0xbe, 0x40, 0x95, 0x3b, 0x2b, 0x39, 0x00, 0x6f, 0xa3, 0xfa, 0x02, 0x51, 0xaf, 0xe8, 0x82, 0x31, 0x5a, 0xd3, 0x13, 0x49, 0x25, 0xee, 0xfe, 0xb9, 0x6b, 0xa3, 0x86, 0x3d, 0x81, 0x1b, 0xf9, 0x0d, 0x01, 0x23, 0x6e, 0xe4, 0xb3, 0xcb, 0x30, 0x34, 0x3b, 0x47, 0xa2, 0xa0, 0x7c, 0xca, 0x09, 
    0x9f, 0x8f, 0x98, 0x4d, 0x39, 0xef, 0x20, 0x0b, 0x14, 0xe5, 0xdb, 0xbc, 0x7b, 0xb0, 0x60, 0x9f, 0x1c, 0x1c, 0xf1, 0x8a, 0x94, 0x38, 0xc7, 0x01, 0xe5, 0x5e, 0x5d, 0x07, 0x3f, 0x79, 0x2f, 0xfe, 0xf9, 0xec, 0x2b, 0x09, 0x48, 0x63, 0xc4, 0x72, 0x18, 0xef, 0x00, 0x72, 0x29, 0xd0, 0x86, 0x8d, 0x65, 0xdc, 0x6c, 0x7c, 0x67, 0x53, 0x4d, 0xf9, 0xdf, 0xdf, 0xa9, 0x23, 0x98, 0xc0, 0x65, 0xad, 
    0x16, 0x12, 0x47, 0x2f, 0xd2, 0x61, 0x71, 0x24, 0xa5, 0x96, 0x95, 0xe2, 0x11, 0xf3, 0x55, 0x7f, 0x3f, 0x8a, 0xa0, 0xd4, 0xc1, 0x2d, 0x09, 0xed, 0x4d, 0x46, 0x15, 0x01, 0x6b, 0x69, 0xce, 0xc3, 0xc9, 0x7f, 0xa8, 0xe2, 0x10, 0x40, 0xa6, 0x93, 0x95, 0xbd, 0xe9, 0x38, 0x6d, 0x07, 0xfa, 0x99, 0x5d, 0x7c, 0xf7, 0x2f, 0x24, 0x58, 0xdc, 0xbb, 0xe3, 0xee, 0x6f, 0x3d, 0x23, 0x11, 0xbf, 0x0f, 
    0xf0, 0xef, 0xf4, 0x7a, 0x9c, 0x37, 0x9a, 0x31, 0x55, 0x59, 0x6e, 0x8f, 0xc8, 0xaa, 0x0f, 0xad, 0x57, 0xec, 0x80, 0x0b, 0x5f, 0xd6, 0xff, 0xd3, 0x52, 0x1e, 0x7c, 0xa8, 0xde, 0xe3, 0x84, 0xc2, 0x66, 0xca, 0x15, 0xc7, 0x21, 0x9b, 0x92, 0x77, 0x64, 0x03, 0xc6, 0xd9, 0xba, 0x61, 0x40, 0x9b, 0xe5, 0x93, 0x5f, 0x4d, 0x55, 0xdb, 0xb9, 0xb6, 0x42, 0x7c, 0x8c, 0x03, 0xf5, 0xe9, 0x5a, 0x70, 
    0x05, 0xf7, 0x2c, 0xcd, 0xbd, 0x55, 0x34, 0x54, 0xc9, 0x91, 0x83, 0x39, 0x0f, 0x62, 0x88, 0x5c, 0xe2, 0xfd, 0x49, 0xf0, 0x52, 0xa6, 0x4e, 0xc5, 0x80, 0xb6, 0xa1, 0x57, 0x16, 0x35, 0xce, 0xac, 0xb4, 0xab, 0xd5, 0x4f, 0x38, 0x96, 0x96, 0xc5, 0xc6, 0x64, 0xa1, 0x35, 0xa4, 0x28, 0x57, 0xd6, 0x3a, 0x07, 0x0b, 0xb9, 0x2b, 0xc7, 0x19, 0x7a, 0x99, 0xec, 0x4b, 0xa9, 0xcd, 0xe5, 0xc1, 0x12, 
    0xa0, 0xe6, 0xf1, 0xf3, 0xa0, 0xc0, 0x4e, 0x7d, 0x06, 0xc6, 0x53, 0x40, 0x40, 0x0e, 0x99, 0x24, 0x77, 0x66, 0x6e, 0xae, 0x0a, 0xf2, 0x57, 0x49, 0xdb, 0xcd, 0x95, 0x66, 0xf8, 0xb6, 0xa4, 0x05, 0x25, 0x59, 0x53, 0x46, 0xbf, 0xf2, 0x5f, 0x72, 0x77, 0xf1, 0xd0, 0xc0, 0x2e, 0xa8, 0x14, 0x85, 0x8a, 0x64, 0x42, 0x15, 0x93, 0xa3, 0xaf, 0x0c, 0x06, 0x63, 0xd8, 0x93, 0x93, 0x2e, 0xac, 0x7c, 
    0xae, 0x24, 0xb7, 0xe4, 0xd2, 0x6c, 0xbe, 0x7d, 0x1b, 0x29, 0xe7, 0xce, 0xfe, 0x1c, 0x33, 0x66, 0xc6, 0xb1, 0x08, 0x65, 0x97, 0xf2, 0x78, 0x2a, 0xb7, 0xae, 0x54, 0x1b, 0x2c, 0xa3, 0x3d, 0x92, 0x48, 0x96, 0x49, 0x83, 0xee, 0x37, 0xdc, 0x04, 0xe9, 0x2a, 0x39, 0x79, 0x7a, 0xd6, 0x2a, 0xce, 0x26, 0xfb, 0x0e, 0xa7, 0xd0, 0x8d, 0x01, 0x67, 0xf3, 0x5f, 0x10, 0x79, 0xd8, 0xc2, 0xae, 0x1e, 
    0x6d, 0x2a, 0xd0, 0x5a, 0x72, 0x66, 0xad, 0xd2, 0xa6, 0xfb, 0x99, 0x0c, 0xc8, 0x3f, 0xda, 0x2b, 0x03, 0x72, 0xda, 0x27, 0x25, 0xba, 0x7c, 0x43, 0x13, 0xd1, 0xe0, 0xff, 0x8f, 0x8c, 0x90, 0x6b, 0x69, 0x66, 0x4a, 0xd2, 0x7c, 0x01, 0x12, 0x15, 0xe0, 0x31, 0xe9, 0xa4, 0x77, 0x89, 0xf6, 0xe8, 0xdb, 0xb3, 0xb7, 0x08, 0x97, 0x3a, 0xa0, 0xd8, 0xfa, 0x5f, 0x0d, 0x05, 0x32, 0x5e, 0x57, 0x73, 
    0x80, 0x43, 0xd8, 0xd3, 0x6b, 0x93, 0x07, 0x30, 0x22, 0xb6, 0xc8, 0xf9, 0xe1, 0xa5, 0xb3, 0x61, 0x67, 0x2c, 0xb0, 0xe6, 0xe5, 0xc2, 0x26, 0xa7, 0x8e, 0x8a, 0x74, 0x36, 0xa1, 0xf4, 0x15, 0x33, 0x0f, 0xe5, 0xd1, 0x8a, 0x3e, 0x89, 0x7b, 0x2d, 0x21, 0x02, 0x1c, 0xac, 0xcd, 0x4f, 0x50, 0xdd, 0xe0, 0xcc, 0x22, 0x3b, 0xed, 0x79, 0xc0, 0x3e, 0xd8, 0x09, 0x81, 0x66, 0x50, 0x9e, 0x75, 0xd6, 
    0x47, 0x50, 0x42, 0x1a, 0x10, 0xe3, 0x88, 0x5c, 0xa0, 0x71, 0xbb, 0xff, 0xdc, 0x3e, 0x4b, 0xa3, 0x9b, 0x7f, 0x35, 0xd5, 0xc4, 0x98, 0x45, 0x19, 0x5f, 0xbd, 0xf3, 0x79, 0x5d, 0x0a, 0xe1, 0x6f, 0xbd, 0xbc, 0xf6, 0x1e, 0x67, 0xb2, 0xfe, 0xad, 0x08, 0x5b, 0x56, 0xc8, 0x38, 0x9b, 0x5c, 0xeb, 0x85, 0xa0, 0xa8, 0xfa, 0x81, 0x50, 0x31, 0x1f, 0xc3, 0x92, 0x3b, 0x13, 0xae, 0xf7, 0x86, 0x48, 
    0x29, 0x47, 0x8b, 0xe0, 0x1d, 0xf9, 0x83, 0xec, 0x7c, 0x19, 0x30, 0x4a, 0xb5, 0xcb, 0x9b, 0x71, 0xab, 0xb3, 0x8b, 0x70, 0xce, 0x1e, 0x9e, 0x81, 0x62, 0x0e, 0x0f, 0x42, 0xe7, 0xf2, 0xc0, 0x37, 0x1f, 0x0a, 0x82, 0xbd, 0xd9, 0xef, 0x81, 0xb5, 0x24, 0xfd, 0x5e, 0x78, 0x49, 0x48, 0x43, 0x15, 0xf1, 0x1b, 0x5c, 0x71, 0xc4, 0x7f, 0xc6, 0x89, 0x2d, 0x41, 0x36, 0x72, 0x83, 0xba, 0x90, 0xb2, 
    0x43, 0x1b, 0x53, 0x68, 0xaf, 0x35, 0x2a, 0xf8, 0x7b, 0x8c, 0xde, 0xc8, 0xf6, 0x17, 0x70, 0x0a, 0x36, 0xd4, 0x51, 0x98, 0x83, 0x1b, 0xbf, 0x3c, 0x44, 0x1a, 0x59, 0x78, 0x73, 0xda, 0xc9, 0xb5, 0x33, 0x99, 0x64, 0xa0, 0xf7, 0x10, 0xe4, 0xb1, 0xd8, 0xb4, 0x81, 0x6c, 0x15, 0xf1, 0xe7, 0x56, 0x6b, 0x30, 0xae, 0x9d, 0xa4, 0xc4, 0xfc, 0x5b, 0x30, 0x73, 0xfc, 0x18, 0xea, 0xc4, 0xfe, 0x28, 
    0x68, 0xc7, 0x5f, 0xd3, 0x36, 0x04, 0x39, 0x8b, 0x86, 0x0b, 0xf7, 0x74, 0x51, 0x07, 0x21, 0x20, 0x28, 0xe8, 0x47, 0xf2, 0x68, 0xc1, 0x8d, 0x41, 0xe9, 0x01, 0x8d, 0x28, 0xe5, 0xcf, 0x0e, 0x12, 0x39, 0x4e, 0xd0, 0x6d, 0x2f, 0x84, 0xa0, 0x8c, 0x50, 0xb1, 0xf5, 0xa9, 0x4a, 0x16, 0x16, 0x1a, 0x72, 0xbe, 0x72, 0xce, 0x44, 0x2e, 0x40, 0xdb, 0x68, 0xec, 0xac, 0xe6, 0x11, 0x91, 0xd7, 0xc2, 
    0x9d, 0xb8, 0x36, 0x42, 0xa3, 0x05, 0x65, 0x08, 0xb8, 0x51, 0x50, 0xe2, 0x98, 0x8c, 0x19, 0x3e, 0xbc, 0x34, 0xf4, 0xfc, 0x65, 0xcb, 0x33, 0xe7, 0x9b, 0x56, 0xad, 0xdf, 0xc3, 0x2d, 0x24, 0x1d, 0x5a, 0x53, 0xb1, 0x9d, 0xf5, 0x5a, 0x3d, 0x2d, 0xbe, 0xde, 0x98, 0x92, 0xaf, 0x1d, 0x65, 0x25, 0xae, 0xe9, 0x95, 0x55, 0x4e, 0xce, 0x91, 0x6d, 0x4c, 0xf8, 0xff, 0xda, 0x20, 0x22, 0xed, 0x0c, 
    0xab, 0xc4, 0x6a, 0xee, 0x5b, 0xa2, 0x7b, 0x08, 0xed, 0xa2, 0x8b, 0x46, 0x37, 0xb7, 0x11, 0x74, 0x4c, 0x52, 0x9a, 0xfd, 0x1e, 0xe6, 0x7c, 0xbc, 0xfb, 0x3f, 0x04, 0xb6, 0xed, 0xcc, 0x23, 0x4a, 0xad, 0x86, 0xe3, 0x4f, 0x49, 0x2a, 0x70, 0x04, 0x9d, 0x3f, 0x5e, 0x43, 0x90, 0xbd, 0x8d, 0x65, 0x23, 0x06, 0xf4, 0x46, 0x73, 0x4a, 0x84, 0xb5, 0x8b, 0x32, 0x21, 0xb3, 0xaa, 0x03, 0x44, 0x98, 
    0x55, 0xea, 0xc6, 0xea, 0x98, 0xb0, 0x96, 0xa7, 0x2e, 0xb8, 0x67, 0xbb, 0xee, 0xde, 0x59, 0xce, 0x82, 0x11, 0x74, 0x53, 0xa6, 0x14, 0x34, 0xe0, 0x88, 0xa7, 0xb6, 0xd2, 0x7c, 0x76, 0xa4, 0x3e, 0x57, 0x70, 0xa1, 0x94, 0xdb, 0x20, 0x06, 0xc3, 0x6a, 0xcb, 0x0b, 0xf2, 0x86, 0xb5, 0x35, 0xe1, 0x50, 0x72, 0x97, 0x1d, 0x0b, 0xb4, 0xbb, 0xee, 0x20, 0x6b, 0x53, 0x3b, 0x80, 0x77, 0x95, 0x53, 
    0x12, 0x60, 0xe8, 0xbe, 0xf8, 0x93, 0xd8, 0x7e, 0x24, 0x04, 0x69, 0x6d, 0xe6, 0xe4, 0xf3, 0x6a, 0x14, 0x58, 0x0a, 0x45, 0x04, 0x30, 0xd7, 0x97, 0x7d, 0x66, 0x76, 0xb0, 0xf4, 0x4a, 0x71, 0xa1, 0xd6, 0xa4, 0x73, 0x70, 0x86, 0xd0, 0x03, 0x40, 0x3d, 0x8c, 0x6b, 0x0b, 0xc4, 0xd5, 0xd4, 0x67, 0x7f, 0x2f, 0xf5, 0x0e, 0xa1, 0xa1, 0x2c, 0x02, 0x18, 0xa7, 0xce, 0xb5, 0xcf, 0x94, 0x86, 0xe4, 
    0x0f, 0x27, 0xbb, 0xdd, 0x9b, 0x19, 0x1a, 0x40, 0x5e, 0x57, 0x75, 0x8c, 0xd9, 0x62, 0xaa, 0xcb, 0xcf, 0xe9, 0x83, 0x02, 0x9c, 0x30, 0x5b, 0xfd, 0xa7, 0xd8, 0x8e, 0x08, 0x0c, 0x6a, 0x54, 0x94, 0x1b, 0x68, 0x7e, 0xf8, 0xce, 0xbd, 0x26, 0xa4, 0xff, 0xc9, 0xda, 0x5c, 0xeb, 0x93, 0xc6, 0x34, 0x12, 0x1c, 0x9d, 0xd5, 0xd5, 0x09, 0x5a, 0x4a, 0xe4, 0xcc, 0xe0, 0x5c, 0x1c, 0x8f, 0x7d, 0x7d, 
    0x77, 0x02, 0x12, 0x2d, 0xda, 0xf7, 0xa8, 0x1d, 0x44, 0x60, 0x48, 0xd6, 0x7c, 0xb0, 0x96, 0x8f, 0x73, 0xc8, 0xb2, 0xcf, 0x34, 0xf7, 0x1b, 0x84, 0x57, 0xed, 0x0e, 0x42, 0xc4, 0x2c, 0x93, 0x56, 0xd8, 0xfc, 0xdc, 0xe7, 0x1f, 0x30, 0x26, 0x7d, 0x8f, 0xf1, 0x45, 0xce, 0x63, 0xe8, 0xe2, 0x0c, 0x8a, 0x97, 0xc7, 0xdf, 0xb2, 0xfc, 0x5c, 0x63, 0x81, 0x9e, 0x2e, 0xcd, 0x28, 0xd4, 0x52, 0xdb, 
    0xf2, 0x0e, 0xaa, 0x23, 0x36, 0x60, 0xa5, 0xc6, 0x43, 0x37, 0xa8, 0xd4, 0xc4, 0x21, 0x85, 0xac, 0x5d, 0xa8, 0x59, 0x83, 0xc8, 0xec, 0x96, 0x3e, 0x4d, 0x0a, 0xf8, 0x0e, 0x27, 0x16, 0x36, 0x47, 0xc2, 0xe6, 0x8a, 0xef, 0xd0, 0x15, 0xa8, 0x03, 0xfc, 0x55, 0xc4, 0xa9, 0x10, 0xfd, 0x80, 0x76, 0x37, 0xb9, 0x3e, 0xbe, 0x5c, 0xe3, 0xde, 0xe1, 0x01, 0x63, 0x75, 0x64, 0x4c, 0x53, 0x38, 0x89, 
    0x33, 0x7c, 0xff, 0x63, 0xe5, 0x2b, 0xc1, 0xd5, 0xd5, 0x46, 0x1f, 0x00, 0xae, 0xf2, 0xbf, 0x25, 0x2a, 0x26, 0x10, 0x86, 0x62, 0x5d, 0xae, 0x30, 0xd3, 0xc3, 0x7c, 0x70, 0x22, 0x42, 0xde, 0xa5, 0xc1, 0xed, 0x58, 0x60, 0x0f, 0x39, 0x99, 0x38, 0x0a, 0x08, 0x70, 0x78, 0xbb, 0x2d, 0xb1, 0x81, 0xe8, 0xf5, 0x1e, 0xa1, 0x83, 0x6d, 0x02, 0x98, 0xcc, 0xb4, 0x34, 0xa4, 0x3d, 0xbf, 0x29, 0xe7, 
    0xf5, 0xbc, 0x4f, 0x10, 0x70, 0x66, 0xc9, 0x57, 0x8c, 0x18, 0x2e, 0xed, 0x3e, 0xc3, 0x09, 0x2a, 0x10, 0x71, 0x02, 0x9d, 0xfa, 0x68, 0xb7, 0x48, 0x32, 0x69, 0x62, 0xc8, 0x26, 0xf5, 0x09, 0x97, 0xa3, 0x5d, 0xfb, 0x4d, 0x39, 0xb6, 0x7d, 0x9a, 0x03, 0x3f, 0x65, 0x7b, 0xbc, 0x2c, 0x4c, 0x32, 0xa5, 0x26, 0x57, 0x37, 0x89, 0x44, 0xc9, 0xc3, 0x00, 0x04, 0x02, 0xa0, 0xff, 0x84, 0xf0, 0x71, 
    0x47, 0x27, 0x15, 0x6e, 0x71, 0xcd, 0x8a, 0xdd, 0xa1, 0xfd, 0x92, 0x2f, 0x7a, 0x3b, 0xbc, 0x27, 0xed, 0x4c, 0xd4, 0xb4, 0x22, 0x88, 0xca, 0x8b, 0xbd, 0x6f, 0xb7, 0xfa, 0xdf, 0x60, 0x90, 0xba, 0x83, 0x56, 0xe9, 0x34, 0x16, 0x30, 0x22, 0x7b, 0x53, 0xd0, 0xa1, 0x6c, 0xea, 0x4e, 0x22, 0x2c, 0x8d, 0xf0, 0x88, 0x18, 0x15, 0xbd, 0x76, 0x3c, 0x53, 0x9a, 0xb0, 0xaa, 0x05, 0xc7, 0xff, 0x39, 
    0x83, 0x12, 0xab, 0xeb, 0x51, 0x6e, 0x96, 0xbb, 0x99, 0x00, 0x95, 0xe1, 0xfd, 0xaa, 0x3b, 0x6b, 0x44, 0x77, 0xba, 0x9d, 0xce, 0x48, 0xe4, 0xb2, 0x8b, 0x32, 0xdd, 0x3b, 0x68, 0x11, 0x98, 0xf4, 0xec, 0x29, 0xcb, 0x86, 0xb9, 0x19, 0xd6, 0x8c, 0xdd, 0x78, 0xfb, 0xa7, 0x4d, 0x52, 0x2c, 0xa9, 0x79, 0x3c, 0xdd, 0xc3, 0x54, 0x40, 0x65, 0x0e, 0xf7, 0xf9, 0x6c, 0x13, 0x8e, 0xad, 0x93, 0x6f, 
    0x42, 0x3c, 0xd0, 0x86, 0xd0, 0xa3, 0x4f, 0x87, 0x1f, 0xdb, 0xe6, 0x38, 0xf4, 0xfc, 0xac, 0xa2, 0x3d, 0x50, 0xd4, 0x5e, 0x23, 0xe3, 0xe1, 0xd0, 0xab, 0x49, 0x90, 0x7f, 0x88, 0xb2, 0xba, 0x0d, 0x1c, 0xe6, 0x74, 0xc3, 0xaf, 0x44, 0x11, 0xd4, 0xc2, 0xac, 0xc7, 0x5a, 0x73, 0xf1, 0x15, 0x90, 0x6d, 0xfe, 0xa5, 0x0e, 0x3e, 0xdb, 0xb1, 0xe7, 0x65, 0x4a, 0x9e, 0x77, 0x88, 0xcc, 0xb0, 0x3c, 
    0x5d, 0x8b, 0xbe, 0xb9, 0xbe, 0x79, 0x0d, 0x18, 0x09, 0x4e, 0x4c, 0xfb, 0x94, 0xd1, 0x11, 0x16, 0x04, 0x73, 0x45, 0x2c, 0xeb, 0xa1, 0xa5, 0xdc, 0x6d, 0x3e, 0x0e, 0x1f, 0x80, 0x9f, 0xc8, 0x59, 0xe3, 0x63, 0x03, 0x46, 0xb8, 0x9a, 0x94, 0xee, 0xc8, 0x62, 0x23, 0x8d, 0xb3, 0x5e, 0xdb, 0x4b, 0xb2, 0x48, 0xca, 0xe6, 0x9c, 0x1e, 0x45, 0x8b, 0x94, 0xf3, 0xf8, 0x71, 0xc1, 0x1f, 0xcd, 0x7f, 
    0xa1, 0xa0, 0x42, 0xb8, 0x6a, 0xcb, 0x76, 0x32, 0x4e, 0x3a, 0x06, 0x83, 0x8d, 0xe9, 0x5b, 0xe3, 0x6d, 0xf0, 0x9d, 0x10, 0x4a, 0xf1, 0x52, 0x09, 0xc4, 0x78, 0x96, 0x19, 0x8d, 0x52, 0xae, 0x42, 0xa6, 0x7e, 0xb2, 0x2d, 0x5b, 0x84, 0x3b, 0xc7, 0x4d, 0x16, 0x15, 0x92, 0xfd, 0xb2, 0x6a, 0x5a, 0x40, 0xe6, 0x2c, 0x88, 0xcb, 0xb5, 0x21, 0xa1, 0x86, 0x4b, 0xef, 0x52, 0xd8, 0x25, 0x67, 0x0b, 
    0x62, 0xf0, 0x2c, 0xe4, 0xab, 0xb7, 0x9b, 0x0b, 0x7a, 0x6e, 0x97, 0x60, 0xbd, 0x78, 0xde, 0x5b, 0x23, 0x80, 0x4b, 0x8f, 0xbc, 0x97, 0x08, 0x9e, 0x19, 0xf5, 0x03, 0x25, 0x37, 0x3b, 0x4f, 0xd0, 0x6b, 0x74, 0x62, 0x8a, 0x19, 0x1e, 0x5c, 0x00, 0xf0, 0xfa, 0x55, 0x99, 0xd5, 0x21, 0xd6, 0x1d, 0x95, 0xa7, 0xea, 0x7b, 0x6f, 0x29, 0xf5, 0x57, 0xc1, 0xd3, 0x1c, 0x14, 0x98, 0x38, 0xe4, 0x1f, 
    0xad, 0x41, 0xf0, 0xdf, 0x5a, 0x50, 0x31, 0xfe, 0x8e, 0xca, 0xae, 0x5c, 0x62, 0x64, 0xd9, 0xe1, 0x77, 0x9b, 0xb7, 0xf3, 0x66, 0x00, 0x53, 0x37, 0x3a, 0x11, 0x55, 0xdb, 0xf8, 0x2b, 0x2c, 0xaa, 0xb0, 0xab, 0xd4, 0x07, 0x44, 0x65, 0x7a, 0x95, 0x41, 0xf7, 0x31, 0xb0, 0x9e, 0xd7, 0x06, 0x0a, 0x08, 0x78, 0x7c, 0x69, 0xc0, 0xf3, 0xa9, 0x2b, 0x32, 0x26, 0x68, 0xde, 0x5a, 0x4c, 0x45, 0x12, 
    0x08, 0xed, 0xb6, 0x5b, 0xc7, 0x21, 0x23, 0x8e, 0xf6, 0xcc, 0x5a, 0x0f, 0x50, 0x7e, 0x92, 0x17, 0xcc, 0x1a, 0x2c, 0xb9, 0xa4, 0x7a, 0xf8, 0x6d, 0x04, 0x17, 0xf6, 0xe2, 0xd6, 0x22, 0x4f, 0x05, 0x5c, 0xf5, 0xe7, 0xb6, 0x1f, 0x5f, 0xe3, 0x46, 0x24, 0x6a, 0xe0, 0xf1, 0xcb, 0x99, 0x01, 0x94, 0x0a, 0xb8, 0x0c, 0xf1, 0x5d, 0x77, 0xab, 0x19, 0xd7, 0x31, 0x7d, 0xc2, 0x9c, 0xd2, 0x22, 0xbd, 
    0x04, 0xde, 0x57, 0xb5, 0x4c, 0xe3, 0x34, 0x18, 0x01, 0x22, 0x62, 0xc6, 0x09, 0xbb, 0x98, 0x85, 0x51, 0x14, 0x37, 0xd8, 0xef, 0x70, 0xa9, 0x5b, 0xf8, 0x7c, 0xe6, 0xcf, 0xb3, 0x7b, 0x9e, 0xeb, 0xdd, 0xee, 0x9e, 0xcd, 0x8e, 0xad, 0x2b, 0x48, 0x81, 0x9b, 0x85, 0x39, 0x49, 0xbd, 0x67, 0x08, 0xe1, 0xba, 0x6c, 0x40, 0x0e, 0x89, 0x29, 0xd0, 0x4e, 0x59, 0x7c, 0x37, 0x65, 0xf9, 0xcf, 0xac, 
    0x90, 0x99, 0x31, 0x18, 0x06, 0xe4, 0xee, 0x82, 0xb3, 0x74, 0x31, 0x3e, 0xa6, 0x9b, 0x81, 0xf6, 0xbf, 0x1a, 0x81, 0x8b, 0xad, 0x5c, 0xda, 0xd0, 0xeb, 0x1d, 0x7e, 0x9a, 0x93, 0xff, 0x7d, 0x34, 0xc9, 0x08, 0x74, 0x69, 0xe3, 0x1a, 0xd8, 0x6f, 0xe4, 0x39, 0xc0, 0x28, 0x1a, 0x82, 0xf9, 0xe6, 0xf8, 0x60, 0x6a, 0x3a, 0xcf, 0xa7, 0xca, 0x0d, 0x5b, 0x8b, 0xe9, 0x08, 0xd5, 0xd4, 0x24, 0xeb, 
    0x40, 0x83, 0x78, 0xf2, 0x14, 0x63, 0xda, 0xfa, 0xa5, 0xa6, 0x3f, 0x34, 0x82, 0xda, 0xb3, 0x62, 0x24, 0xd9, 0xd5, 0x35, 0xc7, 0x41, 0x61, 0x37, 0xa2, 0xc6, 0x7f, 0x66, 0x9c, 0xc0, 0x31, 0x2a, 0xd3, 0xcf, 0x6e, 0x8d, 0x74, 0xa2, 0x01, 0xa5, 0xd2, 0xa1, 0x64, 0xc1, 0x43, 0x2a, 0x41, 0xc0, 0xd1, 0x88, 0xea, 0x6e, 0x28, 0x62, 0xdf, 0xdc, 0x35, 0x5e, 0x48, 0x04, 0x7e, 0x91, 0x9d, 0x16, 
    0xc3, 0x7c, 0xf3, 0x56, 0x2d, 0x86, 0xfb, 0xcc, 0x49, 0x7b, 0xf3, 0xfe, 0xb0, 0xa0, 0x29, 0xed, 0x34, 0x42, 0xc3, 0xc7, 0x6c, 0x0d, 0x6e, 0x32, 0x8b, 0x2c, 0x1f, 0x40, 0x59, 0xb7, 0x63, 0x13, 0x46, 0x2f, 0x4b, 0x0d, 0xda, 0x28, 0xec, 0xa9, 0xcb, 0x36, 0xfd, 0x08, 0x82, 0x60, 0xe9, 0xc9, 0x15, 0x30, 0xb8, 0xb5, 0x87, 0xf8, 0x83, 0x4b, 0xab, 0x10, 0xb6, 0x61, 0xdf, 0x29, 0xef, 0xc4, 
    0x6c, 0x24, 0x18, 0x54, 0x6e, 0x6c, 0x9c, 0xd6, 0x9f, 0x05, 0xea, 0x26, 0x3d, 0x0c, 0xf5, 0x2b, 0x24, 0xc6, 0x1d, 0x43, 0x47, 0xc3, 0x60, 0x00, 0x73, 0xc7, 0x6f, 0x47, 0xb5, 0x8e, 0xd1, 0x49, 0x1e, 0x8a, 0xec, 0x4f, 0x1b, 0xc0, 0xc0, 0xf3, 0x83, 0x89, 0x4d, 0xa3, 0x57, 0x14, 0x39, 0xb8, 0x9b, 0x94, 0x42, 0x54, 0x53, 0xd2, 0x1c, 0xa7, 0x8b, 0x70, 0x73, 0xc0, 0x33, 0x90, 0xb1, 0x94, 
    0xc3, 0x4b, 0xdd, 0x2d, 0x60, 0x0b, 0x6d, 0xac, 0xc2, 0x11, 0x1c, 0xe8, 0xf6, 0xa4, 0x69, 0xbd, 0x4f, 0x26, 0xaf, 0x91, 0x87, 0x56, 0xb0, 0x45, 0xfb, 0x83, 0xe6, 0x88, 0x4a, 0x0f, 0xb6, 0xfb, 0x73, 0x92, 0xba, 0x4a, 0x06, 0x35, 0xf2, 0xea, 0x7b, 0x81, 0x85, 0x14, 0x29, 0xbc, 0x9a, 0x1e, 0x55, 0x70, 0x8a, 0x3b, 0xaf, 0xa6, 0x10, 0xfd, 0x48, 0xc6, 0x39, 0xaf, 0xeb, 0xa8, 0xff, 0x41, 
    0x72, 0x8c, 0x94, 0x15, 0x6c, 0x34, 0x8d, 0xb2, 0xa7, 0xd4, 0x42, 0x73, 0x47, 0x83, 0xb1, 0x9d, 0x00, 0xcc, 0x27, 0xfa, 0xd9, 0xe5, 0x17, 0x88, 0x57, 0x95, 0xa9, 0xb6, 0xc2, 0xf9, 0x13, 0xd6, 0x55, 0xbf, 0x8b, 0x91, 0x6d, 0xe1, 0x68, 0x3c, 0x72, 0xae, 0x27, 0x54, 0xe1, 0x9d, 0x92, 0x5b, 0xd0, 0x21, 0x3e, 0x4f, 0xf3, 0x18, 0xeb, 0xa4, 0x95, 0xa6, 0xe0, 0x0c, 0x8f, 0x0a, 0x7d, 0x46, 
    0x45, 0xb9, 0x7f, 0xd7, 0xa7, 0xd6, 0x84, 0x47, 0x04, 0xc1, 0x56, 0xbb, 0xd3, 0xc5, 0x55, 0x4c, 0x73, 0x32, 0x90, 0xa3, 0x94, 0xaa, 0xe6, 0xf1, 0x0f, 0x7e, 0xbd, 0xfc, 0x6a, 0x3f, 0x54, 0x26, 0xe8, 0xb4, 0x9e, 0xaa, 0x39, 0x0a, 0x0f, 0x60, 0x4f, 0x2f, 0xa8, 0x6f, 0xdd, 0xd1, 0xbd, 0x97, 0x75, 0x1d, 0x28, 0xbc, 0xe5, 0x12, 0xe2, 0x33, 0xfc, 0xa1, 0xb4, 0x38, 0x02, 0x17, 0x76, 0x50, 
    0x85, 0xcf, 0x27, 0xac, 0x2e, 0x89, 0x9a, 0xe2, 0x40, 0x49, 0xc2, 0x7b, 0x35, 0x73, 0x4e, 0x09, 0xf2, 0xfc, 0x94, 0x02, 0x03, 0x1c, 0xe8, 0x61, 0x26, 0x3d, 0xb0, 0xc7, 0x1d, 0x9c, 0x10, 0x5a, 0x33, 0x43, 0x90, 0x1a, 0xd9, 0x09, 0xac, 0x37, 0x52, 0x63, 0x1b, 0xf6, 0xd0, 0xfe, 0xda, 0x53, 0x78, 0x4c, 0xf4, 0x91, 0xc7, 0x10, 0xa1, 0x07, 0xe1, 0x20, 0x63, 0xc8, 0x75, 0xe1, 0x55, 0xb1, 
    0x2a, 0x3a, 0x66, 0xea, 0x09, 0xcf, 0x3d, 0xe6, 0x1c, 0x67, 0x58, 0x5b, 0x12, 0x20, 0x0d, 0x60, 0xdf, 0x90, 0xcd, 0x65, 0x4e, 0x79, 0x47, 0x07, 0xa6, 0xe8, 0xc2, 0xdc, 0x3c, 0x74, 0x83, 0x04, 0x26, 0xf6, 0x65, 0xa2, 0x0c, 0xfc, 0xc0, 0xcb, 0x3f, 0x02, 0x7d, 0xb1, 0x21, 0x05, 0xc1, 0x77, 0x6b, 0xd9, 0xa0, 0x37, 0x3c, 0x2d, 0xc6, 0x73, 0xdd, 0x71, 0x5c, 0xc7, 0x06, 0xc4, 0x53, 0xfc, 
    0xf0, 0x33, 0x36, 0xab, 0xe2, 0x5f, 0x24, 0x11, 0xeb, 0x5d, 0x8e, 0x8a, 0xb4, 0xb3, 0x72, 0x6b, 0xfa, 0xe2, 0xef, 0x16, 0x63, 0xd8, 0x32, 0x14, 0x34, 0x01, 0xa4, 0x24, 0xd2, 0x29, 0x68, 0xff, 0x5f, 0x9f, 0x89, 0x99, 0xc6, 0x5f, 0x78, 0x29, 0xdb, 0xf9, 0x8f, 0xf5, 0x6d, 0x06, 0x12, 0xc7, 0x42, 0xd5, 0x81, 0x2d, 0x7e, 0x52, 0xf0, 0x47, 0x65, 0x61, 0xfd, 0x9b, 0xb4, 0x5f, 0xe8, 0xfb, 
    0xdf, 0x91, 0x9c, 0x52, 0x6f, 0x5a, 0xea, 0x0d, 0xd3, 0x79, 0x99, 0x14, 0xc5, 0x87, 0x9f, 0xe5, 0x65, 0xbb, 0x6b, 0x14, 0x90, 0xdb, 0xd5, 0xcd, 0x75, 0x76, 0x28, 0xeb, 0xab, 0x52, 0x5d, 0xde, 0xfa, 0xa0, 0xce, 0xc4, 0x6d, 0xeb, 0xe0, 0xc4, 0xb0, 0x39, 0xb0, 0x66, 0x75, 0x4a, 0x1f, 0xb3, 0x00, 0x31, 0x9a, 0xe6, 0x7a, 0x6a, 0xb7, 0x96, 0x2a, 0x4d, 0x11, 0x74, 0xd4, 0x84, 0x1c, 0x29, 
    0x50, 0xed, 0x05, 0x9c, 0xbe, 0xdf, 0xc8, 0x93, 0xc1, 0xa9, 0x76, 0x81, 0xf3, 0xd0, 0xed, 0x32, 0xa7, 0x39, 0x92, 0x8b, 0xf7, 0x4e, 0xb9, 0x61, 0x06, 0x74, 0x99, 0x38, 0xa3, 0x12, 0x24, 0x80, 0x3e, 0x4b, 0xbc, 0xd6, 0x93, 0x1d, 0x7e, 0x58, 0xa0, 0xff, 0xb2, 0x11, 0x51, 0xd8, 0x7d, 0xd0, 0xf8, 0x62, 0xf1, 0x97, 0x00, 0x85, 0x1e, 0x9b, 0x48, 0x2e, 0x18, 0x67, 0x56, 0x80, 0xfc, 0xb8, 
    0x94, 0x88, 0x95, 0x3b, 0x1d, 0xcb, 0x13, 0xcc, 0x4a, 0xff, 0x69, 0x0f, 0x7a, 0x38, 0xab, 0x09, 0xdb, 0x20, 0x9d, 0x4e, 0xd2, 0x57, 0x96, 0x82, 0x85, 0xae, 0x4d, 0xba, 0x56, 0xd8, 0xdf, 0x3b, 0x09, 0x03, 0x12, 0xcd, 0xea, 0xcb, 0x46, 0x7c, 0x2e, 0xaf, 0xd8, 0x42, 0x22, 0xfe, 0xad, 0x04, 0xb0, 0x8b, 0xec, 0x89, 0x67, 0xb4, 0x11, 0x07, 0xdb, 0x7f, 0xc9, 0x1d, 0x46, 0x22, 0x00, 0xc6, 
    0x38, 0xbb, 0x71, 0x03, 0xf3, 0xf4, 0xb4, 0x55, 0xb1, 0x1e, 0x34, 0x2d, 0x5c, 0x42, 0xdf, 0x8a, 0xcd, 0x57, 0x3c, 0xb8, 0x1e, 0xa5, 0x9e, 0xee, 0x4d, 0x2d, 0x6b, 0x30, 0x68, 0xd7, 0x83, 0x0d, 0x85, 0xf8, 0x80, 0x5d, 0x52, 0x28, 0x95, 0x25, 0x3e, 0x06, 0x96, 0x8c, 0xef, 0x61, 0xa0, 0x14, 0xce, 0xe5, 0xd7, 0x2f, 0x59, 0x3e, 0x83, 0xd1, 0x85, 0xf5, 0xbf, 0x97, 0x5a, 0xf2, 0xd5, 0x8d, 
    0xb3, 0x61, 0xf9, 0x1e, 0xa3, 0x9d, 0x7e, 0x13, 0x51, 0x00, 0x2a, 0x25, 0xde, 0xc1, 0xb6, 0xb4, 0x39, 0xa3, 0x1d, 0x50, 0x79, 0xff, 0x1c, 0x2c, 0x6b, 0xd4, 0xe4, 0xb0, 0x29, 0xca, 0xeb, 0xf0, 0xf2, 0xa0, 0x52, 0x63, 0x75, 0x33, 0x18, 0xe7, 0x8f, 0x44, 0x31, 0xf4, 0x8f, 0x47, 0x48, 0xb4, 0x8a, 0xcd, 0x0f, 0x5c, 0xac, 0x6e, 0xad, 0xfc, 0xbf, 0xf1, 0x4f, 0x01, 0xd4, 0x2e, 0xa4, 0x78, 
    0xcf, 0x3f, 0x12, 0x71, 0x9a, 0xa6, 0xe2, 0xf3, 0x2b, 0x8d, 0x7b, 0xf9, 0x30, 0x27, 0xc3, 0xe6, 0x5d, 0x9c, 0x1a, 0x86, 0x39, 0x41, 0xf0, 0xec, 0xcd, 0xbf, 0xb8, 0x77, 0x73, 0x73, 0x16, 0xe2, 0xf3, 0x93, 0xa5, 0x87, 0x3d, 0xb4, 0x36, 0x50, 0x7a, 0xe5, 0x1a, 0x95, 0x5c, 0x68, 0x59, 0xa4, 0x5a, 0x29, 0x3c, 0xc9, 0xec, 0x74, 0x97, 0xa2, 0x2c, 0xd6, 0x97, 0xa6, 0x17, 0x76, 0x45, 0x36, 
    0x6a, 0x83, 0x1f, 0xf5, 0x21, 0x91, 0x91, 0xdb, 0x04, 0xd1, 0xb4, 0x6b, 0x2a, 0xfc, 0x83, 0xfe, 0x27, 0x38, 0xb8, 0x5a, 0xa8, 0x01, 0x4c, 0x79, 0xd1, 0xf0, 0x3e, 0xbf, 0xc5, 0xa3, 0x18, 0x99, 0x0a, 0xad, 0x48, 0x24, 0x09, 0x72, 0x46, 0xe2, 0xbd, 0xbd, 0x7e, 0xcb, 0x89, 0xf0, 0x12, 0x30, 0xa9, 0xf9, 0x4e, 0x16, 0xab, 0xc3, 0x6a, 0x27, 0xf8, 0x3d, 0x44, 0x0d, 0x0a, 0x6b, 0xad, 0xac, 
    0x33, 0x31, 0x37, 0xd8, 0x45, 0x6e, 0x5b, 0xd9, 0x42, 0x49, 0x69, 0xe6, 0x6d, 0xef, 0x65, 0x84, 0x10, 0x17, 0x3f, 0x9a, 0xd4, 0xbc, 0xf8, 0x48, 0xd4, 0x5e, 0xac, 0x8e, 0x0d, 0x53, 0x5d, 0xae, 0x85, 0xce, 0x6f, 0x31, 0x1b, 0xdc, 0xba, 0xc1, 0xca, 0xe5, 0xa5, 0x5a, 0x2a, 0x0d, 0x28, 0x5f, 0x18, 0xdf, 0x39, 0xde, 0x35, 0xaa, 0x81, 0x8b, 0xea, 0x40, 0xbe, 0x27, 0x9f, 0xea, 0xd1, 0x22, 
    0x63, 0x72, 0xe4, 0x03, 0x5b, 0x6c, 0xba, 0xbc, 0x86, 0x53, 0x04, 0x5c, 0x48, 0xac, 0x44, 0xc7, 0x9f, 0x7b, 0xb1, 0xce, 0x05, 0x65, 0x0d, 0x58, 0xf2, 0x23, 0x92, 0xa5, 0x47, 0x32, 0x4a, 0x90, 0x1f, 0xf7, 0x1b, 0x68, 0x71, 0x68, 0xc4, 0xc0, 0xeb, 0x11, 0xa3, 0x02, 0x91, 0xe5, 0xcd, 0xd3, 0x26, 0xb8, 0x4a, 0x38, 0x3c, 0x89, 0x4d, 0x50, 0xf6, 0x6c, 0xd9, 0xca, 0xee, 0xbb, 0x5d, 0xad, 
    0x88, 0x3a, 0x50, 0x41, 0xa1, 0xe3, 0x12, 0x77, 0xcc, 0xa4, 0x05, 0x48, 0x47, 0xa8, 0xc0, 0x7e, 0x80, 0xf6, 0x14, 0x1c, 0x08, 0x9a, 0xe0, 0xc4, 0x63, 0x89, 0x14, 0xe0, 0x39, 0xe8, 0x91, 0x18, 0xb9, 0x3d, 0xfd, 0x7c, 0x70, 0xa4, 0xda, 0xcd, 0x57, 0xa2, 0x33, 0x02, 0x69, 0x0e, 0x81, 0xe7, 0x47, 0x3a, 0xa9, 0xdc, 0x72, 0x5d, 0x97, 0x1a, 0x23, 0xca, 0x8c, 0xb9, 0xe4, 0xa4, 0x4f, 0x7b, 
    0x0c, 0x7f, 0xbe, 0xf8, 0xfb, 0x0f, 0x91, 0x89, 0x89, 0xbd, 0x54, 0xc9, 0x2b, 0xb0, 0x97, 0xe9, 0x7a, 0x01, 0xa2, 0xe2, 0xbe, 0x59, 0x2f, 0x8c, 0x13, 0x86, 0x20, 0x2d, 0xcd, 0x6e, 0x80, 0x95, 0x05, 0x03, 0x45, 0xa7, 0x3e, 0x07, 0x9a, 0x68, 0x82, 0x71, 0xf4, 0xa7, 0xc8, 0x54, 0x18, 0xdc, 0xba, 0x78, 0x95, 0x73, 0x6a, 0x1c, 0xc9, 0x0f, 0x56, 0x09, 0xaf, 0x8e, 0x65, 0x1f, 0xb5, 0x51, 
    0xa2, 0x14, 0xbd, 0x40, 0x2e, 0x3c, 0x98, 0xd7, 0xdc, 0xd9, 0x46, 0x16, 0xa8, 0xee, 0xb6, 0x7f, 0x1a, 0xe0, 0x25, 0x40, 0x6b, 0x8e, 0x66, 0xcb, 0x0b, 0x80, 0x12, 0x2d, 0xd7, 0xaf, 0x5d, 0xf4, 0xe1, 0xca, 0x34, 0xa0, 0xaf, 0xc3, 0x53, 0x31, 0x4b, 0xb7, 0x86, 0x22, 0x7a, 0x0a, 0xde, 0xf0, 0xbb, 0x72, 0x16, 0xdd, 0x19, 0xc1, 0xa8, 0xf7, 0x0c, 0x06, 0x0c, 0x6b, 0xbd, 0x2c, 0xd7, 0x85, 
    0xe7, 0x11, 0x63, 0xc3, 0xe8, 0x3b, 0x65, 0x62, 0xa4, 0xdd, 0x49, 0xea, 0x70, 0xd3, 0x24, 0xc8, 0x6d, 0x60, 0x56, 0x96, 0x97, 0xea, 0xbe, 0xd5, 0x44, 0x04, 0x4f, 0x75, 0x62, 0x8c, 0x27, 0xb4, 0x65, 0xf4, 0xe3, 0x37, 0xba, 0x22, 0xf9, 0xa2, 0xd7, 0x55, 0x56, 0xed, 0x1b, 0x8d, 0x63, 0xc9, 0x75, 0x4b, 0x7d, 0xb9, 0xbb, 0x01, 0x51, 0xd5, 0x8e, 0x19, 0xee, 0x67, 0xa2, 0x53, 0xe3, 0x62, 
    0xc6, 0xc5, 0x21, 0x75, 0x04, 0xd7, 0x3b, 0x21, 0xf1, 0x16, 0x9f, 0x2f, 0x9a, 0x3f, 0x74, 0xc9, 0x07, 0x54, 0x08, 0xc6, 0xdd, 0x76, 0x6c, 0x37, 0xe1, 0xb6, 0xf0, 0x47, 0x3a, 0xb7, 0xf6, 0xe9, 0xd9, 0xb5, 0x22, 0xeb, 0xdc, 0xbf, 0x4c, 0x29, 0x64, 0x13, 0x7e, 0xe7, 0x82, 0x91, 0xb7, 0x06, 0xe4, 0x96, 0xf4, 0x39, 0xee, 0x79, 0x29, 0x45, 0xd5, 0xb4, 0xd3, 0x45, 0xe9, 0x58, 0xf6, 0x8c, 
    0x7a, 0x7e, 0xf4, 0xf5, 0xe3, 0x02, 0x28, 0x52, 0xce, 0x67, 0x90, 0x97, 0x16, 0xc6, 0x30, 0xfa, 0x70, 0xf0, 0x3a, 0xe5, 0x25, 0xd3, 0xb7, 0xa5, 0xe3, 0x2c, 0xf9, 0xb8, 0xa1, 0x48, 0x85, 0x06, 0x7c, 0x20, 0x58, 0x02, 0x10, 0x84, 0xfe, 0xed, 0x9b, 0x41, 0x47, 0xfb, 0x23, 0x9a, 0x61, 0x65, 0x6f, 0xa8, 0x9a, 0x7d, 0x90, 0x33, 0xfa, 0x81, 0xae, 0x5d, 0x5c, 0x4f, 0x2e, 0xaa, 0x96, 0xdb, 
    0x17, 0xbd, 0x0a, 0x55, 0x2e, 0x7f, 0x9b, 0xc9, 0x19, 0x34, 0x90, 0x74, 0xef, 0xeb, 0x8d, 0x23, 0x10, 0xb3, 0xab, 0x34, 0x44, 0x32, 0xf8, 0x72, 0x88, 0x77, 0xff, 0xb3, 0xd2, 0x2a, 0x0d, 0x51, 0xae, 0x5f, 0x8e, 0xcb, 0x48, 0x6c, 0x0d, 0xd9, 0x33, 0x75, 0x1f, 0x96, 0x2b, 0xfa, 0xb4, 0x40, 0xc4, 0x88, 0x9b, 0x26, 0xe1, 0xef, 0xed, 0x05, 0xce, 0x88, 0x9a, 0x2c, 0x2e, 0x64, 0x3c, 0xfc, 
    0x24, 0x98, 0x55, 0xe5, 0x71, 0xb3, 0xa9, 0xb6, 0x4a, 0xd1, 0xde, 0x1b, 0x61, 0xf3, 0xab, 0x50, 0x61, 0xff, 0xf1, 0x93, 0x80, 0x37, 0x49, 0x5f, 0x97, 0x17, 0x0e, 0xc7, 0x57, 0x95, 0xa7, 0xa6, 0x3b, 0x6f, 0x76, 0x25, 0x50, 0xff, 0x5c, 0x9b, 0x2e, 0xf9, 0xd2, 0x3e, 0x3f, 0x1e, 0x0a, 0xa3, 0x61, 0x52, 0x4f, 0xff, 0xc3, 0xc2, 0x4c, 0x26, 0x31, 0x98, 0x85, 0x63, 0x17, 0xe3, 0x08, 0x33, 
    0x0d, 0x9c, 0xa9, 0xc9, 0xaa, 0x7e, 0x88, 0x68, 0x4b, 0xbf, 0x0f, 0xae, 0x06, 0x83, 0x62, 0x73, 0x35, 0x8e, 0x9c, 0x98, 0x50, 0x55, 0xfd, 0x86, 0x6d, 0x4c, 0x3c, 0x42, 0xc9, 0xc1, 0x9d, 0x71, 0x5f, 0xdd, 0xe4, 0xd5, 0x65, 0xae, 0x8c, 0xd1, 0x3d, 0x2e, 0x56, 0x7d, 0xc8, 0xf5, 0x11, 0xda, 0x17, 0x2f, 0x58, 0x42, 0xbf, 0x80, 0x8f, 0xd5, 0xe3, 0x20, 0x47, 0x26, 0x9f, 0xcd, 0xfe, 0xc9, 
    0x7a, 0x58, 0x93, 0xfc, 0xac, 0xfd, 0x05, 0x1b, 0xb7, 0x85, 0x3d, 0x56, 0xb3, 0xb9, 0x0b, 0x0c, 0x56, 0xde, 0x93, 0xa1, 0x32, 0xf9, 0x46, 0x1f, 0x1c, 0xaa, 0x5b, 0xc9, 0x2b, 0x9c, 0xe8, 0x82, 0x17, 0x9b, 0x09, 0x49, 0x80, 0xc5, 0x91, 0x04, 0x45, 0xf2, 0x67, 0x17, 0xb6, 0x99, 0xce, 0xe1, 0x39, 0x29, 0x12, 0x60, 0x5a, 0x4a, 0xad, 0x35, 0xb0, 0x70, 0x7d, 0x77, 0x43, 0x40, 0xf2, 0xc5, 
    0xb6, 0x18, 0x93, 0x87, 0x5b, 0x7f, 0x04, 0xca, 0x9e, 0xfd, 0x32, 0x63, 0x7f, 0x81, 0xcf, 0x23, 0x27, 0x3f, 0xac, 0xaa, 0x28, 0x87, 0xda, 0xa4, 0x66, 0xf9, 0xc8, 0x17, 0x03, 0x79, 0x23, 0xd1, 0x68, 0x8b, 0x8e, 0xd1, 0x0a, 0x4f, 0x8e, 0xf1, 0x9e, 0xc0, 0x44, 0xcc, 0xb2, 0xac, 0x88, 0x6a, 0x01, 0xf8, 0x24, 0xa0, 0x60, 0x8b, 0x85, 0x9c, 0xae, 0xda, 0x37, 0xe7, 0x6e, 0x6e, 0xc8, 0xc4, 
    0xa7, 0x39, 0x5c, 0x4e, 0x20, 0x26, 0x32, 0xfa, 0x70, 0xef, 0xb4, 0xfe, 0x5c, 0x28, 0x1c, 0xb6, 0xdd, 0xc2, 0xea, 0x57, 0x07, 0x1c, 0x0a, 0xd3, 0xc1, 0x8b, 0x72, 0x00, 0x61, 0x28, 0xfc, 0xbb, 0x99, 0x36, 0x14, 0x16, 0x76, 0x28, 0xae, 0x92, 0xd5, 0x6d, 0x27, 0xc7, 0xa3, 0xc6, 0x53, 0x08, 0xaf, 0xee, 0xf7, 0x33, 0x39, 0xb8, 0xcf, 0x6b, 0x73, 0xe4, 0x22, 0x03, 0x76, 0x94, 0x8b, 0x45, 
    0x2c, 0x7c, 0xaa, 0x3e, 0x67, 0x26, 0xbf, 0xf3, 0xc5, 0x4d, 0x85, 0x37, 0xd2, 0x24, 0xf3, 0x5b, 0xde, 0xa1, 0x77, 0x69, 0xce, 0xd7, 0xc6, 0x87, 0x69, 0x1f, 0xe1, 0x53, 0xed, 0xbe, 0x38, 0x3e, 0xea, 0xbe, 0x9f, 0x81, 0x2c, 0xf4, 0xd2, 0xeb, 0xaf, 0xa5, 0xb1, 0x7a, 0x5e, 0xcd, 0xf9, 0x88, 0x81, 0x0f, 0x6b, 0x14, 0x9f, 0xd4, 0x02, 0xc4, 0x56, 0xd2, 0xfb, 0x0b, 0xe0, 0x17, 0xa2, 0x18, 
    0xdb, 0xd7, 0x0b, 0x4d, 0x49, 0x3a, 0x30, 0x8d, 0xe9, 0x6c, 0x11, 0x07, 0x44, 0x51, 0x8d, 0xdf, 0xd0, 0xb5, 0x10, 0x1c, 0xe3, 0xd7, 0x73, 0x15, 0xbc, 0x84, 0xf8, 0xfa, 0xba, 0x46, 0x3b, 0x60, 0xaf, 0xe4, 0x1c, 0x08, 0x5f, 0xe0, 0x7d, 0xb9, 0x10, 0x1b, 0x34, 0xb0, 0x31, 0x75, 0x72, 0xeb, 0xc1, 0x1d, 0xd9, 0xd0, 0xdb, 0x0e, 0x57, 0x05, 0x71, 0x0d, 0xbb, 0x19, 0xf6, 0xfe, 0x86, 0x44, 
    0x18, 0x4e, 0xd4, 0xdf, 0x76, 0xa1, 0x94, 0xcd, 0x0f, 0x3e, 0x43, 0xd9, 0xd5, 0x60, 0x3f, 0x84, 0xc0, 0x7c, 0x48, 0x17, 0xea, 0x2a, 0xab, 0xb3, 0x94, 0xd4, 0x19, 0x80, 0x1f, 0xdf, 0xaa, 0x40, 0xf0, 0x4d, 0xf8, 0x38, 0xb6, 0x91, 0x50, 0x08, 0x69, 0xec, 0x7e, 0x09, 0x84, 0xe2, 0xa0, 0x4a, 0x62, 0x8a, 0x1d, 0x01, 0xdf, 0x3b, 0xb4, 0x03, 0x9f, 0x53, 0xf5, 0xd3, 0x10, 0xb5, 0x42, 0xec
};

gint *
chafa_gen_noise_matrix (gdouble magnitude)
{
    gint *matrix;
    gint i;

    matrix = g_malloc (CHAFA_NOISE_TEXTURE_ARRAY_LEN * sizeof (gint));

    for (i = 0; i < CHAFA_NOISE_TEXTURE_ARRAY_LEN; i++)
    {
        matrix [i] = ((gdouble) blue_noise_src [i] - 128.0) * magnitude + 0.5;
    }

    return matrix;
}
