/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.interval.ia_math;

import net.sourceforge.interval.ia_math.IAException;
import net.sourceforge.interval.ia_math.IAMath;
import net.sourceforge.interval.ia_math.RealInterval;

public class IANarrow {
    public static boolean narrow_add(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            realInterval.intersect(IAMath.add(realInterval2, realInterval3));
            realInterval2.intersect(IAMath.sub(realInterval, realInterval3));
            realInterval3.intersect(IAMath.sub(realInterval, realInterval2));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_sub(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return IANarrow.narrow_add(realInterval2, realInterval, realInterval3);
    }

    public static boolean narrow_mul(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            realInterval.intersect(IAMath.mul(realInterval2, realInterval3));
            IAMath.intersect_odiv(realInterval3, realInterval, realInterval2);
            IAMath.intersect_odiv(realInterval2, realInterval, realInterval3);
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_div(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return IANarrow.narrow_mul(realInterval2, realInterval, realInterval3);
    }

    public static boolean narrow_uminus(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval.intersect(IAMath.uminus(realInterval2));
            realInterval2.intersect(IAMath.uminus(realInterval));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_exp(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval2.intersect(IAMath.exp(realInterval));
            realInterval.intersect(IAMath.log(realInterval2));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_log(RealInterval realInterval, RealInterval realInterval2) {
        return IANarrow.narrow_exp(realInterval2, realInterval);
    }

    public static boolean narrow_sin(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval2.intersect(IAMath.sin(realInterval));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_cos(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval2.intersect(IAMath.cos(realInterval));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_tan(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval2.intersect(IAMath.tan(realInterval));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_asin(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval.intersect(new RealInterval(-1.0, 1.0));
            realInterval2.intersect(IAMath.asin(realInterval));
            realInterval.intersect(IAMath.sin(realInterval2));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_acos(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval.intersect(new RealInterval(-1.0, 1.0));
            realInterval2.intersect(IAMath.acos(realInterval));
            realInterval.intersect(IAMath.cos(realInterval2));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_atan(RealInterval realInterval, RealInterval realInterval2) {
        try {
            realInterval2.intersect(IAMath.atan(realInterval));
            realInterval.intersect(IAMath.tan(realInterval2));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_sin2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("narrow_sin2pi not yet implemented");
        return true;
    }

    public static boolean narrow_cos2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("narrow_cos2pi not yet implemented");
        return true;
    }

    public static boolean narrow_tan2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("narrow_tan2pi not yet implemented");
        return true;
    }

    public static boolean narrow_asin2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("asin2pi not yet implemented");
        return true;
    }

    public static boolean narrow_acos2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("acos2pi not yet implemented");
        return true;
    }

    public static boolean narrow_atan2pi(RealInterval realInterval, RealInterval realInterval2) {
        System.out.println("atan2pi not yet implemented");
        return true;
    }

    public static boolean narrow_carot(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            realInterval.intersect(IAMath.integerPower(realInterval2, realInterval3));
            IAMath.intersectIntegerRoot(realInterval, realInterval3, realInterval2);
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_power(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            realInterval.intersect(IAMath.power(realInterval2, realInterval3));
            realInterval2.intersect(IAMath.power(realInterval, IAMath.odiv(new RealInterval(1.0), realInterval3)));
            realInterval3.intersect(IAMath.div(IAMath.log(realInterval), IAMath.log(realInterval2)));
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_semi(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return true;
    }

    public static boolean narrow_colon_equals(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        realInterval2.lo = realInterval3.lo;
        realInterval2.hi = realInterval3.hi;
        return realInterval2.nonEmpty();
    }

    public static boolean narrow_equals(RealInterval realInterval, RealInterval realInterval2) {
        if (realInterval.lo == realInterval.hi && realInterval.equals(realInterval2)) {
            return true;
        }
        try {
            realInterval.intersect(realInterval2);
            realInterval2.intersect(realInterval);
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_eq(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        if (realInterval2.lo == realInterval2.hi && realInterval2.equals(realInterval3)) {
            realInterval.lo = 1.0;
            realInterval.hi = 1.0;
            return true;
        }
        try {
            realInterval2.intersect(realInterval3);
            realInterval3.intersect(realInterval2);
            return true;
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_lt(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            if (realInterval3.lo < realInterval2.lo) {
                realInterval3.lo = realInterval2.lo;
            }
            if (realInterval2.hi > realInterval3.hi) {
                realInterval2.hi = realInterval3.hi;
            }
            if (realInterval3.hi <= realInterval2.lo) {
                return false;
            }
            if (realInterval2.hi < realInterval3.lo) {
                realInterval.lo = 1.0;
                realInterval.hi = 1.0;
            } else {
                realInterval.intersect(new RealInterval(0.0, 1.0));
            }
            return realInterval2.nonEmpty() && realInterval3.nonEmpty();
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_le(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        try {
            if (realInterval3.lo <= realInterval2.lo) {
                realInterval3.lo = realInterval2.lo;
            }
            if (realInterval2.hi >= realInterval3.hi) {
                realInterval2.hi = realInterval3.hi;
            }
            if (realInterval3.hi < realInterval2.lo) {
                return false;
            }
            if (realInterval2.hi <= realInterval3.lo) {
                realInterval.lo = 1.0;
                realInterval.hi = 1.0;
            } else {
                realInterval.intersect(new RealInterval(0.0, 1.0));
            }
            return realInterval2.nonEmpty() && realInterval3.nonEmpty();
        }
        catch (IAException iAException) {
            return false;
        }
    }

    public static boolean narrow_gt(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return IANarrow.narrow_lt(realInterval, realInterval3, realInterval2);
    }

    public static boolean narrow_ge(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return IANarrow.narrow_le(realInterval, realInterval3, realInterval2);
    }

    public static boolean narrow_ne(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) {
        return realInterval2.lo < realInterval2.hi || realInterval3.lo < realInterval3.hi || realInterval2.lo != realInterval3.lo;
    }
}

