/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class MultiPartRequest {
    HttpServletRequest _request;
    LineInput _in;
    String _boundary;
    byte[] _byteBoundary;
    Hashtable _partMap = new Hashtable(10);
    int _char = -2;
    boolean _lastPart = false;

    public MultiPartRequest(HttpServletRequest request) throws IOException {
        this._request = request;
        String content_type = request.getHeader("Content-Type");
        if (!content_type.startsWith("multipart/form-data")) {
            throw new IOException("Not multipart/form-data request");
        }
        Code.debug((Object)"Multipart content type = ", (Object)content_type);
        this._in = new LineInput((InputStream)request.getInputStream());
        this._boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        Code.debug((Object)"Boundary=", (Object)this._boundary);
        this._byteBoundary = (this._boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        this.loadAllParts();
    }

    public String[] getPartNames() {
        return this._partMap.keySet().toArray(new String[0]);
    }

    public boolean contains(String name) {
        Part part = (Part)this._partMap.get(name);
        return part != null;
    }

    public String getString(String name) {
        Part part = (Part)this._partMap.get(name);
        if (part == null) {
            return null;
        }
        return new String(part._data);
    }

    public InputStream getInputStream(String name) {
        Part part = (Part)this._partMap.get(name);
        if (part == null) {
            return null;
        }
        return new ByteArrayInputStream(part._data);
    }

    public Hashtable getParams(String name) {
        Part part = (Part)this._partMap.get(name);
        if (part == null) {
            return null;
        }
        return part._headers;
    }

    public String getFilename(String name) {
        Part part = (Part)this._partMap.get(name);
        if (part == null) {
            return null;
        }
        return part._filename;
    }

    /*
     * Unable to fully structure code
     */
    private void loadAllParts() throws IOException {
        line = this._in.readLine();
        if (line.equals(this._boundary)) ** GOTO lbl48
        Code.warning(line);
        throw new IOException("Missing initial multi part boundary");
lbl-1000:
        // 1 sources

        {
            part = new Part();
            content_disposition = null;
            while ((line = this._in.readLine()) != null) {
                if (line.length() == 0) break;
                Code.debug((Object)"LINE=", (Object)line);
                c = line.indexOf(58, 0);
                if (c <= 0) continue;
                key = line.substring(0, c).trim().toLowerCase();
                value = line.substring(c + 1, line.length()).trim();
                ev = (String)part._headers.get(key);
                part._headers.put(key, ev != null ? ev + ';' + value : value);
                Code.debug(key, ": ", value);
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            tok = new StringTokenizer(content_disposition, ";");
            while (tok.hasMoreTokens()) {
                t = tok.nextToken().trim();
                tl = t.toLowerCase();
                if (t.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    part._name = this.value(t);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                part._filename = this.value(t);
            }
            if (!form_data) {
                Code.warning("Non form-data part in multipart/form-data");
                continue;
            }
            if (part._name == null || part._name.length() == 0) {
                Code.warning("Part with no name in multipart/form-data");
                continue;
            }
            Code.debug((Object)"name=", (Object)part._name);
            Code.debug((Object)"filename=", (Object)part._filename);
            this._partMap.put(part._name, part);
            part._data = this.readBytes();
lbl48:
            // 4 sources

            ** while (!this._lastPart)
        }
lbl49:
        // 1 sources

    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean cr = false;
        boolean lf = false;
        while (true) {
            int c;
            int b = 0;
            while ((c = this._char != -2 ? this._char : this._in.read()) != -1) {
                void var2_4;
                this._char = -2;
                if (var2_4 == 13 || var2_4 == 10) {
                    if (var2_4 != 13) break;
                    this._char = this._in.read();
                    break;
                }
                if (b >= 0 && b < this._byteBoundary.length && var2_4 == this._byteBoundary[b]) {
                    ++b;
                    continue;
                }
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                if (b > 0) {
                    baos.write(this._byteBoundary, 0, b);
                }
                b = -1;
                baos.write((int)var2_4);
            }
            if (b > 0 && b < this._byteBoundary.length - 2 || b == this._byteBoundary.length - 1) {
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                baos.write(this._byteBoundary, 0, b);
                b = -1;
            }
            if (b > 0 || c == -1) {
                if (b == this._byteBoundary.length) {
                    this._lastPart = true;
                }
                if (this._char != 10) break;
                this._char = -2;
                break;
            }
            if (cr) {
                baos.write(13);
            }
            if (lf) {
                baos.write(10);
            }
            cr = c == 13;
            boolean bl = lf = c == 10 || this._char == 10;
            if (this._char != 10) continue;
            this._char = -2;
        }
        if (Code.verbose()) {
            Code.debug(baos.toString());
        }
        return baos.toByteArray();
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    private class Part {
        String _name = null;
        String _filename = null;
        Hashtable _headers = new Hashtable(10);
        byte[] _data = null;

        private Part() {
        }
    }
}

