/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class CompressedInputStream
extends InputStream {
    private Inflater inflater;
    private InputStream in;
    private byte[] buffer;
    private int pos = 0;
    private byte[] packetHeaderBuffer = new byte[7];

    public CompressedInputStream(InputStream streamFromServer) {
        this.in = streamFromServer;
        this.inflater = new Inflater();
    }

    public int available() throws IOException {
        if (this.buffer == null) {
            return this.in.available();
        }
        return this.buffer.length - this.pos + this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.buffer = null;
        this.inflater = null;
    }

    public int read() throws IOException {
        try {
            this.getNextPacketIfRequired(1);
        }
        catch (IOException ioEx) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        try {
            this.getNextPacketIfRequired(len);
        }
        catch (IOException ioEx) {
            return -1;
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long count = 0L;
        long i = 0L;
        while (i < n) {
            int bytesRead = this.read();
            if (bytesRead == -1) break;
            ++count;
            ++i;
        }
        return count;
    }

    private void getNextPacketFromServer() throws IOException {
        byte[] uncompressedData = null;
        int lengthRead = this.readFully(this.packetHeaderBuffer, 0, 7);
        if (lengthRead < 7) {
            throw new IOException("Unexpected end of input stream");
        }
        int compressedPacketLength = (this.packetHeaderBuffer[0] & 0xFF) + ((this.packetHeaderBuffer[1] & 0xFF) << 8) + ((this.packetHeaderBuffer[2] & 0xFF) << 16);
        int uncompressedLength = (this.packetHeaderBuffer[4] & 0xFF) + ((this.packetHeaderBuffer[5] & 0xFF) << 8) + ((this.packetHeaderBuffer[6] & 0xFF) << 16);
        if (uncompressedLength > 0) {
            uncompressedData = new byte[uncompressedLength];
            byte[] compressedBuffer = new byte[compressedPacketLength];
            this.readFully(compressedBuffer, 0, compressedPacketLength);
            try {
                this.inflater.reset();
            }
            catch (NullPointerException npe) {
                this.inflater = new Inflater();
            }
            this.inflater.setInput(compressedBuffer);
            try {
                this.inflater.inflate(uncompressedData);
            }
            catch (DataFormatException dfe) {
                throw new IOException("Error while uncompressing packet from server.");
            }
            this.inflater.end();
        } else {
            uncompressedData = new byte[compressedPacketLength];
            this.readFully(uncompressedData, 0, compressedPacketLength);
        }
        if (this.buffer != null && this.pos < this.buffer.length) {
            int remaining = this.buffer.length - this.pos;
            byte[] newBuffer = new byte[remaining + uncompressedData.length];
            int newIndex = 0;
            int i = this.pos;
            while (i < this.buffer.length) {
                newBuffer[newIndex++] = this.buffer[i];
                ++i;
            }
            System.arraycopy(uncompressedData, 0, newBuffer, newIndex, uncompressedData.length);
            uncompressedData = newBuffer;
        }
        this.pos = 0;
        this.buffer = uncompressedData;
    }

    private void getNextPacketIfRequired(int numBytes) throws IOException {
        if (this.buffer == null || this.pos + numBytes > this.buffer.length) {
            this.getNextPacketFromServer();
        }
    }

    private final int readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return n;
    }
}

