#include <stdio.h>

int main(int argc, char *argv[])
{
  char buffer[1024];
  int offset, byte, line = 0;

  if (argc != 1) {
    fprintf(stderr, "Usage: rdump <dump >file\n");
    exit(-1);
  }

  while (fgets(buffer, sizeof(buffer), stdin) != NULL) {
    if (sscanf(buffer, "%x %x %*s\n", &offset, &byte) == 2) {
      if (offset != line) {
	fprintf(stderr, "Chybicka se vloudila.\n");
	break;
      }
      fputc(byte, stdout);
      line++;
      continue;
    }
    if (sscanf(buffer, "%x -- %*s\n", &offset) == 1) {
      break;
    }
  }
  return(0);
}

