/*
 * hex -- jednoduchy generator binarnich souboru
 *
 * Copyleft (!c) 1998 Pavel Kankovsky <peak@kerberos.troja.mff.cuni.cz>
 * S timto programem jest mozno nakladati v souladu s ustanovenimi GNU GPL.
 */

#include <stdio.h>

int line;

int s_base;
int s_size;
unsigned s_val;
unsigned s_limit;

void
init()
{
  s_base = 10;
  s_size = 8;
  s_val = 0;
  s_limit = 0;
}

void
base(int x)
{
  if (s_base != 10 || s_limit) {
    fprintf(stderr, "line %d: ambiguous base\n", line);
    exit(1);
  }
  s_base = x;
}

void
size(int x)
{
  if (s_size != 8 || s_limit) {
    fprintf(stderr, "line %d: ambiguous size\n", line);
    exit(1);
  }
  s_size = x;
}

void
digit(char c, int x)
{
  if (x >= s_base) {
    fprintf(stderr, "line %d: bad character `%c'\n", line, c);
    exit(1);
  }
  if (!s_limit) {
    /* tohle je trochu magie s pocitanim modulo 2^32 */
    s_limit = ((1UL << s_size) - (s_base - 1)) / s_base;
  }
  if (s_val > s_limit) {
    fprintf(stderr, "line %d: overflow\n", line);
    exit(1);
  }
  s_val *= s_base;
  s_val += x;
}

void
flush()
{
  if (s_limit) {
    while (s_size > 0) {
      putchar(s_val & 0xff);
      s_val >>= 8;
      s_size -= 8;
    }
  }
  init();
}

int
main()
{
  int c;

  init();
  line = 1;
  for (;;) {
    c = getchar();
    switch (c) {
      case EOF:
        flush(); exit(0);
      case '#':
        flush();
        do {
          c = getchar();
          if (c == EOF)
            exit(0);
        } while (c != '\n');
        ++line;
        break;
      case ' ': case '\t':
        flush(); break;
      case '\n':
        flush(); ++line; break;
      case 'x':
        base(16); break;
      case 'o':
        base(8); break;
      case 'W':
        size(16); break;
      case 'L':
        size(32); break;
      case '0'...'9':
        digit(c, c - '0'); break;
      case 'A'...'F':
        digit(c, c - 'A' + 10); break;
      case 'a'...'f':
        digit(c, c - 'a' + 10); break;
      default:
        fprintf(stderr, "line %d: bad character `%c'\n", line, c);
        exit(1);
    }
  }
}

