#include <unistd.h>
#include <fcntl.h>
#include <elf.h>
#include <string.h>

Elf32_Ehdr hdr;
Elf32_Shdr shdr;
Elf32_Phdr phdr;

/*
	xorl %eax, %eax
	incl %eax
	movl %eax,%ebx
	int $0x80
*/
 
char data[] = { 0x31, 0xc0, 0x40, 0x89, 0xc3, 0xcd, 0x80 };

main()
{
	int fd;

	/* ELF header */
	memcpy(&hdr.e_ident[EI_MAG0], ELFMAG, SELFMAG);
	hdr.e_ident[EI_CLASS]    = ELFCLASS32;
	hdr.e_ident[EI_DATA]     = ELFDATA2LSB;
	hdr.e_ident[EI_VERSION]  = EV_CURRENT;

	hdr.e_type      = ET_EXEC;
	hdr.e_machine   = EM_386;
	hdr.e_version   = EV_CURRENT;
	hdr.e_entry     = 0x08048000+((char *) &hdr.e_ident[EI_PAD] - (char *) &hdr);
	hdr.e_phoff     = sizeof(hdr)+sizeof(shdr);
	hdr.e_shoff     = sizeof(hdr);
	hdr.e_flags     = 0;
	hdr.e_ehsize    = sizeof(hdr);
	hdr.e_phentsize = sizeof(phdr);
	hdr.e_phnum     = 1;
	hdr.e_shentsize = sizeof(shdr);
	hdr.e_shnum     = 1;
	hdr.e_shstrndx  = SHN_UNDEF;

	/* Tfuiii - use pad data for our program */
	memcpy(&hdr.e_ident[EI_PAD], data, sizeof(data));

	/* Section header */
	shdr.sh_name      = 1;
	shdr.sh_type      = SHT_PROGBITS;
	shdr.sh_flags     = SHF_ALLOC + SHF_EXECINSTR;
	shdr.sh_addr      = 0x08048000;
	shdr.sh_offset    = sizeof(hdr)+sizeof(phdr)+sizeof(shdr);
	shdr.sh_size      = sizeof(data);
	shdr.sh_link      = SHN_UNDEF;
	shdr.sh_info      = 0;
	shdr.sh_addralign = 4;
	shdr.sh_entsize   = 0;

	/* Program header */
	phdr.p_type   = PT_LOAD;
	phdr.p_offset = 0;
	phdr.p_vaddr  = 0x8048000;
	phdr.p_paddr  = 0;
	phdr.p_filesz = sizeof(data);
	phdr.p_memsz  = 0x100;
	phdr.p_flags  = PF_R + PF_X;
	phdr.p_align  = 0x1000;

	/* Write it */
	fd = open("elf.out", O_WRONLY | O_CREAT | O_TRUNC, 0775);

	write(fd, (void *) &hdr, sizeof(hdr));
	write(fd, (void *) &shdr, sizeof(shdr));
	write(fd, (void *) &phdr, sizeof(phdr));

	close(fd);
}
