#include <locale.h>
#include <libintl.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <monetary.h>

#define LOCALEDIR "/usr/share/locale"
#define PACKAGE "lc_example"

#define BUF 80
#define _(str) gettext(str)

void init() {
   setlocale(LC_ALL,"");
   bindtextdomain (PACKAGE, LOCALEDIR);
   textdomain (PACKAGE);
}

void invite() {
   printf(_("Hello!\n"));
}

void lc_collate() {
#define N 5
   char *words[] = {"plaka", "pln", "Plil", "cikda", "chroust"};
   char *p;
   int i,j;
	
   for (i = 0; i < N; i++)
      for (j = 0; j < N; j++) {
         if (strcoll(words[i],words[j]) < 0) {
            p = words[i];
            words[i] = words[j];
            words[j] = p;
         }
      }
   printf(_("Sorted words:"));

   for (i = 0; i < N; i++)
      printf(" %s", words[i]);	

   printf("\n");
}
	
void lc_time() {
   char buf[BUF];
   time_t t = time(NULL);

   strftime(buf, BUF, "%A", localtime(&t));
   printf(_("%s - I hate it!\n"), buf);
}

void lc_ctype() {
   char buf[BUF];
   int i;

   printf(_("Wrote some text, please:\n"));
   fgets(buf, BUF, stdin);

   for (i = 0; i < BUF && buf[i] != '\0'; i++) { 
      if (isalnum(buf[i]))
         buf[i] = '+';
      else if (isspace(buf[i]))
              buf[i] = '_';
           else
              buf[i] = '-';
   }
   printf("%s\n", buf);
}

void lc_numeric() {
   printf(_("Numbers: %'d   %'f\n"),
      (int) 12345678, (float) 1234567.1235678);
}
	
void lc_monetary() {
   char buf[BUF];

   strfmon(buf, BUF, _("You have forgotten to pay %n to the author of this program.\n"), (double) 1234);
   printf("%s", buf);
}

void main(int argc, char **argv) {
   init();
   invite();
   lc_collate();
   lc_time();
   lc_numeric();
   lc_ctype();
   lc_monetary();
}
