#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#define ITEMS 100
#define NONVALID 0
#define VALID 1

pthread_mutex_t mut_var;
pthread_cond_t condvalid;
pthread_cond_t condnonvalid = PTHREAD_COND_INITIALIZER;
int valid;
int share;

void * konzument(void *a){
	printf("Process %s: start\n", (char *)a);
	while(1){
		pthread_mutex_lock(&mut_var);
		if (!valid)
		  pthread_cond_wait(&condvalid, &mut_var);
		valid = NONVALID;
		printf("Process %s: %i\n", (char *)a, share);
		if (share == -1){
			pthread_mutex_unlock(&mut_var);
			break;
		};
		pthread_cond_signal(&condnonvalid);
		pthread_mutex_unlock(&mut_var);
	};
	printf("Process %s: end\n", (char *)a);
	return NULL;
}

void * producent(void *a){
	int i;
	printf("Process %s: start\n", (char *)a);
	for (i = 0; i<ITEMS; i++){
		pthread_mutex_lock(&mut_var);
		if (valid) 
		  pthread_cond_wait(&condnonvalid, &mut_var);
		share = (int)rand();
		if (share == -1) share = 0;
		if (i == ITEMS - 1) share = -1;
		printf("Process %s: %i\n", (char *)a, share);
		valid = VALID;
		pthread_cond_signal(&condvalid);
		pthread_mutex_unlock(&mut_var);
	};
	printf("Process %s: end\n", (char *)a);
	return NULL;
}

int main(){
	pthread_t a,b;
	
	pthread_mutex_init(&mut_var, NULL);
	pthread_cond_init(&condvalid, NULL);
	pthread_create(&a, NULL, producent, "producent");
	pthread_create(&b, NULL, konzument, "konzument");
	pthread_join(a, NULL);
	pthread_join(b, NULL);
	pthread_cond_destroy(&condvalid);
	pthread_cond_destroy(&condnonvalid);
	pthread_mutex_destroy(&mut_var);
	return 0;
}
