use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.21,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v9.0.0
F967      ; [.3BFC.0021.0002.4E0D][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.3BFC.0032.0002.4E26][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.3BF5.0021.0002.4E32][.3C7B.0020.0002][.3CE6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3C07.0021.0002.4E38][.3C7C.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3BF8.0021.0002.4E39][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.3BFA.0021.0002.4E82][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.3BFA.0021.0002.4E86][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.3BFA.0021.0002.4EAE][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.3BFE.0021.0002.4EC0][.3C87.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.3BFA.0021.0002.4EE4][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.3BFA.0021.0002.4F86][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.3BFA.0021.0002.4F8B][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.3BFB.0021.0002.4FAE][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.3BFB.0021.0002.4FAE][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.3C05.0023.0002.4FBB][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3C06.0021.0002.4FBF][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.3BFC.0022.0002.5002][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.3BFA.0022.0002.502B][.3C84.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.3BFC.0022.0002.5099][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.3BFE.0023.0002.50CF][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.3BFA.0022.0002.50DA][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.3BFE.0023.0002.50E7][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.3BFE.0023.0002.50E7][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.3C00.0021.0002.5140][.3C7B.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.3C03.0021.0002.5145][.3C80.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.3BFB.0021.0002.514D][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.3BFB.0021.0002.514D][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3BF7.0022.0002.5167][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.3C01.0024.0002.5168][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.3BFA.0023.0002.5169][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.3BFA.0021.0002.516D][.3C84.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.3BF5.0026.0002.5177][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.3BF5.0024.0002.5180][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.3C01.0021.0002.518D][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.3BFB.0022.0002.5192][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.3BFB.0022.0002.5195][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.3C00.0023.0002.5197][.3C7F.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.3C00.003B.0002.51A4][.3C81.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3BF8.0022.0002.51AC][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.3BFA.0021.0002.51B7][.3C74.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.3BFA.0024.0002.51C9][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.3BFA.0021.0002.51CC][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.3BFA.0021.0002.51DC][.3C85.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3C07.0022.0002.51DE][.3C86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.3C00.0023.0002.5203][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.3C01.0021.0002.5207][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.3C01.0021.0002.5207][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.3BFA.0022.0002.5217][.3C79.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.3BFA.0022.0002.5229][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.3C01.0022.0002.523A][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.3BF5.0021.0002.523B][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3C07.0021.0002.5272][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.3BFE.002D.0002.5277][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.3BFA.0021.0002.5289][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.3BFA.0021.0002.529B][.3C79.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.3BFA.0023.0002.52A3][.3C79.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.3C00.0024.0002.52C7][.3C7F.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.3C00.0024.0002.52C7][.3C7F.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.3BFB.0023.0002.52C9][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.3BFB.0023.0002.52C9][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.3BFA.0021.0002.52D2][.3C85.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.3BFA.0021.0002.52DE][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.3BF5.0023.0002.52E4][.3C85.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.3BF5.0023.0002.52E4][.3C85.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.3BFA.0023.0002.52F5][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.3C01.0022.0002.52FA][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.3C01.0022.0002.52FA][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3C06.0022.0002.5305][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.3BFC.0021.0002.5317][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.3BFC.0021.0002.5317][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3BF7.0021.0002.533F][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3C07.0021.0002.5349][.3C82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.3BFC.0025.0002.5351][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.3BFC.0025.0002.5351][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.3BFC.0022.0002.535A][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.3C01.0022.0002.5373][.3C85.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.3BFA.0022.0002.5375][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.3C01.0021.0002.537D][.3C85.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.3BF5.0028.0002.537F][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.3BF5.0028.0002.537F][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.3BF5.0028.0002.537F][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.3C03.0022.0002.53C3][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.3BF5.0022.0002.53CA][.3C85.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.3BFE.005E.0002.53DF][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.3BF5.002A.0002.53E5][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.3BF5.0021.0002.53EB][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.3C01.0022.0002.53F1][.3C87.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.3BFA.0024.0002.540F][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.3BFA.0021.0002.541D][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3C07.0021.0002.5438][.3C85.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.3BFA.0024.0002.5442][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.3C01.0026.0002.5448][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.3C01.0028.0002.5468][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.3C00.0031.0002.54A2][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.3C00.0025.0002.54BD][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3BF8.0021.0002.5510][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.3BF5.0022.0002.5553][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3C07.0024.0002.5563][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.3BFE.0024.0002.5584][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.3BFE.0024.0002.5584][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.3BFA.0021.0002.5587][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3C07.0022.0002.5599][.3C82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3C07.0022.0002.5599][.3C82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.3BF5.0022.0002.559D][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.3BF5.0022.0002.559D][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3BF6.0021.0002.55AB][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.3C00.0022.0002.55E2][.3C7B.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.3C05.0022.0002.5606][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.3C05.0022.0002.5606][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.3BF5.0026.0002.5668][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.3BFC.0023.0002.5674][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.3BFA.0023.0002.56F9][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3BF8.0024.0002.5716][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3C07.0024.0002.578B][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.3BFE.0021.0002.57CE][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.3BFE.0021.0002.57F4][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.3BFC.0023.0002.5831][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.3BFC.0033.0002.5840][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.3C03.0022.0002.585A][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.3C03.0022.0002.585A][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.3BFE.0021.0002.585E][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.3BFB.0021.0002.58A8][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.3BFC.0024.0002.58B3][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.3BFA.0021.0002.58D8][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.3BFA.0021.0002.58DF][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.3BFC.0032.0002.5906][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3BF8.0021.0002.591A][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.3BFB.0021.0002.5922][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.3C00.0024.0002.5944][.3C77.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3BF7.0023.0002.5948][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.3BF5.0024.0002.5951][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.3BFC.0025.0002.5954][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.3BFE.0030.0002.5962][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3BF7.0021.0002.5973][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3C07.0026.0002.59EC][.3C86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.3C00.002C.0002.5A1B][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.3C05.0030.0002.5A27][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.3BFC.0027.0002.5A62][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.3BFC.002B.0002.5A66][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.3C00.0025.0002.5AB5][.3C87.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.3C00.0041.0002.5B08][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.3C01.003C.0002.5B28][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.3BFA.0029.0002.5B3E][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.3BFA.0029.0002.5B3E][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3BF8.0021.0002.5B85][.3C74.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.3C00.0029.0002.5BC3][.3C81.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.3C03.003B.0002.5BD8][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3BF7.0021.0002.5BE7][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3BF7.0021.0002.5BE7][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3BF7.0021.0002.5BE7][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.3BFA.0023.0002.5BEE][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3BF7.0021.0002.5C3F][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3BF8.0028.0002.5C60][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.3BFA.0023.0002.5C62][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.3C03.0021.0002.5C64][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.3BFA.0026.0002.5C65][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.3BFE.002A.0002.5CC0][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.3BFA.0023.0002.5D19][.3C84.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.3BFA.0021.0002.5D50][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.3BFA.0025.0002.5DBA][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.3BFE.0021.0002.5DE1][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.3BFE.0027.0002.5DE2][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.3BFE.0022.0002.5DFD][.3C7B.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.3BFE.0029.0002.5E28][.3C78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.3BFB.0025.0002.5E3D][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3BF7.0021.0002.5E74][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3BF8.002B.0002.5EA6][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.3BFC.0052.0002.5EB3][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.3BFE.0025.0002.5EB6][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.3BFA.0021.0002.5EC9][.3C79.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.3BFA.0021.0002.5ECA][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.3BFA.0021.0002.5ECA][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.3BF5.0021.0002.5ED3][.3C7C.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.3BFA.0025.0002.5EEC][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.3BFA.0022.0002.5F04][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3BF8.004B.0002.5F22][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3BF8.004B.0002.5F22][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3C07.0025.0002.5F62][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.3C03.0025.0002.5F69][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.3C01.0027.0002.5F6B][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.3BFA.0021.0002.5F8B][.3C84.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.3BFC.0026.0002.5FA9][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.3C00.0043.0002.5FAD][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.3C00.002A.0002.5FCD][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.3C01.0026.0002.5FD7][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3BF7.0021.0002.5FF5][.3C79.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3BF7.0024.0002.6012][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.3BFA.0026.0002.601C][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.3C00.0042.0002.6081][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3C07.0026.0002.6094][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3C07.0026.0002.6094][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3BF8.0022.0002.60C7][.3C7B.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.3BFB.002D.0002.60D8][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.3C00.0025.0002.60E1][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.3C00.002E.0002.6108][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.3BFA.0022.0002.6144][.3C84.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.3C01.002A.0002.6148][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3C07.0027.0002.614C][.3C7C.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3C07.0027.0002.614C][.3C7C.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.3C00.0047.0002.6160][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.3BF5.0028.0002.6168][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.3BFA.0031.0002.617A][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.3C01.0022.0002.618E][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.3C01.0022.0002.618E][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.3C01.0022.0002.618E][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.3BFA.0021.0002.6190][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.3BFC.0028.0002.61A4][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.3C03.0030.0002.61AF][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3C07.0021.0002.61B2][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.3BFB.0025.0002.61DE][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.3C01.0022.0002.61F2][.3C87.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.3C01.0022.0002.61F2][.3C87.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.3C01.0022.0002.61F2][.3C87.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.3BFA.0022.0002.61F6][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.3BFA.0022.0002.61F6][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.3BFA.0022.0002.6200][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.3BFE.0026.0002.6210][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.3BFA.0022.0002.622E][.3C84.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3BF8.0029.0002.6234][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3C06.002B.0002.62B1][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.3BFA.0021.0002.62C9][.3C73.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3BF7.0024.0002.62CF][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.3C03.0026.0002.62D3][.3C77.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.3BFC.0022.0002.62D4][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.3BFE.0022.0002.62FE][.3C85.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.3BFB.0027.0002.633D][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.3C00.0027.0002.6350][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.3BFE.0039.0002.6368][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3BF7.0024.0002.637B][.3C79.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.3BFE.0029.0002.6383][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.3BFA.0021.0002.63A0][.3C75.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.3C00.0025.0002.63A9][.3C77.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.3C00.0030.0002.63C4][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.3BFE.0030.0002.641C][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.3C01.0025.0002.6422][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.3BFB.0021.0002.6469][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3BF7.0022.0002.649A][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3C07.0029.0002.649D][.3C83.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.3BFA.0023.0002.64C4][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.3BFB.0025.0002.654F][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.3BFB.0025.0002.654F][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.3C00.0030.0002.6556][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.3BF5.0030.0002.656C][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.3BFE.0032.0002.6578][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.3BFA.0025.0002.6599][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.3BFA.0028.0002.65C5][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.3BF5.0035.0002.65E3][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.3C00.0024.0002.6613][.3C79.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.3C01.0026.0002.6649][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.3C03.0022.0002.6674][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.3C03.0022.0002.6674][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3C07.002A.0002.6688][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.3BFE.002B.0002.6691][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.3BFE.002B.0002.6691][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3C06.0022.0002.66B4][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.3BFA.0022.0002.66C6][.3C79.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.3BF5.0033.0002.66F4][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.3BFE.002D.0002.66F8][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.3C03.0023.0002.6700][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.3BFA.0022.0002.6717][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.3BFA.0022.0002.6717][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.3BFA.0022.0002.6717][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.3BFB.0025.0002.671B][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.3BFB.0025.0002.671B][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.3BFA.0028.0002.674E][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3C06.0025.0002.6753][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.3C01.002E.0002.6756][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.3BF5.0038.0002.675E][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3BF7.0021.0002.677B][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.3BFA.0021.0002.6797][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.3BFA.0023.0002.67F3][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.3BFA.0023.0002.6817][.3C84.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.3BFA.0025.0002.6881][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.3BFB.0027.0002.6885][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.3BFB.0027.0002.6885][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.3BFA.0029.0002.68A8][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.3BFE.0062.0002.6942][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.3BF5.002A.0002.69EA][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.3C00.0028.0002.6A02][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.3C00.0028.0002.6A02][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.3C00.0028.0002.6A02][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.3BFA.0024.0002.6A13][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.3BFA.0024.0002.6AD3][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.3C01.0021.0002.6ADB][.3C85.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.3BFA.0023.0002.6B04][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.3C03.0028.0002.6B21][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3C07.0025.0002.6B54][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.3BFE.0023.0002.6B72][.3C78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.3BFA.0023.0002.6B77][.3C79.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.3BFA.0023.0002.6BAE][.3C79.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.3BFE.0023.0002.6BBA][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.3BFE.0023.0002.6BBA][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.3BFE.0023.0002.6BBA][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.3BFC.0025.0002.6C4E][.3C77.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.3C03.0024.0002.6C88][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.3C00.002B.0002.6CBF][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3C06.0024.0002.6CCC][.3C87.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3BF7.0022.0002.6CE5][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.3BFA.0021.0002.6D1B][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3BF8.002A.0002.6D1E][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3C06.0029.0002.6D3E][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.3BFA.0025.0002.6D41][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.3BFA.0025.0002.6D41][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.3BFA.0025.0002.6D41][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3C07.002E.0002.6D69][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.3BFA.0023.0002.6D6A][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3C07.002A.0002.6D77][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3C07.002A.0002.6D77][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.3C03.0025.0002.6D78][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.3C00.0022.0002.6D85][.3C79.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.3BFA.0022.0002.6DCB][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.3BFA.0025.0002.6DDA][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.3BFA.0024.0002.6DEA][.3C84.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.3C00.0026.0002.6DF9][.3C77.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.3C01.002C.0002.6E1A][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3C07.002B.0002.6E2F][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.3C00.002B.0002.6E6E][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.3BFA.0026.0002.6E9C][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3BF7.0022.0002.6EBA][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.3C01.002B.0002.6ECB][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.3C01.002B.0002.6ECB][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3C07.0022.0002.6ED1][.3C7C.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.3BFA.0026.0002.6F0F][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3C07.0026.0002.6F22][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3C07.0026.0002.6F22][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.3BFA.0024.0002.6F23][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.3C01.0033.0002.6F6E][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.3BFC.003C.0002.6FC6][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.3BFA.0025.0002.6FEB][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.3BFA.002A.0002.6FFE][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.3C00.002D.0002.701B][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.3C01.003D.0002.701E][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.3C01.003D.0002.701E][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3C07.002D.0002.7070][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.3C01.002B.0002.707D][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.3C01.002C.0002.7099][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.3C05.0028.0002.70AD][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.3BFA.0025.0002.70C8][.3C79.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.3BFA.0022.0002.70D9][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.3BFA.0025.0002.7149][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.3C01.002D.0002.716E][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.3C01.002D.0002.716E][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.3BFA.0026.0002.71CE][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.3BFA.0023.0002.71D0][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.3BFA.0027.0002.7210][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.3BFA.0026.0002.721B][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.3C03.0036.0002.7228][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.3C01.0028.0002.7235][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.3C01.0028.0002.7235][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.3BFA.0023.0002.7262][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.3BFE.0030.0002.7280][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.3BFC.0027.0002.72AF][.3C77.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.3BFE.0035.0002.72C0][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.3BFA.0024.0002.72FC][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.3C01.002E.0002.732A][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.3C01.002E.0002.732A][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.3BFA.0021.0002.7375][.3C79.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3BF8.0023.0002.737A][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.3BFE.0021.0002.7387][.3C7B.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.3BFE.0021.0002.7387][.3C7B.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.3C00.0025.0002.738B][.3C7C.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.3BFA.0027.0002.73B2][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.3BFA.0023.0002.73DE][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.3BFA.002D.0002.7406][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.3BFA.0028.0002.7409][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.3C05.002B.0002.7422][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.3C00.003D.0002.745C][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3C07.002D.0002.7469][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.3C01.0057.0002.7471][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.3C01.0057.0002.7471][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.3BFA.0026.0002.7489][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.3BFA.0024.0002.7498][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.3BF5.003A.0002.74CA][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.3BFA.002A.0002.7559][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.3BFA.0022.0002.7565][.3C75.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.3C00.002C.0002.7570][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.3C00.002C.0002.7570][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.3BFA.002F.0002.75E2][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.3C00.0059.0002.7610][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.3C00.0023.0002.761F][.3C7B.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.3BFA.0027.0002.7642][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.3BFA.0023.0002.7669][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.3C00.0022.0002.76CA][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.3C00.0022.0002.76CA][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.3BFE.002B.0002.76DB][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.3BFA.0028.0002.76E7][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.3C01.0021.0002.76F4][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.3C01.0021.0002.76F4][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.3BFE.002C.0002.7701][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.3C01.0033.0002.771E][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.3C03.0023.0002.7740][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.3C01.0034.0002.778B][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.3BFA.002C.0002.786B][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.3BFA.0021.0002.788C][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.3BFA.0021.0002.788C][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.3BFC.0038.0002.7891][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.3BFA.0024.0002.78CA][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.3BFC.0032.0002.78FB][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.3BFA.002B.0002.792A][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.3BFE.0046.0002.793E][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.3BF5.004C.0002.7948][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.3C01.0035.0002.7949][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.3C00.0032.0002.7950][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.3C01.0039.0002.7956][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.3C01.0039.0002.7956][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.3C03.0023.0002.795D][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.3BFE.002C.0002.795E][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.3BFE.0037.0002.7965][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.3BFA.0022.0002.797F][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3C07.0027.0002.798D][.3C7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.3C01.0044.0002.798E][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.3BFC.0028.0002.798F][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.3BFC.0028.0002.798F][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.3BFA.0023.0002.79AE][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3BF7.0023.0002.79CA][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.3C03.0024.0002.79EB][.3C80.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.3BFA.0023.0002.7A1C][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.3BF5.0025.0002.7A40][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.3BF5.0025.0002.7A40][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3BF8.0022.0002.7A81][.3C7B.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.3BFA.0022.0002.7ACB][.3C87.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.3BFA.0023.0002.7B20][.3C87.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.3C01.0027.0002.7BC0][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.3C01.0027.0002.7BC0][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.3C01.003D.0002.7BC6][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.3C03.0026.0002.7BC9][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.3BFA.0025.0002.7C3E][.3C79.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.3BFA.0026.0002.7C60][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.3BFA.0024.0002.7C92][.3C87.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.3C01.0047.0002.7CBE][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3BF8.0029.0002.7CD6][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.3BFA.0029.0002.7CE7][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.3BF5.004F.0002.7D00][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3BF7.0022.0002.7D10][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.3BFE.0023.0002.7D22][.3C74.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.3BFA.0028.0002.7D2F][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.3C01.0063.0002.7D5B][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.3BFC.0034.0002.7D63][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.3BFA.0023.0002.7DA0][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.3BFA.0024.0002.7DBE][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.3C03.0030.0002.7DC7][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.3BFA.0027.0002.7DF4][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.3BFA.0027.0002.7DF4][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.3BFA.0027.0002.7DF4][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.3C01.0036.0002.7E09][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.3BFA.0029.0002.7E37][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.3BFC.0026.0002.7E41][.3C77.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.3BFE.0052.0002.7E45][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.3BFC.0035.0002.7F3E][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.3BFE.0035.0002.7F72][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.3BFA.0031.0002.7F79][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.3BFA.0024.0002.7F85][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.3BFA.0029.0002.7F9A][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.3C00.0036.0002.7FBD][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.3BF5.005A.0002.7FFA][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.3BFA.0029.0002.8001][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.3C01.0033.0002.8005][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.3C01.0033.0002.8005][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.3C01.0033.0002.8005][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.3BFA.002B.0002.8046][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.3BFA.0028.0002.806F][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.3C03.0028.0002.8070][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.3BFA.0027.0002.807E][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.3BFA.0022.0002.808B][.3C85.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3BF7.0023.0002.80AD][.3C80.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.3C00.0024.0002.80B2][.3C84.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.3BFC.003F.0002.813E][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.3BFA.0022.0002.81D8][.3C73.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.3BFA.0024.0002.81E8][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.3C03.002A.0002.81ED][.3C83.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.3C00.002E.0002.8201][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.3C00.002E.0002.8201][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.3BFA.002A.0002.826F][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.3C00.0037.0002.828B][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.3C01.003B.0002.829D][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3C07.0029.0002.82B1][.3C7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.3BFC.0035.0002.82B3][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.3C00.0029.0002.82BD][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.3C00.0023.0002.82E5][.3C75.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.3C00.0023.0002.82E5][.3C75.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.3BF5.003A.0002.82E6][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.3C03.002E.0002.831D][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.3C00.004C.0002.8323][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3BF8.0022.0002.8336][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3C07.0034.0002.8352][.3C7C.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.3BFB.002A.0002.83BD][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.3BFA.0024.0002.83C9][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.3BF5.0023.0002.83CA][.3C80.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.3BF5.0025.0002.83CC][.3C84.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.3C03.0029.0002.83DC][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3C07.002A.0002.83EF][.3C7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.3BFA.0025.0002.83F1][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.3BFA.0025.0002.843D][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.3C00.0023.0002.8449][.3C79.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.3C01.0034.0002.8457][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.3C01.0034.0002.8457][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.3BFA.0029.0002.84EE][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3C06.002A.0002.84F1][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.3BFA.002A.0002.84FC][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.3C00.0062.0002.8564][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.3BFA.0028.0002.85CD][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.3BFA.0025.0002.85FA][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.3BFA.002A.0002.8606][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.3BFA.0027.0002.862D][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.3BFA.0025.0002.863F][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3C07.0023.0002.8650][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.3BFA.002B.0002.865C][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.3BFA.002B.0002.865C][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3C07.0025.0002.8667][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.3C03.0034.0002.86A9][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.3C01.0026.0002.8728][.3C77.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.3BFA.0026.0002.87BA][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.3BFA.0023.0002.881F][.3C73.0020.0002][.3CE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3C07.0025.0002.884C][.3C74.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.3C00.0030.0002.8863][.3C86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.3BFA.0026.0002.88C2][.3C79.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.3BFA.0034.0002.88CF][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.3BFA.0035.0002.88E1][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.3BFA.0027.0002.88F8][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.3BF5.0028.0002.8910][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.3BF5.0034.0002.8941][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.3BFA.0029.0002.8964][.3C73.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.3BFC.002D.0002.8986][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.3BF5.0028.0002.898B][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.3BFE.0037.0002.8996][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.3BFE.0037.0002.8996][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.3BFE.0031.0002.8AA0][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.3BFE.002B.0002.8AAA][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.3BFE.002B.0002.8AAA][.3C77.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.3C01.0046.0002.8ABF][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.3C03.0026.0002.8ACB][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.3BFA.002B.0002.8AD2][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.3BFA.0021.0002.8AD6][.3C7B.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.3C00.0046.0002.8AED][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.3C00.0046.0002.8AED][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.3C01.0030.0002.8AF8][.3C78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.3C01.0030.0002.8AF8][.3C78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3BF7.0021.0002.8AFE][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3BF7.0021.0002.8AFE][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.3C00.0022.0002.8B01][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.3C00.0022.0002.8B01][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.3BF5.002D.0002.8B39][.3C85.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.3BF5.002D.0002.8B39][.3C85.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.3BFE.002C.0002.8B58][.3C87.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3BF8.002A.0002.8B80][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.3BFC.0023.0002.8B8A][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.3BFC.0023.0002.8B8A][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.3BF5.0057.0002.8C48][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.3BFE.003B.0002.8C55][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.3BF5.002E.0002.8CAB][.3C7C.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.3BFC.0032.0002.8CC1][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.3BFA.0025.0002.8CC2][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.3BF5.0039.0002.8CC8][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.3BFC.002D.0002.8CD3][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.3C01.002B.0002.8D08][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.3C01.002B.0002.8D08][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.3BF5.0039.0002.8D1B][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.3BF5.0058.0002.8D77][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.3BFC.0027.0002.8DCB][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.3BFA.002C.0002.8DEF][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.3C03.002D.0002.8ECA][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.3BFA.002A.0002.8F26][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.3BFA.0026.0002.8F2A][.3C84.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.3BFE.004F.0002.8F38][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.3BFE.004F.0002.8F38][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.3BFC.002F.0002.8F3B][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.3BFA.0026.0002.8F62][.3C79.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.3C01.003E.0002.8FB0][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.3BFA.002B.0002.9023][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.3C00.0027.0002.9038][.3C87.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.3C00.0027.0002.9038][.3C87.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.3C01.0041.0002.9072][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.3BFA.002B.0002.907C][.3C7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.3BFA.0028.0002.908F][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.3BFA.0028.0002.90DE][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.3BF8.0045.0002.90FD][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.3BFA.0026.0002.916A][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.3BFA.0024.0002.91B4][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.3BFA.0036.0002.91CC][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.3BFA.002D.0002.91CF][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.3BF5.0021.0002.91D1][.3C87.0020.0002][.3CE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.3BFA.002D.0002.9234][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.3BFC.002F.0002.9238][.3C73.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.3BFC.0039.0002.927C][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3C07.003F.0002.92D7][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.3BFA.0025.0002.9304][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.3BFA.002C.0002.934A][.3C79.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.3BF5.0033.0002.958B][.3C74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.3BFA.002E.0002.95AD][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.3C00.0031.0002.962E][.3C7C.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.3BFA.002D.0002.964B][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.3BF5.0037.0002.964D][.3C73.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.3BFA.0026.0002.9675][.3C85.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.3BFA.0023.0002.9678][.3C84.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.3C01.004E.0002.967C][.3C77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.3BFA.0021.0002.9686][.3C84.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.3BFA.0027.0002.96A3][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.3BFA.0025.0002.96B7][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.3BFA.0026.0002.96B8][.3C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.3BFA.0038.0002.96E2][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3BF7.0023.0002.96E3][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3BF7.0023.0002.96E3][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.3BFA.002E.0002.96F6][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.3BFA.0028.0002.96F7][.3C7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.3C00.0031.0002.9723][.3C80.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.3BFA.002E.0002.9732][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.3BFA.002F.0002.9748][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.3C01.0054.0002.9756][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.3C01.0054.0002.9756][.3C77.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3C06.0034.0002.97E0][.3C87.0020.0002][.3CD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3C07.0026.0002.97FF][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3C07.0026.0002.97FF][.3C75.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.3BFA.0030.0002.9818][.3C79.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.3BFC.002E.0002.983B][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.3BFC.002E.0002.983B][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.3BFA.002E.0002.985E][.3C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.3BF5.005B.0002.98E2][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.3BFC.0039.0002.98EF][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.3BFE.005A.0002.98FC][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.3BF5.0030.0002.9928][.3C7C.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.3BFA.0027.0002.99F1][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.3BFA.0030.0002.9A6A][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.3C01.004C.0002.9B12][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.3C01.004C.0002.9B12][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.3BFA.002F.0002.9B6F][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.3BFA.0028.0002.9C57][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3C07.0025.0002.9DB4][.3C73.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.3BFA.0030.0002.9DFA][.3C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.3BFA.0028.0002.9E1E][.3C73.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.3BFA.0026.0002.9E7F][.3C7B.0020.0002][.3CD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.3BFA.0031.0002.9E97][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.3BFA.0029.0002.9E9F][.3C87.0020.0002][.3CD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.3BFB.0028.0002.9EBB][.3C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.3BFA.0032.0002.9ECE][.3C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.3BFC.004A.0002.9F3B][.3C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.3BFA.0021.0002.9F8D][.3C7F.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.3BFA.002E.0002.9F8E][.3C7B.0020.0002][.3CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.3BF5.0056.0002.9F9C][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.3BF5.0056.0002.9F9C][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.3BF5.0056.0002.9F9C][.3C80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
