# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-text/podofo/podofo-0.8.4.ebuild,v 1.3 2011/02/24 17:31:10 zmedico Exp $

EAPI=2
inherit cmake-utils eutils multilib

DESCRIPTION="PoDoFo is a C++ library to work with the PDF file format."
HOMEPAGE="http://sourceforge.net/projects/podofo/"
SRC_URI="mirror://sourceforge/podofo/${P}.tar.gz
http://sourceforge.net/apps/mantisbt/podofo/file_download.php?file_id=15&type=bug -> podofo-0.8.4-libpng15.patch"

LICENSE="GPL-2 LGPL-2.1"
SLOT="0"
KEYWORDS="~amd64 ~hppa ~ppc ~ppc64 ~sparc ~x86"
IUSE="+boost debug test"

RDEPEND="dev-lang/lua
	dev-libs/openssl
	media-libs/fontconfig
	media-libs/freetype:2
	virtual/jpeg
	>=media-libs/libpng-1.4
	media-libs/tiff
	sys-libs/zlib"
DEPEND="${RDEPEND}
	boost? ( dev-util/boost-build )
	test? ( dev-util/cppunit )"

DOCS="AUTHORS ChangeLog TODO"

src_prepare() {
	# Bug #356293 - libpng-1.5 compatibility
	epatch "$DISTDIR"/$P-libpng15.patch

	sed -i \
		-e "s:LIBDIRNAME \"lib\":LIBDIRNAME \"$(get_libdir)\":" \
		CMakeLists.txt || die
	# TODO: fix this test case
	# ColorTest.cpp:42:Assertion
	# Test name: ColorTest::testHexNames
	# assertion failed
	# - Expression: static_cast<int>(rgb.GetGreen() * 255.0) == 0x0A
	sed -e 's:CPPUNIT_TEST( testHexNames );://CPPUNIT_TEST( testHexNames );:' \
		-i test/unit/ColorTest.h || die

	# Bug #352125: test failure, depending on installed fonts
	# ##Failure Location unknown## : Error
	# Test name: FontTest::testFonts
	# uncaught exception of type PoDoFo::PdfError
	# - ePdfError_UnsupportedFontFormat
	sed -e 's:CPPUNIT_TEST( testFonts );://CPPUNIT_TEST( testFonts );:' \
		-i test/unit/FontTest.h || die
}

src_configure() {
	mycmakeargs+=(
		"-DPODOFO_BUILD_SHARED=1"
		"-DPODOFO_HAVE_JPEG_LIB=1"
		"-DPODOFO_HAVE_PNG_LIB=1"
		"-DPODOFO_HAVE_TIFF_LIB=1"
		"-DWANT_FONTCONFIG=1"
		"-DUSE_STLPORT=0"
		$(cmake-utils_use_want boost)
		$(cmake-utils_use_has test CPPUNIT)
		)

	cmake-utils_src_configure
}

src_test() {
	cd "${CMAKE_BUILD_DIR}"/test/unit
	./podofo-test --selftest || die "self test failed"
}
