# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/net-libs/openpgm/openpgm-5.1.114.ebuild,v 1.1 2011/03/23 12:39:05 djc Exp $

EAPI=3
inherit autotools

DESCRIPTION="OpenPGM is an open source implementation of the Pragmatic General
Multicast (PGM) specification"
HOMEPAGE="http://code.google.com/p/openpgm"
SRC_URI="http://openpgm.googlecode.com/files/libpgm-${PV}~dfsg.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="static-libs"

DEPEND=""
RDEPEND="${DEPEND}"

S="${WORKDIR}/libpgm-${PV}~dfsg/${PN}/pgm"

src_prepare() {
	eautoreconf
}

src_configure() {
	econf \
		$(use_enable static-libs static) \
		${EXTRA_ECONF} \
		--disable-dependency-tracking
}

src_install() {
	emake DESTDIR="${D}" install || die "emake install failed."
	dodoc "${S}"/../doc/* "${S}"/README

	# remove useless .la files
	find "${D}" -name '*.la' -delete

	# remove useless .a (only for non static compilation)
	use static-libs || find "${D}" -name '*.a' -delete
}
