// { dg-do run }

#include <stdlib.h>

 // In any instance of "loop", "ptr" should always equal "this".
struct loop
{
  loop (int):ptr (this)
  {
  }
  loop (const loop & o):ptr (this)
  {
    o.check ();
  }
  loop & operator= (const loop & o)
  {
    o.check ();
    ptr = this;
    return *this;
  }
  loop *ptr;
  void check () const
  {
    if (ptr != this)
      abort ();
  }
};

 // Structures with loop fields but no user-defined ctors.
struct t1
{
  loop l;
};
struct t2
{
  unsigned int i:7, j:7;
  t1 k;
  loop l;
  unsigned int m;
};
struct t3
{
  t2 a[2];
  t2 b;
};

 // Macros for initialising the above
#define LOOP 1
#define T1 { LOOP }
#define T2(BASE) { BASE, BASE + 1, T1, LOOP, BASE + 2 }
#define T3(BASE) { { T2 (BASE), T2 (BASE + 4) }, T2 (BASE + 8) }

// A series of functions for checking an object against its initializer.
void
check (const loop & o)
{
  o.check ();
}

void
check (const t1 & o)
{
  check (o.l);
}

void
check (const t2 & o, unsigned int base)
{
  if (o.i != base || o.j != base + 1 || o.m != base + 2)
    abort ();
  check (o.k);
  check (o.l);
}

void
check (const t3 & o, unsigned int base)
{
  check (o.a[0], base);
  check (o.a[1], base + 4);
  check (o.b, base + 8);
}

 // Test CONSTRUCTORs that directly initialize a RESULT_DECL.
t1
f1 ()
{
  return __extension__ ((t1) T1);
}

t2
f2 ()
{
  return __extension__ ((t2) T2 (2));
}

t3
f3 ()
{
  return __extension__ ((t3) T3 (3));
}

int
main ()
{
  // Test CONSTRUCTORs that initialize variables.
  t1 x1 = T1;
  t2 x2 = T2 (20);
  t3 x3 = T3 (30);
  loop y1[] = { LOOP, LOOP, LOOP };
  t3 y2[] = { T3 (100), T3 (101), T3 (102), T3 (103) };

  check (f1 ());
  check (f2 (), 2);
  check (f3 (), 3);

  check (x1);
  check (x2, 20);
  check (x3, 30);
  for (unsigned int i = 0; i < 3; i++)
    check (y1[i]);
  for (unsigned int i = 0; i < 4; i++)
    check (y2[i], i + 100);

  exit (0);
}
