# the set of arches on which libgcj provides gcj and libgcj-javac-placeholder.sh
%define java_arches %{ix86} alpha ia64 ppc ppc64 s390 s390x sparc sparcv9 x86_64
# borrow the definition of nptl_arches from glibc's .spec file
%define nptl_arches %{ix86}       ia64 ppc ppc64 s390 s390x       sparcv9 x86_64
# define nptl_java_arches to be the intersection of java_arches and nptl_arches
%define nptl_java_arches %{ix86}  ia64 ppc ppc64 s390 s390x       sparcv9 x86_64

# compatibility with legacy versions of rpm
%{!?_lib:%define _lib	lib}

%define	__soversion	4.2
%define	_libdb_a	libdb-%{__soversion}.a
%define	_libcxx_a	libdb_cxx-%{__soversion}.a

Summary: The Berkeley DB database library (version 4) for C.
Name: db4
Version: 4.2.52
Release: 6.gnupro.1
Source: http://www.sleepycat.com/update/%{version}/db-%{version}.tar.gz
Source1: http://www.sleepycat.com/update/1.85/db.1.85.tar.gz
Source2: nptl-abi-note.S
Patch0: db-4.1.25-no-jni-includes.patch
Patch1: db-4.2.52-java.patch
Patch2: patch.4.2.52.1
Patch3: patch.4.2.52.2
Patch4: db-4.2.52-gcj.patch
Patch10: http://www.sleepycat.com/update/1.85/patch.1.1
Patch11: http://www.sleepycat.com/update/1.85/patch.1.2
Patch12: http://www.sleepycat.com/update/1.85/patch.1.3
Patch13: http://www.sleepycat.com/update/1.85/patch.1.4
Patch14: db-1.85-errno.patch
Patch1000: db-4.1.25-cross.patch

URL: http://www.sleepycat.com/
License: GPL
Group: System Environment/Libraries
Obsoletes: db1, db1-devel
%if "%{_arch}" == %{_build_arch}
BuildPreReq: perl, libtool, ed, tcl-devel >= 8.4.4
%else
BuildPreReq: tcl-devel >= 8.4.4
%endif
%ifarch %{java_arches}
BuildPreReq: gcc-java
%endif
BuildRoot: %{_tmppath}/%{name}-root

%description
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. The Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. The Berkeley DB supports C, C++, Java, and Perl APIs. It is
used by many applications, including Python and Perl, so this should
be installed on all systems.

%package utils
Summary: Command line tools for managing Berkeley DB (version 4) databases.
Group: Applications/Databases
Requires: db4 = %{version}-%{release}
Obsoletes: db2-utils, db3-utils

%description utils
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. DB supports C, C++, Java and Perl APIs.

This package contains command line tools for managing Berkeley DB
(version 4) databases.

%package devel
Summary: Development files for the Berkeley DB (version 4) library.
Group: System Environment/Libraries
Requires: db4 = %{version}-%{release}
Obsoletes: db2-devel, db3-devel

%description devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the header files,
libraries, and documentation for building programs which use the
Berkeley DB.

%package tcl
Summary: Development files for using the Berkeley DB (version 4) with tcl.
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description tcl
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in Tcl.

%package java
Summary: Development files for using the Berkeley DB (version 4) with Java.
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description java
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in Java.

%prep
%setup -q -n db-%{version} -a 1
#%patch0 -p1 -b .no-jni-includes
%patch1 -p1 -b .java
%patch2 -p0 -b .4.2.52.1
%patch3 -p0 -b .4.2.52.2
%patch4 -p1 -b .gcj
pushd dist
libtoolize --copy --force
cp -f %{_datadir}/aclocal/libtool.m4 aclocal/libtool.ac
popd
pushd db.1.85/PORT/linux
%patch10 -p0 -b .1
popd
pushd db.1.85
%patch11 -p0 -b .1
%patch12 -p0 -b .2
%patch13 -p0 -b .3
%patch14 -p1 -b .errno
popd

%if "%{_arch}" != %{_build_arch}
%patch1000 -p1 -b .cross
%endif

# Remove tags files which we don't need.
find . -name tags | xargs rm -f
# Define a shell function for fixing HREF references in the docs, which
# would otherwise break when we split the docs up into subpackages.
fixup_href() {
    for doc in $@ ; do
        chmod u+w ${doc}
        sed -e 's,="../api_c/,="../../%{name}-devel-%{version}/api_c/,g' \
            -e 's,="api_c/,="../%{name}-devel-%{version}/api_c/,g' \
            -e 's,="../api_cxx/,="../../%{name}-devel-%{version}/api_cxx/,g' \
            -e 's,="api_cxx/,="../%{name}-devel-%{version}/api_cxx/,g' \
            -e 's,="../api_java/,="../../%{name}-devel-%{version}/api_java/,g' \
            -e 's,="api_java/,="../%{name}-devel-%{version}/api_java/,g' \
            -e 's,="../api_tcl/,="../../%{name}-devel-%{version}/api_tcl/,g' \
            -e 's,="api_tcl/,="../%{name}-devel-%{version}/api_tcl/,g' \
            -e 's,="../examples_c/,="../../%{name}-devel-%{version}/examples_c/,g' \
            -e 's,="examples_c/,="../%{name}-devel-%{version}/examples_c/,g' \
            -e 's,="../examples_cxx/,="../../%{name}-devel-%{version}/examples_cxx/,g' \
            -e 's,="examples_cxx/,="../%{name}-devel-%{version}/examples_cxx/,g' \
            -e 's,="../ref/,="../../%{name}-devel-%{version}/ref/,g' \
            -e 's,="ref/,="../%{name}-devel-%{version}/ref/,g' \
            -e 's,="../sleepycat/,="../../%{name}-devel-%{version}/sleepycat/,g' \
            -e 's,="sleepycat/,="../%{name}-devel-%{version}/sleepycat/,g' \
            -e 's,="../images/,="../../%{name}-%{version}/images/,g' \
            -e 's,="images/,="../%{name}-%{version}/images/,g' \
            -e 's,="../utility/,="../../%{name}-utils-%{version}/utility/,g' \
            -e 's,="utility/,="../%{name}-utils-%{version}/utility/,g' ${doc} > ${doc}.new
        touch -r ${doc} ${doc}.new
        cat ${doc}.new > ${doc}
        touch -r ${doc}.new ${doc}
        rm -f ${doc}.new
    done
}

set +x	# XXX painful to watch
# Fix all of the HTML files.
fixup_href `find . -name "*.html"`
set -x	# XXX painful to watch

cd dist
./s_config

%build
CFLAGS="$RPM_OPT_FLAGS"; export CFLAGS
%if "%{_arch}" != %{_build_arch}
AR=%{__ar}; export AR
CC="%{__cc}"; export CC
RANLIB=%{__ranlib}; export RANLIB
%_update_config
%endif

# Build the old db-185 libraries.
make -C db.1.85/PORT/%{_os} OORG="$CFLAGS"

build() {
	test -d dist/$1 || mkdir dist/$1
	# Static link db_dump185 with old db-185 libraries.
	/bin/sh libtool --mode=compile %{__cc} $RPM_OPT_FLAGS -Idb.1.85/PORT/%{_os}/include -D_REENTRANT -c db_dump185/db_dump185.c -o dist/$1/db_dump185.lo
	/bin/sh libtool --mode=link    %{__cc} -o dist/$1/db_dump185 dist/$1/db_dump185.lo db.1.85/PORT/%{_os}/libdb.a
	pushd dist/$1
	# Force the threading model used, for selecting whether or not we will
	# depend on NPTL-specific features.
	echo ${2:+db_cv_mutex=$2} > config.cache
	if test -n "$nptl_lo" ; then
		/bin/sh libtool --mode=compile %{__cc} $RPM_OPT_FLAGS \
			-o $nptl_lo -c $nptl_s
	fi
	ln -sf ../configure .
	# XXX --enable-diagnostic should be disabled for production (but is
	# useful).
	# XXX --enable-debug_{r,w}op should be disabled for production.
	%configure -C \
		--enable-compat185 --enable-dump185 \
		--enable-shared --enable-static --enable-rpc \
%if "%{_arch}" == %{_build_arch}
		--enable-tcl --with-tcl=%{_libdir} \
%else
		--enable-tcl --with-tcl=%{_sysroot}%{_libdir} \
		--with-tclconfig=%{_sysroot}%{_libdir} \
%endif
		--enable-cxx \
%ifarch %{java_arches}
		--enable-java \
%else
		--disable-java \
%endif
%if "%{_arch}" == %{_build_arch}
		--enable-test \
%endif
		# --enable-diagnostic \
		# --enable-debug --enable-debug_rop --enable-debug_wop \

%if "%{_arch}" != %{_build_arch}
	# Fix TCL include path
	perl -pi -e 's@-I/usr@-I%{_sysroot}/usr@' Makefile
%endif

	# Remove libtool predep_objects and postdep_objects wonkiness so that
	# building without -nostdlib doesn't include them twice.  Because we
	# already link with g++, weird stuff happens if you don't let the
	# compiler handle this.
	perl -pi -e 's/^predep_objects=".*$/predep_objects=""/' libtool
	perl -pi -e 's/^postdep_objects=".*$/postdep_objects=""/' libtool
	perl -pi -e 's/-shared -nostdlib/-shared/' libtool

	make libdb=%{_libdb_a} libcxx=%{_libcxx_a} %{?_smp_mflags} \
		 LIBSO_LIBS='$(LIBS)'" $nptl_lo" \
		LIBXSO_LIBS='$(LIBS)'" $nptl_lo" \
		LIBJSO_LIBS='$(LIBS)'" $nptl_lo" \
		LIBTSO_LIBS='$(LIBS)'" $nptl_lo"

	# XXX hack around libtool not creating ./libs/libdb_java-X.Y.lai
	LDBJ=./.libs/libdb_java-%{__soversion}.la
	if test -f ${LDBJ} -a ! -f ${LDBJ}i; then
	    sed -e 's,^installed=no,installed=yes,' < ${LDBJ} > ${LDBJ}i
	fi

	popd
}

%ifarch %{nptl_arches}
unset nptl_s nptl_lo
case %{_os} in
linux|Linux)
	nptl_s=$RPM_SOURCE_DIR/nptl-abi-note.S
	nptl_lo=nptl-abi-note.lo
	;;
esac
build dist-tls POSIX/pthreads/library
unset nptl_s nptl_lo
%endif
build dist-notls POSIX/pthreads/library/private

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
%ifarch %{nptl_arches}
%makeinstall -C dist/dist-tls

# XXX Nuke non-versioned archives.
rm -f $RPM_BUILD_ROOT/%{_libdir}/{libdb.a,libdb_cxx.a}

chmod +x $RPM_BUILD_ROOT/%{_libdir}/*.so*
mkdir -p ${RPM_BUILD_ROOT}{/%{_lib},%{_libdir}}/tls
mv $RPM_BUILD_ROOT/%{_libdir}/libdb*%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/tls/
%else
mkdir -p ${RPM_BUILD_ROOT}{/%{_lib},%{_libdir}}
%endif
%makeinstall -C dist/dist-notls

# XXX Nuke non-versioned archives.
rm -f $RPM_BUILD_ROOT/%{_libdir}/{libdb.a,libdb_cxx.a}

chmod +x $RPM_BUILD_ROOT/%{_libdir}/*.so*

# Move the main shared library to lib directory, but leave the unversioned .so
# symlink in the usual place to link against.
if [ "%{_libdir}" != "/%{_lib}" ]; then
	# Move the non-tls library.
	mv $RPM_BUILD_ROOT/%{_libdir}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_lib}/
	# Move the tls library, if we have one.
	mkdir -p $RPM_BUILD_ROOT/%{_lib}/tls
	if test -e $RPM_BUILD_ROOT/%{_libdir}/tls/libdb-%{__soversion}.so ; then
		mv $RPM_BUILD_ROOT/%{_libdir}/tls/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_lib}/tls/
	fi
	# Leave relative symlinks in %{_libdir}.
	touch $RPM_BUILD_ROOT/rootfile
	root=..
	while [ ! -e $RPM_BUILD_ROOT/%{_libdir}/${root}/rootfile ] ; do
		root=${root}/..
	done
	rm $RPM_BUILD_ROOT/rootfile
	ln -sf ${root}/%{_lib}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/libdb.so
	ln -sf ${root}/%{_lib}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/
	# Leave relative symlinks in %{_libdir}/tls.
	if test -e $RPM_BUILD_ROOT/%{_lib}/tls/libdb-%{__soversion}.so ; then
		ln -sf ${root}/../%{_lib}/tls/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/tls/
	fi
fi

# Move the x86 libraries into platform-specific subdirectories so that the
# tls-enabled glibc doesn't try to use NPTL-dependent libdb on real i386s,
# because it doesn't provide an NPTL libpthread for that platform.
%ifarch %{ix86}
case %{_target_platform} in
	i386*|i486*) arches="i486 i586 i686";;
	i586*) arches="i586 i686";;
	i686*) arches="i686";;
	athlon*) arches="athlon";;
	*) arches=%{_target_cpu};;
esac
# "Move" the libraries by linking them.
for targetarch in $arches ; do
	mkdir -p $RPM_BUILD_ROOT/%{_libdir}/tls/${targetarch}
	ln $RPM_BUILD_ROOT/%{_libdir}/tls/lib* $RPM_BUILD_ROOT/%{_libdir}/tls/${targetarch}/
	if [ "%{_libdir}" != "/%{_lib}" ]; then
		mkdir -p $RPM_BUILD_ROOT/%{_lib}/tls/${targetarch}
		ln $RPM_BUILD_ROOT/%{_lib}/tls/lib* $RPM_BUILD_ROOT/%{_lib}/tls/${targetarch}/
	fi
done
rm $RPM_BUILD_ROOT/{%{_lib},%{_libdir}}/tls/lib*

# Now fix the symlinks.
if [ "%{_libdir}" != "/%{_lib}" ]; then
	# In with the new.
	for targetarch in $arches ; do
		mkdir -p $RPM_BUILD_ROOT/%{_libdir}/tls/${targetarch}
		ln -sf ${root}/../../%{_lib}/tls/${targetarch}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/tls/${targetarch}/
	done
fi
%endif

# Move the header files to a subdirectory, in case we're deploying on a
# system with multiple versions of DB installed.
mkdir -p $RPM_BUILD_ROOT/%{_includedir}/db4
mv $RPM_BUILD_ROOT/%{_includedir}/*.h $RPM_BUILD_ROOT/%{_includedir}/db4/

# Create symlinks to includes so that "use <db.h> and link with -ldb" works.
for i in db.h db_cxx.h db_185.h; do
	ln -s db4/$i $RPM_BUILD_ROOT%{_includedir}
done

%ifarch %{java_arches}
# Move java jar file to the correct place
mkdir -p $RPM_BUILD_ROOT%{_datadir}/java
mv $RPM_BUILD_ROOT%{_libdir}/*.jar $RPM_BUILD_ROOT%{_datadir}/java
%endif

# Eliminate installed doco
rm -rf ${RPM_BUILD_ROOT}%{_prefix}/docs

%clean
rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post -p /sbin/ldconfig tcl

%postun -p /sbin/ldconfig tcl

%post -p /sbin/ldconfig java

%postun -p /sbin/ldconfig java

%files
%defattr(-,root,root)
%doc LICENSE README docs/images
/%{_lib}/libdb-%{__soversion}.so
%{_libdir}/libdb-%{__soversion}.so
%{_libdir}/libdb_cxx-%{__soversion}.so
%ifarch %{nptl_arches}
%ifarch %{ix86}
/%{_lib}/tls/*/libdb-%{__soversion}.so
%{_libdir}/tls/*/libdb-%{__soversion}.so
%{_libdir}/tls/*/libdb_cxx-%{__soversion}.so
%else
/%{_lib}/tls/libdb-%{__soversion}.so
%{_libdir}/tls/libdb-%{__soversion}.so
%{_libdir}/tls/libdb_cxx-%{__soversion}.so
%endif
%endif

%files utils
%defattr(-,root,root)
%doc	docs/utility
%{_bindir}/berkeley_db*_svc
%{_bindir}/db*_archive
%{_bindir}/db*_checkpoint
%{_bindir}/db*_deadlock
%{_bindir}/db*_dump*
%{_bindir}/db*_load
%{_bindir}/db*_printlog
%{_bindir}/db*_recover
%{_bindir}/db*_stat
%{_bindir}/db*_upgrade
%{_bindir}/db*_verify

%files devel
%defattr(-,root,root)
%doc	docs/api_c docs/api_cxx docs/api_tcl docs/index.html
%doc	docs/ref docs/sleepycat
%doc	examples_c examples_cxx
%{_libdir}/libdb.so
%{_libdir}/libdb-%{__soversion}.la
%{_libdir}/libdb_cxx-%{__soversion}.la
%{_libdir}/%{_libdb_a}
%{_libdir}/%{_libcxx_a}
%{_includedir}/%{name}
%{_includedir}/*.h

%files tcl
%defattr(-,root,root)
%{_libdir}/libdb_tcl-%{__soversion}.a
%{_libdir}/libdb_tcl-%{__soversion}.la
%{_libdir}/libdb_tcl-%{__soversion}.so
%ifarch %{nptl_arches}
%ifnarch %{ix86}
%{_libdir}/tls/libdb_tcl-%{__soversion}.so
%else
%{_libdir}/tls/*/libdb_tcl-%{__soversion}.so
%endif
%endif

%ifarch %{java_arches}
%files java
%defattr(-,root,root)
%doc docs/java
%doc examples_java
%{_libdir}/libdb_java*
%{_datadir}/java/*.jar
%endif
%ifarch %{nptl_java_arches}
%ifnarch %{ix86}
%{_libdir}/tls/libdb_java*
%else
%{_libdir}/tls/*/libdb_java*
%endif
%endif

%changelog
* Tue Sep 21 2004 Nalin Dahyabhai <nalin@redhat.com> 4.2.52-6
- on %%{ix86} systems, make the availability of an NPTL-requiring libdb match
  the availability of an NPTL libpthread in glibc > 2.3.3-48
- run ldconfig in db4-java's %%post/%%postun
- when building java support, assume that libgcj is equivalent enough to 1.3

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Jun  7 2004 Jeff Johnson <jbj@jbj.org> 4.2.52-4
- remove dangling symlinks (#123721 et al).
- remove db_cxx.so and db_tcl.so symlinks, versioned equivs exist.
- apply 2 patches from sleepycat.
- resurrect db4-java using sun jvm-1.4.2.
- cripple autoconf sufficiently to build db4-java with gcj, without jvm.
- check javac first, gcj34 next, then gcj-ssa, finally gcj.
- add ed build dependency (#125180).

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Jan 16 2004 Jeff Johnson <jbj@jbj.org> 4.2.52-2
- fix: automake *.lo wrapper, not elf, files included in *.a (#113572).

* Thu Dec 11 2003 Jeff Johnson <jbj@jbj.org> 4.2.52-1
- upgrade to db-4.2.52, no db4-java for the moment.

* Fri Nov 28 2003 Paul Nasrat <pauln@truemesh.com> 4.2.41-0.2
- Add build requires tcl-devel

* Fri Oct 24 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-14
- symlink from %%{_libdir}/tls/libdb-4.1.so to the copy in /%%{_lib}/tls, so
  that the run-time linker can find the right copy for of apps which use an
  RPATH to point at %%{_libdir}/libdb-4.1.so

* Thu Oct 23 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-13
- add another section to the ABI note for the TLS libdb so that it's marked as
  not needing an executable stack (from Arjan Van de Ven)

* Wed Oct 15 2003 Nalin Dahyabhai <nalin@redhat.com>
- build both with and without support for shared mutex locks, which require NPTL
- make behavior wrt where we put libdb the same for all OSs
- revert changes making tcl optional - nesting %%if tcl and %%ifarch nptl
  doesn't work
- fix dangling HREFs in utility docs (pointed to main docs dir, while they're
  actually in the -utils docs dir)
- run ldconfig when installing/removing the -utils subpackage, as it contains
  shared libraries

* Wed Oct 15 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-11
- fix multiple-inclusion problem of startup files when building shlibs without
  the -nostdlib flag

* Tue Oct 14 2003 Nalin Dahyabhai <nalin@redhat.com>
- link shared libraries without -nostdlib, which created an unresolvable dep
  on a hidden symbol

* Tue Sep 23 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- allow compiling without tcl dependency

* Sat Sep 20 2003 Jeff Johnson <jbj@jbj.org> 4.2.42-0.1
- update to 4.2.42.
- build in build_unix subdir.
- eliminate --enable-dump185, db_dump185.c no longer compiles for libdb*.
- create db4-tcl sub-pkg to isolate libtcl dependencies.

* Thu Aug 21 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-9
- rebuild

* Tue Aug 19 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-8
- add missing tcl-devel buildrequires (#101814)

* Tue Jul 15 2003 Joe Orton <jorton@redhat.com> 4.1.25-7
- rebuild

* Fri Jun 27 2003 Jeff Johnson <jbj@redhat.com> 4.1.25-6
- build with libtool-1.5, which can't recognize the .so in libfoo*.so atm.
- whack out libtool predep_objects wonkiness.

* Thu Jun 26 2003 Jeff Johnson <jbj@redhat.com> 4.1.25-5
- rebuild.

* Tue Jun 24 2003 Jeff Johnson <jbj@redhat.com> 4.1.25-4
- hack out O_DIRECT support in db4 for now.

* Tue Jun 24 2003 Nalin Dahyabhai <nalin@redhat.com>
- replace libtool.ac with current libtool.m4 so that running libtoolize doesn't
  cause a mismatch

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun  4 2003 Nalin Dahyabhai <nalin@redhat.com> 4.1.25-2
- change configure to only warn if JNI includes aren't found, assuming that
  the C compiler can find them
- remove build requirement on jdkgcj -- gcj is sufficient

* Mon May  5 2003 Jeff Johnson <jbj@redhat.com> 4.1.25-1
- upgrade to 4.1.25, crypto version.
- enable posix mutexes using nptl on all arches.

* Mon Mar  3 2003 Thoams Woerner <twoerner@redhat.com> 4.0.14-21
- enabled db4-java for x86_64

* Wed Feb  5 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-20
- add dynamic libdb-4.0.so link back to %%{_libdir} so that dynamically
  linking with -ldb-4.0 will work again

* Tue Feb  4 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-19
- rebuild to use link the shared object with the same libraries we use
  for the bundled utils, should pull in libpthread when needed
- move libdb.so from /%%{_lib} to %%{_libdir} where the linker can find it

* Sun Feb 02 2003 Florian La Roche <Florian.LaRoche@redhat.de> 4.0.14-18
- add java for s390x

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 4.0.14-17
- rebuilt

* Wed Nov 20 2002 Florian La Roche <Florian.LaRoche@redhat.de> 4.0.14-16
- add java for s390

* Tue Oct  8 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-15
- add java bits back in for x86 boxes

* Fri Sep 20 2002 Than Ngo <than@redhat.com> 4.0.14-14.1
- Added better fix for s390/s390x/x86_64

* Thu Sep 05 2002 Arjan van de Ven
- remove java bits for x86-64

* Tue Aug 27 2002 Jeff Johnson <jbj@redhat.com> 4.0.14-14
- include libdb_tcl-4.1.a library.
- obsolete db1 packages.

* Tue Aug 13 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-13
- include patch to avoid db_recover (#70362)

* Sat Aug 10 2002 Elliot Lee <sopwith@redhat.com>
- rebuilt with gcc-3.2 (we hope)

* Tue Jul 23 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-11
- own %%{_includedir}/%{name}

* Tue Jul 23 2002 Tim Powers <timp@redhat.com> 4.0.14-10
- build using gcc-3.2-0.1

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 12 2002 Bernhard Rosenkraenzer <bero@redhat.com> 4.0.14-8
- Add java bindings
- Fix C++ bindings

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May  9 2002 Jeff Johnson <jbj@redhat.com>
- re-enable db.h symlink creation, db_util names, and db[23]-devel obsoletes.
- make sure that -ldb is functional.

* Thu Feb 21 2002 Jeff Johnson <jbj@redhat.com>
- avoid db_util name collisions with multiple versions installed.

* Mon Feb 18 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-3
- remove relocatability stuffs
- swallow a local copy of db1 and build db185_dump statically with it, to
  remove the build dependency and simplify bootstrapping new arches

* Mon Jan 27 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.14-2
- have subpackages obsolete their db3 counterparts, because they conflict anyway

* Tue Jan  8 2002 Jeff Johnson <jbj@redhat.com> db4-4.0.14-1
- upgrade to 4.0.14.

* Sun Aug  5 2001 Nalin Dahyabhai <nalin@redhat.com>
- fix dangling docs symlinks
- fix dangling doc HREFs (#33328)
- apply the two patches listed at http://www.sleepycat.com/update/3.2.9/patch.3.2.9.html

* Tue Jun 19 2001 Bill Nottingham <notting@redhat.com>
- turn off --enable-debug

* Thu May 10 2001 Than Ngo <than@redhat.com>
- fixed to build on s390x

* Mon Mar 19 2001 Jeff Johnson <jbj@redhat.com>
- update to 3.2.9.

* Tue Dec 12 2000 Jeff Johnson <jbj@redhat.com>
- rebuild to remove 777 directories.

* Sat Nov 11 2000 Jeff Johnson <jbj@redhat.com>
- don't build with --enable-diagnostic.
- add build prereq on tcl.
- default value for %%_lib macro if not found.

* Tue Oct 17 2000 Jeff Johnson <jbj@redhat.com>
- add /usr/lib/libdb-3.1.so symlink to %%files.
- remove dangling tags symlink from examples.

* Mon Oct  9 2000 Jeff Johnson <jbj@redhat.com>
- rather than hack *.la (see below), create /usr/lib/libdb-3.1.so symlink.
- turn off --enable-diagnostic for performance.

* Fri Sep 29 2000 Jeff Johnson <jbj@redhat.com>
- update to 3.1.17.
- disable posix mutexes Yet Again.

* Tue Sep 26 2000 Jeff Johnson <jbj@redhat.com>
- add c++ and posix mutex support.

* Thu Sep 14 2000 Jakub Jelinek <jakub@redhat.com>
- put nss_db into a separate package

* Wed Aug 30 2000 Matt Wilson <msw@redhat.com>
- rebuild to cope with glibc locale binary incompatibility, again

* Wed Aug 23 2000 Jeff Johnson <jbj@redhat.com>
- remove redundant strip of libnss_db* that is nuking symbols.
- change location in /usr/lib/libdb-3.1.la to point to /lib (#16776).

* Thu Aug 17 2000 Jeff Johnson <jbj@redhat.com>
- summaries from specspo.
- all of libdb_tcl* (including symlinks) in db3-utils, should be db3->tcl?

* Wed Aug 16 2000 Jakub Jelinek <jakub@redhat.com>
- temporarily build nss_db in this package, should be moved
  into separate nss_db package soon

* Wed Jul 19 2000 Jakub Jelinek <jakub@redhat.com>
- rebuild to cope with glibc locale binary incompatibility

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 11 2000 Jeff Johnson <jbj@redhat.com>
- upgrade to 3.1.14.
- create db3-utils sub-package to hide tcl dependency, enable tcl Yet Again.
- FHS packaging.

* Mon Jun  5 2000 Jeff Johnson <jbj@redhat.com>
- disable tcl Yet Again, base packages cannot depend on libtcl.so.

* Sat Jun  3 2000 Jeff Johnson <jbj@redhat.com>
- enable tcl, rebuild against tcltk 8.3.1 (w/o pthreads).

* Tue May 30 2000 Matt Wilson <msw@redhat.com>
- include /lib/libdb.so in the devel package

* Wed May 10 2000 Jeff Johnson <jbj@redhat.com>
- put in "System Environment/Libraries" per msw instructions.

* Tue May  9 2000 Jeff Johnson <jbj@redhat.com>
- install shared library in /lib, not /usr/lib.
- move API docs to db3-devel.

* Mon May  8 2000 Jeff Johnson <jbj@redhat.com>
- don't rename db_* to db3_*.

* Tue May  2 2000 Jeff Johnson <jbj@redhat.com>
- disable --enable-test --enable-debug_rop --enable-debug_wop.
- disable --enable-posixmutexes --enable-tcl as well, to avoid glibc-2.1.3
  problems.

* Mon Apr 24 2000 Jeff Johnson <jbj@redhat.com>
- add 3.0.55.1 alignment patch.
- add --enable-posixmutexes (linux threads has not pthread_*attr_setpshared).
- add --enable-tcl (needed -lpthreads).

* Sat Apr  1 2000 Jeff Johnson <jbj@redhat.com>
- add --enable-debug_{r,w}op for now.
- add variable to set shm perms.

* Sat Mar 25 2000 Jeff Johnson <jbj@redhat.com>
- update to 3.0.55

* Tue Dec 29 1998 Jeff Johnson <jbj@redhat.com>
- Add --enable-cxx to configure.

* Thu Jun 18 1998 Jeff Johnson <jbj@redhat.com>
- Create.
