/* checksum.h: asm-assisted checksumming code
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_CHECKSUM_H
#define _ASM_CHECKSUM_H

extern unsigned int csum_partial(const unsigned char * buff, int len,
				 unsigned int sum);
extern unsigned int csum_partial_copy_nocheck(const char *src, char *dst,
					      int len, int sum);
extern unsigned int csum_partial_copy_from_user(const char *src, char *dst,
						int len, unsigned int sum,
						int *err_ptr);
extern unsigned short ip_fast_csum(unsigned char * iph, unsigned int ihl);
extern unsigned int csum_partial(const unsigned char * buff, int len,
				 unsigned int sum);
extern unsigned short ip_compute_csum(unsigned char * buff, int len);

#define csum_partial_copy_fromuser csum_partial_copy
extern unsigned int csum_partial_copy(const char *src, char *dst, int len,
				      unsigned int sum);

static inline unsigned int csum_fold(unsigned int sum)
{
	asm(
		"	add	%1,%0		\n"
		"	addc	0xffff,%0	\n"
		: "=r" (sum)
		: "r" (sum << 16), "0" (sum & 0xffff0000)
		: "cc"
		);
	return (~sum) >> 16;
}

static inline unsigned long csum_tcpudp_nofold(unsigned long saddr,
					       unsigned long daddr,
					       unsigned short len,
					       unsigned short proto,
					       unsigned int sum)
{
	unsigned long tmp;

	tmp = (unsigned long) ntohs(len) << 16;
	tmp += (unsigned long) proto << 8;

	asm(
		"	add	%1,%0		\n"
		"	addc	%2,%0		\n"
		"	addc	%3,%0		\n"
		"	addc	0,%0		\n"
		: "=r" (sum)
		: "r" (daddr), "r"(saddr), "r"(tmp), "0"(sum)
		: "cc"
		);
	return sum;
}

/*
 * computes the checksum of the TCP/UDP pseudo-header
 * returns a 16-bit checksum, already complemented
 */
static inline unsigned short int csum_tcpudp_magic(unsigned long saddr,
						   unsigned long daddr,
						   unsigned short len,
						   unsigned short proto,
						   unsigned int sum)
{
	return csum_fold(csum_tcpudp_nofold(saddr, daddr, len, proto, sum));
}

#undef _HAVE_ARCH_IPV6_CSUM

/*
 *	Copy and checksum to user
 */
#define HAVE_CSUM_COPY_USER
extern unsigned int csum_and_copy_to_user(const char *src, char *dst, int len,
					  unsigned int sum, int *err_ptr);


#endif /* _ASM_CHECKSUM_H */
