;; A first example of using threads that really shows that two threads
;; are running.  This example works with cooperative threads (should
;; also work with preemptive threads).

(require 'debug)

(newline) (newline)

(define (sample-thread delay)
  (begin
    (monitor
     (print "this thread was invoked with a delay of " delay)
     (print "About to go to sleep:"))
    (force-output)
    (sleep delay)
    (monitor
     (print delay "-> done with sleeping"))
    (force-output)))

;; arrange the threads we are creating in a list
(define list-of-threads (list (make-thread (lambda () (sample-thread 40)))
			      (make-thread (lambda () (sample-thread 90)))
			      (make-thread (lambda () (sample-thread 70)))
			      (make-thread (lambda () (sample-thread 55)))))

;; now invoke join-thread: this makes sure that the guile "read"
;; statement (which waits for the next scheme expression) does not
;; block out the threads: join-thread will make sure they have all
;; finished executing.
(for-each join-thread list-of-threads)

(newline) (newline)
(print "all threads seem to have terminated")
