Name: reiserfs-utils
Version: 3.6.18
Release: 1
Summary: Tools for creating, repairing, and debugging ReiserFS filesystems.
URL: http://www.namesys.com/
Source: ftp://namesys.com/pub/reiserfsprogs/reiserfsprogs-%{version}.tar.gz
License: GPL
Group: System Environment/Base
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-root
Epoch: 2
# Not big-endian safe as of 2002-12-11 -ECL
ExclusiveArch: %{ix86} ia64 alpha x86_64

%description
The reiserfs-utils package contains a number of utilities for
creating, checking, modifying, and correcting any inconsistencies in
ReiserFS filesystems, including reiserfsck (used to repair filesystem
inconsistencies), mkreiserfs (used to initialize a partition to
contain an empty ReiserFS filesystem), debugreiserfs (used to examine
the internal structure of a filesystem, to manually repair a corrupted
filesystem, or to create test cases for reiserfsck), and some other
ReiserFS filesystem utilities.

You should install the reiserfs-utils package if you want to use
ReiserFS on any of your partitions.

%{name} contains reiserfsck (used to repair filesystem
%prep
%setup -n reiserfsprogs-%{version}

%build
export CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"
find . -name "config.cache" |xargs rm -f
%configure --prefix=/
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT"
mv -f $RPM_BUILD_ROOT/usr/sbin $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 debugreiserfs/debugreiserfs.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 fsck/reiserfsck.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 mkreiserfs/mkreiserfs.8 $RPM_BUILD_ROOT%{_mandir}/man8
( cd $RPM_BUILD_ROOT/sbin
  ln -fs mkreiserfs mkfs.reiserfs
  ln -fs reiserfsck fsck.reiserfs )

%files
%defattr(-,root,root)
%doc README
/sbin/debugreiserfs
/sbin/mkreiserfs
/sbin/reiserfsck
/sbin/resize_reiserfs
/sbin/reiserfstune
/sbin/mkfs.reiserfs
/sbin/fsck.reiserfs
%{_mandir}/*/*

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/%{name}-%{version}

%changelog
* Tue Oct 12 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- 3.6.18

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 09 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- 3.6.17

* Sat Mar 06 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- Use %%ix86 macro, this got dropped with my previous update

* Thu Mar 04 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- 3.6.13

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Aug 28 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 3.6.11

* Sat May 31 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 3.6.8

* Wed Apr 30 2003 Elliot Lee <sopwith@redhat.com> 2:3.6.4-6
- Change ExcludeArch to ExclusiveArch to better handle the future of computing

* Thu Feb 06 2003 Phil Knirsch <pknirsch@redhat.com> 2:3.6.4-5
- Bumped release and rebuilt
- Removed s390 and s390x again until i get around fixing the bitops related
  stuff (which is borken on big-endian).

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 2:3.6.4-4
- rebuilt

* Sun Dec 01 2002 Elliot Lee <sopwith@redhat.com> 2:3.6.4-3
- For real

* Wed Nov 27 2002 Tim Powers <timp@redhat.com> 2:3.6.4-2
- build on all arches

* Mon Nov 11 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 3.6.4

* Fri Jul 19 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- also compile on mainframe
- update epoch

* Mon Jul 15 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- update to version 3.6.2, all additional patches are not needed anymore

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Jan 15 2002 Tim Powers <timp@ragnarok.devel.redhat.com>
- rebuilt with tool toolchain

* Tue Jan 15 2002 Tim Powers <timp@redhat.com>
- rebuilt, for some reason the build date for the binary is not
  matching the build date for the SRPM.

* Wed Apr 25 2001 Bernhard Rosenkraenzer <bero@redhat.com> 3.x.0j-1
- Update to 3.x.0j

* Mon Mar  5 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Update to 3.x.0f, many important fixes in fsck
- Add missing README (#30556)
- Use -v2 by default in mkreiserfs (#30556)

* Tue Feb 07 2001 Than Ngo <than@redhat.com>
- added Missing symlinks for mkfs and fsck commands (Bug #26359)

* Tue Jan 23 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- initial RPM
- changes from base package:
  - Fix a security problem (yet another tmp file issue)
  - Fix an fd leak
  - Get rid of the config.cache file, it contains broken settings
  - Install man pages
  - Fix locations of binaries, installing this stuff to "bin" is
    not really a good idea
  - Fix build on alpha and ia64
