Summary: Clients for remote access commands (rsh, rlogin, rcp).
Name: rsh
Version: 0.17
Release: 24.1
License: BSD
Group: Applications/Internet
Source: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/netkit-rsh-%{version}.tar.gz
Source1: rexec.pam
Source2: rlogin.pam
Source3: rsh.pam
Source4: http://www.tc.cornell.edu/~sadd/rexec-1.5.tar.gz
Source5: rsh-xinetd
Source6: rlogin-xinetd
Source7: rexec-xinetd
Patch2: netkit-rsh-0.17-sectty.patch
Patch3: netkit-rsh-0.17-rexec.patch
Patch4: netkit-rsh-0.10-stdarg.patch
Patch5: netkit-rsh-0.16-jbj.patch
Patch6: netkit-rsh-0.16-pamfix.patch
Patch7: netkit-rsh-0.16-jbj2.patch
Patch8: netkit-rsh-0.16-jbj3.patch
Patch9: netkit-rsh-0.16-jbj4.patch
Patch10: netkit-rsh-0.16-prompt.patch
Patch11: netkit-rsh-0.16-rlogin=rsh.patch
Patch12: netkit-rsh-0.16-nokrb.patch
Patch13: netkit-rsh-0.17-pre20000412-jbj5.patch
Patch14: netkit-rsh-0.17-userandhost.patch
Patch15: netkit-rsh-0.17-strip.patch
Patch16: netkit-rsh-0.17-lfs.patch
Patch17: netkit-rsh-0.17-chdir.patch
Patch18: netkit-rsh-0.17-pam-nologin.patch
Patch19: netkit-rsh-0.17-nohostcheck.patch
#Patch19: netkit-rsh-0.17-localdomain.patch
Patch20: netkit-rsh-0.17-rexec-netrc.patch
Patch21: netkit-rsh-0.17-rexec-sig.patch

BuildRoot: %{_tmppath}/%{name}-root
BuildPrereq: perl
BuildPrereq: libtermcap-devel

%description
The rsh package contains a set of programs which allow users to run
commands on remote machines, login to other machines and copy files
between machines (rsh, rlogin and rcp).  All three of these commands
use rhosts style authentication.  This package contains the clients
needed for all of these services.
The rsh package should be installed to enable remote access to other
machines.

%package server
Summary: Servers for remote access commands (rsh, rlogin, rcp).
Group: System Environment/Daemons
Requires: pam >= 0.59, /etc/pam.d/system-auth

%description server
The rsh-server package contains a set of programs which allow users
to run commands on remote machines, login to other machines and copy
files between machines (rsh, rlogin and rcp).  All three of these
commands use rhosts style authentication.  This package contains the
servers needed for all of these services.  It also contains a server
for rexec, an alternate method of executing remote commands.
All of these servers are run by inetd and configured using
/etc/inetd.conf and PAM.  The rexecd server is disabled by default,
but the other servers are enabled.

The rsh-server package should be installed to enable remote access
from other machines.

%prep
%setup -q -n netkit-rsh-%{version} -a 4
%patch2 -p1 -b .sectty
%patch3 -p1 -b .rexec
%patch4 -p1 -b .stdarg
%patch5 -p1 -b .jbj
# XXX patches {6,7,8} not applied
#%patch6 -p1 -b .pamfix
#%patch7 -p1 -b .jbj2
#%patch8 -p1 -b .jbj3
%patch9 -p1 -b .jbj4
%patch10 -p1 -b .prompt
%patch11 -p1 -b .rsh
%patch12 -p1 -b .rsh.nokrb
%patch13 -p1 -b .jbj5
%patch14 -p1 -b .userandhost
%patch15 -p1 -b .strip
%patch16 -p1 -b .lfs
%patch17 -p1 -b .chdir
%patch18 -p1 -b .pam-nologin
%patch19 -p1 -b .nohostcheck
%patch20 -p1 -b .rexec-netrc
%patch21 -p1 -b .rexec-sig

# No, I don't know what this is doing in the tarball.
rm -f rexec/rexec

%build
sh configure --with-c-compiler=gcc
%ifarch s390 s390x
%{__perl} -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -fPIC -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64,;
    s,^LDFLAGS=,LDFLAGS=-pie,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG
%else
%{__perl} -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -fpic -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64,;
    s,^LDFLAGS=,LDFLAGS=-pie,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG
%endif
make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,5,8}
mkdir -p ${RPM_BUILD_ROOT}/etc/pam.d

make INSTALLROOT=${RPM_BUILD_ROOT} BINDIR=%{_bindir} MANDIR=%{_mandir} install

install -m 644 $RPM_SOURCE_DIR/rexec.pam ${RPM_BUILD_ROOT}/etc/pam.d/rexec
install -m 644 $RPM_SOURCE_DIR/rlogin.pam ${RPM_BUILD_ROOT}/etc/pam.d/rlogin
install -m 644 $RPM_SOURCE_DIR/rsh.pam ${RPM_BUILD_ROOT}/etc/pam.d/rsh

mkdir -p ${RPM_BUILD_ROOT}/etc/xinetd.d/
install -m644 %SOURCE5 ${RPM_BUILD_ROOT}/etc/xinetd.d/rsh
install -m644 %SOURCE6 ${RPM_BUILD_ROOT}/etc/xinetd.d/rlogin
install -m644 %SOURCE7 ${RPM_BUILD_ROOT}/etc/xinetd.d/rexec

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%attr(4755,root,root)	%{_bindir}/rcp
%{_bindir}/rexec
%attr(4755,root,root)	%{_bindir}/rlogin
%attr(4755,root,root)	%{_bindir}/rsh
%{_mandir}/man1/*.1*

%files server
%defattr(-,root,root)
%config	/etc/pam.d/rsh
%config	/etc/pam.d/rlogin
%config	/etc/pam.d/rexec
%{_sbindir}/in.rexecd
%{_sbindir}/in.rlogind
%{_sbindir}/in.rshd
%config(noreplace) /etc/xinetd.d/*
%{_mandir}/man8/*.8*

%changelog
* Sat Dec  4 2004 Karel Zak <kzak@redhat.com> 0.17-24.1
- fixed rexec fails with "Invalid Argument" (#118630)

* Mon Oct 18 2004 Radek Vokal <rvokal@redhat.com> 0.17-24
- The username and password for ~/.netrc are used (#135643)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 12 2004 Phil Knirsch <pknirsch@redhat.com> 0.17-22
- Added all other tools to list of PIE enabled apps.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Feb  5 2004 Thomas Woerner <twoerner@redhat.com> 0.17-20
- in.rexecd, in.rlogind and in.rshd are pie, now

* Tue Oct 21 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-19
- Included updated patch from #105733.

* Thu Oct 02 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-18
- Fixed YAT (#79391).
- Included feature request #105733 (-D option).

* Fri Jun 27 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-17.1
- rebuilt

* Thu Jun 26 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-17
- Included chdir patch (#57392).
- Included pam-nologin patch (#63806).

* Tue Jun 17 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-16
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com> 0.17-15
- rebuilt

* Tue May 06 2003 Phil Knirsch <pknirsch@redhat.com>
- Fixed manpages (#7168).

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Jan 17 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-13
- Added LFS support (#67362).
- Fixed user and host patch (#80822).

* Tue Jan 14 2003 Phil Knirsch <pknirsch@redhat.com> 0.17-12
- Fixed bug #79391 (typo in description).

* Mon Nov 11 2002 Nalin Dahyabhai <nalin@redhat.com> 0.17-11
- remove directory names from PAM configuration files, allowing them to be used
  for all arches on multilib systems

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 19 2002 Phil Knirsch <pknirsch@redhat.com> 0.17-9
- Don't forcibly strip binaries

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 30 2002 Phil Knirsch <pknirsch@redhat.com>
- Bumped version for rebuild
- Added the remote user and host addition (RFE #42880)

* Tue Jul 24 2001 Phil Knirsch <pknirsch@redhat.com>
- Fixed really missing BuildPrereq: libtermcap-devel (#49577)
- Fixed security problem with rexec.pam (#49181)

* Fri Jun 22 2001 Phil Knirsch <pknirsch@redhat.com>
- Update to latest stable version 0.17
- Removed unneeded glib22 patch

* Mon Apr 30 2001 Nalin Dahyabhai <nalin@redhat.com>
- tag xinetd config files as config files

* Wed Apr  4 2001 Jakub Jelinek <jakub@redhat.com>
- don't let configure to guess compiler, it can pick up egcs

* Mon Feb  5 2001 Nalin Dahyabhai <nalin@redhat.com>
- securetty is screwy because rsh doesn't allocate one and rlogin does auth
  before it has a tty, so change the hard-coded TTYs used from "tty" for all
  to "rsh" or "rlogin" or "rexec"

* Tue Oct 10 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix PAM config files to always honor nologin and securetty, to use rhosts,
  and to fall back to password auth only for rlogin and rexec (#17183)
- add references to pam_env to the PAM configs as well (#16170)
- disable rlogin and rsh by default

* Mon Oct 02 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix typo in the rexec xinetd configuration file (#18107)

* Fri Jul 21 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix typo in the rlogin PAM config file
- continue the tradition of messed-up release numbers

* Tue Jul 18 2000 Bill Nottingham <notting@redhat.com>
- add description & default to xinetd file

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.
- update to 0.17.

* Thu Jun  1 2000 Nalin Dahyabhai <nalin@redhat.com>
- modify PAM setup to use system-auth

* Mon May 29 2000 Nalin Dahyabhai <nalin@redhat.com>
- expunge all mentions of kerberos authentication or DES encryption using
  kerberos from the man pages

* Thu May 25 2000 Trond Eivind Glomsrd <teg@redhat.com>
- switched to xinetd

* Tue Mar  7 2000 Jeff Johnson <jbj@redhat.com>
- rebuild for sparc baud rates > 38400.

* Fri Mar 04 2000 Nalin Dahyabhai <nalin@redhat.com>
- make rlogin still work correctly when argv[0] = "rsh"

* Mon Feb 28 2000 Jeff Johnson <jbj@redhat.com>
- workaround (by explicitly prompting for password) #4328 and #9715.

* Wed Feb  9 2000 Jeff Johnson <jbj@redhat.com>
- mark pam config files as %config.

* Fri Feb  4 2000 Bill Nottingham <notting@redhat.com>
- handle compressed manpages

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix description

* Sun Jan 30 2000 Bill Nottingham <notting@redhat.com>
- remove bogus rexec binary when building; it causes weirdness

* Fri Jan 28 2000 Jeff Johnson <jbj@redhat.com>
- Make sure that rshd is compiled with -DUSE_PAM.

* Mon Jan 10 2000 Jeff Johnson <jbj@redhat.com>
- Fix bug in rshd (hangs forever with zombie offspring) (#8313).

* Wed Jan  5 2000 Jeff Johnson <jbj@redhat.com>
- fix the PAM fix yet again (#8133).

* Tue Jan  4 2000 Bill Nottingham <notting@redhat.com>
- split client and server

* Tue Dec 21 1999 Jeff Johnson <jbj@redhat.com>
- update to 0.16.
- dup setuid bits into files list.

* Fri Jul 30 1999 Jeff Johnson <jbj@redhat.com>
- update to rexec-1.5 client (#4262)

* Wed May 19 1999 Jeff Johnson <jbj@redhat.com>
- fix broken rexec protocol in in.rexecd (#2318).

* Tue May  4 1999 Justin Vallon <vallon@mindspring.com>
- rcp with error was tricked by stdarg side effect (#2300)

* Thu Apr 15 1999 Michael K. Johnson <johnsonm@redhat.com>
- rlogin pam file was missing comment magic

* Tue Apr 06 1999 Preston Brown <pbrown@redhat.com>
- strip rexec

* Fri Mar 26 1999 Jeff Johnson <jbj@redhat.com>
- rexec needs pam_set_item() (#60).
- clarify protocol in rexecd.8.
- add rexec client from contrib.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 22)

* Mon Mar 15 1999 Jeff Johnson <jbj@redhat.com>
- compile for 6.0.

* Fri Apr 24 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Apr 14 1998 Erik Troan <ewt@redhat.com>
- built against new ncurses

* Sat Apr  5 1998 Marcelo F. Vianna <m-vianna@usa.net>
- Packaged for RH5.0 (Hurricane)

* Tue Oct 14 1997 Michael K. Johnson <johnsonm@redhat.com>
- new pam conventions

* Tue Jul 15 1997 Erik Troan <ewt@redhat.com>
- initial build
