Summary: A basic system library for accessing the termcap database.
Name: libtermcap
Version: 2.0.8
Release: 39
Source: ftp://metalab.unc.edu/pub/Linux/GCC/termcap-2.0.8.tar.bz2
Url: ftp://metalab.unc.edu/pub/Linux/GCC/
License: LGPL
Group: System Environment/Libraries
Patch0: termcap-2.0.8-shared.patch
Patch1: termcap-2.0.8-setuid.patch
Patch2: termcap-2.0.8-instnoroot.patch
Patch3: termcap-2.0.8-compat21.patch
Patch4: termcap-2.0.8-xref.patch
Patch5: termcap-2.0.8-fix-tc.patch
Patch6: termcap-2.0.8-ignore-p.patch
Patch7: termcap-buffer.patch
# This patch is a REALLY BAD IDEA without patch #10 below....
Patch8: termcap-2.0.8-bufsize.patch
Patch9: termcap-2.0.8-colon.patch
Patch10: libtermcap-aaargh.patch
Patch11: termcap-2.0.8-glibc22.patch
Patch12: libtermcap-2.0.8-ia64.patch
Patch13: termcap-116934.patch
Requires: /etc/termcap
BuildPrereq: texinfo
BuildRoot: /var/tmp/%{name}-root

%description
The libtermcap package contains a basic system library needed to
access the termcap database.  The termcap library supports easy access
to the termcap database, so that programs can output character-based
displays in a terminal-independent manner.

%package devel
Summary: Development tools for programs which will access the termcap database.
Group: Development/Libraries
Requires: libtermcap = %{version}

%description devel
This package includes the libraries and header files necessary for
developing programs which will access the termcap database.

If you need to develop programs which will access the termcap database,
you'll need to install this package.  You'll also need to install the
libtermcap package.

%prep
%setup -q -n termcap-2.0.8
%patch0 -p1
%patch1 -p1
%patch2 -p1 -b .nochown
%patch3 -p1 -b .compat21
%patch4 -p1
%patch5 -p1 -b .fix-tc
%patch6 -p1 -b .ignore-p
%patch7 -p1 -b .buffer
%patch8 -p1 -b .bufsize
%patch9 -p1 -b .colon
%patch10 -p1 -b .aaargh
%patch11 -p1 -b .glibc22
%ifarch ia64
%patch12 -p1 -b .ia64
%endif
%patch13 -p1 -b .116934

%build
make AR=%{__ar} CC=%{__cc} CFLAGS="$RPM_OPT_FLAGS -I."

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/{usr/lib,%{_infodir},usr/include,etc,lib}

export PATH=/sbin:$PATH
make prefix=$RPM_BUILD_ROOT/usr install

install -c -m644 termcap.src $RPM_BUILD_ROOT/etc/termcap
cp termcap.info* $RPM_BUILD_ROOT/%{_infodir}

rm -f $RPM_BUILD_ROOT/etc/termcap
mkdir -p $RPM_BUILD_ROOT/%{_lib} $RPM_BUILD_ROOT/%{_libdir}
mv $RPM_BUILD_ROOT/usr/lib/libtermcap.so* $RPM_BUILD_ROOT/%{_lib}/
ln -sf libtermcap.so.2.0.8 $RPM_BUILD_ROOT/%{_lib}/libtermcap.so.2
ln -sf ../../%{_lib}/libtermcap.so.2.0.8 $RPM_BUILD_ROOT/%{_libdir}/libtermcap.so
gzip -9nf $RPM_BUILD_ROOT/%{_infodir}/termcap.info*
chmod 644 $RPM_BUILD_ROOT/%{_infodir}/termcap.info*
if [ %{_libdir} != /usr/lib ] ; then
 mv $RPM_BUILD_ROOT/usr/lib/libtermcap.a $RPM_BUILD_ROOT/%{_libdir}/libtermcap.a
fi

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%trigger devel -- info >= 3.12
/sbin/install-info \
	--section="Libraries" --entry="* Termcap: (termcap).               The GNU termcap library." \
	--info-dir=%{_infodir} %{_infodir}/termcap.info.gz

%postun -p /sbin/ldconfig

%postun devel
if [ $1 = 0 ]; then
    /sbin/install-info --delete \
	--section="Libraries" --entry="* Termcap: (termcap).               The GNU termcap library." \
	--info-dir=%{_infodir} %{_infodir}/termcap.info.gz
fi

%files
%defattr(-,root,root)
/%{_lib}/libtermcap.so.2*

%files devel
%defattr(-,root,root)
%{_libdir}/libtermcap.a
%{_libdir}/libtermcap.so
%{_includedir}/termcap.h
%{_infodir}/termcap.info*

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri May  7 2004 Tim Waugh <twaugh@redhat.com> 2.0.8-38
- Fix tgetent() (bug #116934).

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 04 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- add symlink to shared lib

* Mon Jan 27 2003 Nalin Dahyabhai <nalin@redhat.com> 2.0.8-34
- don't strip libraries directly, that's the job of the buildroot policy
- rework part of %%install to handle cases where %%{_libdir} = /usr/lib

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Thu Nov 21 2002 Elliot Lee <sopwith@redhat.com> 2.0.8-33
- Cross-compile changes

* Thu Nov 21 2002 Elliot Lee <sopwith@redhat.com>
- Pull in hammer changes, rebuild

* Tue Sep 24 2002 Jeremy Katz <katzj@redhat.com>
- libdir fun

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Jan 14 2002 Bernhard Rosenkraenzer <bero@redhat.com> 2.0.8-29
- Add workaround for libgcc/glibc breakage on ia64
- s/Copyright/License/ in spec file
- bzip2 source to save space

* Mon Jul  9 2001 Tim Powers <timp@redhat.com>
- make libtermcap-devel require the same version as the main package

* Thu Jun 21 2001 Than Ngo <than@redhat.com>
- add missing libtermcap symlink

* Sat Oct  7 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Uninstall info pages in %%postun devel rather than %%postun
  (Bug #18545)

* Wed Aug 16 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix broken symlink (#16285)

* Mon Aug 14 2000 Preston Brown <pbrown@redhat.com>
- absolute --> relative symlink (#16131)

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jul  4 2000 Matt Wilson <msw@redhat.com>
- move the trigger to the devel package, that's where the info pages
  live now

* Sun Jun 18 2000 Matt Wilson <msw@redhat.com>
- rebuild for next release
- move info pages to the development package
- use %%{_infodir}
- patched to build against new glibc (patch11)

* Sun Feb  6 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- BuildPrereq: texinfo (#8927)

* Sat Feb  5 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- strip library
- fix up handling of RPM_OPT_FLAGS

* Tue Aug 30 1999 Bill Nottingham <notting@redhat.com>
- ignore the first argument to tgetent, so the last change doesn't
  keep blowing up programs.
- ignore the second argument to tgetstr() as well. 

* Sat Aug 21 1999 Jeff Johnson <jbj@redhat.com>
- increase default size of malloc'ed tgetent buffer from 1024 to 1536.
- don't shrink colons (#4270).
- rebuild for 6.1.

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- add buffer overflow patch from Kevin Vajk <kvajk@ricochet.net>

* Sat May 15 1999 Jeff Johnson <jbj@redhat.com>
- permit multiple tc= continuations and ignore unnecessary %p ("push arg") (#54)

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 13)
- fix to make the texi documenattion compile

* Thu Jan 14 1999 Jeff Johnson <jbj@redhat.com>
- use __PMT(...) prototypes (#761)

* Fri Dec 18 1998 Cristian Gafton <gafton@redhat.com>
- build against glibc 2.1

* Wed Aug 05 1998 Erik Troan <ewt@redhat.com>
- run install-info from a %trigger so we don't have to make it a prereq; as
  termcap is used by bash, the install ordering issues are hairy
- commented out the chown stuff from 'make install' so you don't have to
  be root to build this
- don't run ldconfig if prefix= is used during 'make install'

* Tue Aug  4 1998 Jeff Johnson <jbj@redhat.com>
- build root.

* Tue Jun 30 1998 Alan Cox <alan@redhat.com>
- But assume system termcap is sane. Also handle setfsuid return right.

* Tue Jun 30 1998 Alan Cox <alan@redhat.com>
- TERMCAP environment hole for setuid apps squished.

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Oct 14 1997 Donnie Barnes <djb@redhat.com>
- spec file cleanups

* Tue Jun 03 1997 Erik Troan <ewt@redhat.com>
- built against glibc
