%define DATE 20041015
%define oprofile_version 0.8.1
%define oprofile_release 11
Summary: System wide profiler
Name: oprofile
Version: 0.8.1
Release: %{oprofile_release}
License: GPL
Group: Development/System
#
Source0: oprofile-%{version}.tar.gz
Requires: binutils
Patch10: oprofile-0.4-guess2.patch
#The following patch should go away when newer binutils/libbfd is used
#Patch35: oprofile-0.4-separatedebug.patch
Patch57: oprofile-0.5.2-module.patch
Patch58: oprofile-0.5.2-filepos.patch
Patch63: oprofile-0.7-libs.patch
#Patch75: oprofile-0.8-oparchive.patch
Patch76: oprofile-0.8.1-libnames.patch
Patch77: oprofile-0.8.1-power45.patch
Patch78: oprofile-0.8.1-power45sign.patch
Patch79: oprofile-0.8.1-power970.patch

URL: http://oprofile.sf.net
ExclusiveArch: %{ix86} ia64 x86_64 ppc ppc64 s390 s390x
BuildPreReq: qt-devel
BuildPreReq: libxslt
BuildPreReq: docbook-style-xsl
BuildPreReq: docbook-utils
BuildPreReq: elinks
BuildPreReq: gtk2-devel
BuildPreReq: automake

BuildRoot: %{_tmppath}/%{name}-root

%description
oprofile is a profiling system for systems running Linux 2.2/2.4.
Profiling runs transparently during the background, and profile data
can be collected at any time. oprofile makes use of the hardware performance
counters provided on Intel P6, and AMD Athlon family processors, and can use
the RTC for profiling on other x86 processor types.

See the HTML documentation for further details.

%package devel
Summary: Header files and libraries for developing apps which will use oprofile.
Group: Development/Libraries
Requires: oprofile = %{version}-%{release}

%description devel

Header files and libraries for developing apps which will use oprofile.

%prep
%setup -q -n %{name}-%{version}
%patch10 -p1 -b .guess2
#%patch35 -p1 -b .separate
#%patch57 -p1 -b .module
#%patch58 -p1 -b .filepos
%patch63 -p1 -b .libs
#%patch75 -p1 -b .archive
%patch76 -p1 -b .libnames
%patch77 -p1 -b .power45
%patch78 -p1 -b .power45sign
%patch79 -p1 -b .power970

./autogen.sh

%build
QTDIR=%{_libdir}/qt-3.3;     export QTDIR

#The CXXFLAGS below is temporary to work around
# bugzilla #113909
CXXFLAGS=-g;     export CXXFLAGS

./configure \
	--with-kernel-support \
        --host=%{_host} --target=%{_target_platform} --build=%{_build} \
	--program-prefix= \
        --prefix=%{_prefix} \
        --exec-prefix=%{_exec_prefix} \
        --bindir=%{_bindir} \
        --sbindir=%{_sbindir} \
        --sysconfdir=%{_sysconfdir} \
        --datadir=%{_datadir} \
        --includedir=%{_includedir} \
        --libdir=%{_libdir} \
        --libexecdir=%{_libexecdir} \
        --localstatedir=%{_localstatedir} \
        --sharedstatedir=%{_sharedstatedir} \
        --mandir=%{_mandir} \
        --infodir=%{_infodir} \
	--with-separate-debug-dir=/usr/lib/debug \
	--enable-abi

make

%install
rm -rf ${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1

make DESTDIR=${RPM_BUILD_ROOT} install

#the following is an ugly hack
rm -rf ${RPM_BUILD_ROOT}/usr/share/doc/oprofile
rm -rf ${RPM_BUILD_ROOT}/usr/share/mangled-name

#hack to make header files available
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}
install -m 755 libop/op_events.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libop/op_cpu_type.h $RPM_BUILD_ROOT/%{_includedir}
#install -m 755 libop/op_events_desc.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libop/op_config.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libop/op_sample_file.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libutil/op_types.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libutil/op_list.h $RPM_BUILD_ROOT/%{_includedir}
install -m 755 libdb/odb.h $RPM_BUILD_ROOT/%{_includedir}

#hack to make .a files available
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
install -m 755 libop/libop.a $RPM_BUILD_ROOT/%{_libdir}
install -m 755 libdb/libodb.a $RPM_BUILD_ROOT/%{_libdir}
install -m 755 libutil/liboputil.a $RPM_BUILD_ROOT/%{_libdir}
install -m 755 libutil++/liboputil++.a $RPM_BUILD_ROOT/%{_libdir}
#install -m 755 pp/liboppp.a $RPM_BUILD_ROOT/%{_libdir}
install -m 755 libabi/libopabi.a $RPM_BUILD_ROOT/%{_libdir}

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc doc/oprofile.html

%{_bindir}/oprof_start
%{_bindir}/op_help
%{_bindir}/op_import
%{_bindir}/opannotate
%{_bindir}/opcontrol
%{_bindir}/opgprof
%{_bindir}/opreport
%{_bindir}/oprofiled
%{_bindir}/opstack
%{_bindir}/oparchive

%{_mandir}/man1/op_help.1.gz
%{_mandir}/man1/opannotate.1.gz
%{_mandir}/man1/opcontrol.1.gz
%{_mandir}/man1/opgprof.1.gz
%{_mandir}/man1/opreport.1.gz
%{_mandir}/man1/oprofile.1.gz
%{_mandir}/man1/opstack.1.gz
%{_mandir}/man1/oparchive.1.gz

/usr/share/oprofile/alpha/ev4/events
/usr/share/oprofile/alpha/ev4/unit_masks
/usr/share/oprofile/alpha/ev5/events
/usr/share/oprofile/alpha/ev5/unit_masks
/usr/share/oprofile/alpha/ev6/events
/usr/share/oprofile/alpha/ev6/unit_masks
/usr/share/oprofile/alpha/ev67/events
/usr/share/oprofile/alpha/ev67/unit_masks
/usr/share/oprofile/alpha/pca56/events
/usr/share/oprofile/alpha/pca56/unit_masks
/usr/share/oprofile/arm/xscale1/events
/usr/share/oprofile/arm/xscale1/unit_masks
/usr/share/oprofile/arm/xscale2/events
/usr/share/oprofile/arm/xscale2/unit_masks
/usr/share/oprofile/i386/athlon/events
/usr/share/oprofile/i386/athlon/unit_masks
/usr/share/oprofile/i386/p4-ht/events
/usr/share/oprofile/i386/p4-ht/unit_masks
/usr/share/oprofile/i386/p4/events
/usr/share/oprofile/i386/p4/unit_masks
/usr/share/oprofile/i386/p6_mobile/events
/usr/share/oprofile/i386/p6_mobile/unit_masks
/usr/share/oprofile/i386/pii/events
/usr/share/oprofile/i386/pii/unit_masks
/usr/share/oprofile/i386/piii/events
/usr/share/oprofile/i386/piii/unit_masks
/usr/share/oprofile/i386/ppro/events
/usr/share/oprofile/i386/ppro/unit_masks
/usr/share/oprofile/ia64/ia64/events
/usr/share/oprofile/ia64/ia64/unit_masks
/usr/share/oprofile/ia64/itanium/events
/usr/share/oprofile/ia64/itanium/unit_masks
/usr/share/oprofile/ia64/itanium2/events
/usr/share/oprofile/ia64/itanium2/unit_masks
/usr/share/oprofile/rtc/events
/usr/share/oprofile/rtc/unit_masks
/usr/share/oprofile/stl.pat
/usr/share/oprofile/x86-64/hammer/events
/usr/share/oprofile/x86-64/hammer/unit_masks
/usr/share/oprofile/ppc64/power4/event_mappings
/usr/share/oprofile/ppc64/power4/events
/usr/share/oprofile/ppc64/power4/unit_masks
/usr/share/oprofile/ppc64/power5/event_mappings
/usr/share/oprofile/ppc64/power5/events
/usr/share/oprofile/ppc64/power5/unit_masks
/usr/share/oprofile/ppc64/970/event_mappings
/usr/share/oprofile/ppc64/970/events
/usr/share/oprofile/ppc64/970/unit_masks

%files devel
%defattr(-,root,root)

%{_includedir}/odb.h
%{_includedir}/op_config.h
%{_includedir}/op_cpu_type.h
%{_includedir}/op_events.h
%{_includedir}/op_list.h
%{_includedir}/op_sample_file.h
%{_includedir}/op_types.h

%{_libdir}/libodb.a
%{_libdir}/libop.a
%{_libdir}/libopabi.a
%{_libdir}/liboputil++.a
%{_libdir}/liboputil.a


%changelog
* Fri Oct 15 2004 Will Cohen <wcohen@redhat.com>
- Additional ppc64 support for ppc64/970.

* Thu Oct 7 2004 Will Cohen <wcohen@redhat.com>
- Correct opcontrol check for Power 4/5.

* Fri Oct 1 2004 Will Cohen <wcohen@redhat.com>
- Add support for Power 4/5 performance monitoring hardware.

* Wed Sep 22 2004 Will Cohen <wcohen@redhat.com>
- Add logic to use preferred symbol names.

* Wed Sep 15 2004 Will Cohen <wcohen@redhat.com>
- Clean up file manifests.

* Mon Sep 13 2004 Will Cohen <wcohen@redhat.com>
- Rebase on 0.8.1 release.

* Wed Jul 7 2004 Will Cohen <wcohen@redhat.com>
- Add oparchive patch.

* Mon Jun 21 2004 Will Cohen <wcohen@redhat.com>
- bump version

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu May 20 2004 Will Cohen <wcohen@redhat.com>
- Eliminate AUTOMAKE and ACLOCAL definitions.
- Correct QTDIR and add oprof_start to file manifests.

* Tue May 11 2004 Will Cohen <wcohen@redhat.com>
- Remove wildcards in the file manifests.
- Correct build directory.
- Use the 0.8 release tarball.

* Tue Mar 23 2004 Will Cohen <wcohen@redhat.com>
- Bump version and rebuild.

* Mon Mar 15 2004 Will Cohen <wcohen@redhat.com>
- Correct cvs checkin.

* Thu Feb 19 2004 Will Cohen <wcohen@redhat.com>
- Use automake 1.6.

* Wed Jan 21 2004 Will Cohen <wcohen@redhat.com>
- Rebase on 8.0 cvs snapshot.

* Mon Dec 01 2003 Will Cohen <wcohen@redhat.com>
- Turn on debug info patch.

* Mon Nov 24 2003 Will Cohen <wcohen@redhat.com>
- Rebase on 7.1 cvs snapshot.

* Fri Sep 26 2003 Will Cohen <wcohen@redhat.com>
- Reenable separatedebug and filepos patch.

* Thu Sep 4 2003 Will Cohen <wcohen@redhat.com>
- Limit to i386.
- Everything but x86_64.
- Turn on x86_64.

* Mon Aug 11 2003 Will Cohen <wcohen@redhat.com>
- Add gtk2-devel to build requirements.

* Thu Aug 07 2003 Will Cohen <wcohen@redhat.com>
- adapt to 0.7cvs.

* Wed Jul 30 2003 Will Cohen <wcohen@redhat.com>
- handle sample files names with spaces.
- clean spec file.
- revise opcontrol --reset.

* Fri Jul 25 2003 Will Cohen <wcohen@redhat.com>
- Restrict PATH in opcontrol.

* Wed Jul 09 2003 Will Cohen <wcohen@redhat.com>
- Patch for testing code coverage.
- Better handling of 2.5 module information.

* Fri Jun 27 2003 Will Cohen <wcohen@redhat.com>
- move to oprofile 0.5.4 pristine tarball.

* Fri Jun 13 2003 Will Cohen <wcohen@redhat.com>
- Bitmask check.

* Wed Jun 11 2003 Will Cohen <wcohen@redhat.com>
- Update AMD events.

* Fri Jun 06 2003 Will Cohen <wcohen@redhat.com>
- Build for ppc64.

* Thu Jun 05 2003 Will Cohen <wcohen@redhat.com>
- put in s390.
- Fix includes for asserts.
- Make sure elinks is available for html to txt conversion.

* Fri May 23 2003 Will Cohen <wcohen@redhat.com>
- Avoid library name collisions.

* Thu May 22 2003 Will Cohen <wcohen@redhat.com>
- Turn on ppc build.
- Turn off ppc build.
- Package op_list.h.

* Mon May 19 2003 Will Cohen <wcohen@redhat.com>
- Correct typo.

* Thu Apr 24 2003 Will Cohen <wcohen@redhat.com>
- check min event counts.
- revised op_to_source output to avoid changing line count.
- p4event events revised.
- hammer events revised.

* Wed Apr 23 2003 Will Cohen <wcohen@redhat.com>
- re-enable ppc build.

* Wed Apr 16 2003 Will Cohen <wcohen@redhat.com>
- Use /proc/ksym for module information.
- Correct separate debuginfo handling.
- Configure with --enable-abi.

* Tue Apr 1 2003 Will Cohen <wcohen@redhat.com>
- Correct path finding for daemon and op_help.

* Mon Mar 31 2003 Will Cohen <wcohen@redhat.com>
- Fix name collisons with /usr/lib/libdb.a.

* Fri Mar 28 2003 Will Cohen <wcohen@redhat.com>
- clean up spec file.
- turn off ppc build.

* Mon Mar 24 2003 Will Cohen <wcohen@redhat.com>
- getc instead of fgetc to improve performance.

* Thu Mar 20 2003 Will Cohen <wcohen@redhat.com>
- produce oprofile-devel.

* Thu Mar 13 2003 Will Cohen <wcohen@redhat.com>
- fix opvisualise patch format.

* Wed Mar 12 2003 Will Cohen <wcohen@redhat.com>
- add cmoller changes to fix warnings in opvisualise.

* Tue Mar 11 2003 Will Cohen <wcohen@redhat.com>
- setup to build on ppc.
- turn on op_visualise for ia64.
- remove unused patches.

* Mon Mar 10 2003 Will Cohen <wcohen@redhat.com>
- re-enable op_visualise.

* Fri Mar 7 2003 Will Cohen  <wcohen@redhat.com>
- move to oprofile 0.5.1 pristine tarball.
- change libdb abi.

* Fri Feb 14 2003 Will Cohen <wcohen@redhat.com>
- Requires binutils not perl.

* Thu Feb 13 2003 Will Cohen <wcohen@redhat.com>
- correct x86_64 sys_lookup_dcookie.
- correct applications of patches.

* Mon Feb 10 2003 Will Cohen <wcohen@redhat.com>
- rebuilt.
- handle stale locks
- opcontrol rtc patch
- update manpage info

* Fri Feb 7 2003 Will Cohen <wcohen@redhat.com>
- turn on build for ppc64
- change order op_visualise searches lib directories.
- revise oprofile-0.4-deprecate patch.
- utils/oprofile kernel range check, --save, and do_dump corrections.
- update gui to use "--separate=library".

* Thu Feb 6 2003 Will Cohen <wcohen@redhat.com>
- Fix dumping.

* Fri Jan 31 2003 Will Cohen <wcohen@redhat.com>
- Syscall value for x86_64.
- Update manpage and documentation.
- Revise utils/* to deprecate old.
- Include CPU_P4_HT2 in op_help.c
- Revise how CPU_TIMER_INT handled.
- Apply cookie patch for all archs.
- Correct autogen.sh location.

* Mon Jan 27 2003 Will Cohen <wcohen@redhat.com>
- Add Hammer specific events.

* Fri Jan 24 2003 Will Cohen <wcohen@redhat.com>
- Hack to get correct syscall for ia64.
- Hack to get get timer interupt data.
- Fix doc/Makefile.am.

* Wed Jan 22 2003 Will Cohen <wcohen@redhat.com>
- Add patch for separate debug infomation.

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Thu Jan 16 2003 Will Cohen <wcohen@redhat.com>
- Add support for P4 HT.

* Wed Jan 15 2003 Will Cohen <wcohen@redhat.com>
- Add support for x86_64.

* Tue Jan 07 2003 Will Cohen <wcohen@redhat.com>
- Revise op_visualise patch to check opendir() results.

* Mon Jan 06 2003 Will Cohen <wcohen@redhat.com>
- Patch to fix op_visualise seg fault on startup.

* Thu Jan 02 2003 Will Cohen <wcohen@redhat.com>
- Correct argument type in daemon/oprofiled.c.
- Correct QTDIR.

* Wed Dec 18 2002 Will Cohen <wcohen@redhat.com>
- Correct reporting of interrupts in oprof_start. 

* Wed Dec 18 2002 Will Cohen <wcohen@redhat.com>
- Rebuilt against new kernel

* Fri Dec 13 2002 Will Cohen <wcohen@redhat.com>
- Use opcontrol in oprof_start.

* Thu Dec 12 2002 Will Cohen <wcohen@redhat.com>
- Correct opvisualise problem.

* Tue Dec 10 2002 Will Cohen <wcohen@redhat.com>
- Add opcontrol, op_dump, op_visualise, ia64 support,
  and debugging information.

* Fri Dec 06 2002 Will Cohen <wcohen@redhat.com>
- Change to use OProfile 0.4 release and kernel support.

* Sat Nov 30 2002 Tim Powers <timp@redhat.com> 0.3-0.20021108.1
- rebuild against current version of libbfd

* Tue Aug 06 2002 Will Cohen <wcohen@redhat.com>
- Change to avoid assumption on executable name

* Fri Aug 02 2002 Will Cohen <wcohen@redhat.com>
- Move to 0.4cvs sources.

* Mon Jul 29 2002 Will Cohen <wcohen@redhat.com>
- localize nr_counter code
- add ia64 arch
- guess path to vmlinux.

* Sun Jul 28 2002 Will Cohen <wcohen@redhat.com>
- adjust structure to fit ia64 oprofile module.

* Thu Jul 25 2002 Will Cohen <wcohen@redhat.com>
- recognize ia64 cpu and events.

* Tue Jul 23 2002 Will Cohen <wcohen@redhat.com>
- changes to turn of warning as error on ia64.

* Tue Jul 23 2002 Will Cohen <wcohen@redhat.com>
- changes to allow compilation on ia64.

* Mon Jul 22 2002 Will Cohen <wcohen@redhat.com>
- pick better Red Hat Linux default image file in /boot.

* Tue Jul 14 2002 Will Cohen <wcohen@redhat.com>
- use older OProfile 0.2 kernel<->daemon API.

* Tue Jul 11 2002 Will Cohen <wcohen@redhat.com>
- avoid oprof_start installing the oprofile module

* Tue Jul 02 2002 Will Cohen <wcohen@redhat.com>
- avoid building and installing the oprofile module

* Tue May 28 2002 Jeff Johnson <jbj@redhat.com>
- create package.
