Summary: A password-checking library.
Name: cracklib
Version: 2.7
Release: 28
Group: System Environment/Libraries
Source0: http://www.crypticide.org/users/alecm/security/cracklib,%{version}.tgz
Source1: crack.h
Source10: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/Domains.gz
Source11: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/Dosref.gz
Source12: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/Ftpsites.gz
Source13: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/Jargon.gz
Source14: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/common-passwords.txt.gz
Source15: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/computer/etc-hosts.gz
Source16: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/movieTV/Movies.gz
Source17: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/movieTV/Python.gz
Source18: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/movieTV/Trek.gz
Source19: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/LCarrol.gz
Source20: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/Paradise.Lost.gz
Source21: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/cartoon.gz
Source22: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/myths-legends.gz
Source23: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/sf.gz
Source24: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/literature/shakespeare.gz
Source25: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/ASSurnames.gz
Source26: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/Congress.gz
Source27: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/Family-Names.gz
Source28: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/Given-Names.gz
Source29: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/famous.gz
Source30: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/fast-names.gz
Source31: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/female-names.gz
Source32: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/male-names.gz
Source33: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/names.french.gz
Source34: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/names.hp.gz
Source35: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/other-names.gz
Source36: ftp://ftp.cerias.purdue.edu/pub/dict/wordlists/names/surnames.finnish.gz
Url: http://www.crypticide.org/users/alecm/
License: Artistic
Patch0: cracklib-2.7-rh.patch
Patch1: cracklib-2.7-nss.patch
Buildroot: %{_tmppath}/%{name}-root
BuildPrereq: gzip, words

%description
CrackLib tests passwords to determine whether they match certain
security-oriented characteristics, with the purpose of stopping users
from choosing passwords that are easy to guess. CrackLib performs
several tests on passwords: it tries to generate words from a username
and gecos entry and checks those words against the password; it checks
for simplistic patterns in passwords; and it checks for the password
in a dictionary.

CrackLib is actually a library containing a particular C function
which is used to check the password, as well as other C
functions. CrackLib is not a replacement for a passwd program; it must
be used in conjunction with an existing passwd program.

Install the cracklib package if you need a program to check users'
passwords to see if they are at least minimally secure. If you install
CrackLib, you will also want to install the cracklib-dicts package.

%package dicts
Summary: The standard CrackLib dictionaries.
Group: System Environment/Libraries
Requires: words >= 2-13

%description dicts
The cracklib-dicts package includes the CrackLib dictionaries.
CrackLib will need to use the dictionary appropriate to your system,
which is normally put in /usr/share/dict/words. Cracklib-dicts also
contains the utilities necessary for the creation of new dictionaries.

If you are installing CrackLib, you should also install cracklib-dicts.

%prep
%setup -n cracklib,%{version} -q
%patch0 -p1 -b .rh
%patch1 -p1 -b .nss
cp %{SOURCE1} cracklib/crack.h
mkdir cracklib-dicts
for dict in %{SOURCE10} %{SOURCE11} %{SOURCE12} %{SOURCE13} %{SOURCE14} \
            %{SOURCE15} %{SOURCE16} %{SOURCE17} %{SOURCE18} %{SOURCE19} \
            %{SOURCE20} %{SOURCE21} %{SOURCE22} %{SOURCE23} %{SOURCE24} \
            %{SOURCE25} %{SOURCE26} %{SOURCE27} %{SOURCE28} %{SOURCE29} \
            %{SOURCE30} %{SOURCE31} %{SOURCE32} %{SOURCE33} %{SOURCE34} \
            %{SOURCE35} %{SOURCE36}
do
	cp -fv ${dict} cracklib-dicts/
done
gunzip cracklib-dicts/*

%build
make all \
	DICTPATH=%{_libdir}/cracklib_dict \
	libdir=%{_libdir}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT{%{_includedir},%{_libdir},%{_sbindir}}
make install \
	ROOT=$RPM_BUILD_ROOT \
	includedir=%{_includedir} \
	DICTPATH=%{_libdir}/cracklib_dict \
	libdir=%{_libdir} \
	sbindir=%{_sbindir}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%triggerpostun -- cracklib < 2.7-24
/sbin/ldconfig

%files
%defattr(-,root,root)
%doc README MANIFEST LICENCE HISTORY POSTER
%{_includedir}/*
%{_libdir}/lib*

%files dicts
%defattr(-,root,root)
%{_sbindir}/*
%{_libdir}/cracklib_dict*

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Feb  4 2004 Nalin Dahyabhai <nalin@redhat.com> 2.7-26
- update URL (previous page moved) (#114894)

* Fri Jan 30 2004 Nalin Dahyabhai <nalin@redhat.com> 2.7-25
- fix ldconfig invocation in trigger for older versions which included the
  soname symlink (#114620)

* Mon Dec  1 2003 Nalin Dahyabhai <nalin@redhat.com> 2.7-24
- include packer.h for reading dictionaries directly, since we already include
  packer in the -dicts subpackage (#68339)
- don't include the soname symlink in the package, let ldconfig do its job

* Wed Jun 18 2003 Nalin Dahyabhai <nalin@redhat.com> 2.7-23
- rebuild

* Mon Jun 16 2003 Nalin Dahyabhai <nalin@redhat.com> 2.7-22
- rebuild

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Apr 30 2003 Nalin Dahyabhai <nalin@redhat.com>
- update URL

* Tue Feb 04 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- add symlink to shared libs

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Sep 25 2002 Nalin Dahyabhai <nalin@redhat.com> 2.7-19
- fix for builds on multilib systems (set DICTPATH properly)

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.7-16
- rebuild in new environment

* Fri Feb 22 2002 Nalin Dahyabhai <nalin@redhat.com> 2.7-15
- rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Oct  2 2001 Nalin Dahyabhai <nalin@redhat.com> 2.7-13
- use getpwuid_r instead of getpwuid

* Fri Aug  3 2001 Nalin Dahyabhai <nalin@redhat.com> 2.7-12
- remove cruft that ldconfig already knows how to manage
- don't explicitly strip anything -- the brp setup decides that
- tweak the header so that it can be used in C++ (#46685)
- buildprereq the words package

* Tue Jun 26 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- add link from library major version number

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun 27 2000 Nalin Dahyabhai <nalin@redhat.com>
- FHS fixes
- fix undeclared function warnings from the new compiler
- fix URL

* Fri Apr 07 2000 Trond Eivind Glomsrd <teg@redhat.com>
- switched to use /usr/share/dict/words

* Tue Apr 06 1999 Preston Brown <pbrown@redhat.com>
- strip binaries

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Wed Jan 06 1999 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Sat May 09 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Mar 10 1998 Cristian Gafton <gafton@redhat.com>
- updated to 2.7
- build shared libraries

* Mon Nov 03 1997 Donnie Barnes <djb@redhat.com>
- added -fPIC

* Mon Oct 13 1997 Donnie Barnes <djb@redhat.com>
- basic spec file cleanups

* Mon Jun 02 1997 Erik Troan <ewt@redhat.com>
- built against glibc
