
/* Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#ifndef _SYS_UCONTEXT_H
#define _SYS_UCONTEXT_H	1

#include <features.h>
#include <signal.h>

/* We need the signal context definitions even if they are not used
   included in <signal.h>.  */
#include <bits/sigcontext.h>


/* Type for general register.  */
typedef unsigned long greg_t;

/* Number of general registers.  */
#define NGREG	26

/* Container for all general registers.  */
typedef greg_t gregset_t[NGREG];

#ifdef __USE_GNU
/* Number of each register is the `gregset_t' array.  */
enum
{
  R_D0 = 0,
# define R_D0		R_D0
  R_D1,
# define R_D1		R_D1
  R_D2,
# define R_D2		R_D2
  R_D3,
# define R_D3		R_D3
  R_A0,
# define R_A0		R_A0
  R_A1,
# define R_A1		R_A1
  R_A2,
# define R_A2		R_A2
  R_A3,
# define R_A3		R_A3
  R_E0,
# define R_E0		R_E0
  R_E1,
# define R_E1		R_E1
  R_E2,
# define R_E2		R_E2
  R_E3,
# define R_E3		R_E3
  R_E4,
# define R_E4		R_E4
  R_E5,
# define R_E5		R_E5
  R_E6,
# define R_E6		R_E6
  R_E7,
# define R_E7		R_E7
  R_LAR,
# define R_LAR	R_LAR
  R_LIR,
# define R_LIR	R_LIR
  R_MDR,
# define R_MDR	R_MDR
  R_MCVF,
# define R_MCVF	R_MCVF
  R_MCRL,
# define R_MCRL	R_MCRL
  R_MCRH,
# define R_MCRH	R_MCRH
  R_MDRQ,
# define R_MDRQ	R_MDRQ
  R_SP,
# define R_SP		R_SP
  R_EPSW,
# define R_EPSW	R_EPSW
  R_PC,
# define R_PC		R_PC
};
#endif

struct _libc_fpstate
{
  unsigned long fs[32];
  unsigned long int fpcr;
};

/* Structure to describe FPU registers.  */
typedef struct _libc_fpstate *fpregset_t;

/* Context to describe whole processor state.  */
typedef struct
  {
    gregset_t gregs;
    /* Due to Linux's history we have to use a pointer here.  The SysV/i386
       ABI requires a struct with the values.  */
    fpregset_t fpregs;
    unsigned long int oldmask;
  } mcontext_t;

/* Userlevel context.  */
typedef struct ucontext
  {
    unsigned long int uc_flags;
    struct ucontext *uc_link;
    stack_t uc_stack;
    mcontext_t uc_mcontext;
    __sigset_t uc_sigmask;
  } ucontext_t;

#endif /* sys/ucontext.h */
