From guile-owner@cygnus.com Tue Jun  4 09:15:43 1996
Status: RO
X-VM-v5-Data: ([nil nil nil nil nil nil nil nil nil]
	["2964" "Tue" " 4" "June" "1996" "16:09:36" "+0200" "Juergen Weiss" "juergen@mona.aesop.de" nil "127" "Re: catch/throw implemented with call/cc" "^From:" nil nil "6" "1996060414:09:36" nil nil nil]
	nil)
Received: from mailhost.lanl.gov (mailhost.lanl.gov [128.165.3.12]) by sst10a.lanl.gov (8.6.10/8.6.10) with ESMTP id JAA19687 for <rosalia@sst10a.lanl.gov>; Tue, 4 Jun 1996 09:15:42 -0600
Received: from cygnus.com by mailhost.lanl.gov (8.7.5/1.2)
	id JAA18852; Tue, 4 Jun 1996 09:15:41 -0600 (MDT)
Received: (from daemon@localhost) by cygnus.com (8.6.12/8.6.9) id HAA23328 for guile-outgoing; Tue, 4 Jun 1996 07:26:53 -0700
Received: from merlin.aesop.de (merlin.aesop.de [193.30.116.13]) by cygnus.com (8.6.12/8.6.9) with SMTP id HAA23323 for <gel@cygnus.com>; Tue, 4 Jun 1996 07:26:44 -0700
Received: from mona.aesop.de by merlin.aesop.de with SMTP
	(1.37.109.4/16.2) id AA15765; Tue, 4 Jun 96 16:27:05 +0200
Received: by mona (940816.SGI.8.6.9/940406.SGI.AUTO)
	for gel@cygnus.com id QAA05368; Tue, 4 Jun 1996 16:09:39 +0200
Message-Id: <199606041409.QAA05368@mona>
X-Mailer: ELM [version 2.4 PL20]
Content-Type: text
Precedence: bulk
From: juergen@mona.aesop.de (Juergen Weiss)
Sender: owner-guile@cygnus.com
To: gel@cygnus.com
Subject: Re: catch/throw implemented with call/cc
Date: Tue, 4 Jun 1996 16:09:36 +0200 (Sommer)


I have not been programming for very long in scheme, so I give no
guarantees for this code ...

;;; -- CATCH AND THROW WITH CONTINUATIONS --



;; variables private to my-catch and my-throw

; list of installed throw handlers;
; the list contains items of the form (key . continuation)
; where CONTINUATION passes control to the throw handler
; which is installed for the given KEY
(define %%throw-handlers '())

; unique value passed to a contination if invoked by throw
(define %%throw-value (cons #f #f))

; arguments given to throw which are passed to the throw handler
(define %%throw-args #f)



(define (my-catch key thunk handler)

  (define (install key cont)
    (set! %%throw-handlers (acons key cont %%throw-handlers)))

  (define (uninstall cont)
    (letrec ((remove-binding!
	      (lambda (list)
		(cond ((null? list) '())
		      ((eq? (cdar list) cont) (cdr list))
		      (else
		       (set-cdr! list (remove-binding! (cdr list)))
		       list)))))
      (set! %%throw-handlers (remove-binding! %%throw-handlers))))

  (let ((c (call-with-current-continuation (lambda (c) c))))

    (cond ((eq? c %%throw-value)
	   ; the continuation has been invoked
	   (apply handler key %%throw-args))

	  ; if key is #f a unique key id ("jump buffer object")
	  ; is passed to THUNK;  if throw is invoked with this
	  ; key the execution must be resumed with the handler of
	  ; the particular catch invokation that created the key;
	  ; this behaviour can be easily implemented by passing
	  ; the continuation object
	  ((eq? key #f)
	   (dynamic-wind
	    (lambda () (install c c))
	    (lambda () (thunk c))
	    (lambda () (uninstall c))))

	  ; key is either a symbol or #t
	  (else
	   (dynamic-wind
	    (lambda () (install key c))
	    thunk
	    (lambda () (uninstall c)))))))


(define (my-throw key . args)

  (let ((pair (or (assq key %%throw-handlers)
		  (assq #t %%throw-handlers)
		  ; if no handler is installed check the property
		  ; list of the symbol
		  (and (symbol? key)
		       (symbol-property key 'throw-default-handler)))))
    (cond (pair
	   (set! %%throw-args args)
	   ; invoke the continuation which was saved in my-catch
	   ((cdr pair) %%throw-value))
	  (else
	   (error "my-throw: no catch for key" key)))))




;; test code

(define (foo x y)
  (my-catch 'invalid-number
	 (lambda ()
	   (add x y))
	 (lambda (key arg)
	   (error "foo: argument is not a number:" arg))))

(define (add x y)
  (cond ((not (number? x))
	 (my-throw 'invalid-number x))
	((not (number? y))
	 (my-throw 'invalid-number y))
	(else
	 (+ x y))))

(foo 2 3)
(foo 3 'a)



(define (bar)
  (my-catch #f
    (lambda (break)
      (let loop ((i 0))
	(if (= i 10)
	    (my-throw break))
	(display i) (display #\space)
	(loop (+ 1 i))))
    (lambda ignore
      (newline))))
	  
(bar)
    

-------

BTW: properties are not an R4RS feature 
the invokation of symbol-property should therefore be removed

Any comments welcome. 

 -- Juergen

