/* rtc.h:
 *
 * Written by Noboru Asai (asai.noboru@jp.panasonic.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _ASM_RTC_H
#define _ASM_RTC_H

#ifdef CONFIG_MN10300_RTC

void check_rtc_time(void);
unsigned long get_rtc_time(void);
void calibrate_clock(void);

#else /* !CONFIG_MN10300_RTC */

static inline void check_rtc_time(void)
{
}
static inline unsigned long get_rtc_time(void)
{
	return 0;
}
static inline void calibrate_clock(void)
{
}

#endif /* !CONFIG_MN10300_RTC */

#endif /* _ASM_RTC_H */
