%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%define WITH_SELINUX 1
%endif
%define python %(%{__python} -c "import sys; print sys.version[:3]")

Name: libuser
Version: 0.52.5
Release: 1
Group: System Environment/Base
License: LGPL
Source: libuser-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
BuildPrereq: pam-devel, popt, python-devel
BuildPrereq: glib2-devel, gtk-doc, linuxdoc-tools
BuildPrereq: cyrus-sasl-devel, openldap-devel
Summary: A user and group account administration library.

%description
The libuser library implements a standardized interface for manipulating
and administering user and group accounts.  The library uses pluggable
back-ends to interface to its data sources.

Sample applications modeled after those included with the shadow password
suite are included.

%package devel
Group: Development/Libraries
Summary: Files needed for developing applications which use libuser.
Requires: %{name} = %{version}-%{release}

%description devel
The libuser-devel package contains header files, static libraries, and other
files useful for developing applications with libuser.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS -fPIC" ; export CFLAGS
%configure --enable-gtk-doc \
%if %{WITH_SELINUX}
	--with-selinux \
%endif
	--with-ldap \
	--with-python-version=%{python} \
	--with-python-path=%{_includedir}/python%{python} \
	--with-html-dir=%{_datadir}/gtk-doc/html
make

%clean
rm -fr $RPM_BUILD_ROOT

%install
rm -fr $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_libdir}:${LD_LIBRARY_PATH}
export LD_LIBRARY_PATH

# Verify that all python modules load, just in case.
pushd $RPM_BUILD_ROOT/%{_libdir}/python%{python}/site-packages/
python%{python} -c "import libuser"
popd

%find_lang %{name}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README TODO docs/*.txt python/modules.txt
%config(noreplace) %{_sysconfdir}/libuser.conf

%attr(0755,root,root) %{_bindir}/*
%{_libdir}/python%{python}/site-packages/*.so
%{_libdir}/*.so.*.*
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/*.so
%attr(0755,root,root) %{_sbindir}/*
%{_mandir}/man1/*

%files devel
%defattr(-,root,root)
%{_includedir}/libuser
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
#%attr(0644,root,root) %{_mandir}/man3/*
%{_libdir}/pkgconfig/*
%{_datadir}/gtk-doc/html/*

%changelog
* Tue Oct 12 2004 Miloslav Trmac <mitr@redhat.com> - 0.52.5-1
- Fix home directory renaming in ADMIN.modifyUser (#135280)
- Further Python reference counting fixes

* Sun Oct 10 2004 Miloslav Trmac <mitr@redhat.com> - 0.52.4-1
- Fix memory leaks (#113730)
- Build with updated translations

* Wed Sep 29 2004 Miloslav Trmac <mitr@redhat.com> - 0.52.3-1
- Fix compilation without libuser headers already installed (#134085)

* Tue Sep 28 2004 Miloslav Trmac <mitr@redhat.com> - 0.52.2-1
- Allow LDAP connection using ldaps, custom ports or without TLS (original
  patch from Pawel Salek).

* Mon Sep 27 2004 Miloslav Trmac <mitr@redhat.com> - 0.52.1-1
- Fix freecon() of uninitialized value in files/shadow module

* Mon Sep 27 2004 Miloslav Trmac <mitr@redhat.com> - 0.52-1
- Usable LDAP backend (#68052, #99435, #130404)
- Miscellaneous bug fixes

* Fri Sep 24 2004 Miloslav Trmac <mitr@redhat.com> - 0.51.12-1
- Don't claim success and exception at the same time (#133479)
- LDAP fixes, second round
- Various other bugfixes

* Thu Sep 23 2004 Miloslav Trmac <mitr@redhat.com> - 0.51.11-1
- Allow documented optional arguments in Python
  ADMIN.{addUser,modifyUser,deleteUser} (#119812)
- Add man pages for lchfn and lchsh
- LDAP fixes, first round
- Avoid file conflict on multilib systems
- Call ldconfig correctly

* Fri Sep  3 2004 Miloslav Trmac <mitr@redhat.com> - 0.51.10-1
- Don't attempt to lookup using original entity name after entity
  modification (rename in particular) (#78376, #121252)
- Fix copying of symlinks from /etc/skel (#87572, original patch from gLaNDix)
- Make --enable-quota work, and fix the quota code to at least compile (#89114)
- Fix several bugs (#120168, original patch from Steve Grubb)
- Don't hardcode python version in spec file (#130952, from Robert Scheck)
- Properly integrate the SELinux patch, it should actually be used now, even
  though it was "enabled" since 0.51.7-6

* Tue Aug 31 2004 Miloslav Trmac <mitr@redhat.com> - 0.51.9-1
- Fix various typos
- Document library interfaces
- Build all shared libraries with -fPIC (#72536)

* Wed Aug 25 2004 Miloslav Trmac <mitr@redhat.com> - 0.51.8-1
- Update to build with latest autotools and gtk-doc
- Update ALL_LINGUAS and POTFILES.in
- Rebuild to depend on newer openldap

* Mon Jan 26 2004 Dan Walsh <dwalsh@redhat.com> 0.51.7-7
- fix is_selinux_enabled call

* Sun Dec 14 2003 Jeremy Katz <katzj@redhat.com> 0.51.7-6
- rebuild against python 2.3
- enable SELinux

* Mon Sep 08 2003 Dan Walsh <dwalsh@redhat.com> 0.51.7-5
- Turn off SELinux 

* Wed Aug 06 2003 Dan Walsh <dwalsh@redhat.com> 0.51.7-3
- Add SELinux support

* Wed Feb 19 2003 Nalin Dahyabhai <nalin@redhat.com> 0.51.7-1
- ldap: set error codes correctly when we encounter failures initializing
- don't double-close modules which fail initialization
- ldap: don't set an error in cases where one is already set

* Tue Feb 18 2003 Nalin Dahyabhai <nalin@redhat.com> 0.51.6-1
- use a crypt salt consistent with the defaults/crypt_style setting when
  setting new passwords (#79337)

* Thu Feb  6 2003 Nalin Dahyabhai <nalin@redhat.com> 0.51.5-2
- rebuild

* Wed Feb  5 2003 Nalin Dahyabhai <nalin@redhat.com> 0.51.5-1
- expose lu_get_first_unused_id() as a package-private function
- provide libuser.ADMIN.getFirstUnusedUid and libuser.ADMIN.getFirstUnusedGid
  in python

* Thu Dec 19 2002 Nalin Dahyabhai <nalin@redhat.com> 0.51.4-1
- fix not freeing resources properly in files.c(generic_is_locked), spotted by
  Zou Pengcheng

* Wed Dec 11 2002 Nalin Dahyabhai <nalin@redhat.com> 0.51.2-1
- degrade gracefully
- build with --with-pic and -fPIC
- remove unpackaged man page

* Tue Aug 27 2002 Nalin Dahyabhai <nalin@redhat.com> 0.51.1-2
- translation updates

* Wed Jul 24 2002 Nalin Dahyabhai <nalin@redhat.com> 0.51.1-1
- doc updates -- cvs tree moved
- language updates
- disallow weird characters in account names

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon May 20 2002 Nalin Dahyabhai <nalin@redhat.com> 0.51-1
- files: ignore blank lines in files
- libuser: disallow creation of accounts with names containing whitespace,
  control characters, or non-ASCII characters

* Tue Apr 16 2002 Nalin Dahyabhai <nalin@redhat.com> 0.50.2-1
- refresh translations
- fix a heap-corruption bug in the python bindings

* Mon Apr 15 2002 Nalin Dahyabhai <nalin@redhat.com> 0.50-1
- bump version
- refresh translations

* Thu Mar 14 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.102-1
- ldap: cache an entity's dn in the entity structure to try to speed things up

* Mon Mar 11 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.101-3
- rebuild in new environment

* Thu Mar  7 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.101-2
- add missing buildreqs on cyrus-sasl-devel and openldap-devel (#59456)
- translation refresh

* Fri Mar  1 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.101-1
- fix python bindings of enumerateFull functions
- adjust prompter wrapping to not error out on successful returns

* Thu Feb 28 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.100-1
- be more careful about printing error messages
- fix refreshing after adding of accounts
- ldap: try to use a search to convert names to DNs, and only fall back to
  guessing if it turns up nothing
- files: fix an off-by-one in removal of entries

* Mon Feb 25 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.99-1
- refresh translations
- fix admin() constructor comments in the python module

* Thu Feb 21 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.98-1
- automatically refresh entities after add, modify, setpass, removepass,
  lock, and unlock operations
- remove debug spewage when creating and removing mail spools
- files: fix saving of multi-valued attributes
- rename MEMBERUID attribute for groups to MEMBERNAME

* Wed Feb 20 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.97-1
- files: fix bug in removals
- ldap: revert attempts at being smart at startup time, because it makes UIs
  very messy (up the three whole dialogs just to start the ldap stuff!)

* Sun Feb 16 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.96-1
- fix thinko in dispatch routines

* Wed Feb 13 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.95-1
- lgroupmod: fix thinko

* Thu Jan 31 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.94-2
- rebuild in new environment

* Tue Jan 29 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.93-1
- move shadow initialization for groups to the proper callback
- rework locking in the files module to not require that files be writable

* Tue Jan 29 2002 Nalin Dahyabhai <nalin@redhat.com>
- expose lu_strerror()
- add various typedefs for types used by the library

* Mon Jan 28 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.92-1
- add removepass() functions

* Thu Jan 24 2002 Nalin Dahyabhai <nalin@redhat.com>
- lchfn,lchsh,lpasswd - reorder PAM authentication calls
- include API docs in the package

* Thu Jan 24 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.91-1
- ldap: finish port to new API
- sasl: finish port to new API (needs test)
- libuser: don't commit object changes before passing data to service
  functions which might need differing data sets to figure out what to
  change (for example, ldap)

* Thu Jan 17 2002 Nalin Dahyabhai <nalin@redhat.com> 0.49.90-1
- bind the internal mail spool creation/removal functions for python

* Wed Jan 16 2002 Nalin Dahyabhai <nalin@redhat.com>
- renamed the python module
- revamped internals to use gobject's gvalues and gvaluearrays instead of
  glists of cached strings
- add enumeration-with-data functions to the C library

* Mon Jan 07 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- require linuxdoc-tools instead of sgml-tools for rawhide

* Tue Nov 13 2001 Nalin Dahyabhai <nalin@redhat.com>
- fixup build files to allow building for arbitrary versions of python

* Wed Aug 29 2001 Nalin Dahyabhai <nalin@redhat.com> 0.32-1
- link the python module against libpam
- attempt to import the python modules at build-time to verify dependencies

* Tue Aug 28 2001 Nalin Dahyabhai <nalin@redhat.com> 0.31-1
- fix a file-parsing bug that popped up in 0.29's mmap modifications

* Mon Aug 27 2001 Nalin Dahyabhai <nalin@redhat.com> 0.30-1
- quotaq: fix argument order when reading quota information
- user_quota: set quota grace periods correctly
- luseradd: never create home directories for system accounts

* Tue Aug 21 2001 Nalin Dahyabhai <nalin@redhat.com>
- add da translation files
- update translations

* Tue Aug 21 2001 Nalin Dahyabhai <nalin@redhat.com> 0.29-1
- add an explicit build dependency on jade (for the docs)

* Mon Aug 20 2001 Nalin Dahyabhai <nalin@redhat.com>
- HUP nscd on modifications
- userutil.c: mmap files we're reading for probable speed gain
- userutil.c: be conservative with the amount of random data we read
- docs fixes

* Wed Aug 15 2001 Nalin Dahyabhai <nalin@redhat.com> 0.28-1
- apps: print usage on errors
- lnewusers.c: initialize groups as groups, not users
- lnewusers.c: set passwords for new accounts
- luseradd.c: accept group names in addition to IDs for the -g flag
- luseradd.c: allow the primary GID to be a preexisting group

* Tue Aug 14 2001 Nalin Dahyabhai <nalin@redhat.com> 0.27-1
- add ko translation files
- files.c: fix a heap corruption bug in lock/unlock (#51750)
- files.c: close a memory leak in reading of files

* Mon Aug 13 2001 Nalin Dahyabhai <nalin@redhat.com>
- files.c: remove implementation limits on lengths of lines

* Thu Aug  9 2001 Nalin Dahyabhai <nalin@redhat.com> 0.26-1
- lusermod: change user name in groups the user is a member of during renames
- lgroupmod: change primary GID for users who are in the group during renumbers
- ldap.c: handle new attributes more gracefully if possible
- add ru translation files

* Tue Aug  7 2001 Nalin Dahyabhai <nalin@redhat.com> 0.25.1-1
- rename the quota source files to match the library, which clears up a
  file conflict with older quota packages
- add ja translation files

* Thu Aug  2 2001 Nalin Dahyabhai <nalin@redhat.com>
- add lu_ent_clear_all() function

* Thu Aug  2 2001 Nalin Dahyabhai <nalin@redhat.com> 0.25-1
- close up some memory leaks
- add the ability to include resident versions of modules in the library

* Wed Aug  1 2001 Nalin Dahyabhai <nalin@redhat.com> 0.24-4
- fix incorrect Py_BuildValue invocation in python module

* Tue Jul 31 2001 Nalin Dahyabhai <nalin@redhat.com> 0.24-3
- stop leaking descriptors in the files module
- speed up user creation by reordering some checks for IDs being in use
- update the shadowLastChanged attribute when we set a password
- adjust usage of getXXXXX_r where needed
- fix assorted bugs in python binding which break prompting

* Mon Jul 30 2001 Nalin Dahyabhai <nalin@redhat.com> 0.23-1
- install sv translation
- make lpasswd prompt for passwords when none are given on the command line
- make sure all user-visible strings are marked for translation
- clean up some user-visible strings
- require PAM authentication in lchsh, lchfn, and lpasswd for non-networked modules

* Fri Jul 27 2001 Nalin Dahyabhai <nalin@redhat.com>
- print uids and gids of users and names in lid app
- fix tree traversal in users_enumerate_by_group and groups_enumerate_by_users
- implement enumerate_by_group and enumerate_by_user in ldap module
- fix id-based lookups in the ldap module
- implement islocked() method in ldap module
- implement setpass() method in ldap module
- add lchfn and lchsh apps
- add %%d substitution to libuser.conf

* Thu Jul 26 2001 Nalin Dahyabhai <nalin@redhat.com> 0.21-1
- finish adding a sasldb module which manipulates a sasldb file
- add users_enumerate_by_group and groups_enumerate_by_users

* Wed Jul 25 2001 Nalin Dahyabhai <nalin@redhat.com> 
- luserdel: remove the user's primary group if it has the same name as
  the user and has no members configured (-G disables)
- fixup some configure stuff to make libuser.conf get generated correctly
  even when execprefix isn't specified

* Tue Jul 24 2001 Nalin Dahyabhai <nalin@redhat.com> 0.20-1
- only call the auth module when setting passwords (oops)
- use GTrees instead of GHashTables for most internal tables
- files: complain properly about unset attributes
- files: group passwords are single-valued, not multiple-valued
- add lpasswd app, make sure all apps start up popt with the right names

* Mon Jul 23 2001 Nalin Dahyabhai <nalin@redhat.com> 0.18-1
- actually make the new optional arguments optional
- fix lu_error_new() to actually report errors right
- fix part of the python bindings
- include tools in the binary package again
- fixup modules so that password-changing works right again
- add a "key" field to prompt structures for use by apps which like to
  cache these things
- add an optional "mvhomedir" argument to userModify (python)

* Fri Jul 20 2001 Nalin Dahyabhai <nalin@redhat.com> 0.16.1-1
- finish home directory population
- implement home directory moving
- change entity get semantics in the python bindings to allow default values for .get()
- add lu_ent_has(), and a python has_key() method to Entity types
- don't include tools in the binary package
- add translated strings

* Thu Jul 19 2001 Nalin Dahyabhai <nalin@redhat.com>
- lib/user.c: catch and ignore errors when running stacks
- lusermod: fix slightly bogus help messages
- luseradd: when adding a user and group, use the gid of the group
  instead of the user's uid as the primary group
- properly set the password field in user accounts created using
  auth-only auth modules (shadow needs "x" instead of "!!")
- implement home directory removal, start on population

* Wed Jul 18 2001 Nalin Dahyabhai <nalin@redhat.com>
- fix group password setting in the files module
- setpass affects both auth and info, so run both stacks

* Tue Jul 17 2001 Nalin Dahyabhai <nalin@redhat.com>
- make the testbed apps noinst

* Mon Jul 16 2001 Nalin Dahyabhai <nalin@redhat.com>
- fix errors due to uninitialized fields in the python bindings
- add kwargs support to all python wrappers
- add a mechanism for passing arguments to python callbacks

* Wed Jul 11 2001 Nalin Dahyabhai <nalin@redhat.com>
- stub out the krb5 and ldap modules so that they'll at least compile again
 
* Tue Jul 10 2001 Nalin Dahyabhai <nalin@redhat.com>
- don't bail when writing empty fields to colon-delimited files
- use permissions of the original file when making backup files instead of 0600

* Fri Jul  6 2001 Nalin Dahyabhai <nalin@redhat.com>
- finish implementing is_locked methods in files/shadow module
- finish cleanup of the python bindings
- allow conditional builds of modules so that we can build without
  all of the prereqs for all of the modules

* Thu Jun 21 2001 Nalin Dahyabhai <nalin@redhat.com>
- add error reporting facilities
- split public header into pieces by function
- backend cleanups

* Mon Jun 18 2001 Nalin Dahyabhai <nalin@redhat.com>
- make %%{name}-devel require %%{name} and not %%{name}-devel

* Fri Jun 15 2001 Nalin Dahyabhai <nalin@redhat.com>
- clean up quota bindings some more
- finish most of the ldap bindings
- fix a subtle bug in the files module that would show up when renaming accounts
- fix mapping methods for entity structures in python

* Thu Jun 14 2001 Nalin Dahyabhai <nalin@redhat.com>
- get bindings for prompts to work correctly
- clean up some of the add/remove semantics (set source on add)
- ldap: implement enumeration
- samples/enum: fix the argument order

* Wed Jun 13 2001 Nalin Dahyabhai <nalin@redhat.com>
- clean up python bindings for quota

* Tue Jun 12 2001 Nalin Dahyabhai <nalin@redhat.com> 0.11
- finish up python bindings for quota support

* Sun Jun 10 2001 Nalin Dahyabhai <nalin@redhat.com>
- finish up quota support libs

* Fri Jun  8 2001 Nalin Dahyabhai <nalin@redhat.com>
- start quota support library to get some type safety

* Thu Jun  7 2001 Nalin Dahyabhai <nalin@redhat.com>
- start looking at quota manipulation

* Wed Jun  6 2001 Nalin Dahyabhai <nalin@redhat.com>
- add functions for enumerating users and groups, optionally per-module
- lusermod.c: -s should specify the shell, not the home directory

* Fri Jun  1 2001 Nalin Dahyabhai <nalin@redhat.com> 0.10
- finish the python bindings and verify that the file backend works again

* Wed May 30 2001 Nalin Dahyabhai <nalin@redhat.com>
- remove a redundant check which was breaking modifications

* Tue May 29 2001 Nalin Dahyabhai <nalin@redhat.com>
- finish adding setpass methods

* Wed May  2 2001 Nalin Dahyabhai <nalin@redhat.com> 0.9
- get a start on some Python bindings

* Tue May  1 2001 Nalin Dahyabhai <nalin@redhat.com> 0.8.2
- make binary-incompatible change in headers

* Mon Apr 30 2001 Nalin Dahyabhai <nalin@redhat.com> 0.8.1
- add doxygen docs and a "doc" target for them

* Sat Jan 20 2001 Nalin Dahyabhai <nalin@redhat.com> 0.8
- add a "quiet" prompter
- add --interactive flag to sample apps and default to using quiet prompter
- ldap: attempt a "self" bind if other attempts fail
- krb5: connect to the password-changing service if the user principal has
  the NULL instance

* Wed Jan 10 2001 Nalin Dahyabhai <nalin@redhat.com>
- the great adding-of-the-copyright-statements
- take more care when creating backup files in the files module

* Wed Jan  3 2001 Nalin Dahyabhai <nalin@redhat.com> 0.7
- add openldap-devel as a buildprereq
- krb5: use a continuous connection
- krb5: add "realm" config directive
- ldap: use a continuous connection
- ldap: add "server", "basedn", "binddn", "user", "authuser" config directives
- ldap: actually finish the account deletion function
- ldap: don't send cleartext passwords to the directory
- fix naming attribute for users (should be uid, not gid)
- refine the search-by-id,convert-to-name,search-by-name logic
- fix handling of defaults when the config file is read in but contains no value
- implement an LDAP information store
- try to clean up module naming with libtool
- luseradd: pass plaintext passwords along
- luseradd: use symbolic attribute names instead of hard-coded
- lusermod: pass plaintext passwords along
- lgroupadd: pass plaintext passwords along
- lgroupmod: pass plaintext passwords along
- add libuser as a dependency of libuser-devel

* Tue Jan  2 2001 Nalin Dahyabhai <nalin@redhat.com> 0.6
- initial packaging
