Summary: The standard UNIX FTP (File Transfer Protocol) client.
Name: ftp
Version: 0.17
Release: 22
License: BSD
Group: Applications/Internet
Source0: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit-devel/netkit-ftp-%{version}.tar.bz2
Patch1: netkit-ftp-0.17-pre20000412.pasv-security.patch
Patch2: netkit-ftp-0.17-acct.patch
Patch3: netkit-ftp.usagi-ipv6.patch
Patch4: netkit-ftp-0.17-segv.patch
Patch5: netkit-ftp-0.17-volatile.patch
BuildRoot: /var/tmp/%{name}-root
BuildRequires: gcc, glibc-devel, readline-devel, ncurses-devel, perl

%description
The ftp package provides the standard UNIX command-line FTP (File
Transfer Protocol) client.  FTP is a widely used protocol for
transferring files over the Internet and for archiving files.

If your system is on a network, you should install ftp in order to do
file transfers.

%prep
%setup -q -n netkit-ftp-%{version}
%patch1 -p1
%patch2 -p1 -b .acct
%patch3 -p1 -b .ipv6
%patch4 -p1 -b .segv
%patch5 -p1 -b .volatile

%build
sh configure --with-c-compiler=gcc --enable-ipv6
perl -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -D_GNU_SOURCE -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG

make %{?_smp_mflags}

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man5

make INSTALLROOT=${RPM_BUILD_ROOT} install

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%{_bindir}/ftp
%{_bindir}/pftp
%{_mandir}/man1/ftp.*
%{_mandir}/man1/pftp.*
%{_mandir}/man5/netrc.*

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Jun 14 2004 Alan Cox <alan@redhat.com>
- Re-arranged some totally bogus old bezerkly code that could
  segfault ftp on connection loss. (BZ #122295)

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Dec 13 2002 Elliot Lee <sopwith@redhat.com>
- Rebuild

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri Apr 12 2002 Bernhard Rosenkraenzer <bero@redhat.com> 0.17-13
- Recompile with support for files > 2 GB

* Mon Jun 25 2001 Bernhard Rosenkraenzer <bero@redhat.com> 0.17-12
- Add some Build dependencies (#45007)

* Fri May 18 2001 Bernhard Rosenkraenzer <bero@redhat.com> 0.17-11
- Actually apply Patch #3

* Fri May 11 2001 Bernhard Rosenkraenzer <bero@redhat.com> 0.17-10
- Rebuild with new readline

* Sun Apr 15 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Add IPv6 patch (RFE #35642)

* Wed Apr  4 2001 Jakub Jelinek <jakub@redhat.com>
- don't let configure to guess compiler, it can pick up egcs

* Sun Jan 21 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Update to 0.17 final
- Fix up ACCT support in netrc (Bug #17353)

* Wed Aug 16 2000 Philipp Knirsch <pknirsch@redhat.com>
- Switched the default transfer protocol from PORT to PASV as proposed on
  bugzilla (#16134)
- Fixed a small compiler warning in ftp.c line 886

* Fri Jul 14 2000 Jeff Johnson <jbj@redhat.com>
- add netrc man page (#7443).
- fix possible buffer overflows in ftp client.

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.
- update to 0.17-pre20000412.

* Wed Apr  5 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- rebuild with current libreadline

* Fri Mar 24 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 0.17

* Fri Feb  4 2000 Bill Nottingham <notting@redhat.com>
- handle compressed man pages

* Tue Jan  4 2000 Bill Nottingham <notting@redhat.com>
- the ftp client does not require inetd

* Wed Dec 22 1999 Jeff Johnson <jbj@redhat.com>
- update to 0.16.

* Mon Aug 30 1999 Jeff Johnson <jbj@redhat.com>
- update to 0.15.
- enable readline support (#3796).

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 22)

* Mon Mar 15 1999 Jeff Johnson <jbj@redhat.com>
- compile for 6.0.

* Tue Aug 11 1998 Jeff Johnson <jbj@redhat.com>
- build root

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr
