%define _use_internal_dependency_generator 0
%define __find_requires %{SOURCE99}

Summary: A secure replacement for inetd.
Name: xinetd
Version: 2.3.13
Release: 4
License: Distributable (BSD-like)
Group: System Environment/Daemons
Epoch: 2
Source: http://www.xinetd.org/xinetd-%{version}.tar.gz
Source1: xinetd.init
Source2: xinetd.conf
Source3: xinetd-inetdconvert
Source4: xinetd-ttime
Source5: xinetd-utime
Source6: xinetd-tdtime
Source7: xinetd-udtime
Source8: xinetd-echo
Source9: xinetd-uecho
Source10: xinetd-chargen
Source11: xinetd-uchargen
Source12: xinetd.sysconf
#Source13: xinetd-services
Source99: filter-requires-xinetd.sh
Provides: inetd
Patch0: xinetd-2.3.11-pie.patch
Patch1: xinetd-2.3.13-libwrap.patch
Patch2: xinetd-2.3.12-tcp_rpc.patch
Patch3: xinetd-2.3.13-rpc.patch
Patch4: xinetd-2.3.13-banner.patch
Prereq: /sbin/chkconfig /etc/init.d /sbin/service
BuildRequires: glibc-devel
%{!?tcp_wrappers:BuildRequires: tcp_wrappers}
Requires: filesystem >= 2.0.1, initscripts, setup, fileutils
URL: http://www.xinetd.org
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Obsoletes: inetd, netkit-base

%description
Xinetd is a secure replacement for inetd, the Internet services
daemon. Xinetd provides access control for all services based on the
address of the remote host and/or on time of access and can prevent
denial-of-access attacks. Xinetd provides extensive logging, has no
limit on the number of server arguments, and lets you bind specific
services to specific IP addresses on your host machine. Each service
has its own specific configuration file for Xinetd; the files are
located in the /etc/xinetd.d directory.

%prep
%setup -q  
%patch0 -p0 -b .pie
%patch1 -p1 -b .libwrap
%patch2 -p1 -b .tcp_rpc
%patch3 -p1 -b .rpc
%patch4 -p1 -b .banner

%build
libtoolize --copy --force
%configure --with-loadavg --with-inet6 %{!?tcp_wrappers:--with-libwrap}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
%makeinstall DAEMONDIR=$RPM_BUILD_ROOT/usr/sbin MANDIR=$RPM_BUILD_ROOT/%{_mandir}
mkdir -p $RPM_BUILD_ROOT/etc/xinetd.d/
install -m 755 %SOURCE1 $RPM_BUILD_ROOT/etc/rc.d/init.d/xinetd
install -m 644 %SOURCE2 $RPM_BUILD_ROOT/etc/xinetd.conf
install -m 755 %SOURCE3 $RPM_BUILD_ROOT/usr/sbin/inetdconvert
install -m 644 %SOURCE4 $RPM_BUILD_ROOT/etc/xinetd.d/time
install -m 644 %SOURCE5 $RPM_BUILD_ROOT/etc/xinetd.d/time-udp
install -m 644 %SOURCE6 $RPM_BUILD_ROOT/etc/xinetd.d/daytime
install -m 644 %SOURCE7 $RPM_BUILD_ROOT/etc/xinetd.d/daytime-udp
install -m 644 %SOURCE8 $RPM_BUILD_ROOT/etc/xinetd.d/echo
install -m 644 %SOURCE9 $RPM_BUILD_ROOT/etc/xinetd.d/echo-udp
install -m 644 %SOURCE10 $RPM_BUILD_ROOT/etc/xinetd.d/chargen
install -m 644 %SOURCE11 $RPM_BUILD_ROOT/etc/xinetd.d/chargen-udp
#install -m 644 %SOURCE13 $RPM_BUILD_ROOT/etc/xinetd.d/services

rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/itox*
rm -f $RPM_BUILD_ROOT/usr/sbin/itox
rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/xconv.pl*
rm -f $RPM_BUILD_ROOT/usr/sbin/xconv.pl

mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
install -m 644 %SOURCE12 $RPM_BUILD_ROOT/etc/sysconfig/xinetd

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ $1 = 1 ]; then
    /sbin/chkconfig --add xinetd 
fi

%preun
if [ $1 = 0 ]; then
    /sbin/service xinetd stop > /dev/null 2>&1
    /sbin/chkconfig --del xinetd 
fi

%postun
if [ $1 -ge 1 ]; then
    /sbin/service xinetd condrestart >/dev/null 2>&1
fi


%files
%defattr(-,root,root)
%doc INSTALL CHANGELOG COPYRIGHT README xinetd/sample.conf 

%config(noreplace) /etc/xinetd.conf
%config(noreplace) /etc/sysconfig/xinetd
/usr/sbin/xinetd
/usr/sbin/inetdconvert
%{_mandir}/*/*
%config /etc/rc.d/init.d/xinetd
%config(noreplace) /etc/xinetd.d/*
%config(noreplace) /etc/sysconfig/xinetd

%changelog
* Fri Jun 18 2004 Jay Fenlason <fenlason@redhat.com> 2:2.3.14-4
- Add patch to fix #126242: banner's don't work

* Thu Jun 17 2004 Jay Fenlason <fenlason@redhat.com>
- Remove the configuration for the no-longer-present "services" service.
  Closes #126169

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri May 14 2004 Jay Fenlason <fenlason@redhat.com>
- Add patch to allow multiple rpc services to cooexist as long as they're
  different program numbers or different versions.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Jan 29 2004 Jay Fenlason <fenlason@redhat.com> 2.3.13-1
- Upgrade to new upstream version, which obsoletes most patches.
- Add new tcp_rpc patch, to turn on the nolibwrap flag on tcp rpc services,
  since libwrap cannot be used on them.

* Sun Dec 28 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- use new technology to filter python dep for inetdconvert instead
  of changing the -x bit on file permissions

* Wed Nov 12 2003 Jay Fenlason <fenlason@redhat.com> 2.3.12-3
- build in HEAD for pre FC-2
- merge from xinetd-3E-branch to fix bugzilla #103009
  also includes:
   New upstream version, which obsoletes most of my patches
   Remove %{_mandir}/man8/xconv.pl*  fixing #90730
   Remove the servers service, which was removed from 2.3.12
   Change localization: instead of using en_US in /etc/rc.d/init.d/xinetd
    (overriding the system default and preventing any customization),
    /etc/sysconfig/xinetd sets XINETD_LANG, which is either a locale to use
    or the word "none", which causes all locale environment variables to be
    cleared before xinetd is started.  This fixes #91403
   #77724 was fixed by the upgrade to 2.3.12
   include post 2.3.12 patch from upstream (originally by
    Matthias Andree <ma+xi@dt.e-technik.uni-dortmund.de>) to add a new
    "libwrap" parameter.
    This closes bugs (#91555,#91135,#77724) by making xinetd's behavior
    documented and user-configurable.
   Removed the old libwrap/TCP/wait patch.  If anyone actually cares,
    they can add "flags = NOLIBWRAP" to the configuration of TCP/wait
    services to get the old behavior.
   Mark /etc/sysconfig/xinetd as a config file in xinetd.spec
   Add pie support

* Tue Sep 23 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- allow compiling without tcp_wrappers

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Feb 24 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 21 2003 Jay Fenlason <fenlason@redhat.com> 2.3.10-5
- Merge various patches from xinetd-CVS, since 2.3.11 won't be
  out in time for our Red Hat Linux release.  One improves range checking
  on file descriptors.  (A potential security problem.)  Another
  fixes bugzilla #84840: tcpmux doesn't work at all.  A third improves
  error checking on tcpmux service entries.  The last improves error
  checking on service startup.  

* Tue Feb 11 2003 Nalin Dahyabhai <nalin@redhat.com> 2.3.10-4
- rebuild

* Mon Feb 10 2003 Nalin Dahyabhai <nalin@redhat.com> 2.3.10-3
- rebuild

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Jan  7 2003 Jay Fenlason <fenlason.redhat.com> 2.3.10-1
- Fix #81770, #80612, #79219, #79274: New upstream version
- May also fix #79085, #78903, #78699, #77781, #77760, #76727
- ... #73805, #60049, #58881, #58855
- Fix #79999: remove xinetd-ipv6 executable
- Fix #82021: changed preun to turn off the server
- try to Fix #74198 by quoting "${NETWORKING}" in xinetd.init


* Tue Dec 10 2002 Dan Walsh <dwalsh@redhat.com> 2.3.7-6
- Fix Service startup script to check for id=0

* Tue Nov 19 2002 Bill Nottingham <notting@redhat.com> 2.3.7-5
- add new stream_wait patch (#74696)

* Wed Nov 13 2002 Dan Walsh <dwalsh@redhat.com> 2.3.7-4
- Fix Service Descriptions

* Wed Nov 13 2002 Dan Walsh <dwalsh@redhat.com> 2.3.7-3
- Fix #77710 Fix Service Descriptions

* Thu Aug 15 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.7-2
- Fix #71506 (mixed internal services)

* Mon Aug 12 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.7-1
- 2.3.7 - this fixes #70504

* Mon Aug  5 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.5-6
- Initscript fixes (#70730)

* Wed Jul 17 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.5-5
- Add patch for improved cross compiling (#55927)

* Wed Jul  3 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.5-4
- #67701

* Wed Jun 26 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.5=3
- Fix maks for access control (#65743)
- some fixes for config file parsing

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 30 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.5-1
- 2.3.5

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Apr 22 2002 Trond Eivind Glomsrd <teg@redhat.com>
- 2.3.4 final (bah, never announced... has been out for 3 weeks)

* Thu Apr  4 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.8
- Add a patch to avoid fam haunting the system

* Tue Apr  2 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.7
- Add patch from Alex Larson in order not to use tcp_wrappers on tcp/wait - 
  they'd always be 0.0.0.0

* Thu Mar 28 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.6
- 2002-03-26. 2.3.4 final RSN

* Fri Mar  1 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.5
- 2002-02-28-1

* Sun Jan  6 2002 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.4
- 2002-01-04
- Update URLs

* Fri Dec 14 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.3
- 2001-12-13

* Mon Dec  3 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.2
- 2001-12-03 (fixes #57001, #55738)

* Fri Nov 30 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.4-0.1
- 2001-11-29, which fixes #56487
- Add configuration files for the xinetd internal services listing 
  current servers and services. It's off by default, and restricted
  to localhost when enabled (#52707)
- Use SIGHUP for configuration reload (change in program)

* Wed Aug 29 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.3-1
- 2.3.3
- parser patch now obsolete

* Thu Aug 23 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.2-1
- 2.3.2, which contains the memory overwrite patch, 
  the audit fixes, the conn_free patch and the filelog patch.
- Fix handling of rpc_version with ranges (like "1-2") (#51737)

* Wed Aug 15 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.0-7
- Don't apply the skipjunk patch anymore - xinetd now skips files with ".", 
  which include .rpmsave etc.
- fix memory overwrite bug in env.c:grow()

* Mon Aug 13 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.0-6
- conn_free was called twice...
- add cps = 25 30 to xinetd.conf. Thus, if a service has many 
  connections (25 in a 1 second period), it will be disabled
  for 30 seconds. Without this, 10 connections to a service in
  a second would permanently disable the service (#49122)

* Thu Aug  9 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.0-5
- add the patch from "Solar Designer"'s audit

* Thu Aug  9 2001 Trond Eivind Glomsrd <teg@redhat.com> 2.3.0-4
- Make it handle stop and status when IPv6 is enabled (#49621)

* Mon Jul 23 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add IPv6 support - separate binary, invoked if 
  NETWORKING_IPV6 is set (#49621)
- Make inetdconvert handle the "/usr/sbin/in.telnetd in.telnetd" 
  scenario of inetd (#46449)

* Tue Jul  3 2001 Trond Eivind Glomsrd <teg@redhat.com>
- redo skipjunkfile patch

* Fri Jun 29 2001 Trond Eivind Glomsrd <teg@redhat.com>
- 2.3.0

* Thu Jun 21 2001 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre16

* Mon Jun  4 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Remove explicit dependancy on initscripts version

* Sun May 20 2001 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre15, which should fix wait=yes with tcp (linuxconf is
  the only program I know of using this)
- fix some problems with UDP internal services (#38669)
- make /etc/xinetd.conf noreplace

* Wed Apr 25 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add the tcp wait=yes patch from the xinetd version in a different tree

* Wed Apr  4 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add /etc/sysconfig/xinetd so users can add extra options (#34321)

* Tue Feb 27 2001 Preston Brown <pbrown@redhat.com>
- noreplace the xinetd.d files

* Mon Feb  5 2001 Preston Brown <pbrown@redhat.com>
- built against newer tcp_wrappers that fixes name resolution problem (#16949)

* Mon Feb  5 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Patch from nalin@redhat.com for terminating the environment variables properly

* Tue Jan 30 2001 Trond Eivind Glomsrd <teg@redhat.com>
- remove PID from log_on_failure flags (#22687)

* Tue Jan 23 2001 Trond Eivind Glomsrd <teg@redhat.com>
- improve gettextization
- add "UNLISTED" to the internal udp services (#24279)

* Thu Jan 18 2001 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre14

* Wed Jan 17 2001 Trond Eivind Glomsrd <teg@redhat.com>
- gettextize

* Sat Dec 30 2000 Jeff Johnson <jbj@redhat.com>
- remove python dependency.

* Tue Dec 26 2000 Trond Eivind Glomsrd <teg@redhat.com>
- remove RECORD from xinetd.conf for security reasons
  (no known holes, but better safe than sorry #22687)

* Mon Dec 04 2000 Trond Eivind Glomsrd <teg@redhat.com>
- unset a couple of environment variables(HOME,MAIL) in the initscript.
  This should avoid problems like bug #21663

* Fri Dec 01 2000 Trond Eivind Glomsrd <teg@redhat.com>
- rebuild

* Tue Nov 14 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre13, which should fix #19355
- changes to initscript - set all locale environment variables
  to en_US, as the server doesn't know what locale the client
  expects  and error messages can otherwise be confusing 
  (partially #20566)

* Thu Nov 09 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix mismatch in documentation vs. reality, introduced
  when we changed the behaviour of the access control
  to use server names (#20567)

* Tue Oct 31 2000 Trond Eivind Glomsrd <teg@redhat.com>
- obsolete netkit-base, which was inetd's home until 6.2 
  
* Thu Oct 19 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre12, which has a new "-stayalive" option so 
  xinetd stays alive even if no services are enabled.
- use the above in the initscript (#18819)

* Tue Oct 17 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre11, which includes the previous bugfixes.
- don't convert the internal services, include 
  such files with xinetd (#17331, #18899)

* Mon Oct 09 2000 Trond Eivind Glomsrd <teg@redhat.com>
- Add patch to fix segfault problem (#18686)

* Fri Oct 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- apply patch from nalin@redhat.com for handling tcp
  connections with wait=yes properly

* Tue Sep 26 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add explicit dependency on a modern version of initscripts 
  (#17533)

* Wed Aug 30 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre10 - remove tcpwrapper and pidfile patches,
  as they are now in.
- change default startup position to 56, so it 
  starts after bind (#17047)

* Thu Aug 18 2000 Trond Eivind Glomsrd <teg@redhat.com>
- use the server name not the service name for libwrap
  checking (#16516). The new way was better, but
  this is sacrificed so old systems will continue to work
  and the documentation for tcp_wrappers can be correct.

* Wed Aug 16 2000 Than Ngo <than@redhat.com>
- fix initscript, test network file before source it (Bug #16247)

* Tue Aug 15 2000 Trond Eivind Glomsrd <teg@redhat.com
- make the pidfile 0644, not 0300 (#16256)

* Tue Aug 08 2000 Trond Eivind Glomsrd <teg@redhat.com>
- added support for "-pidfile" option (#15531)

* Fri Aug 04 2000 Trond Eivind Glomsrd <teg@redhat.com>
- added patch to ignore .rpmsave, .rpmorig, .rpmnew, ~ 
  suffixed files (#15304)

* Thu Aug 03 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre9, old patches are now integrated.

* Wed Aug 02 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix converting of "wait" argument (#13884) 
- remove tcpd and /usr/sbin/tcpd from inetd.conf services
  before converting - xinetd is linked against tcp_wrappers 

* Mon Jul 31 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix linuxconf restart problem (#14856)
- fix conditional restart
- mark /etc/xinetd.conf as a configuration file

* Tue Jul 25 2000 Bill Nottingham <notting@redhat.com>
- um, we *need* to prereq /etc/init.d

* Mon Jul 24 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Don't require /etc/init.d

* Sat Jul 22 2000 Bill Nottingham <notting@redhat.com>
- rebuild

* Tue Jul 18 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix the sections of the man pages (#14244)

* Tue Jul 18 2000 Trond Eivind Glomsrd <teg@redhat.com>
- remove itox, as it wouldn't do the right thing with our
  configuration
- same with xconv.pl
- some changes to the installation process

* Mon Jul 17 2000 Trond Eivind Glomsrd <teg@redhat.com>
- move initscript back to /etc/rc.d/init.d

* Fri Jul 14 2000 Trond Eivind Glomsrd <teg@redhat.com>
- change process name in init file

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Fri Jul  7 2000 Nalin Dahyabhai <nalin@redhat.com>
- start the daemon with the "-reuse" flag

* Thu Jul 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- "Prereq:", not "Requires:" for /etc/init.d

* Wed Jul 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- require /etc/init.d

* Wed Jul  5 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- upper the number of instances to 60

* Sun Jul  2 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix a memory-allocation bug

* Wed Jun 28 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre8

* Wed Jun 21 2000 Trond Eivind Glomsrd <teg@redhat.com>
- moved to /etc/init.d

* Wed Jun 21 2000 Trond Eivind Glomsrd <teg@redhat.com>
- changed specfile and initfile to implement conditional
  restart

* Sun Jun 18 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre7
- now obsoletes inetd
- use %%{_tmppath}

* Sun Jun 04 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre6
- added converter script which can convert specified or 
  remaing uncoverted services
- use %%{_mandir}
- removed +x on xinetd.conf

* Wed May 24 2000 Trond Eivind Glomsrd <teg@redhat.com>
- 2.1.8.9pre4
- authpriv patch no longer needed

* Tue May 23 2000 Trond Eivind Glomsrd <teg@redhat.com>
- /etc/xinetd.d is now part of the filesystem package
- more fixes to xinetd.init

* Mon May 22 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fixed some obvious bugs in xinetd.init
- added a default xinetd.conf
- patched xinetd to understand LOG_AUTHPRIV

* Fri May 19 2000 Trond Eivind Glomsrd <teg@redhat.com>
- updated version
- removed a define %ver (we already have %version)
- removed some extra CFLAGS declarations
- added configuration directory, /etc/xinetd.d

* Mon Feb 21 2000 Tim Powers <timp@redhat.com>
- fixed broken postun sections, should have been *preun*
- fixed broken gzip of manpages

* Wed Jan 19 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 2.1.8.8p8
- Fix the init script (Bug #7277)
- remove our patches (no longer required)

* Tue Sep 21 1999 Bill Nottingham <notting@redhat.com>
- add -lnsl

* Tue Sep 7 1999 Tim Powers <timp@redhat.com>
- modification top install routine

* Mon Jul 26 1999 Tim Powers <timp@redhat.com>
- updated source to 2.1.8.6b6
- built for 6.1

* Mon Apr 26 1999 Bill Nottingham <notting@redhat.com>
- update to 2.1.8.6b5
- build for PowerTools

* Mon Jan 10 1999 Bill Nottingham <notting@redhat.com>
- update to 2.1.8.5p2

* Tue Dec  1 1998 Bill Nottingham <notting@redhat.com>
- intial build
