#include <tls.h>
#include "tlsdesc.h"

	.text
#ifdef USE_TLS
	.hidden	_dl_tlsdesc_return
	.global	_dl_tlsdesc_return
	.type	_dl_tlsdesc_return,@function
_dl_tlsdesc_return:
	ret
	.size	_dl_tlsdesc_return, .-_dl_tlsdesc_return

#ifdef SHARED
	.hidden _dl_tlsdesc_dynamic
	.global	_dl_tlsdesc_dynamic
	.type	_dl_tlsdesc_dynamic,@function
	
     /* We get in gr9 a pointer to a struct tlsdesc, and have to
	return the TLS offset for the corresponding variable, without
	clobbering any registers other than gr8.  The assembly code
	that follows is a rendition of the following C code, massaged
	to preserve call-clobbered registers as needed, especially
	across the __tls_get_addr call.
	
#define O2I(X) ((X) / sizeof(dtv_t))

ptrdiff_t _dl_tlsdesc_dynamic(void *x, struct tlsdesc *td)
{
  dtv_t *dtv = *(dtv_t **)((char *)tp - 2048);
  if (__builtin_expect (td->gen_count <= dtv[0].counter
			&& (dtv[O2I(td->modidoff)].pointer
			    != TLS_DTV_UNALLOCATED),
			1))
    return dtv[O2I(td->modidoff)].pointer - __thread_pointer;

  return __tls_get_addr (O2I(td->modidoff), td->modoff) - __thread_pointer;
}
*/

_dl_tlsdesc_dynamic:
	ldi.p	@(gr29,DTV_OFFSET), gr8 ; DTV address
	addi	sp,-16,sp
	stdi	gr10, @(sp,8)
	std.p	gr12, @(sp,gr0)
	mov	gr8, gr12
	movsg	ccr, gr13
	
	ldi	@(gr9,TLSDESC_GEN_COUNT), gr10
	ld	@(gr12,gr0), gr11 ; DTV's generation counter
.if TLSDESC_MODIDOFF == 0	
	ldd.p	@(gr9,gr0), gr10		; modidoff & tlsmoff
.else
	lddi.p	@(gr9,TLSDESC_MODIDOFF), gr10	; modidoff & tlsmoff
.endif
	cmp	gr10, gr11, icc0
	bhi	icc0,0,.L0
	ld	@(gr12, gr10),gr8	; dtv[modid] (pointer)
	cmpi	gr8,-1,icc0
	beq	icc0,0,.L0
	
	movgs	gr13, ccr
	ldd.p	@(sp,gr0), gr12
	add	gr8,gr11,gr8
	lddi.p	@(sp,8), gr10
	sub	gr8, gr29, gr9
	addi.p	sp,16,sp
	ret
	
.L0:
	;; Save all registers
	
	;; Ok, not all of them, only the call-clobbered ones other
	;; than those we're entitled to clobber, i.e., gr8 and gr9,
	;; and any registers we assume __tls_get_addr won't clobber,
	;; such as floating-point ones.

#define COMMON 48

#if __FRV_GPR__ == 64
#define TOTAL (COMMON+64)
#elif __FRV_GPR__ == 32
#define TOTAL (COMMON)
#else
# error unsupported __FRV_GPR__ value
#endif 

	addi	sp, -TOTAL, sp
	std	gr2, @(sp, gr0)
	stdi	gr4, @(sp, 8)
	stdi	gr6, @(sp, 16)
	stdi	gr14, @(sp, 24)
	movsg	lr, gr12
	movsg	cccr, gr4
	movsg	lcr, gr5
	stdi	gr12, @(sp, 32)
	stdi	gr4, @(sp, 40)

#if __FRV_GPR__ == 64
	stdi	gr32, @(sp, COMMON)
	stdi	gr34, @(sp, COMMON+8)
	stdi	gr36, @(sp, COMMON+16)
	stdi	gr38, @(sp, COMMON+24)
	stdi	gr40, @(sp, COMMON+32)
	stdi	gr42, @(sp, COMMON+40)
	stdi	gr44, @(sp, COMMON+48)
	stdi	gr46, @(sp, COMMON+56)
#endif

;;	ldi.p	@(gr15, 4), gr15
	/* We could use the above instead, with identical results, but
	   it would lose in terms of cache locality, and wouldn't
	   actually save us any space in TLS descriptors.  */
	ldi.p	@(gr9, TLSDESC_GP), gr15
	mov	sp,fp
	srli.p	gr10, 2, gr8	; shift modidoff right to get modid
	mov	gr11, gr9	; move tlsmoff into place
	call	__tls_get_addr
	
	;; Restore all registers
	lddi.p	@(sp, 40), gr14
	sub	gr8, gr29, gr9	; compute TLS offset
	lddi	@(sp, 32), gr12
	movgs	gr15, lcr
	movgs	gr14, cccr
	movgs	gr13, ccr
	ldd.p	@(sp, gr0), gr2
	mov	gr12, gr8	; return address
	lddi	@(sp, 8), gr4
	lddi	@(sp, 16), gr6
	lddi	@(sp, 24), gr14
	
#if __FRV_GPR__ == 64
	lddi	@(sp, COMMON), gr32
	lddi	@(sp, COMMON+8), gr34
	lddi	@(sp, COMMON+16), gr36
	lddi	@(sp, COMMON+24), gr38
	lddi	@(sp, COMMON+32), gr40
	lddi	@(sp, COMMON+40), gr42
	lddi	@(sp, COMMON+48), gr44
	lddi	@(sp, COMMON+56), gr46
#endif
	
	lddi	@(sp, TOTAL), gr12
	lddi	@(sp, TOTAL+8), gr10

	jmpl.p	@(gr8, gr0)
	addi	sp,TOTAL+16,sp
	.size	_dl_tlsdesc_dynamic, .-_dl_tlsdesc_dynamic
#endif /* SHARED */
#endif /* USE_TLS */
