'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: code.n,v 1.4 2000/10/11 22:11:42 spolk Exp $
'\"
.so man.macros
.TH code n 3.0 itcl "[incr\ Tcl]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
code \- capture the namespace context for a code fragment
.SH SYNOPSIS
\fBcode \fR?\fB-namespace \fIname\fR? \fIcommand \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
Creates a scoped value for the specified \fIcommand\fR and its
associated \fIarg\fR arguments.  A scoped value is a list with three
elements:  the "\fC@scope\fR" keyword, a namespace context,
and a value string.  For example, the command
.CS
namespace foo {
    code puts "Hello World!"
}
.CE
produces the scoped value:
.CS
@scope ::foo {puts {Hello World!}}
.CE
Note that the \fBcode\fR command captures the current namespace
context.  If the \fB-namespace\fR flag is specified, then the
current context is ignored, and the \fIname\fR string is used
as the namespace context.
.PP
Extensions like Tk execute ordinary code fragments in the global
namespace.  A scoped value captures a code fragment together with
its namespace context in a way that allows it to be executed
properly later.  It is needed, for example, to wrap up code fragments
when a Tk widget is used within a namespace:
.CS
namespace foo {
    private proc report {mesg} {
        puts "click: $mesg"
    }

    button .b1 -text "Push Me" \
        -command [code report "Hello World!"]
    pack .b1
}
.CE
The code fragment associated with button \fC.b1\fR only makes
sense in the context of namespace "foo".  Furthermore, the
"report" procedure is private, and can only be accessed within
that namespace.  The \fBcode\fR command wraps up the code
fragment in a way that allows it to be executed properly
when the button is pressed.
.PP
Also, note that the \fBcode\fR command preserves the integrity
of arguments on the command line.  This makes it a natural replacement
for the \fBlist\fR command, which is often used to format Tcl code
fragments.  In other words, instead of using the \fBlist\fR command
like this:
.CS
after 1000 [list puts "Hello $name!"]
.CE
use the \fBcode\fR command like this:
.CS
after 1000 [code puts "Hello $name!"]
.CE
This not only formats the command correctly, but also captures
its namespace context.
.PP
Scoped commands can be invoked like ordinary code fragments, with
or without the \fBeval\fR command.  For example, the following
statements work properly:
.CS
set cmd {@scope ::foo .b1}
$cmd configure -background red

set opts {-bg blue -fg white}
eval $cmd configure $opts
.CE
Note that scoped commands by-pass the usual protection mechanisms;
the command:
.CS
@scope ::foo {report {Hello World!}}
.CE
can be used to access the "foo::report" proc from any namespace
context, even though it is private.

.SH KEYWORDS
scope, callback, namespace, public, protected, private
