/* Header file the type CGEN_ISA_MASK.

Copyright 2002 Free Software Foundation, Inc.

This file is part of GDB, the GNU debugger, and the GNU Binutils.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef CGEN_BITSET_H
#define CGEN_BITSET_H

#ifdef __cplusplus
extern "C" {
#endif

/* A bitmask of ISAs represented as a string.
   A cpu may support more than one isa. Each is represented as a bit
   in the string. Bytes are indexed from left to right in the string and
   bits from most significant to least within each byte.

   For example, the bit representing ISA number 6 is (mask->bits[0] & 0x02).
*/
typedef struct cgen_isa_mask
{
  unsigned length;
  char *bits;
} CGEN_ISA_MASK;

extern CGEN_ISA_MASK *cgen_isa_mask_create PARAMS ((unsigned));
extern void cgen_isa_mask_init PARAMS ((CGEN_ISA_MASK *, unsigned));
extern void cgen_isa_mask_clear PARAMS ((CGEN_ISA_MASK *));
extern void cgen_isa_mask_add PARAMS ((CGEN_ISA_MASK *, unsigned));
extern void cgen_isa_mask_set PARAMS ((CGEN_ISA_MASK *, unsigned));
extern int cgen_isa_mask_compare PARAMS ((CGEN_ISA_MASK *, CGEN_ISA_MASK *));
extern void cgen_isa_mask_combine PARAMS ((CGEN_ISA_MASK *, CGEN_ISA_MASK *, CGEN_ISA_MASK *));
extern int cgen_isa_mask_intersection PARAMS ((CGEN_ISA_MASK *, CGEN_ISA_MASK *));
extern int cgen_isa_supported PARAMS ((CGEN_ISA_MASK *, unsigned));
extern CGEN_ISA_MASK *cgen_isa_mask_copy PARAMS ((CGEN_ISA_MASK *));

#ifdef __cplusplus
} // extern "C"
#endif

#endif
