/**
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wildfly.swarm.jaxrs;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Test;
import org.junit.runner.RunWith;

import static org.fest.assertions.Assertions.assertThat;

/**
 * @author Bob McWhirter
 */
@RunWith(Arquillian.class)
public class ArqJAXRSExceptionMapperTest {

    @Deployment(testable = false)
    public static Archive createDeployment() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("project-test-defaults-path.yml");
        assertThat(url).isNotNull();
        File projectDefaults = new File(url.toURI());
        JAXRSArchive deployment = ShrinkWrap.create(JAXRSArchive.class, "myapp.war");
        deployment.addClass(JsonProcessingExceptionMapper.class);
        deployment.addClass(CustomExceptionMapper.class);
        deployment.addClass(CustomException.class);
        deployment.addResource(JsonParsingExceptionResource.class);
        deployment.addResource(CustomExceptionResource.class);
        deployment.addAsResource(projectDefaults, "/project-defaults.yml");
        deployment.addAllDependencies();
        return deployment;
    }

    @Test
    @RunAsClient
    public void testCustom() throws Exception {
        String content = IOUtils.toString(new URL("http://localhost:8080/custom/throw"), Charset.forName("UTF-8"));
        assertThat(content).contains("mapped custom: Custom exception");
    }

    @Test
    @RunAsClient
    public void testJson() throws Exception {
        String content = IOUtils.toString(new URL("http://localhost:8080/json/throw"), Charset.forName("UTF-8"));
        assertThat(content).contains("mapped json: that didn't work");
    }

}
