#!/bin/bash

PME_ARGS=(
  "-Dswarm.product.build"
  "-Dswarm.docs.skip"
  "-Pcore-testsuite"
  "-DdependencyOverride.org.keycloak:*@*=4.8.18.Final-redhat-00001"
  "-DdependencyOverride.org.slf4j:*@*=1.7.22.redhat-2"
  "-DdependencyOverride.com.google.guava:guava@*=25.0.0.redhat-1"
  "-DdependencyOverride.org.jboss.eap:*@*=7.2.7.GA-redhat-00004"
)

if [[ "$1" == "--skip-default-pme-args" ]] ; then
  PME_ARGS=()
  shift
fi

BASE_URL=https://repo1.maven.org/maven2/org/commonjava/maven/ext/pom-manipulation-cli
VERSION=$(curl --silent $BASE_URL/maven-metadata.xml | xmlstarlet select --template --value-of '/metadata/versioning/latest')
FILE=pom-manipulation-cli-$VERSION.jar
if [[ ! -f $FILE ]] ; then
  echo "Downloading $FILE"
  curl --silent --remote-name $BASE_URL/$VERSION/$FILE
  echo "Downloaded $FILE"
else
  echo "Using existing $FILE"
fi

java -jar $FILE -DdependencySource=REST -DversionIncrementalSuffix=redhat -DversionIncrementalSuffixPadding=5 -DrestURL=http://da.psi.redhat.com/da/rest/v-1 "${PME_ARGS[@]}" "$@"
