/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.gjt.jclasslib.io.Log;
import org.gjt.jclasslib.structures.AbstractStructureWithAttributes;
import org.gjt.jclasslib.structures.AccessFlags;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public class ClassFile
extends AbstractStructureWithAttributes {
    public static final String SYSTEM_PROPERTY_SKIP_CONSTANT_POOL = "jclasslib.io.skipConstantPool";
    private static final int MAGIC_NUMBER = -889275714;
    private final boolean skipConstantPool;
    private int minorVersion;
    private int majorVersion;
    private CPInfo[] constantPool;
    private HashMap constantPoolEntryToIndex = new HashMap();
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    static /* synthetic */ Class class$org$gjt$jclasslib$structures$constants$ConstantUtf8Info;

    public ClassFile() {
        this.skipConstantPool = Boolean.getBoolean(SYSTEM_PROPERTY_SKIP_CONSTANT_POOL);
        this.setClassFile(this);
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public CPInfo[] getConstantPool() {
        return this.constantPool;
    }

    public int getConstantPoolIndex(CPInfo cPInfo) {
        Integer n = (Integer)this.constantPoolEntryToIndex.get(cPInfo);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public void setConstantPool(CPInfo[] cPInfoArray) {
        this.constantPool = cPInfoArray;
        for (int i = 0; i < cPInfoArray.length; ++i) {
            this.constantPoolEntryToIndex.put(cPInfoArray[i], new Integer(i));
        }
    }

    public void enlargeConstantPool(CPInfo[] cPInfoArray) {
        int n = this.constantPool == null ? 0 : this.constantPool.length;
        this.constantPool = cPInfoArray;
        for (int i = n; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPoolEntryToIndex.put(this.constantPool[i], new Integer(i));
        }
    }

    public void registerConstantPoolEntry(int n) {
        this.constantPoolEntryToIndex.put(this.constantPool[n], new Integer(n));
    }

    public void unregisterConstantPoolEntry(int n) {
        this.constantPoolEntryToIndex.remove(this.constantPool[n]);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public int getThisClass() {
        return this.thisClass;
    }

    public void setThisClass(int n) {
        this.thisClass = n;
    }

    public String getThisClassName() throws InvalidByteCodeException {
        return this.getConstantPoolEntryName(this.getThisClass());
    }

    public int getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(int n) {
        this.superClass = n;
    }

    public String getSuperClassName() throws InvalidByteCodeException {
        return this.getConstantPoolEntryName(this.getSuperClass());
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public void setFields(FieldInfo[] fieldInfoArray) {
        this.fields = fieldInfoArray;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodInfo[] methodInfoArray) {
        this.methods = methodInfoArray;
    }

    public String getFormattedAccessFlags() {
        return this.printAccessFlags(this.accessFlags);
    }

    public String getAccessFlagsVerbose() {
        return this.printAccessFlagsVerbose(this.accessFlags);
    }

    public ConstantUtf8Info getConstantPoolUtf8Entry(int n) throws InvalidByteCodeException {
        return (ConstantUtf8Info)this.getConstantPoolEntry(n, class$org$gjt$jclasslib$structures$constants$ConstantUtf8Info == null ? (class$org$gjt$jclasslib$structures$constants$ConstantUtf8Info = ClassFile.class$("org.gjt.jclasslib.structures.constants.ConstantUtf8Info")) : class$org$gjt$jclasslib$structures$constants$ConstantUtf8Info);
    }

    public CPInfo getConstantPoolEntry(int n, Class clazz) throws InvalidByteCodeException {
        if (!this.checkValidConstantPoolIndex(n)) {
            return null;
        }
        CPInfo cPInfo = this.constantPool[n];
        if (cPInfo == null) {
            return null;
        }
        if (clazz.isAssignableFrom(cPInfo.getClass())) {
            return cPInfo;
        }
        throw new InvalidByteCodeException("constant pool entry at " + n + " is not assignable to " + clazz.getName());
    }

    public String getConstantPoolEntryName(int n) throws InvalidByteCodeException {
        if (!this.checkValidConstantPoolIndex(n)) {
            return null;
        }
        CPInfo cPInfo = this.constantPool[n];
        if (cPInfo == null) {
            return "invalid constant pool index";
        }
        return cPInfo.getVerbose();
    }

    public int getFieldIndex(String string, String string2) throws InvalidByteCodeException {
        for (int i = 0; i < this.fields.length; ++i) {
            FieldInfo fieldInfo = this.fields[i];
            if (!fieldInfo.getName().equals(string) || !fieldInfo.getDescriptor().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public FieldInfo getField(String string, String string2) throws InvalidByteCodeException {
        int n = this.getFieldIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.fields[n];
    }

    public int getMethodIndex(String string, String string2) throws InvalidByteCodeException {
        for (int i = 0; i < this.methods.length; ++i) {
            MethodInfo methodInfo = this.methods[i];
            if (!methodInfo.getName().equals(string) || !methodInfo.getDescriptor().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public MethodInfo getMethod(String string, String string2) throws InvalidByteCodeException {
        int n = this.getMethodIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.methods[n];
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.readMagicNumber(dataInput);
        this.readVersion(dataInput);
        this.readConstantPool(dataInput);
        this.readAccessFlags(dataInput);
        this.readThisClass(dataInput);
        this.readSuperClass(dataInput);
        this.readInterfaces(dataInput);
        this.readFields(dataInput);
        this.readMethods(dataInput);
        this.readAttributes(dataInput);
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        this.writeMagicNumber(dataOutput);
        this.writeVersion(dataOutput);
        this.writeConstantPool(dataOutput);
        this.writeAccessFlags(dataOutput);
        this.writeThisClass(dataOutput);
        this.writeSuperClass(dataOutput);
        this.writeInterfaces(dataOutput);
        this.writeFields(dataOutput);
        this.writeMethods(dataOutput);
        this.writeAttributes(dataOutput);
    }

    private boolean checkValidConstantPoolIndex(int n) {
        return n >= 1 && n < this.constantPool.length;
    }

    private void readMagicNumber(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readInt();
        if (n != -889275714) {
            throw new InvalidByteCodeException("Invalid magic number 0x" + Integer.toHexString(n) + " instead of 0x" + Integer.toHexString(-889275714));
        }
        if (this.debug) {
            this.debug("read magic number");
        }
    }

    private void writeMagicNumber(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(-889275714);
        if (this.debug) {
            this.debug("wrote magic number");
        }
    }

    private void readVersion(DataInput dataInput) throws IOException {
        this.minorVersion = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read minor version " + this.minorVersion);
        }
        this.majorVersion = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read major version " + this.majorVersion);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    private void writeVersion(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.minorVersion);
        if (this.debug) {
            this.debug("wrote minor version " + this.minorVersion);
        }
        dataOutput.writeShort(this.majorVersion);
        if (this.debug) {
            this.debug("wrote major version " + this.majorVersion);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    private void readConstantPool(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.constantPoolEntryToIndex.clear();
        int n = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read constant pool count " + n);
        }
        this.constantPool = new CPInfo[n];
        for (int i = 1; i < n; ++i) {
            if (this.skipConstantPool) {
                i += CPInfo.skip(dataInput);
                continue;
            }
            if (this.debug) {
                this.debug("reading constant pool entry " + i);
            }
            this.constantPool[i] = CPInfo.create(dataInput, this);
            this.constantPoolEntryToIndex.put(this.constantPool[i], new Integer(i));
            if (!(this.constantPool[i] instanceof ConstantLargeNumeric)) continue;
            ++i;
        }
    }

    private void writeConstantPool(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n;
        for (n = this.getLength(this.constantPool) - 1; n >= 0 && this.constantPool[n] == null; --n) {
        }
        dataOutput.writeShort(n + 1);
        if (this.debug) {
            this.debug("wrote constant pool count " + (n + 1));
        }
        for (int i = 1; i <= n; ++i) {
            if (this.constantPool[i] == null) {
                throw new InvalidByteCodeException("constant pool entry " + i + " is null");
            }
            if (this.debug) {
                this.debug("writing constant pool entry " + i);
            }
            this.constantPool[i].write(dataOutput);
            if (!(this.constantPool[i] instanceof ConstantLargeNumeric)) continue;
            ++i;
        }
    }

    private void readAccessFlags(DataInput dataInput) throws IOException {
        this.accessFlags = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read access flags " + this.printAccessFlags(this.accessFlags));
        }
    }

    private void writeAccessFlags(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.accessFlags);
        if (this.debug) {
            this.debug("wrote access flags " + this.printAccessFlags(this.accessFlags));
        }
    }

    private void readThisClass(DataInput dataInput) throws IOException {
        this.thisClass = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read this_class index " + this.thisClass);
        }
    }

    private void writeThisClass(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.thisClass);
        if (this.debug) {
            this.debug("wrote this_class index " + this.thisClass);
        }
    }

    private void readSuperClass(DataInput dataInput) throws IOException {
        this.superClass = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read super_class index " + this.superClass);
        }
    }

    private void writeSuperClass(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.superClass);
        if (this.debug) {
            this.debug("wrote super_class index " + this.superClass);
        }
    }

    private void readInterfaces(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read interfaces count " + n);
        }
        this.interfaces = new int[n];
        for (int i = 0; i < n; ++i) {
            this.interfaces[i] = dataInput.readUnsignedShort();
            if (!this.debug) continue;
            this.debug("read interface index " + this.interfaces[i]);
        }
    }

    private void writeInterfaces(DataOutput dataOutput) throws IOException {
        int n = this.getLength(this.interfaces);
        dataOutput.writeShort(n);
        if (this.debug) {
            this.debug("wrote interfaces count " + n);
        }
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(this.interfaces[i]);
            if (!this.debug) continue;
            this.debug("wrote interface index " + this.interfaces[i]);
        }
    }

    private void readFields(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read fields count " + n);
        }
        this.fields = new FieldInfo[n];
        for (int i = 0; i < n; ++i) {
            this.fields[i] = FieldInfo.create(dataInput, this);
        }
    }

    private void writeFields(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n = this.getLength(this.fields);
        dataOutput.writeShort(n);
        if (this.debug) {
            this.debug("wrote fields count " + n);
        }
        for (int i = 0; i < n; ++i) {
            if (this.fields[i] == null) {
                throw new InvalidByteCodeException("field " + i + " is null");
            }
            this.fields[i].write(dataOutput);
        }
    }

    private void readMethods(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read methods count " + n);
        }
        this.methods = new MethodInfo[n];
        for (int i = 0; i < n; ++i) {
            this.methods[i] = MethodInfo.create(dataInput, this);
        }
    }

    private void writeMethods(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n = this.getLength(this.methods);
        dataOutput.writeShort(n);
        if (this.debug) {
            this.debug("wrote methods count " + n);
        }
        for (int i = 0; i < n; ++i) {
            if (this.methods[i] == null) {
                throw new InvalidByteCodeException("method " + i + " is null");
            }
            this.methods[i].write(dataOutput);
        }
    }

    protected void readAttributes(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.readAttributes(dataInput);
        if (this.debug) {
            this.debug("read " + this.getLength(this.attributes) + " attributes for the ClassFile structure");
        }
    }

    protected void writeAttributes(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.writeAttributes(dataOutput);
        if (this.debug) {
            this.debug("wrote " + this.getLength(this.attributes) + " attributes for the ClassFile structure");
        }
    }

    private void checkMajorVersion(int n) {
        if (n < 45 || n > 49) {
            Log.warning("major version should be between 45 and 49 for JDK <= 1.5");
        }
    }

    protected String printAccessFlagsVerbose(int n) {
        return this.printAccessFlagsVerbose(AccessFlags.CLASS_ACCESS_FLAGS, AccessFlags.CLASS_ACCESS_FLAGS_VERBOSE, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

