/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.visitor;

import jd.xml.xpath.VariableName;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.expr.compare.CompareFactory;
import jd.xml.xpath.expr.function.Function;
import jd.xml.xpath.expr.misc.Constant;
import jd.xml.xpath.expr.misc.Negate;
import jd.xml.xpath.expr.misc.ParenthesisExpression;
import jd.xml.xpath.expr.operator.Add;
import jd.xml.xpath.expr.operator.And;
import jd.xml.xpath.expr.operator.Divide;
import jd.xml.xpath.expr.operator.Modulo;
import jd.xml.xpath.expr.operator.Multiply;
import jd.xml.xpath.expr.operator.Or;
import jd.xml.xpath.expr.operator.Subtract;
import jd.xml.xpath.expr.operator.Union;
import jd.xml.xpath.expr.path.ComposedPath;
import jd.xml.xpath.expr.path.FilteredLocationStep;
import jd.xml.xpath.expr.path.LocationStep;
import jd.xml.xpath.expr.path.LocationStepChain;
import jd.xml.xpath.expr.path.PredicateExpression;
import jd.xml.xpath.expr.path.SimpleLocationStep;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XBoolean;
import jd.xml.xpath.object.XObject;

public class ExprSimplifier
implements ExpressionVisitor {
    private Expression expr_;

    public synchronized Expression simplify(Expression expression) {
        if (expression instanceof Constant) {
            return expression;
        }
        if (this.isConstant(expression)) {
            return new Constant(expression.toXObject(null));
        }
        Expression expression2 = this.setExpr(expression);
        expression.accept(this);
        return this.setExpr(expression2);
    }

    private Expression setExpr(Expression expression) {
        Expression expression2 = this.expr_;
        this.expr_ = expression;
        return expression2;
    }

    private boolean isConstant(Expression expression) {
        return expression.getContextDependencies() == 0;
    }

    private Expression getConstant(boolean bl) {
        return new Constant(XBoolean.getBoolean(bl));
    }

    public void add(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Add(this.simplify(expression2), this.simplify(expression3));
    }

    public void and(Expression expression, Expression expression2, Expression expression3) {
        expression2 = this.simplify(expression2);
        expression3 = this.simplify(expression3);
        this.expr_ = this.isConstant(expression2) ? (!expression2.toBooleanValue(null) ? this.getConstant(false) : expression3) : (this.isConstant(expression3) ? (!expression3.toBooleanValue(null) ? this.getConstant(false) : expression2) : new And(expression2, expression3));
    }

    public void compare(Expression expression, Expression expression2, Equality equality, Expression expression3) {
        this.expr_ = CompareFactory.createEquals(this.simplify(expression2), equality, this.simplify(expression3));
    }

    public void compare(Expression expression, Expression expression2, Relation relation, Expression expression3) {
        this.expr_ = CompareFactory.createRelate(this.simplify(expression2), relation, this.simplify(expression3));
    }

    public void composedPath(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new ComposedPath(this.simplify(expression2), this.simplify(expression3));
    }

    public void composedPath(Expression expression, Expression[] expressionArray) {
        LocationStep[] locationStepArray = new LocationStep[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            locationStepArray[i] = (LocationStep)this.simplify(expressionArray[i]);
        }
        this.expr_ = new LocationStepChain(locationStepArray);
    }

    public void constant(Expression expression, XObject xObject) {
    }

    public void divide(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Divide(this.simplify(expression2), this.simplify(expression3));
    }

    public void function(Expression expression, String string, Expression[] expressionArray) {
        if (expression instanceof Function) {
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray2[i] = this.simplify(expressionArray[i]);
            }
            Function function = (Function)expression;
            try {
                function = function.getFunctionType().copyFunction(function);
            }
            catch (Exception exception) {
                throw new XPathException("cannot instantiate function '" + string + "'", exception);
            }
            function.setArguments(expressionArray2);
            this.expr_ = function;
        }
    }

    public void invalid(Expression expression, String string, String string2) {
    }

    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest) {
    }

    public void locationStep(Expression expression, Axis axis, NodeTest nodeTest, Expression expression2, boolean bl, boolean bl2) {
        this.expr_ = FilteredLocationStep.create(new SimpleLocationStep(axis, nodeTest), this.simplify(expression2));
    }

    public void modulo(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Modulo(this.simplify(expression2), this.simplify(expression3));
    }

    public void multiply(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Multiply(this.simplify(expression2), this.simplify(expression3));
    }

    public void negate(Expression expression, Expression expression2) {
        this.expr_ = new Negate(this.simplify(expression2));
    }

    public void or(Expression expression, Expression expression2, Expression expression3) {
        expression2 = this.simplify(expression2);
        expression3 = this.simplify(expression3);
        this.expr_ = this.isConstant(expression2) ? (expression2.toBooleanValue(null) ? this.getConstant(true) : expression3) : (this.isConstant(expression3) ? (expression3.toBooleanValue(null) ? this.getConstant(true) : expression2) : new Or(expression2, expression3));
    }

    public void parenthesis(Expression expression, Expression expression2) {
        this.expr_ = new ParenthesisExpression(this.simplify(expression2));
    }

    public void predicate(Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.expr_ = new PredicateExpression(this.simplify(expression2), this.simplify(expression3), bl);
    }

    public void root(Expression expression) {
    }

    public void subtract(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Subtract(this.simplify(expression2), this.simplify(expression3));
    }

    public void union(Expression expression, Expression expression2, Expression expression3) {
        this.expr_ = new Union(this.simplify(expression2), this.simplify(expression3));
    }

    public void variableReference(Expression expression, VariableName variableName) {
    }
}

