/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.movie.FontDefinition;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.structs.Rect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Font
extends Symbol {
    protected Object font1Key = new Object();
    protected Object font2Key = new Object();
    protected FontDefinition fontDef;
    protected HashMap glyphs = new HashMap();
    protected HashMap indices = new HashMap();
    protected ArrayList glyphList = new ArrayList();
    protected int languageCode = 0;

    public int getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(int n) {
        this.languageCode = n;
    }

    public FontDefinition getDefinition() {
        return this.fontDef;
    }

    public Font(FontDefinition fontDefinition) {
        this.fontDef = fontDefinition;
    }

    public List getGlyphList() {
        return this.glyphList;
    }

    public void loadGlyphs(String string) throws NoGlyphException {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            this.getGlyph(cArray[i], null);
        }
    }

    public void loadAllGlyphs() {
        ArrayList arrayList = this.fontDef.getGlyphList();
        for (FontDefinition.Glyph glyph : arrayList) {
            this.addGlyph(glyph);
        }
    }

    public Chars chars(String string, double d) throws NoGlyphException {
        return new Chars(string, d);
    }

    protected FontDefinition.Glyph getGlyph(int n, int[] nArray) throws NoGlyphException {
        Integer n2 = new Integer(n);
        FontDefinition.Glyph glyph = (FontDefinition.Glyph)this.glyphs.get(n2);
        if (glyph != null) {
            if (nArray != null) {
                Integer n3 = (Integer)this.indices.get(n2);
                nArray[0] = n3;
            }
            return glyph;
        }
        glyph = this.fontDef.getGlyph(n);
        if (glyph == null) {
            throw new NoGlyphException(n);
        }
        int n4 = this.addGlyph(glyph);
        if (nArray != null) {
            nArray[0] = n4;
        }
        return glyph;
    }

    public int addGlyph(FontDefinition.Glyph glyph) {
        int n = this.glyphs.size();
        if (glyph.getCode() > 0) {
            Integer n2 = new Integer(glyph.getCode());
            this.indices.put(n2, new Integer(n));
            this.glyphs.put(n2, glyph);
        }
        this.glyphList.add(glyph);
        return n;
    }

    public void setCode(int n, int n2) {
        if (n >= this.glyphList.size()) {
            return;
        }
        FontDefinition.Glyph glyph = (FontDefinition.Glyph)this.glyphList.get(n);
        glyph.setCode(n2);
        Integer n3 = new Integer(n2);
        this.indices.put(n3, new Integer(n));
        this.glyphs.put(n3, glyph);
    }

    protected int define(boolean bl, Movie movie, SWFTagTypes sWFTagTypes) throws IOException {
        Integer n;
        Integer n2 = n = bl ? (Integer)movie.definedSymbols.get(this.font1Key) : (Integer)movie.definedSymbols.get(this.font2Key);
        if (n == null) {
            if (bl) {
                n = new Integer(this.defineFont1(movie, sWFTagTypes));
                movie.definedSymbols.put(this.font1Key, n);
            } else {
                n = new Integer(this.defineFont2(movie, sWFTagTypes));
                movie.definedSymbols.put(this.font2Key, n);
            }
        }
        this.id = n;
        return this.id;
    }

    protected int defineFont1(Movie movie, SWFTagTypes sWFTagTypes) throws IOException {
        int n = this.getNextId(movie);
        SWFVectors sWFVectors = sWFTagTypes.tagDefineFont(n, this.glyphList.size());
        for (FontDefinition.Glyph glyph : this.glyphList) {
            Shape shape = glyph.getShape();
            shape.writeGlyph(sWFVectors);
        }
        if (this.fontDef.getName() != null) {
            int n2 = 0;
            if (this.fontDef.isSmallText()) {
                n2 |= 0x20;
            }
            if (this.fontDef.isShiftJIS()) {
                n2 |= 0x10;
            }
            if (this.fontDef.isAnsi()) {
                n2 |= 8;
            }
            if (this.fontDef.isItalic()) {
                n2 |= 4;
            }
            if (this.fontDef.isBold()) {
                n2 |= 2;
            }
            if (movie.getVersion() >= 6 && this.languageCode != 0) {
                sWFTagTypes.tagDefineFontInfo2(n, this.fontDef.getName(), n2, this.getCodes(), this.languageCode);
            } else {
                sWFTagTypes.tagDefineFontInfo(n, this.fontDef.getName(), n2, this.getCodes());
            }
        }
        return n;
    }

    protected int defineFont2(Movie movie, SWFTagTypes sWFTagTypes) throws IOException {
        Object object;
        Object[] objectArray;
        int n = this.getNextId(movie);
        int n2 = this.glyphList.size();
        int[] nArray = new int[n2];
        Rect[] rectArray = new Rect[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (FontDefinition.Glyph glyph : this.glyphList) {
            nArray[n3] = glyph.getCode();
            nArray2[n3] = (int)(glyph.getAdvance() * 20.0);
            objectArray = glyph.getShape().getBoundingRectangle();
            rectArray[n3] = new Rect(objectArray[0] * 20.0, objectArray[1] * 20.0, objectArray[2] * 20.0, objectArray[3] * 20.0);
            ++n3;
        }
        ArrayList arrayList = this.fontDef.getKerningPairList();
        int n4 = arrayList.size();
        objectArray = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        n3 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (FontDefinition.KerningPair)iterator.next();
            objectArray[n3] = ((FontDefinition.KerningPair)object).getCode1();
            nArray3[n3] = ((FontDefinition.KerningPair)object).getCode2();
            nArray4[n3] = (int)(((FontDefinition.KerningPair)object).getAdjustment() * 20.0);
            ++n3;
        }
        int n5 = 0;
        if (this.fontDef.hasMetrics()) {
            n5 |= 0x80;
        }
        if (this.fontDef.isShiftJIS()) {
            n5 |= 0x40;
        }
        if (this.fontDef.isSmallText()) {
            n5 |= 0x20;
        }
        if (this.fontDef.isAnsi()) {
            n5 |= 0x10;
        }
        if (this.fontDef.isItalic()) {
            n5 |= 2;
        }
        if (this.fontDef.isBold()) {
            n5 |= 1;
        }
        object = sWFTagTypes.tagDefineFont2(n, n5, this.fontDef.getName(), n2, (int)(this.fontDef.getAscent() * 20.0), (int)(this.fontDef.getDescent() * 20.0), (int)(this.fontDef.getLeading() * 20.0), nArray, nArray2, rectArray, (int[])objectArray, nArray3, nArray4);
        for (FontDefinition.Glyph glyph : this.glyphList) {
            Shape shape = glyph.getShape();
            shape.writeGlyph((SWFVectors)object);
        }
        return n;
    }

    protected int[] getCodes() {
        int[] nArray = new int[this.glyphList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            FontDefinition.Glyph glyph = (FontDefinition.Glyph)this.glyphList.get(i);
            nArray[i] = glyph.getCode();
        }
        return nArray;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        return this.id;
    }

    public class Chars {
        protected String chars;
        protected double size;
        protected int[] indices;
        protected int[] advances;
        protected double totalAdvance;
        protected double ascent;
        protected double descent;
        protected double leftMargin;
        protected double rightMargin;

        public String toString() {
            return this.chars;
        }

        public Font getFont() {
            return Font.this;
        }

        public double getSize() {
            return this.size;
        }

        public double getTotalAdvance() {
            return this.totalAdvance;
        }

        public double getAscent() {
            return this.ascent;
        }

        public double getDescent() {
            return this.descent;
        }

        public double getLeftMargin() {
            return this.leftMargin;
        }

        public double getRightMargin() {
            return this.rightMargin;
        }

        protected Chars(String string, double d) throws NoGlyphException {
            this.chars = string;
            this.size = d;
            this.init();
        }

        protected void init() throws NoGlyphException {
            char[] cArray = this.chars.toCharArray();
            this.indices = new int[cArray.length];
            this.advances = new int[cArray.length];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = this.size * 20.0 / 1024.0;
            for (int i = 0; i < cArray.length; ++i) {
                double d4;
                char c = cArray[i];
                int[] nArray = new int[1];
                FontDefinition.Glyph glyph = Font.this.getGlyph(c, nArray);
                this.indices[i] = nArray[0];
                if (glyph == null) continue;
                Shape shape = glyph.getShape();
                double[] dArray = shape.getBoundingRectangle();
                double d5 = dArray[0] * d3;
                double d6 = dArray[1] * d3;
                double d7 = dArray[2] * d3;
                double d8 = dArray[3] * d3;
                if (d < -d6) {
                    d = -d6;
                }
                if (d2 < d8) {
                    d2 = d8;
                }
                if ((d4 = glyph.getAdvance() * d3) == 0.0) {
                    d4 = d7 - d5;
                }
                if (i < cArray.length - 1) {
                    d4 += Font.this.fontDef.getKerningOffset(c, cArray[i + 1]) * d3;
                }
                this.totalAdvance += d4;
                this.advances[i] = (int)(d4 * 20.0);
                if (i == 0) {
                    this.leftMargin = -d6;
                }
                if (i != cArray.length - 1) continue;
                this.rightMargin = d7 - d4;
            }
            this.ascent = Font.this.fontDef.getAscent() * d3;
            if (this.ascent == 0.0) {
                this.ascent = d;
            }
            this.descent = Font.this.fontDef.getDescent() * d3;
            if (this.descent == 0.0) {
                this.descent = d2;
            }
        }
    }

    public class NoGlyphException
    extends Exception {
        public int code;

        public NoGlyphException(int n) {
            super("The font does not have a glyph definition for code " + n);
            this.code = n;
        }
    }
}

