/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.movie.FontDefinition;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.writers.SWFTagTypesImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FontLoader
extends SWFTagTypesImpl {
    protected FontDefinition fontDef;

    public FontLoader() {
        super(null);
    }

    public static FontDefinition loadFont(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        FontDefinition fontDefinition = FontLoader.loadFont(fileInputStream);
        fileInputStream.close();
        return fontDefinition;
    }

    public static FontDefinition loadFont(InputStream inputStream) throws IOException {
        FontLoader fontLoader = new FontLoader();
        TagParser tagParser = new TagParser(fontLoader);
        SWFReader sWFReader = new SWFReader((SWFTags)tagParser, inputStream);
        sWFReader.readFile();
        return fontLoader.fontDef;
    }

    public SWFVectors tagDefineFont2(int n, int n2, String string, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, Rect[] rectArray, int[] nArray3, int[] nArray4, int[] nArray5) throws IOException {
        if (this.fontDef != null) {
            return null;
        }
        double d = 20.0;
        this.fontDef = new FontDefinition(string, (double)n4 / d, (double)n5 / d, (double)n6 / d, (n2 & 0x20) != 0, (n2 & 0x40) != 0, (n2 & 0x10) != 0, (n2 & 2) != 0, (n2 & 1) != 0, (n2 & 0x80) != 0);
        if (nArray3 != null && nArray3.length > 0) {
            ArrayList arrayList = this.fontDef.getKerningPairList();
            for (int i = 0; i < nArray3.length; ++i) {
                FontDefinition.KerningPair kerningPair = new FontDefinition.KerningPair(nArray3[i], nArray4[i], (double)nArray5[i] / d);
                arrayList.add(kerningPair);
            }
        }
        return new VectorImpl(nArray, nArray2, rectArray);
    }

    protected class VectorImpl
    implements SWFVectors {
        protected int[] codes;
        protected int[] advances;
        protected Rect[] bounds;
        protected int i;
        protected Shape shape;
        protected int currx;
        protected int curry;
        protected double twips = 20.0;

        protected VectorImpl(int[] nArray, int[] nArray2, Rect[] rectArray) {
            this.codes = nArray;
            this.advances = nArray2;
            this.bounds = rectArray;
            this.i = 0;
            this.shape = new Shape();
        }

        public void done() {
            double d = this.advances == null ? 0.0 : (double)this.advances[this.i] / this.twips;
            int n = this.codes[this.i];
            Rect rect = this.bounds[this.i];
            this.shape.minX = (double)rect.getMinX() / this.twips;
            this.shape.minY = (double)rect.getMinY() / this.twips;
            this.shape.maxX = (double)rect.getMaxX() / this.twips;
            this.shape.maxY = (double)rect.getMaxY() / this.twips;
            FontDefinition.Glyph glyph = new FontDefinition.Glyph(this.shape, d, n);
            FontLoader.this.fontDef.getGlyphList().add(glyph);
            ++this.i;
            if (this.i < this.codes.length) {
                this.shape = new Shape();
            }
            this.curry = 0;
            this.currx = 0;
        }

        public void line(int n, int n2) {
            this.currx += n;
            this.curry += n2;
            this.shape.line((double)this.currx / this.twips, (double)this.curry / this.twips);
        }

        public void curve(int n, int n2, int n3, int n4) {
            this.currx = n3 += (n += this.currx);
            this.curry = n4 += (n2 += this.curry);
            this.shape.curve((double)n3 / this.twips, (double)n4 / this.twips, (double)n / this.twips, (double)n2 / this.twips);
        }

        public void move(int n, int n2) {
            this.currx = n;
            this.curry = n2;
            this.shape.move((double)n / this.twips, (double)n2 / this.twips);
        }
    }
}

