/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Instance;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Placement;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.SoundInfo;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Frame {
    protected int frameNumber;
    protected String label;
    protected Vector placements = new Vector();
    protected boolean stop;
    protected TimeLine timeline;
    protected Actions actions;
    protected SoundStreamHead soundHeader;
    protected byte[] soundData;
    protected Sound soundToStart;
    protected int customTag = -1;
    protected byte[] customTagData;
    protected boolean mAnchor;

    protected Frame(int n, TimeLine timeLine) {
        this.frameNumber = n;
        this.timeline = timeLine;
    }

    public SoundStreamHead getSoundHeader() {
        return this.soundHeader;
    }

    public void setSoundHeader(SoundStreamHead soundStreamHead) {
        this.soundHeader = soundStreamHead;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setSoundData(byte[] byArray) {
        this.soundData = byArray;
    }

    public boolean isAnchor() {
        return this.mAnchor;
    }

    public void setAnchor(boolean bl) {
        this.mAnchor = bl;
    }

    public void setCustomTag(int n, byte[] byArray) {
        this.customTag = n;
        this.customTagData = byArray;
    }

    public int startSound(Sound sound, int n) {
        this.soundToStart = sound;
        int n2 = sound.getFrequency();
        switch (n2) {
            case 0: {
                n2 = 5500;
                break;
            }
            case 1: {
                n2 = 11000;
                break;
            }
            case 2: {
                n2 = 22000;
                break;
            }
            case 3: {
                n2 = 44000;
                break;
            }
            default: {
                n2 = 22000;
            }
        }
        int n3 = sound.getSampleCount();
        int n4 = n3 / n2;
        return n4 * n;
    }

    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public Actions actions(int n) {
        this.actions = new Actions(0, n);
        return this.actions;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Placement[] getPlacements() {
        Object[] objectArray = new Placement[this.placements.size()];
        this.placements.copyInto(objectArray);
        return objectArray;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void stop() {
        this.stop = true;
    }

    public Instance placeSymbol(Symbol symbol, int n, int n2) {
        return this.placeSymbol(symbol, new Transform(n, n2), null, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform transform, AlphaTransform alphaTransform) {
        return this.placeSymbol(symbol, transform, alphaTransform, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform transform, AlphaTransform alphaTransform, int n, int n2) {
        int n3 = this.timeline.getAvailableDepth();
        Instance instance = new Instance(symbol, n3);
        this.timeline.setAvailableDepth(n3 + 1);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, null, n, n2, this.frameNumber, false, false, null);
        this.placements.add(placement);
        return instance;
    }

    public Instance replaceSymbol(Symbol symbol, int n, Transform transform, AlphaTransform alphaTransform, int n2, int n3) {
        Instance instance = new Instance(symbol, n);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, null, n2, n3, this.frameNumber, false, true, null);
        this.placements.add(placement);
        return instance;
    }

    public void undefineSymbol(Symbol symbol) {
        this.placements.add(new Placement(symbol));
    }

    public Instance placeMovieClip(Symbol symbol, Transform transform, AlphaTransform alphaTransform, String string, Actions[] actionsArray) {
        int n = this.timeline.getAvailableDepth();
        Instance instance = new Instance(symbol, n);
        this.timeline.setAvailableDepth(n + 1);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, string, -1, -1, this.frameNumber, false, false, actionsArray);
        this.placements.add(placement);
        return instance;
    }

    public Instance replaceMovieClip(Symbol symbol, int n, Transform transform, AlphaTransform alphaTransform, String string, Actions[] actionsArray) {
        Instance instance = new Instance(symbol, n);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, string, -1, -1, this.frameNumber, false, true, actionsArray);
        this.placements.add(placement);
        return instance;
    }

    public void remove(Instance instance) {
        this.placements.add(new Placement(instance, this.frameNumber));
    }

    public void alter(Instance instance, int n, int n2) {
        this.alter(instance, new Transform(n, n2), null, -1);
    }

    public void alter(Instance instance, Transform transform, AlphaTransform alphaTransform) {
        this.alter(instance, transform, alphaTransform, -1);
    }

    public void alter(Instance instance, Transform transform, AlphaTransform alphaTransform, int n) {
        Placement placement = new Placement(instance, transform, alphaTransform, null, n, -1, this.frameNumber, true, false, null);
        this.placements.add(placement);
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        Enumeration enumeration = this.placements.elements();
        while (enumeration.hasMoreElements()) {
            Placement placement = (Placement)enumeration.nextElement();
            placement.flushDefinitions(movie, sWFTagTypes, sWFTagTypes2);
        }
    }

    protected void write(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        Object object;
        Object object2;
        if (this.customTag >= 0) {
            sWFTagTypes2.tag(this.customTag, false, this.customTagData);
        }
        if (this.actions != null) {
            object2 = sWFTagTypes2.tagDoAction();
            object = object2.start(0);
            object.blob(this.actions.bytes);
            object2.done();
        }
        if (this.stop) {
            object2 = sWFTagTypes2.tagDoAction();
            object = object2.start(0);
            object.stop();
            object.end();
            object2.done();
        }
        if (this.soundHeader != null) {
            this.soundHeader.write(sWFTagTypes2);
        }
        if (this.soundData != null) {
            sWFTagTypes2.tagSoundStreamBlock(this.soundData);
        }
        if (this.soundToStart != null) {
            sWFTagTypes2.tagStartSound(this.soundToStart.define(movie, sWFTagTypes, sWFTagTypes2), new SoundInfo(true, false, null, -1, -1, 0));
        }
        object2 = this.placements.elements();
        while (object2.hasMoreElements()) {
            object = (Placement)object2.nextElement();
            ((Placement)object).write(movie, sWFTagTypes, sWFTagTypes2);
        }
        if (this.label != null) {
            sWFTagTypes2.tagFrameLabel(this.label, this.mAnchor);
        }
        sWFTagTypes2.tagShowFrame();
    }
}

